/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.DumpFileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LogEntry;
import java.io.IOException;
import java.nio.ByteBuffer;

public class PrintFileReader
extends DumpFileReader {
    public PrintFileReader(EnvironmentImpl env, int readBufferSize, long startLsn, long finishLsn, String entryTypes, String txnIds, boolean verbose) throws IOException, DatabaseException {
        super(env, readBufferSize, startLsn, finishLsn, entryTypes, txnIds, verbose);
    }

    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        byte curType = this.currentEntryHeader.getType();
        byte curVer = LogEntryType.getVersionValue(this.currentEntryHeader.getVersion());
        byte ignore = 0;
        LogEntryType lastEntryType = LogEntryType.findType(curType, ignore);
        StringBuffer sb = new StringBuffer();
        sb.append("<entry lsn=\"0x").append(Long.toHexString(this.readBufferFileNum));
        sb.append("/0x").append(Long.toHexString(this.currentEntryOffset));
        sb.append("\" type=\"").append(lastEntryType.toStringNoVersion()).append("/").append(curVer);
        if (LogEntryType.isEntryProvisional(curType)) {
            sb.append("\" isProvisional=\"true");
        }
        sb.append("\" prev=\"0x");
        sb.append(Long.toHexString(this.currentEntryHeader.getPrevOffset()));
        if (this.verbose) {
            sb.append("\" size=\"").append(this.currentEntryHeader.getItemSize());
            sb.append("\" cksum=\"").append(this.currentEntryHeader.getChecksum());
        }
        sb.append("\">");
        LogEntry entry = lastEntryType.getSharedLogEntry();
        this.readEntry(entry, entryBuffer, true);
        boolean dumpIt = true;
        if (this.targetTxnIds.size() > 0) {
            if (lastEntryType.isTransactional()) {
                if (!this.targetTxnIds.contains(new Long(entry.getTransactionId()))) {
                    dumpIt = false;
                }
            } else {
                dumpIt = false;
            }
        }
        if (dumpIt) {
            entry.dumpEntry(sb, this.verbose);
            sb.append("</entry>");
            System.out.println(sb.toString());
        }
        return true;
    }
}

