/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.txn.TxnAbort;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.txn.TxnPrepare;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.Xid;

public class LNFileReader
extends FileReader {
    protected Map targetEntryMap = new HashMap();
    protected LogEntry targetLogEntry;

    public LNFileReader(EnvironmentImpl env, int readBufferSize, long startLsn, boolean redo, long endOfFileLsn, long finishLsn, Long singleFileNum) throws IOException, DatabaseException {
        super(env, readBufferSize, redo, startLsn, singleFileNum, endOfFileLsn, finishLsn);
    }

    public void addTargetType(LogEntryType entryType) throws DatabaseException {
        this.targetEntryMap.put(entryType, entryType.getNewLogEntry());
    }

    protected boolean isTargetEntry(byte entryTypeNum, byte entryTypeVersion) {
        if (LogEntryType.isEntryProvisional(entryTypeVersion)) {
            this.targetLogEntry = null;
        } else {
            LogEntryType fromLogType = new LogEntryType(entryTypeNum, entryTypeVersion);
            this.targetLogEntry = (LogEntry)this.targetEntryMap.get(fromLogType);
        }
        return this.targetLogEntry != null;
    }

    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        this.readEntry(this.targetLogEntry, entryBuffer, true);
        return true;
    }

    public boolean isLN() {
        return this.targetLogEntry instanceof LNLogEntry;
    }

    public LN getLN() {
        return ((LNLogEntry)this.targetLogEntry).getLN();
    }

    public DatabaseId getDatabaseId() {
        return ((LNLogEntry)this.targetLogEntry).getDbId();
    }

    public byte[] getKey() {
        return ((LNLogEntry)this.targetLogEntry).getKey();
    }

    public byte[] getDupTreeKey() {
        return ((LNLogEntry)this.targetLogEntry).getDupKey();
    }

    public Long getTxnId() {
        return ((LNLogEntry)this.targetLogEntry).getTxnId();
    }

    public boolean isPrepare() {
        return this.targetLogEntry.getMainItem() instanceof TxnPrepare;
    }

    public long getTxnPrepareId() {
        return ((TxnPrepare)this.targetLogEntry.getMainItem()).getId();
    }

    public Xid getTxnPrepareXid() {
        return ((TxnPrepare)this.targetLogEntry.getMainItem()).getXid();
    }

    public boolean isAbort() {
        return this.targetLogEntry.getMainItem() instanceof TxnAbort;
    }

    public long getTxnAbortId() {
        return ((TxnAbort)this.targetLogEntry.getMainItem()).getId();
    }

    public long getTxnCommitId() {
        return ((TxnCommit)this.targetLogEntry.getMainItem()).getId();
    }

    public long getNodeId() {
        return ((LNLogEntry)this.targetLogEntry).getLN().getNodeId();
    }

    public long getAbortLsn() {
        return ((LNLogEntry)this.targetLogEntry).getAbortLsn();
    }

    public boolean getAbortKnownDeleted() {
        return ((LNLogEntry)this.targetLogEntry).getAbortKnownDeleted();
    }
}

