/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.LogScanConfig;
import com.sleepycat.je.LogScanner;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbEnvPool;
import com.sleepycat.je.dbi.DbEnvState;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.ReplicatorInstance;
import com.sleepycat.je.dbi.TruncateResult;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.incomp.INCompressor;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LNFileReader;
import com.sleepycat.je.log.LatchedLogManager;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.SyncedLogManager;
import com.sleepycat.je.log.TraceLogHandler;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.NotImplementedYetException;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.Tracer;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class EnvironmentImpl
implements EnvConfigObserver {
    private static final boolean TEST_NO_LOCKING_MODE = false;
    private DbEnvState envState;
    private boolean closing;
    private File envHome;
    private int referenceCount;
    private boolean isTransactional;
    private boolean isNoLocking;
    private boolean isReadOnly;
    private boolean isMemOnly;
    private boolean directNIO;
    private static boolean fairLatches;
    private static boolean useSharedLatchesForINs;
    private boolean deferredWriteTemp;
    private boolean dbEviction;
    private MemoryBudget memoryBudget;
    private static int adler32ChunkSize;
    private long lockTimeout;
    private long txnTimeout;
    private DbTree dbMapTree;
    private long mapTreeRootLsn = -1L;
    private Latch mapTreeRootLatch;
    private INList inMemoryINs;
    private DbConfigManager configManager;
    private List configObservers;
    private Logger envLogger;
    protected LogManager logManager;
    private FileManager fileManager;
    private TxnManager txnManager;
    private Evictor evictor;
    private INCompressor inCompressor;
    private Checkpointer checkpointer;
    private Cleaner cleaner;
    private boolean isReplicated;
    private ReplicatorInstance repInstance;
    private RecoveryInfo lastRecoveryInfo;
    private RunRecoveryException savedInvalidatingException;
    private static boolean forcedYield;
    private SharedLatch triggerLatch;
    private ExceptionListener exceptionListener = null;
    private volatile int backgroundSleepBacklog;
    private volatile int backgroundReadLimit;
    private volatile int backgroundWriteLimit;
    private long backgroundSleepInterval;
    private int backgroundReadCount;
    private long backgroundWriteBytes;
    private TestHook backgroundSleepHook;
    private Object backgroundTrackingMutex = new Object();
    private Object backgroundSleepMutex = new Object();
    private static int threadLocalReferenceCount;
    private static boolean noComparators;
    public final RunRecoveryException SAVED_RRE = DbInternal.makeNoArgsRRE();
    public static final boolean JAVA5_AVAILABLE;
    private static final String DISABLE_JAVA_ADLER32 = "je.disable.java.adler32";
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvironmentImpl(File envHome, EnvironmentConfig envConfig) throws DatabaseException {
        try {
            this.envHome = envHome;
            this.envState = DbEnvState.INIT;
            this.mapTreeRootLatch = LatchSupport.makeLatch("MapTreeRoot", this);
            this.configManager = new DbConfigManager(envConfig);
            this.configObservers = new ArrayList();
            this.addConfigObserver(this);
            this.memoryBudget = new MemoryBudget(this, this.configManager);
            this.envLogger = this.initLogger(envHome);
            forcedYield = this.configManager.getBoolean(EnvironmentParams.ENV_FORCED_YIELD);
            this.isTransactional = this.configManager.getBoolean(EnvironmentParams.ENV_INIT_TXN);
            boolean bl = this.isNoLocking = !this.configManager.getBoolean(EnvironmentParams.ENV_INIT_LOCKING);
            if (this.isTransactional && this.isNoLocking) {
                throw new IllegalArgumentException("Can't set 'je.env.isNoLocking' and 'je.env.isTransactional';");
            }
            this.directNIO = this.configManager.getBoolean(EnvironmentParams.LOG_DIRECT_NIO);
            fairLatches = this.configManager.getBoolean(EnvironmentParams.ENV_FAIR_LATCHES);
            this.isReadOnly = this.configManager.getBoolean(EnvironmentParams.ENV_RDONLY);
            this.isMemOnly = this.configManager.getBoolean(EnvironmentParams.LOG_MEMORY_ONLY);
            useSharedLatchesForINs = this.configManager.getBoolean(EnvironmentParams.ENV_SHARED_LATCHES);
            this.dbEviction = this.configManager.getBoolean(EnvironmentParams.ENV_DB_EVICTION);
            adler32ChunkSize = this.configManager.getInt(EnvironmentParams.ADLER32_CHUNK_SIZE);
            this.exceptionListener = envConfig.getExceptionListener();
            this.deferredWriteTemp = this.configManager.getBoolean(EnvironmentParams.LOG_DEFERREDWRITE_TEMP);
            this.fileManager = new FileManager(this, envHome, this.isReadOnly);
            if (!envConfig.getAllowCreate() && !this.fileManager.filesExist()) {
                throw new DatabaseException("Environment.setAllowCreate is false so environment  creation is not permitted, but there is no  pre-existing environment in " + envHome);
            }
            this.logManager = fairLatches ? new LatchedLogManager(this, this.isReadOnly) : new SyncedLogManager(this, this.isReadOnly);
            this.inMemoryINs = new INList(this);
            this.txnManager = new TxnManager(this);
            this.createDaemons();
            this.dbMapTree = new DbTree(this);
            this.referenceCount = 0;
            this.triggerLatch = LatchSupport.makeSharedLatch("TriggerLatch", this);
            if (this.configManager.getBoolean(EnvironmentParams.ENV_RECOVERY)) {
                try {
                    RecoveryManager recoveryManager = new RecoveryManager(this);
                    this.lastRecoveryInfo = recoveryManager.recover(this.isReadOnly);
                }
                finally {
                    try {
                        this.logManager.flush();
                        this.fileManager.clear();
                    }
                    catch (IOException e) {
                        throw new DatabaseException(e.getMessage());
                    }
                }
            }
            this.isReadOnly = true;
            noComparators = true;
            this.lockTimeout = PropUtil.microsToMillis(this.configManager.getLong(EnvironmentParams.LOCK_TIMEOUT));
            this.txnTimeout = PropUtil.microsToMillis(this.configManager.getLong(EnvironmentParams.TXN_TIMEOUT));
            this.memoryBudget.initCacheMemoryUsage();
            this.envConfigUpdate(this.configManager);
            this.open();
        }
        catch (DatabaseException e) {
            if (this.fileManager != null) {
                try {
                    this.fileManager.clear();
                    this.fileManager.close();
                }
                catch (IOException IOE) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public void envConfigUpdate(DbConfigManager mgr) throws DatabaseException {
        this.runOrPauseDaemons(mgr);
        this.backgroundReadLimit = mgr.getInt(EnvironmentParams.ENV_BACKGROUND_READ_LIMIT);
        this.backgroundWriteLimit = mgr.getInt(EnvironmentParams.ENV_BACKGROUND_WRITE_LIMIT);
        this.backgroundSleepInterval = PropUtil.microsToMillis(mgr.getLong(EnvironmentParams.ENV_BACKGROUND_SLEEP_INTERVAL));
    }

    private void createDaemons() throws DatabaseException {
        this.evictor = new Evictor(this, "Evictor");
        long checkpointerWakeupTime = Checkpointer.getWakeupPeriod(this.configManager);
        this.checkpointer = new Checkpointer(this, checkpointerWakeupTime, "Checkpointer");
        long compressorWakeupInterval = PropUtil.microsToMillis(this.configManager.getLong(EnvironmentParams.COMPRESSOR_WAKEUP_INTERVAL));
        this.inCompressor = new INCompressor(this, compressorWakeupInterval, "INCompressor");
        this.cleaner = new Cleaner(this, "Cleaner");
    }

    private void runOrPauseDaemons(DbConfigManager mgr) throws DatabaseException {
        if (!this.isReadOnly) {
            this.inCompressor.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_INCOMPRESSOR));
            this.cleaner.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_CLEANER) && !this.isMemOnly);
            this.checkpointer.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_CHECKPOINTER));
        }
        this.evictor.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_EVICTOR));
    }

    public INCompressor getINCompressor() {
        return this.inCompressor;
    }

    public UtilizationTracker getUtilizationTracker() {
        return this.cleaner.getUtilizationTracker();
    }

    public UtilizationProfile getUtilizationProfile() {
        return this.cleaner.getUtilizationProfile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackgroundReads(int nReads) {
        int limit = this.backgroundReadLimit;
        if (limit > 0) {
            Object object = this.backgroundTrackingMutex;
            synchronized (object) {
                this.backgroundReadCount += nReads;
                if (this.backgroundReadCount >= limit) {
                    ++this.backgroundSleepBacklog;
                    this.backgroundReadCount -= limit;
                    if (!$assertionsDisabled && this.backgroundReadCount < 0) {
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackgroundWrites(int writeSize, int logBufferSize) {
        int limit = this.backgroundWriteLimit;
        if (limit > 0) {
            Object object = this.backgroundTrackingMutex;
            synchronized (object) {
                this.backgroundWriteBytes += (long)writeSize;
                int writeCount = (int)(this.backgroundWriteBytes / (long)logBufferSize);
                if (writeCount >= limit) {
                    ++this.backgroundSleepBacklog;
                    this.backgroundWriteBytes -= (long)(limit * logBufferSize);
                    if (!$assertionsDisabled && this.backgroundWriteBytes < 0L) {
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleepAfterBackgroundIO() {
        if (this.backgroundSleepBacklog > 0) {
            Object object = this.backgroundSleepMutex;
            synchronized (object) {
                try {
                    Thread.sleep(this.backgroundSleepInterval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!$assertionsDisabled && !TestHookExecute.doHookIfSet(this.backgroundSleepHook)) {
                    throw new AssertionError();
                }
            }
            object = this.backgroundTrackingMutex;
            synchronized (object) {
                if (this.backgroundSleepBacklog > 0) {
                    --this.backgroundSleepBacklog;
                }
            }
        }
    }

    public void setBackgroundSleepHook(TestHook hook) {
        this.backgroundSleepHook = hook;
    }

    public boolean scanLog(long startPosition, long endPosition, LogScanConfig config, LogScanner scanner) throws DatabaseException {
        try {
            DbConfigManager cm = this.getConfigManager();
            int readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
            long endOfLogLsn = this.fileManager.getNextLsn();
            boolean forwards = config.getForwards();
            LNFileReader reader = null;
            if (forwards) {
                if (endPosition > endOfLogLsn) {
                    throw new IllegalArgumentException("endPosition (" + endPosition + ") is past the end of the log on a forewards scan.");
                }
                reader = new LNFileReader(this, readBufferSize, startPosition, true, endPosition, -1L, null);
            } else {
                if (startPosition > endOfLogLsn) {
                    throw new IllegalArgumentException("startPosition (" + startPosition + ") is past the end of the log on a backwards scan.");
                }
                reader = new LNFileReader(this, readBufferSize, startPosition, false, endOfLogLsn, endPosition, null);
            }
            reader.addTargetType(LogEntryType.LOG_LN_TRANSACTIONAL);
            reader.addTargetType(LogEntryType.LOG_LN);
            reader.addTargetType(LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL);
            reader.addTargetType(LogEntryType.LOG_DEL_DUPLN);
            Map dbNameMap = this.dbMapTree.getDbNamesAndIds();
            while (reader.readNextEntry()) {
                boolean continueScanning;
                if (!reader.isLN()) continue;
                LN theLN = reader.getLN();
                byte[] theKey = reader.getKey();
                DatabaseId dbId = reader.getDatabaseId();
                String dbName = (String)dbNameMap.get(dbId);
                if (this.dbMapTree.isReservedDbName(dbName) || (continueScanning = scanner.scanRecord(new DatabaseEntry(theKey), new DatabaseEntry(theLN.getData()), theLN.isDeleted(), dbName))) continue;
                break;
            }
            return true;
        }
        catch (IOException IOE) {
            throw new DatabaseException(IOE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMapTreeRoot() throws DatabaseException {
        this.mapTreeRootLatch.acquire();
        try {
            this.mapTreeRootLsn = this.logManager.log(new SingleItemEntry(LogEntryType.LOG_ROOT, this.dbMapTree));
        }
        finally {
            this.mapTreeRootLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteMapTreeRoot(long cleanerTargetLsn) throws DatabaseException {
        this.mapTreeRootLatch.acquire();
        try {
            if (DbLsn.compareTo(cleanerTargetLsn, this.mapTreeRootLsn) == 0) {
                this.mapTreeRootLsn = this.logManager.log(new SingleItemEntry(LogEntryType.LOG_ROOT, this.dbMapTree));
            }
        }
        finally {
            this.mapTreeRootLatch.release();
        }
    }

    public long getRootLsn() {
        return this.mapTreeRootLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMapTreeFromLog(long rootLsn) throws DatabaseException {
        this.dbMapTree = (DbTree)this.logManager.get(rootLsn);
        this.dbMapTree.setEnvironmentImpl(this);
        this.mapTreeRootLatch.acquire();
        try {
            this.mapTreeRootLsn = rootLsn;
        }
        finally {
            this.mapTreeRootLatch.release();
        }
    }

    public void addToCompressorQueue(BIN bin, Key deletedKey, boolean doWakeup) throws DatabaseException {
        if (this.inCompressor != null) {
            this.inCompressor.addBinKeyToQueue(bin, deletedKey, doWakeup);
        }
    }

    public void addToCompressorQueue(BINReference binRef, boolean doWakeup) throws DatabaseException {
        if (this.inCompressor != null) {
            this.inCompressor.addBinRefToQueue(binRef, doWakeup);
        }
    }

    public void addToCompressorQueue(Collection binRefs, boolean doWakeup) throws DatabaseException {
        if (this.inCompressor != null) {
            this.inCompressor.addMultipleBinRefsToQueue(binRefs, doWakeup);
        }
    }

    public void lazyCompress(IN in, UtilizationTracker tracker) throws DatabaseException {
        if (this.inCompressor != null) {
            this.inCompressor.lazyCompress(in, tracker);
        }
    }

    private Logger initLogger(File envHome) throws DatabaseException {
        Logger logger = Logger.getAnonymousLogger();
        logger.setUseParentHandlers(false);
        Level level = Tracer.parseLevel(this, EnvironmentParams.JE_LOGGING_LEVEL);
        logger.setLevel(level);
        if (this.configManager.getBoolean(EnvironmentParams.JE_LOGGING_CONSOLE)) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(level);
            logger.addHandler(consoleHandler);
        }
        FileHandler fileHandler = null;
        try {
            if (this.configManager.getBoolean(EnvironmentParams.JE_LOGGING_FILE)) {
                int limit = this.configManager.getInt(EnvironmentParams.JE_LOGGING_FILE_LIMIT);
                int count = this.configManager.getInt(EnvironmentParams.JE_LOGGING_FILE_COUNT);
                String logFilePattern = envHome + "/" + "je.info";
                fileHandler = new FileHandler(logFilePattern, limit, count, true);
                fileHandler.setFormatter(new SimpleFormatter());
                fileHandler.setLevel(level);
                logger.addHandler(fileHandler);
            }
        }
        catch (IOException e) {
            throw new DatabaseException(e.getMessage());
        }
        return logger;
    }

    public void enableDebugLoggingToDbLog() throws DatabaseException {
        if (this.configManager.getBoolean(EnvironmentParams.JE_LOGGING_DBLOG)) {
            TraceLogHandler dbLogHandler = new TraceLogHandler(this);
            Level level = Level.parse(this.configManager.get(EnvironmentParams.JE_LOGGING_LEVEL));
            dbLogHandler.setLevel(level);
            this.envLogger.addHandler(dbLogHandler);
        }
    }

    public void closeLogger() {
        Handler[] handlers = this.envLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].close();
        }
    }

    public void open() {
        this.envState = DbEnvState.OPEN;
    }

    public void invalidate(RunRecoveryException e) {
        this.savedInvalidatingException = e;
        this.envState = DbEnvState.INVALID;
        this.requestShutdownDaemons();
    }

    public void invalidate(Error e) {
        if (this.SAVED_RRE.getCause() == null) {
            this.savedInvalidatingException = (RunRecoveryException)this.SAVED_RRE.initCause(e);
            this.envState = DbEnvState.INVALID;
            this.requestShutdownDaemons();
        }
    }

    public boolean isOpen() {
        return this.envState == DbEnvState.OPEN;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public boolean isClosed() {
        return this.envState == DbEnvState.CLOSED;
    }

    public boolean mayNotWrite() {
        return this.envState == DbEnvState.INVALID || this.envState == DbEnvState.CLOSED;
    }

    public void checkIfInvalid() throws RunRecoveryException {
        if (this.envState == DbEnvState.INVALID) {
            this.savedInvalidatingException.setAlreadyThrown();
            if (this.savedInvalidatingException == this.SAVED_RRE) {
                this.savedInvalidatingException.fillInStackTrace();
            }
            throw this.savedInvalidatingException;
        }
    }

    public void checkNotClosed() throws DatabaseException {
        if (this.envState == DbEnvState.CLOSED) {
            throw new DatabaseException("Attempt to use a Environment that has been closed.");
        }
    }

    public synchronized void close() throws DatabaseException {
        if (--this.referenceCount <= 0) {
            this.doClose(true);
        }
    }

    public synchronized void close(boolean doCheckpoint) throws DatabaseException {
        if (--this.referenceCount <= 0) {
            this.doClose(doCheckpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose(boolean doCheckpoint) throws DatabaseException {
        StringBuffer errors = new StringBuffer();
        try {
            Tracer.trace(Level.FINE, this, "Close of environment " + this.envHome + " started");
            this.envState.checkState(DbEnvState.VALID_FOR_CLOSE, DbEnvState.CLOSED);
            this.requestShutdownDaemons();
            if (doCheckpoint && !this.isReadOnly && this.envState != DbEnvState.INVALID && this.logManager.getLastLsnAtRecovery() != this.fileManager.getLastUsedLsn()) {
                CheckpointConfig ckptConfig = new CheckpointConfig();
                ckptConfig.setForce(true);
                ckptConfig.setMinimizeRecoveryTime(true);
                try {
                    this.invokeCheckpoint(ckptConfig, false, "close");
                }
                catch (DatabaseException IE) {
                    errors.append("\nException performing checkpoint: ");
                    errors.append(IE.toString()).append("\n");
                }
            }
            Tracer.trace(Level.FINE, this, "About to shutdown daemons for Env " + this.envHome);
            try {
                this.shutdownDaemons();
            }
            catch (InterruptedException IE) {
                errors.append("\nException shutting down daemon threads: ");
                errors.append(IE.toString()).append("\n");
            }
            try {
                this.logManager.flush();
            }
            catch (DatabaseException DBE) {
                errors.append("\nException flushing log manager: ");
                errors.append(DBE.toString()).append("\n");
            }
            try {
                this.fileManager.clear();
            }
            catch (IOException IOE) {
                errors.append("\nException clearing file manager: ");
                errors.append(IOE.toString()).append("\n");
            }
            catch (DatabaseException DBE) {
                errors.append("\nException clearing file manager: ");
                errors.append(DBE.toString()).append("\n");
            }
            try {
                this.fileManager.close();
            }
            catch (IOException IOE) {
                errors.append("\nException clearing file manager: ");
                errors.append(IOE.toString()).append("\n");
            }
            catch (DatabaseException DBE) {
                errors.append("\nException clearing file manager: ");
                errors.append(DBE.toString()).append("\n");
            }
            try {
                this.inMemoryINs.clear();
            }
            catch (DatabaseException DBE) {
                errors.append("\nException closing file manager: ");
                errors.append(DBE.toString()).append("\n");
            }
            this.closeLogger();
            DbEnvPool.getInstance().remove(this.envHome);
            try {
                if (this.envState != DbEnvState.INVALID) {
                    this.checkLeaks();
                }
            }
            catch (DatabaseException DBE) {
                errors.append("\nException performing validity checks: ");
                errors.append(DBE.toString()).append("\n");
            }
        }
        finally {
            this.envState = DbEnvState.CLOSED;
        }
        if (errors.length() > 0 && this.savedInvalidatingException == null) {
            throw new RunRecoveryException(this, errors.toString());
        }
    }

    public synchronized void closeAfterRunRecovery() throws DatabaseException {
        try {
            this.shutdownDaemons();
        }
        catch (InterruptedException IE) {
            // empty catch block
        }
        try {
            this.fileManager.clear();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.fileManager.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DbEnvPool.getInstance().remove(this.envHome);
    }

    public synchronized void forceClose() throws DatabaseException {
        this.referenceCount = 1;
        this.close();
    }

    public synchronized void incReferenceCount() {
        ++this.referenceCount;
    }

    public static int getThreadLocalReferenceCount() {
        return threadLocalReferenceCount;
    }

    public static synchronized void incThreadLocalReferenceCount() {
        ++threadLocalReferenceCount;
    }

    public static synchronized void decThreadLocalReferenceCount() {
        --threadLocalReferenceCount;
    }

    public static boolean getNoComparators() {
        return noComparators;
    }

    private void checkLeaks() throws DatabaseException {
        TransactionStats txnStat;
        if (!this.configManager.getBoolean(EnvironmentParams.ENV_CHECK_LEAKS)) {
            return;
        }
        boolean clean = true;
        StatsConfig statsConfig = new StatsConfig();
        statsConfig.setFast(false);
        LockStats lockStat = this.lockStat(statsConfig);
        if (lockStat.getNTotalLocks() != 0) {
            clean = false;
            System.out.println("Problem: " + lockStat.getNTotalLocks() + " locks left");
            this.txnManager.getLockManager().dump();
        }
        if ((txnStat = this.txnStat(statsConfig)).getNActive() != 0) {
            clean = false;
            System.out.println("Problem: " + txnStat.getNActive() + " txns left");
            TransactionStats.Active[] active = txnStat.getActiveTxns();
            if (active != null) {
                for (int i = 0; i < active.length; ++i) {
                    System.out.println(active[i]);
                }
            }
        }
        if (LatchSupport.countLatchesHeld() > 0) {
            clean = false;
            System.out.println("Some latches held at env close.");
            LatchSupport.dumpLatchesHeld();
        }
        if (!$assertionsDisabled && !clean) {
            throw new AssertionError((Object)"Lock, transaction, or latch left behind at environment close");
        }
    }

    public boolean invokeCheckpoint(CheckpointConfig config, boolean flushAll, String invokingSource) throws DatabaseException {
        if (this.checkpointer != null) {
            this.checkpointer.doCheckpoint(config, flushAll, invokingSource);
            return true;
        }
        return false;
    }

    public long forceLogFileFlip() throws DatabaseException {
        return this.logManager.logForceFlip(new SingleItemEntry(LogEntryType.LOG_TRACE, new Tracer("File Flip")));
    }

    public boolean invokeCompressor() throws DatabaseException {
        if (this.inCompressor != null) {
            this.inCompressor.doCompress();
            return true;
        }
        return false;
    }

    public void invokeEvictor() throws DatabaseException {
        if (this.evictor != null) {
            this.evictor.doEvict("manual");
        }
    }

    public int invokeCleaner() throws DatabaseException {
        if (this.cleaner != null) {
            return this.cleaner.doClean(true, false);
        }
        return 0;
    }

    private void requestShutdownDaemons() {
        this.closing = true;
        if (this.inCompressor != null) {
            this.inCompressor.requestShutdown();
        }
        if (this.evictor != null) {
            this.evictor.requestShutdown();
        }
        if (this.checkpointer != null) {
            this.checkpointer.requestShutdown();
        }
        if (this.cleaner != null) {
            this.cleaner.requestShutdown();
        }
    }

    private void shutdownDaemons() throws InterruptedException {
        this.shutdownINCompressor();
        this.shutdownCleaner();
        this.shutdownCheckpointer();
        this.shutdownEvictor();
    }

    public void shutdownINCompressor() throws InterruptedException {
        if (this.inCompressor != null) {
            this.inCompressor.shutdown();
            this.inCompressor.clearEnv();
            this.inCompressor = null;
        }
    }

    public void shutdownEvictor() throws InterruptedException {
        if (this.evictor != null) {
            this.evictor.shutdown();
            this.evictor.clearEnv();
            this.evictor = null;
        }
    }

    void shutdownCheckpointer() throws InterruptedException {
        if (this.checkpointer != null) {
            this.checkpointer.shutdown();
            this.checkpointer.clearEnv();
            this.checkpointer = null;
        }
    }

    public void shutdownCleaner() throws InterruptedException {
        if (this.cleaner != null) {
            this.cleaner.shutdown();
        }
    }

    public boolean isNoLocking() {
        return this.isNoLocking;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isMemOnly() {
        return this.isMemOnly;
    }

    public static boolean getFairLatches() {
        return fairLatches;
    }

    public static boolean getSharedLatches() {
        return useSharedLatchesForINs;
    }

    public boolean getDbEviction() {
        return this.dbEviction;
    }

    public boolean getDeferredWriteTemp() {
        return this.deferredWriteTemp;
    }

    public boolean useDirectNIO() {
        return this.directNIO;
    }

    public static int getAdler32ChunkSize() {
        return adler32ChunkSize;
    }

    public DatabaseImpl createDb(Locker locker, String databaseName, DatabaseConfig dbConfig, Database databaseHandle) throws DatabaseException {
        return this.dbMapTree.createDb(locker, databaseName, dbConfig, databaseHandle);
    }

    public DatabaseImpl getDb(Locker locker, String databaseName, Database databaseHandle) throws DatabaseException {
        return this.dbMapTree.getDb(locker, databaseName, databaseHandle);
    }

    public void releaseDb(DatabaseImpl db) {
        this.dbMapTree.releaseDb(db);
    }

    public List getDbNames() throws DatabaseException {
        return this.dbMapTree.getDbNames();
    }

    public void dumpMapTree() throws DatabaseException {
        this.dbMapTree.dump();
    }

    public void dbRename(Locker locker, String databaseName, String newName) throws DatabaseException {
        this.dbMapTree.dbRename(locker, databaseName, newName);
    }

    public void dbRemove(Locker locker, String databaseName) throws DatabaseException {
        this.dbMapTree.dbRemove(locker, databaseName);
    }

    public TruncateResult truncate(Locker locker, DatabaseImpl database) throws DatabaseException {
        return this.dbMapTree.truncate(locker, database, true);
    }

    public long truncate(Locker locker, String databaseName, boolean returnCount) throws DatabaseException {
        return this.dbMapTree.truncate(locker, databaseName, returnCount);
    }

    public Txn txnBegin(Transaction parent, TransactionConfig txnConfig) throws DatabaseException {
        if (!this.isTransactional) {
            throw new DatabaseException("beginTransaction called,  but Environment was not opened with transactional cpabilities");
        }
        return this.txnManager.txnBegin(parent, txnConfig);
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public DbTree getDbMapTree() {
        return this.dbMapTree;
    }

    public DbConfigManager getConfigManager() {
        return this.configManager;
    }

    public EnvironmentConfig cloneConfig() {
        return DbInternal.cloneConfig(this.configManager.getEnvironmentConfig());
    }

    public EnvironmentMutableConfig cloneMutableConfig() {
        return DbInternal.cloneMutableConfig(this.configManager.getEnvironmentConfig());
    }

    public void checkImmutablePropsForEquality(EnvironmentConfig config) throws IllegalArgumentException {
        DbInternal.checkImmutablePropsForEquality(this.configManager.getEnvironmentConfig(), config);
    }

    public synchronized void setMutableConfig(EnvironmentMutableConfig config) throws DatabaseException {
        EnvironmentConfig newConfig = DbInternal.cloneConfig(this.configManager.getEnvironmentConfig());
        DbInternal.copyMutablePropsTo(config, newConfig);
        this.configManager = new DbConfigManager(newConfig);
        for (int i = this.configObservers.size() - 1; i >= 0; --i) {
            EnvConfigObserver o = (EnvConfigObserver)this.configObservers.get(i);
            o.envConfigUpdate(this.configManager);
        }
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public synchronized void addConfigObserver(EnvConfigObserver o) {
        this.configObservers.add(o);
    }

    public synchronized void removeConfigObserver(EnvConfigObserver o) {
        this.configObservers.remove(o);
    }

    public INList getInMemoryINs() {
        return this.inMemoryINs;
    }

    public TxnManager getTxnManager() {
        return this.txnManager;
    }

    public Checkpointer getCheckpointer() {
        return this.checkpointer;
    }

    public Cleaner getCleaner() {
        return this.cleaner;
    }

    public MemoryBudget getMemoryBudget() {
        return this.memoryBudget;
    }

    public Logger getLogger() {
        return this.envLogger;
    }

    public boolean verify(VerifyConfig config, PrintStream out) throws DatabaseException {
        return this.dbMapTree.verify(config, out);
    }

    public void verifyCursors() throws DatabaseException {
        this.inCompressor.verifyCursors();
    }

    public synchronized EnvironmentStats loadStats(StatsConfig config) throws DatabaseException {
        EnvironmentStats stats = new EnvironmentStats();
        this.inCompressor.loadStats(config, stats);
        this.evictor.loadStats(config, stats);
        this.checkpointer.loadStats(config, stats);
        this.cleaner.loadStats(config, stats);
        this.logManager.loadStats(config, stats);
        this.memoryBudget.loadStats(config, stats);
        return stats;
    }

    public synchronized LockStats lockStat(StatsConfig config) throws DatabaseException {
        return this.txnManager.lockStat(config);
    }

    public synchronized TransactionStats txnStat(StatsConfig config) throws DatabaseException {
        return this.txnManager.txnStat(config);
    }

    public int getINCompressorQueueSize() throws DatabaseException {
        return this.inCompressor.getBinRefQueueSize();
    }

    public RecoveryInfo getLastRecoveryInfo() {
        return this.lastRecoveryInfo;
    }

    public File getEnvironmentHome() {
        return this.envHome;
    }

    public long getTxnTimeout() {
        return this.txnTimeout;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public SharedLatch getTriggerLatch() {
        return this.triggerLatch;
    }

    public Evictor getEvictor() {
        return this.evictor;
    }

    void alertEvictor() {
        if (this.evictor != null) {
            this.evictor.alert();
        }
    }

    public boolean isReplicated() {
        return this.isReplicated;
    }

    public ReplicatorInstance getReplicator() {
        throw new NotImplementedYetException();
    }

    public void setReplicator(ReplicatorInstance repInstance) {
        this.repInstance = repInstance;
    }

    public static boolean maybeForceYield() {
        if (forcedYield) {
            Thread.yield();
        }
        return true;
    }

    static {
        String javaVersion;
        $assertionsDisabled = !EnvironmentImpl.class.desiredAssertionStatus();
        forcedYield = false;
        threadLocalReferenceCount = 0;
        noComparators = false;
        boolean ret = false;
        if (System.getProperty(DISABLE_JAVA_ADLER32) == null && (javaVersion = System.getProperty("java.version")) != null && !javaVersion.startsWith("1.4.")) {
            ret = true;
        }
        JAVA5_AVAILABLE = ret;
    }
}

