/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.config;

import com.sleepycat.je.config.ConfigParam;

public class LongConfigParam
extends ConfigParam {
    private static final String DEBUG_NAME = LongConfigParam.class.getName();
    private Long min;
    private Long max;

    LongConfigParam(String configName, Long minVal, Long maxVal, Long defaultValue, boolean mutable, boolean forReplication, String description) {
        super(configName, defaultValue.toString(), mutable, forReplication, description);
        this.min = minVal;
        this.max = maxVal;
    }

    private void validate(Long value) throws IllegalArgumentException {
        if (value != null) {
            if (this.min != null && value.compareTo(this.min) < 0) {
                throw new IllegalArgumentException(DEBUG_NAME + ":" + " param " + this.name + " doesn't validate, " + value + " is less than min of " + this.min);
            }
            if (this.max != null && value.compareTo(this.max) > 0) {
                throw new IllegalArgumentException(DEBUG_NAME + ":" + " param " + this.name + " doesn't validate, " + value + " is greater than max " + " of " + this.max);
            }
        }
    }

    public void validateValue(String value) throws IllegalArgumentException {
        try {
            this.validate(new Long(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(DEBUG_NAME + ": " + value + " not valid value for " + this.name);
        }
    }

    public String getExtraDescription() {
        StringBuffer minMaxDesc = new StringBuffer();
        if (this.min != null) {
            minMaxDesc.append("# minimum = ").append(this.min);
        }
        if (this.max != null) {
            if (this.min != null) {
                minMaxDesc.append("\n");
            }
            minMaxDesc.append("# maximum = ").append(this.max);
        }
        return minMaxDesc.toString();
    }
}

