/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class EnvironmentMutableConfig
implements Cloneable {
    private boolean txnNoSync = false;
    private boolean txnWriteNoSync = false;
    protected long cacheSize;
    protected Properties props;
    private boolean loadPropertyFile = true;
    boolean validateParams = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EnvironmentMutableConfig() {
        this.props = new Properties();
    }

    EnvironmentMutableConfig(Properties properties) throws IllegalArgumentException {
        DbConfigManager.validateProperties(properties, false, this.getClass().getName());
        this.props = new Properties();
        this.props.putAll((Map<?, ?>)properties);
    }

    public void setTxnNoSync(boolean noSync) {
        this.txnNoSync = noSync;
    }

    public boolean getTxnNoSync() {
        return this.txnNoSync;
    }

    public void setTxnWriteNoSync(boolean writeNoSync) {
        this.txnWriteNoSync = writeNoSync;
    }

    public boolean getTxnWriteNoSync() {
        return this.txnWriteNoSync;
    }

    public void setCacheSize(long totalBytes) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, EnvironmentParams.MAX_MEMORY, Long.toString(totalBytes), this.validateParams);
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCachePercent(int percent) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, EnvironmentParams.MAX_MEMORY_PERCENT, Integer.toString(percent), this.validateParams);
    }

    public int getCachePercent() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.MAX_MEMORY_PERCENT);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cache percent is not a valid integer: " + e.getMessage());
        }
    }

    public void setConfigParam(String paramName, String value) throws IllegalArgumentException {
        DbConfigManager.setConfigParam(this.props, paramName, value, true, this.validateParams, false);
    }

    public String getConfigParam(String paramName) throws IllegalArgumentException {
        return DbConfigManager.getConfigParam(this.props, paramName);
    }

    void setValidateParams(boolean validateParams) {
        this.validateParams = validateParams;
    }

    void checkImmutablePropsForEquality(EnvironmentMutableConfig passedConfig) throws IllegalArgumentException {
        Properties passedProps = passedConfig.props;
        Iterator iter = EnvironmentParams.SUPPORTED_PARAMS.keySet().iterator();
        while (iter.hasNext()) {
            String paramName = (String)iter.next();
            ConfigParam param = (ConfigParam)EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
            if (!$assertionsDisabled && param == null) {
                throw new AssertionError();
            }
            if (param.isMutable()) continue;
            String paramVal = this.props.getProperty(paramName);
            String useParamVal = passedProps.getProperty(paramName);
            if (!(paramVal != null ? !paramVal.equals(useParamVal) : useParamVal != null)) continue;
            throw new IllegalArgumentException(paramName + " is set to " + useParamVal + " in the config parameter" + " which is incompatible" + " with the value of " + paramVal + " in the" + " underlying environment");
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        EnvironmentMutableConfig copy = (EnvironmentMutableConfig)super.clone();
        copy.props = (Properties)this.props.clone();
        return copy;
    }

    EnvironmentMutableConfig cloneMutableConfig() {
        try {
            EnvironmentMutableConfig copy = (EnvironmentMutableConfig)this.clone();
            copy.clearImmutableProps();
            return copy;
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    void copyHandlePropsTo(EnvironmentMutableConfig other) {
        other.txnNoSync = this.txnNoSync;
        other.txnWriteNoSync = this.txnWriteNoSync;
    }

    void copyMutablePropsTo(EnvironmentMutableConfig toConfig) {
        Properties toProps = toConfig.props;
        Enumeration<?> propNames = this.props.propertyNames();
        while (propNames.hasMoreElements()) {
            String paramName = (String)propNames.nextElement();
            ConfigParam param = (ConfigParam)EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
            if (!$assertionsDisabled && param == null) {
                throw new AssertionError();
            }
            if (!param.isMutable()) continue;
            String newVal = this.props.getProperty(paramName);
            toProps.setProperty(paramName, newVal);
        }
    }

    void fillInEnvironmentGeneratedProps(EnvironmentImpl envImpl) {
        this.cacheSize = envImpl.getMemoryBudget().getMaxMemory();
    }

    private void clearImmutableProps() {
        Enumeration<?> propNames = this.props.propertyNames();
        while (propNames.hasMoreElements()) {
            String paramName = (String)propNames.nextElement();
            ConfigParam param = (ConfigParam)EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
            if (!$assertionsDisabled && param == null) {
                throw new AssertionError();
            }
            if (param.isMutable()) continue;
            this.props.remove(paramName);
        }
    }

    Properties getProps() {
        return this.props;
    }

    void setLoadPropertyFile(boolean loadPropertyFile) {
        this.loadPropertyFile = loadPropertyFile;
    }

    boolean getLoadPropertyFile() {
        return this.loadPropertyFile;
    }

    int getNumExplicitlySetParams() {
        return this.props.size();
    }

    public String toString() {
        return this.props.toString();
    }

    static {
        $assertionsDisabled = !EnvironmentMutableConfig.class.desiredAssertionStatus();
    }
}

