/*
 * Decompiled with CFR 0.152.
 */
package be.redlab.jaxb.swagger.process;

import be.redlab.jaxb.swagger.DataTypeDeterminationUtil;
import be.redlab.jaxb.swagger.XJCHelper;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.wordnik.swagger.annotations.ApiProperty;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessUtil {
    private static final String NOTES = "notes";
    private static final String REQUIRED = "required";
    private static final String DATA_TYPE = "dataType";
    private static final String IS = "is";
    private static final String VALUE = "value";
    private static final String GET = "get";
    private static final ProcessUtil myself = new ProcessUtil();

    private ProcessUtil() {
    }

    public static ProcessUtil getInstance() {
        return myself;
    }

    public boolean validFieldMods(int mods) {
        return (mods & 8) == 0 && (mods & 0x10) == 0 && (mods & 0x20) == 0 && (mods & 0x40) == 0 && (mods & 0x100) == 0 && (mods & 0x200) == 0;
    }

    public void addMethodAnnotationForField(JDefinedClass implClass, JFieldVar jFieldVar, Collection<EnumOutline> enums) {
        JMethod jm = this.getCorrespondingMethod(implClass, jFieldVar.name());
        if (null != jm) {
            this.addMethodAnnotation(implClass, jm, this.isRequired(jFieldVar), this.getDefault(jFieldVar), enums);
        }
    }

    public String getDefault(JFieldVar jFieldVar) {
        JAnnotationUse annotation = XJCHelper.getAnnotation(jFieldVar.annotations(), XmlElement.class);
        if (null != annotation) {
            return XJCHelper.getStringValueFromAnnotationMember(annotation, "defaultValue");
        }
        return null;
    }

    public boolean isRequired(JFieldVar jFieldVar) {
        return jFieldVar.type().isPrimitive() || this.isRequiredByAnnotation(XJCHelper.getAnnotation(jFieldVar.annotations(), XmlElement.class));
    }

    public boolean isRequiredByAnnotation(JAnnotationUse annotation) {
        return null != annotation && "true".equalsIgnoreCase(XJCHelper.getStringValueFromAnnotationMember(annotation, REQUIRED));
    }

    public JMethod getCorrespondingMethod(JDefinedClass implClass, String key) {
        StringBuilder b = new StringBuilder(key.substring(0, 1).toUpperCase());
        if (key.length() > 1) {
            b.append(key.substring(1));
        }
        String get = GET + b.toString();
        String is = IS + b.toString();
        for (JMethod m : implClass.methods()) {
            if (!get.equals(m.name()) && !is.equals(m.name())) continue;
            return m;
        }
        return null;
    }

    public boolean validMethodMods(int mods) {
        return (mods & 2) == 0 && (mods & 4) == 0 && (mods & 8) == 0 && (mods & 0x10) == 0 && (mods & 0x20) == 0 && (mods & 0x40) == 0 && (mods & 0x100) == 0 && (mods & 0x200) == 0;
    }

    public void addMethodAnnotation(JDefinedClass o, JMethod m, boolean required, String defaultValue, Collection<EnumOutline> enums) {
        if (null == XJCHelper.getAnnotation(m.annotations(), ApiProperty.class)) {
            if (this.isValidMethod(m, GET)) {
                this.internalAddMethodAnnotation(o, m, GET, required, defaultValue, enums);
            } else if (this.isValidMethod(m, IS)) {
                this.internalAddMethodAnnotation(o, m, IS, required, defaultValue, enums);
            }
        }
    }

    protected void internalAddMethodAnnotation(JDefinedClass implClass, JMethod m, String prefix, boolean required, String defaultValue, Collection<EnumOutline> enums) {
        String datatype;
        JAnnotationUse apiProperty = m.annotate(ApiProperty.class);
        String name = this.prepareNameFromMethod(m.name(), prefix);
        apiProperty.param(VALUE, name);
        EnumOutline eo = this.getKnownEnum(m.type().fullName(), enums);
        if (null != eo) {
            ProcessUtil.addAllowableValues(eo, apiProperty);
            datatype = "string";
        } else {
            datatype = DataTypeDeterminationUtil.setDataType(m.type());
        }
        apiProperty.param(DATA_TYPE, datatype);
        if (required) {
            apiProperty.param(REQUIRED, true);
        }
        if (null != defaultValue) {
            apiProperty.param(NOTES, defaultValue);
        }
    }

    private static void addAllowableValues(EnumOutline eo, JAnnotationUse apiProperty) {
        List constants = eo.constants;
        StringBuilder b = new StringBuilder();
        int size = constants.size();
        int classNameLength = eo.clazz.fullName().length() + 1;
        for (int i = 0; i < size; ++i) {
            b.append(((EnumConstantOutline)constants.get((int)i)).constRef.getName().substring(classNameLength));
            if (i >= size - 1) continue;
            b.append(',');
        }
        apiProperty.param("allowableValues", b.toString());
    }

    public boolean isValidMethod(JMethod m, String prefix) {
        return m.name().length() > prefix.length() && m.name().startsWith(prefix);
    }

    public String prepareNameFromMethod(String getterName, String prefix) {
        String name = getterName.substring(prefix.length());
        StringBuilder b = new StringBuilder();
        b.append(Character.toLowerCase(name.charAt(0)));
        if (name.length() > 1) {
            b.append(name.substring(1));
        }
        return b.toString();
    }

    public EnumOutline getKnownEnum(String clazz, Collection<EnumOutline> enums) {
        for (EnumOutline eo : enums) {
            if (!eo.clazz.fullName().equals(clazz)) continue;
            return eo;
        }
        return null;
    }
}

