/*
 * Decompiled with CFR 0.152.
 */
package be.redlab.jaxb.swagger;

import be.redlab.jaxb.swagger.ProcessStrategy;
import be.redlab.jaxb.swagger.XJCHelper;
import be.redlab.jaxb.swagger.process.FieldProcessStrategy;
import be.redlab.jaxb.swagger.process.NoProcessStrategy;
import be.redlab.jaxb.swagger.process.PropertyProcessStrategy;
import be.redlab.jaxb.swagger.process.PublicMemberProcessStrategy;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import com.wordnik.swagger.annotations.ApiClass;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SwaggerAnnotationsJaxbPlugin
extends Plugin {
    private static final String DESCRIPTION_CLASS = " description generated by jaxb-swagger, hence no class description yet.";
    private static final String WARNING_SKIPPING = "Skipping %s as it is not an implementation or class";
    private static final String DESCRIPTION = "description";
    private static final String SWAGGERIFY = "swaggerify";
    private static final String USAGE = "Add this plugin to the JAXB classes generator classpath and provide the argument '-swaggerify'.";
    private static final String VALUE = "value";
    private static FieldProcessStrategy fieldProcessor;
    private static NoProcessStrategy noProcessor;
    private static PropertyProcessStrategy propProcessor;
    private static PublicMemberProcessStrategy publicMemberProcessor;

    public String getOptionName() {
        return SWAGGERIFY;
    }

    public String getUsage() {
        return USAGE;
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        Collection classes = outline.getClasses();
        Collection enums = outline.getEnums();
        for (ClassOutline o : classes) {
            JDefinedClass implClass = o.implClass;
            if (null != implClass && implClass.isClass() && !implClass.isAbstract() && !implClass.isInterface() && !implClass.isAnnotationTypeDeclaration()) {
                XmlAccessType access;
                Collection annotations = implClass.annotations();
                if (annotations.isEmpty() || null == (access = XJCHelper.getAccessType(annotations))) continue;
                this.addClassAnnotation(o);
                SwaggerAnnotationsJaxbPlugin.getProcessStrategy(access).process(implClass, enums);
                continue;
            }
            errorHandler.warning(new SAXParseException(String.format(WARNING_SKIPPING, o), null));
        }
        return true;
    }

    protected void addClassAnnotation(ClassOutline o) {
        JAnnotationUse apiClass = o.implClass.annotate(ApiClass.class);
        apiClass.param(VALUE, o.ref.name());
        apiClass.param(DESCRIPTION, o.ref.fullName() + DESCRIPTION_CLASS);
    }

    public static ProcessStrategy getProcessStrategy(XmlAccessType access) {
        switch (access) {
            case FIELD: {
                return null == fieldProcessor ? (fieldProcessor = new FieldProcessStrategy()) : fieldProcessor;
            }
            case NONE: {
                return null == noProcessor ? (noProcessor = new NoProcessStrategy()) : noProcessor;
            }
            case PROPERTY: {
                return null == propProcessor ? (propProcessor = new PropertyProcessStrategy()) : propProcessor;
            }
            case PUBLIC_MEMBER: {
                return null == publicMemberProcessor ? (publicMemberProcessor = new PublicMemberProcessStrategy()) : publicMemberProcessor;
            }
        }
        throw new UnsupportedOperationException(String.format("%s not supported as ProcessStrategy", access));
    }
}

