/*
 * Decompiled with CFR 0.152.
 */
package be.redlab.jaxb.swagger;

import com.sun.codemodel.JType;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;

public class DataTypeDeterminationUtil {
    public static String setDataType(JType jType) {
        String newName = jType.name();
        String fullName = jType.fullName();
        if (jType.isArray()) {
            newName = "Array";
        } else if (jType.isPrimitive()) {
            newName = fullName.equals("short") ? "int" : fullName;
        } else if (fullName.equals(String.class.getName())) {
            newName = "string";
        } else if (fullName.equals(Integer.class.getName())) {
            newName = "int";
        } else if (fullName.equals(BigInteger.class.getName()) || fullName.equals(Long.class.getName())) {
            newName = "long";
        } else if (fullName.equals(Double.class.getName())) {
            newName = "double";
        } else if (fullName.equals(Byte.class.getName())) {
            newName = "byte";
        } else if (fullName.equals(Float.class.getName())) {
            newName = "float";
        } else if (fullName.equals(Short.class.getName())) {
            newName = "int";
        } else if (fullName.equals(Boolean.class.getName())) {
            newName = "boolean";
        } else if (fullName.equals(Date.class.getName())) {
            newName = "long";
        } else {
            try {
                Class<?> forName;
                if (fullName.contains("<")) {
                    StringBuilder untypedName = new StringBuilder();
                    for (char c : fullName.toCharArray()) {
                        if (c == '<') break;
                        untypedName.append(c);
                    }
                    fullName = untypedName.toString();
                }
                if (XMLGregorianCalendar.class.isAssignableFrom(forName = Class.forName(fullName))) {
                    newName = "date";
                } else if (List.class.isAssignableFrom(forName)) {
                    newName = "List";
                } else if (Set.class.isAssignableFrom(forName)) {
                    newName = "Set";
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return newName;
    }
}

