/*
 * Decompiled with CFR 0.152.
 */
package at.mukprojects.exclycore.model;

import at.mukprojects.exclycore.model.ExclyDataType;
import at.mukprojects.exclycore.model.ExclyLongError;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;

public class ExclyLong
implements ExclyDataType,
Comparable<ExclyLong> {
    protected boolean error;
    private Long data;

    public ExclyLong(long data) {
        this.data = data;
        this.error = false;
    }

    public ExclyLong(double data) {
        this((long)data);
    }

    @Override
    public void setCell(Cell cell) {
        this.setCell(cell, cell.getCellStyle());
    }

    @Override
    public void setCell(Cell cell, CellStyle cellStyle) {
        cell.setCellValue((double)this.data.longValue());
        cell.setCellStyle(cellStyle);
    }

    public long getData() {
        return this.data;
    }

    public boolean isError() {
        return this.error;
    }

    public String toString() {
        return this.data + "";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.data * 1000L);
        result = 31 * result + (this.error ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExclyLong other = (ExclyLong)obj;
        if (this.data != other.data) {
            return false;
        }
        return this.error == other.error;
    }

    @Override
    public int compareTo(ExclyLong other) {
        if (!this.error && other.error) {
            return -1;
        }
        if (this.error && !other.error) {
            return 1;
        }
        if (this.error && other.error) {
            return 0;
        }
        return this.data.compareTo(other.data);
    }

    public static ExclyLong add(ExclyLong ... values) {
        ExclyLongError error = null;
        Long data = null;
        for (ExclyLong value : values) {
            if (data == null) {
                if (value.isError()) {
                    error = new ExclyLongError();
                } else {
                    data = value.getData();
                }
            } else if (value.isError()) {
                error = new ExclyLongError();
            } else {
                data = data + value.getData();
            }
            if (error == null) continue;
            return error;
        }
        return new ExclyLong(data);
    }

    public static ExclyLong sub(ExclyLong ... values) {
        ExclyLongError error = null;
        Long data = null;
        for (ExclyLong value : values) {
            if (data == null) {
                if (value.isError()) {
                    error = new ExclyLongError();
                } else {
                    data = value.getData();
                }
            } else if (value.isError()) {
                error = new ExclyLongError();
            } else {
                data = data - value.getData();
            }
            if (error == null) continue;
            return error;
        }
        return new ExclyLong(data);
    }
}

