/*
 * Decompiled with CFR 0.152.
 */
package at.mukprojects.exclycore.model;

import at.mukprojects.exclycore.model.ExclyDataType;
import at.mukprojects.exclycore.model.ExclyIntegerError;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;

public class ExclyInteger
implements ExclyDataType,
Comparable<ExclyInteger> {
    protected boolean error;
    private Integer data;

    public ExclyInteger(int data) {
        this.data = data;
        this.error = false;
    }

    public ExclyInteger(double data) {
        this((int)data);
    }

    @Override
    public void setCell(Cell cell) {
        this.setCell(cell, cell.getCellStyle());
    }

    @Override
    public void setCell(Cell cell, CellStyle cellStyle) {
        cell.setCellValue((double)this.data.intValue());
        cell.setCellStyle(cellStyle);
    }

    public int getData() {
        return this.data;
    }

    public boolean isError() {
        return this.error;
    }

    public String toString() {
        return this.data + "";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.data;
        result = 31 * result + (this.error ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExclyInteger other = (ExclyInteger)obj;
        if (this.data != other.data) {
            return false;
        }
        return this.error == other.error;
    }

    @Override
    public int compareTo(ExclyInteger other) {
        if (!this.error && other.error) {
            return -1;
        }
        if (this.error && !other.error) {
            return 1;
        }
        if (this.error && other.error) {
            return 0;
        }
        return this.data.compareTo(other.data);
    }

    public static ExclyInteger add(ExclyInteger ... values) {
        ExclyIntegerError error = null;
        Integer data = null;
        for (ExclyInteger value : values) {
            if (data == null) {
                if (value.isError()) {
                    error = new ExclyIntegerError();
                } else {
                    data = value.getData();
                }
            } else if (value.isError()) {
                error = new ExclyIntegerError();
            } else {
                data = data + value.getData();
            }
            if (error == null) continue;
            return error;
        }
        return new ExclyInteger(data);
    }

    public static ExclyInteger sub(ExclyInteger ... values) {
        ExclyIntegerError error = null;
        Integer data = null;
        for (ExclyInteger value : values) {
            if (data == null) {
                if (value.isError()) {
                    error = new ExclyIntegerError();
                } else {
                    data = value.getData();
                }
            } else if (value.isError()) {
                error = new ExclyIntegerError();
            } else {
                data = data - value.getData();
            }
            if (error == null) continue;
            return error;
        }
        return new ExclyInteger(data);
    }
}

