/*
 * Decompiled with CFR 0.152.
 */
package at.mukprojects.exclycore.model;

import at.mukprojects.exclycore.model.ExclyDataType;
import at.mukprojects.exclycore.model.ExclyDateError;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;

public class ExclyDate
implements ExclyDataType,
Comparable<ExclyDate> {
    protected boolean error;
    private Date data;

    public ExclyDate(Date data) {
        this.data = data;
        this.error = false;
    }

    @Override
    public void setCell(Cell cell) {
        this.setCell(cell, cell.getCellStyle());
    }

    @Override
    public void setCell(Cell cell, CellStyle cellStyle) {
        cell.setCellValue(this.data);
        cell.setCellStyle(cellStyle);
    }

    public Date getData() {
        return this.data;
    }

    public boolean isError() {
        return this.error;
    }

    public String toString() {
        return this.data.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.error ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExclyDate other = (ExclyDate)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return this.error == other.error;
    }

    @Override
    public int compareTo(ExclyDate other) {
        if (!this.error && other.error || this.data != null && other.data == null) {
            return -1;
        }
        if (this.error && !other.error || this.data == null && other.data != null) {
            return 1;
        }
        if (this.error && other.error || this.data == null && other.data == null) {
            return 0;
        }
        return this.data.compareTo(other.data);
    }

    public static ExclyDate add(ExclyDate ... dates) {
        ExclyDateError error = null;
        Date dateData = null;
        for (ExclyDate date : dates) {
            if (dateData == null) {
                if (date.isError()) {
                    error = new ExclyDateError();
                } else {
                    dateData = date.getData();
                }
            } else if (date.isError()) {
                error = new ExclyDateError();
            } else if (date.getData() != null) {
                dateData = new Date(dateData.getTime() + date.getData().getTime());
            }
            if (error == null) continue;
            return error;
        }
        return new ExclyDate(dateData);
    }

    public static ExclyDate sub(ExclyDate ... dates) {
        ExclyDateError error = null;
        Date dateData = null;
        for (ExclyDate date : dates) {
            if (dateData == null) {
                if (date.isError()) {
                    error = new ExclyDateError();
                } else {
                    dateData = date.getData();
                }
            } else if (date.isError()) {
                error = new ExclyDateError();
            } else if (date.getData() != null) {
                dateData = new Date(dateData.getTime() - date.getData().getTime());
            }
            if (error == null) continue;
            return error;
        }
        return new ExclyDate(dateData);
    }
}

