/*
 * Decompiled with CFR 0.152.
 */
package at.mukprojects.exclycore.dao;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XLSXWriter {
    private static final Logger log = LoggerFactory.getLogger(XLSXWriter.class);
    private FileOutputStream outputStream;
    private XSSFWorkbook outputWorkbook;
    private File output;
    private File tempOutput;

    protected XSSFWorkbook createWorkbook(File output, boolean add) throws IOException {
        log.info("Workbook gets created...");
        this.output = output;
        if (add) {
            log.info("The content will be appended to the existing file.");
            if (output.exists() && output.getName().endsWith("xlsx")) {
                try {
                    this.outputWorkbook = (XSSFWorkbook)WorkbookFactory.create((File)output);
                }
                catch (InvalidFormatException e) {
                    log.error("The Writer is unable to open the existing Workbook.", (Throwable)e);
                    throw new IOException("The Writer is unable to open the existing Workbook.", e);
                }
                this.tempOutput = new File(output.getAbsolutePath() + ".temp");
                this.outputStream = new FileOutputStream(this.tempOutput);
            } else {
                this.outputStream = new FileOutputStream(output);
                this.outputWorkbook = new XSSFWorkbook();
            }
        } else {
            log.info("The content will be written in a new file.");
            this.outputStream = new FileOutputStream(output);
            this.outputWorkbook = new XSSFWorkbook();
        }
        return this.outputWorkbook;
    }

    protected void closeWorkbook() throws IOException {
        if (this.outputWorkbook != null) {
            this.outputWorkbook.write((OutputStream)this.outputStream);
            if (this.tempOutput != null) {
                this.output.delete();
                this.tempOutput.renameTo(this.output);
                this.tempOutput.delete();
            }
            this.outputWorkbook.close();
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

