/*
 * Decompiled with CFR 0.152.
 */
package androidx.vectordrawable.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorSet;
import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.util.Xml;
import android.view.InflateException;
import android.view.animation.Interpolator;
import androidx.annotation.AnimatorRes;
import androidx.annotation.RestrictTo;
import androidx.core.content.res.TypedArrayUtils;
import androidx.core.graphics.PathParser;
import androidx.vectordrawable.graphics.drawable.AndroidResources;
import androidx.vectordrawable.graphics.drawable.AnimationUtilsCompat;
import androidx.vectordrawable.graphics.drawable.ArgbEvaluator;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AnimatorInflaterCompat {
    private static final String TAG = "AnimatorInflater";
    private static final int TOGETHER = 0;
    private static final int MAX_NUM_POINTS = 100;
    private static final int VALUE_TYPE_FLOAT = 0;
    private static final int VALUE_TYPE_INT = 1;
    private static final int VALUE_TYPE_PATH = 2;
    private static final int VALUE_TYPE_COLOR = 3;
    private static final int VALUE_TYPE_UNDEFINED = 4;
    private static final boolean DBG_ANIMATOR_INFLATER = false;

    public static Animator loadAnimator(Context context, @AnimatorRes int id) throws Resources.NotFoundException {
        Animator objectAnimator = Build.VERSION.SDK_INT >= 24 ? AnimatorInflater.loadAnimator((Context)context, (int)id) : AnimatorInflaterCompat.loadAnimator(context, context.getResources(), context.getTheme(), id);
        return objectAnimator;
    }

    public static Animator loadAnimator(Context context, Resources resources, Resources.Theme theme, @AnimatorRes int id) throws Resources.NotFoundException {
        return AnimatorInflaterCompat.loadAnimator(context, resources, theme, id, 1.0f);
    }

    public static Animator loadAnimator(Context context, Resources resources, Resources.Theme theme, @AnimatorRes int id, float pathErrorScale) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            Animator animator;
            parser = resources.getAnimation(id);
            Animator animator2 = animator = AnimatorInflaterCompat.createAnimatorFromXml(context, resources, theme, (XmlPullParser)parser, pathErrorScale);
            return animator2;
        }
    }

    private static PropertyValuesHolder getPVH(TypedArray styledAttributes, int valueType, int valueFromId, int valueToId, String propertyName) {
        int toType;
        TypedValue tvFrom = styledAttributes.peekValue(valueFromId);
        boolean hasFrom = tvFrom != null;
        int fromType = hasFrom ? tvFrom.type : 0;
        TypedValue tvTo = styledAttributes.peekValue(valueToId);
        boolean hasTo = tvTo != null;
        int n = toType = hasTo ? tvTo.type : 0;
        if (valueType == 4) {
            valueType = hasFrom && AnimatorInflaterCompat.isColorType(fromType) || hasTo && AnimatorInflaterCompat.isColorType(toType) ? 3 : 0;
        }
        boolean getFloats = valueType == 0;
        PropertyValuesHolder returnValue = null;
        if (valueType == 2) {
            String fromString = styledAttributes.getString(valueFromId);
            String toString = styledAttributes.getString(valueToId);
            PathParser.PathDataNode[] nodesFrom = PathParser.createNodesFromPathData((String)fromString);
            PathParser.PathDataNode[] nodesTo = PathParser.createNodesFromPathData((String)toString);
            if (nodesFrom != null || nodesTo != null) {
                if (nodesFrom != null) {
                    PathDataEvaluator evaluator = new PathDataEvaluator();
                    if (nodesTo != null) {
                        if (!PathParser.canMorph((PathParser.PathDataNode[])nodesFrom, (PathParser.PathDataNode[])nodesTo)) {
                            throw new InflateException(" Can't morph from " + fromString + " to " + toString);
                        }
                        returnValue = PropertyValuesHolder.ofObject((String)propertyName, (TypeEvaluator)evaluator, (Object[])new Object[]{nodesFrom, nodesTo});
                    } else {
                        returnValue = PropertyValuesHolder.ofObject((String)propertyName, (TypeEvaluator)evaluator, (Object[])new Object[]{nodesFrom});
                    }
                } else if (nodesTo != null) {
                    PathDataEvaluator evaluator = new PathDataEvaluator();
                    returnValue = PropertyValuesHolder.ofObject((String)propertyName, (TypeEvaluator)evaluator, (Object[])new Object[]{nodesTo});
                }
            }
        } else {
            ArgbEvaluator evaluator = null;
            if (valueType == 3) {
                evaluator = ArgbEvaluator.getInstance();
            }
            if (getFloats) {
                if (hasFrom) {
                    float valueFrom = fromType == 5 ? styledAttributes.getDimension(valueFromId, 0.0f) : styledAttributes.getFloat(valueFromId, 0.0f);
                    if (hasTo) {
                        float valueTo = toType == 5 ? styledAttributes.getDimension(valueToId, 0.0f) : styledAttributes.getFloat(valueToId, 0.0f);
                        returnValue = PropertyValuesHolder.ofFloat((String)propertyName, (float[])new float[]{valueFrom, valueTo});
                    } else {
                        returnValue = PropertyValuesHolder.ofFloat((String)propertyName, (float[])new float[]{valueFrom});
                    }
                } else {
                    float valueTo = toType == 5 ? styledAttributes.getDimension(valueToId, 0.0f) : styledAttributes.getFloat(valueToId, 0.0f);
                    returnValue = PropertyValuesHolder.ofFloat((String)propertyName, (float[])new float[]{valueTo});
                }
            } else if (hasFrom) {
                int valueFrom = fromType == 5 ? (int)styledAttributes.getDimension(valueFromId, 0.0f) : (AnimatorInflaterCompat.isColorType(fromType) ? styledAttributes.getColor(valueFromId, 0) : styledAttributes.getInt(valueFromId, 0));
                if (hasTo) {
                    int valueTo = toType == 5 ? (int)styledAttributes.getDimension(valueToId, 0.0f) : (AnimatorInflaterCompat.isColorType(toType) ? styledAttributes.getColor(valueToId, 0) : styledAttributes.getInt(valueToId, 0));
                    returnValue = PropertyValuesHolder.ofInt((String)propertyName, (int[])new int[]{valueFrom, valueTo});
                } else {
                    returnValue = PropertyValuesHolder.ofInt((String)propertyName, (int[])new int[]{valueFrom});
                }
            } else if (hasTo) {
                int valueTo = toType == 5 ? (int)styledAttributes.getDimension(valueToId, 0.0f) : (AnimatorInflaterCompat.isColorType(toType) ? styledAttributes.getColor(valueToId, 0) : styledAttributes.getInt(valueToId, 0));
                returnValue = PropertyValuesHolder.ofInt((String)propertyName, (int[])new int[]{valueTo});
            }
            if (returnValue != null && evaluator != null) {
                returnValue.setEvaluator((TypeEvaluator)evaluator);
            }
        }
        return returnValue;
    }

    private static void parseAnimatorFromTypeArray(ValueAnimator anim, TypedArray arrayAnimator, TypedArray arrayObjectAnimator, float pixelSize, XmlPullParser parser) {
        long duration = TypedArrayUtils.getNamedInt((TypedArray)arrayAnimator, (XmlPullParser)parser, (String)"duration", (int)1, (int)300);
        long startDelay = TypedArrayUtils.getNamedInt((TypedArray)arrayAnimator, (XmlPullParser)parser, (String)"startOffset", (int)2, (int)0);
        int valueType = TypedArrayUtils.getNamedInt((TypedArray)arrayAnimator, (XmlPullParser)parser, (String)"valueType", (int)7, (int)4);
        if (TypedArrayUtils.hasAttribute((XmlPullParser)parser, (String)"valueFrom") && TypedArrayUtils.hasAttribute((XmlPullParser)parser, (String)"valueTo")) {
            PropertyValuesHolder pvh;
            if (valueType == 4) {
                valueType = AnimatorInflaterCompat.inferValueTypeFromValues(arrayAnimator, 5, 6);
            }
            if ((pvh = AnimatorInflaterCompat.getPVH(arrayAnimator, valueType, 5, 6, "")) != null) {
                anim.setValues(new PropertyValuesHolder[]{pvh});
            }
        }
        anim.setDuration(duration);
        anim.setStartDelay(startDelay);
        anim.setRepeatCount(TypedArrayUtils.getNamedInt((TypedArray)arrayAnimator, (XmlPullParser)parser, (String)"repeatCount", (int)3, (int)0));
        anim.setRepeatMode(TypedArrayUtils.getNamedInt((TypedArray)arrayAnimator, (XmlPullParser)parser, (String)"repeatMode", (int)4, (int)1));
        if (arrayObjectAnimator != null) {
            AnimatorInflaterCompat.setupObjectAnimator(anim, arrayObjectAnimator, valueType, pixelSize, parser);
        }
    }

    private static void setupObjectAnimator(ValueAnimator anim, TypedArray arrayObjectAnimator, int valueType, float pixelSize, XmlPullParser parser) {
        ObjectAnimator oa = (ObjectAnimator)anim;
        String pathData = TypedArrayUtils.getNamedString((TypedArray)arrayObjectAnimator, (XmlPullParser)parser, (String)"pathData", (int)1);
        if (pathData != null) {
            String propertyXName = TypedArrayUtils.getNamedString((TypedArray)arrayObjectAnimator, (XmlPullParser)parser, (String)"propertyXName", (int)2);
            String propertyYName = TypedArrayUtils.getNamedString((TypedArray)arrayObjectAnimator, (XmlPullParser)parser, (String)"propertyYName", (int)3);
            if (valueType == 2 || valueType == 4) {
                valueType = 0;
            }
            if (propertyXName == null && propertyYName == null) {
                throw new InflateException(arrayObjectAnimator.getPositionDescription() + " propertyXName or propertyYName is needed for PathData");
            }
            Path path = PathParser.createPathFromPathData((String)pathData);
            AnimatorInflaterCompat.setupPathMotion(path, oa, 0.5f * pixelSize, propertyXName, propertyYName);
        } else {
            String propertyName = TypedArrayUtils.getNamedString((TypedArray)arrayObjectAnimator, (XmlPullParser)parser, (String)"propertyName", (int)0);
            oa.setPropertyName(propertyName);
        }
    }

    private static void setupPathMotion(Path path, ObjectAnimator oa, float precision, String propertyXName, String propertyYName) {
        PathMeasure measureForTotalLength = new PathMeasure(path, false);
        float totalLength = 0.0f;
        ArrayList<Float> contourLengths = new ArrayList<Float>();
        contourLengths.add(Float.valueOf(0.0f));
        do {
            float pathLength = measureForTotalLength.getLength();
            contourLengths.add(Float.valueOf(totalLength += pathLength));
        } while (measureForTotalLength.nextContour());
        PathMeasure pathMeasure = new PathMeasure(path, false);
        int numPoints = Math.min(100, (int)(totalLength / precision) + 1);
        float[] mX = new float[numPoints];
        float[] mY = new float[numPoints];
        float[] position = new float[2];
        int contourIndex = 0;
        float step = totalLength / (float)(numPoints - 1);
        float currentDistance = 0.0f;
        for (int i = 0; i < numPoints; ++i) {
            pathMeasure.getPosTan(currentDistance - ((Float)contourLengths.get(contourIndex)).floatValue(), position, null);
            mX[i] = position[0];
            mY[i] = position[1];
            currentDistance += step;
            if (contourIndex + 1 >= contourLengths.size() || !(currentDistance > ((Float)contourLengths.get(contourIndex + 1)).floatValue())) continue;
            ++contourIndex;
            pathMeasure.nextContour();
        }
        PropertyValuesHolder x = null;
        PropertyValuesHolder y = null;
        if (propertyXName != null) {
            x = PropertyValuesHolder.ofFloat((String)propertyXName, (float[])mX);
        }
        if (propertyYName != null) {
            y = PropertyValuesHolder.ofFloat((String)propertyYName, (float[])mY);
        }
        if (x == null) {
            oa.setValues(new PropertyValuesHolder[]{y});
        } else if (y == null) {
            oa.setValues(new PropertyValuesHolder[]{x});
        } else {
            oa.setValues(new PropertyValuesHolder[]{x, y});
        }
    }

    private static Animator createAnimatorFromXml(Context context, Resources res, Resources.Theme theme, XmlPullParser parser, float pixelSize) throws XmlPullParserException, IOException {
        return AnimatorInflaterCompat.createAnimatorFromXml(context, res, theme, parser, Xml.asAttributeSet((XmlPullParser)parser), null, 0, pixelSize);
    }

    private static Animator createAnimatorFromXml(Context context, Resources res, Resources.Theme theme, XmlPullParser parser, AttributeSet attrs, AnimatorSet parent, int sequenceOrdering, float pixelSize) throws XmlPullParserException, IOException {
        int type;
        ObjectAnimator anim = null;
        ArrayList<ObjectAnimator> childAnims = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            boolean gotValues = false;
            if (name.equals("objectAnimator")) {
                anim = AnimatorInflaterCompat.loadObjectAnimator(context, res, theme, attrs, pixelSize, parser);
            } else if (name.equals("animator")) {
                anim = AnimatorInflaterCompat.loadAnimator(context, res, theme, attrs, null, pixelSize, parser);
            } else if (name.equals("set")) {
                anim = new AnimatorSet();
                TypedArray a = TypedArrayUtils.obtainAttributes((Resources)res, (Resources.Theme)theme, (AttributeSet)attrs, (int[])AndroidResources.STYLEABLE_ANIMATOR_SET);
                int n = TypedArrayUtils.getNamedInt((TypedArray)a, (XmlPullParser)parser, (String)"ordering", (int)0, (int)0);
                AnimatorInflaterCompat.createAnimatorFromXml(context, res, theme, parser, attrs, (AnimatorSet)anim, n, pixelSize);
                a.recycle();
            } else if (name.equals("propertyValuesHolder")) {
                PropertyValuesHolder[] values = AnimatorInflaterCompat.loadValues(context, res, theme, parser, Xml.asAttributeSet((XmlPullParser)parser));
                if (values != null && anim instanceof ValueAnimator) {
                    ((ValueAnimator)anim).setValues(values);
                }
                gotValues = true;
            } else {
                throw new RuntimeException("Unknown animator name: " + parser.getName());
            }
            if (parent == null || gotValues) continue;
            if (childAnims == null) {
                childAnims = new ArrayList<ObjectAnimator>();
            }
            childAnims.add(anim);
        }
        if (parent != null && childAnims != null) {
            Animator[] animsArray = new Animator[childAnims.size()];
            int index = 0;
            for (Animator animator : childAnims) {
                animsArray[index++] = animator;
            }
            if (sequenceOrdering == 0) {
                parent.playTogether(animsArray);
            } else {
                parent.playSequentially(animsArray);
            }
        }
        return anim;
    }

    private static PropertyValuesHolder[] loadValues(Context context, Resources res, Resources.Theme theme, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        ArrayList<PropertyValuesHolder> values = null;
        while ((type = parser.getEventType()) != 3 && type != 1) {
            if (type != 2) {
                parser.next();
                continue;
            }
            String name = parser.getName();
            if (name.equals("propertyValuesHolder")) {
                int valueType;
                TypedArray a = TypedArrayUtils.obtainAttributes((Resources)res, (Resources.Theme)theme, (AttributeSet)attrs, (int[])AndroidResources.STYLEABLE_PROPERTY_VALUES_HOLDER);
                String propertyName = TypedArrayUtils.getNamedString((TypedArray)a, (XmlPullParser)parser, (String)"propertyName", (int)3);
                PropertyValuesHolder pvh = AnimatorInflaterCompat.loadPvh(context, res, theme, parser, propertyName, valueType = TypedArrayUtils.getNamedInt((TypedArray)a, (XmlPullParser)parser, (String)"valueType", (int)2, (int)4));
                if (pvh == null) {
                    pvh = AnimatorInflaterCompat.getPVH(a, valueType, 0, 1, propertyName);
                }
                if (pvh != null) {
                    if (values == null) {
                        values = new ArrayList<PropertyValuesHolder>();
                    }
                    values.add(pvh);
                }
                a.recycle();
            }
            parser.next();
        }
        PropertyValuesHolder[] valuesArray = null;
        if (values != null) {
            int count = values.size();
            valuesArray = new PropertyValuesHolder[count];
            for (int i = 0; i < count; ++i) {
                valuesArray[i] = (PropertyValuesHolder)values.get(i);
            }
        }
        return valuesArray;
    }

    private static int inferValueTypeOfKeyframe(Resources res, Resources.Theme theme, AttributeSet attrs, XmlPullParser parser) {
        TypedArray a = TypedArrayUtils.obtainAttributes((Resources)res, (Resources.Theme)theme, (AttributeSet)attrs, (int[])AndroidResources.STYLEABLE_KEYFRAME);
        TypedValue keyframeValue = TypedArrayUtils.peekNamedValue((TypedArray)a, (XmlPullParser)parser, (String)"value", (int)0);
        boolean hasValue = keyframeValue != null;
        int valueType = hasValue && AnimatorInflaterCompat.isColorType(keyframeValue.type) ? 3 : 0;
        a.recycle();
        return valueType;
    }

    private static int inferValueTypeFromValues(TypedArray styledAttributes, int valueFromId, int valueToId) {
        TypedValue tvFrom = styledAttributes.peekValue(valueFromId);
        boolean hasFrom = tvFrom != null;
        int fromType = hasFrom ? tvFrom.type : 0;
        TypedValue tvTo = styledAttributes.peekValue(valueToId);
        boolean hasTo = tvTo != null;
        int toType = hasTo ? tvTo.type : 0;
        int valueType = hasFrom && AnimatorInflaterCompat.isColorType(fromType) || hasTo && AnimatorInflaterCompat.isColorType(toType) ? 3 : 0;
        return valueType;
    }

    private static void dumpKeyframes(Object[] keyframes, String header) {
        if (keyframes == null || keyframes.length == 0) {
            return;
        }
        Log.d((String)TAG, (String)header);
        int count = keyframes.length;
        for (int i = 0; i < count; ++i) {
            Keyframe keyframe = (Keyframe)keyframes[i];
            Log.d((String)TAG, (String)("Keyframe " + i + ": fraction " + (keyframe.getFraction() < 0.0f ? "null" : Float.valueOf(keyframe.getFraction())) + ", " + ", value : " + (keyframe.hasValue() ? keyframe.getValue() : "null")));
        }
    }

    private static PropertyValuesHolder loadPvh(Context context, Resources res, Resources.Theme theme, XmlPullParser parser, String propertyName, int valueType) throws XmlPullParserException, IOException {
        int count;
        int type;
        PropertyValuesHolder value = null;
        ArrayList<Keyframe> keyframes = null;
        while ((type = parser.next()) != 3 && type != 1) {
            Keyframe keyframe;
            String name = parser.getName();
            if (!name.equals("keyframe")) continue;
            if (valueType == 4) {
                valueType = AnimatorInflaterCompat.inferValueTypeOfKeyframe(res, theme, Xml.asAttributeSet((XmlPullParser)parser), parser);
            }
            if ((keyframe = AnimatorInflaterCompat.loadKeyframe(context, res, theme, Xml.asAttributeSet((XmlPullParser)parser), valueType, parser)) != null) {
                if (keyframes == null) {
                    keyframes = new ArrayList<Keyframe>();
                }
                keyframes.add(keyframe);
            }
            parser.next();
        }
        if (keyframes != null && (count = keyframes.size()) > 0) {
            float startFraction;
            Keyframe firstKeyframe = (Keyframe)keyframes.get(0);
            Keyframe lastKeyframe = (Keyframe)keyframes.get(count - 1);
            float endFraction = lastKeyframe.getFraction();
            if (endFraction < 1.0f) {
                if (endFraction < 0.0f) {
                    lastKeyframe.setFraction(1.0f);
                } else {
                    keyframes.add(keyframes.size(), AnimatorInflaterCompat.createNewKeyframe(lastKeyframe, 1.0f));
                    ++count;
                }
            }
            if ((startFraction = firstKeyframe.getFraction()) != 0.0f) {
                if (startFraction < 0.0f) {
                    firstKeyframe.setFraction(0.0f);
                } else {
                    keyframes.add(0, AnimatorInflaterCompat.createNewKeyframe(firstKeyframe, 0.0f));
                    ++count;
                }
            }
            Keyframe[] keyframeArray = new Keyframe[count];
            keyframes.toArray(keyframeArray);
            for (int i = 0; i < count; ++i) {
                Keyframe keyframe = keyframeArray[i];
                if (!(keyframe.getFraction() < 0.0f)) continue;
                if (i == 0) {
                    keyframe.setFraction(0.0f);
                    continue;
                }
                if (i == count - 1) {
                    keyframe.setFraction(1.0f);
                    continue;
                }
                int startIndex = i;
                int endIndex = i;
                int j = startIndex + 1;
                while (j < count - 1 && !(keyframeArray[j].getFraction() >= 0.0f)) {
                    endIndex = j++;
                }
                float gap = keyframeArray[endIndex + 1].getFraction() - keyframeArray[startIndex - 1].getFraction();
                AnimatorInflaterCompat.distributeKeyframes(keyframeArray, gap, startIndex, endIndex);
            }
            value = PropertyValuesHolder.ofKeyframe((String)propertyName, (Keyframe[])keyframeArray);
            if (valueType == 3) {
                value.setEvaluator((TypeEvaluator)ArgbEvaluator.getInstance());
            }
        }
        return value;
    }

    private static Keyframe createNewKeyframe(Keyframe sampleKeyframe, float fraction) {
        return sampleKeyframe.getType() == Float.TYPE ? Keyframe.ofFloat((float)fraction) : (sampleKeyframe.getType() == Integer.TYPE ? Keyframe.ofInt((float)fraction) : Keyframe.ofObject((float)fraction));
    }

    private static void distributeKeyframes(Keyframe[] keyframes, float gap, int startIndex, int endIndex) {
        int count = endIndex - startIndex + 2;
        float increment = gap / (float)count;
        for (int i = startIndex; i <= endIndex; ++i) {
            keyframes[i].setFraction(keyframes[i - 1].getFraction() + increment);
        }
    }

    private static Keyframe loadKeyframe(Context context, Resources res, Resources.Theme theme, AttributeSet attrs, int valueType, XmlPullParser parser) throws XmlPullParserException, IOException {
        boolean hasValue;
        TypedArray a = TypedArrayUtils.obtainAttributes((Resources)res, (Resources.Theme)theme, (AttributeSet)attrs, (int[])AndroidResources.STYLEABLE_KEYFRAME);
        Keyframe keyframe = null;
        float fraction = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"fraction", (int)3, (float)-1.0f);
        TypedValue keyframeValue = TypedArrayUtils.peekNamedValue((TypedArray)a, (XmlPullParser)parser, (String)"value", (int)0);
        boolean bl = hasValue = keyframeValue != null;
        if (valueType == 4) {
            valueType = hasValue && AnimatorInflaterCompat.isColorType(keyframeValue.type) ? 3 : 0;
        }
        if (hasValue) {
            switch (valueType) {
                case 0: {
                    float value = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"value", (int)0, (float)0.0f);
                    keyframe = Keyframe.ofFloat((float)fraction, (float)value);
                    break;
                }
                case 1: 
                case 3: {
                    int intValue = TypedArrayUtils.getNamedInt((TypedArray)a, (XmlPullParser)parser, (String)"value", (int)0, (int)0);
                    keyframe = Keyframe.ofInt((float)fraction, (int)intValue);
                }
            }
        } else {
            keyframe = valueType == 0 ? Keyframe.ofFloat((float)fraction) : Keyframe.ofInt((float)fraction);
        }
        int resID = TypedArrayUtils.getNamedResourceId((TypedArray)a, (XmlPullParser)parser, (String)"interpolator", (int)1, (int)0);
        if (resID > 0) {
            Interpolator interpolator = AnimationUtilsCompat.loadInterpolator(context, resID);
            keyframe.setInterpolator((TimeInterpolator)interpolator);
        }
        a.recycle();
        return keyframe;
    }

    private static ObjectAnimator loadObjectAnimator(Context context, Resources res, Resources.Theme theme, AttributeSet attrs, float pathErrorScale, XmlPullParser parser) throws Resources.NotFoundException {
        ObjectAnimator anim = new ObjectAnimator();
        AnimatorInflaterCompat.loadAnimator(context, res, theme, attrs, (ValueAnimator)anim, pathErrorScale, parser);
        return anim;
    }

    private static ValueAnimator loadAnimator(Context context, Resources res, Resources.Theme theme, AttributeSet attrs, ValueAnimator anim, float pathErrorScale, XmlPullParser parser) throws Resources.NotFoundException {
        TypedArray arrayAnimator = TypedArrayUtils.obtainAttributes((Resources)res, (Resources.Theme)theme, (AttributeSet)attrs, (int[])AndroidResources.STYLEABLE_ANIMATOR);
        TypedArray arrayObjectAnimator = TypedArrayUtils.obtainAttributes((Resources)res, (Resources.Theme)theme, (AttributeSet)attrs, (int[])AndroidResources.STYLEABLE_PROPERTY_ANIMATOR);
        if (anim == null) {
            anim = new ValueAnimator();
        }
        AnimatorInflaterCompat.parseAnimatorFromTypeArray(anim, arrayAnimator, arrayObjectAnimator, pathErrorScale, parser);
        int resID = TypedArrayUtils.getNamedResourceId((TypedArray)arrayAnimator, (XmlPullParser)parser, (String)"interpolator", (int)0, (int)0);
        if (resID > 0) {
            Interpolator interpolator = AnimationUtilsCompat.loadInterpolator(context, resID);
            anim.setInterpolator((TimeInterpolator)interpolator);
        }
        arrayAnimator.recycle();
        if (arrayObjectAnimator != null) {
            arrayObjectAnimator.recycle();
        }
        return anim;
    }

    private static boolean isColorType(int type) {
        return type >= 28 && type <= 31;
    }

    private AnimatorInflaterCompat() {
    }

    private static class PathDataEvaluator
    implements TypeEvaluator<PathParser.PathDataNode[]> {
        private PathParser.PathDataNode[] mNodeArray;

        PathDataEvaluator() {
        }

        PathDataEvaluator(PathParser.PathDataNode[] nodeArray) {
            this.mNodeArray = nodeArray;
        }

        public PathParser.PathDataNode[] evaluate(float fraction, PathParser.PathDataNode[] startPathData, PathParser.PathDataNode[] endPathData) {
            if (!PathParser.canMorph((PathParser.PathDataNode[])startPathData, (PathParser.PathDataNode[])endPathData)) {
                throw new IllegalArgumentException("Can't interpolate between two incompatible pathData");
            }
            if (!PathParser.canMorph((PathParser.PathDataNode[])this.mNodeArray, (PathParser.PathDataNode[])startPathData)) {
                this.mNodeArray = PathParser.deepCopyNodes((PathParser.PathDataNode[])startPathData);
            }
            for (int i = 0; i < startPathData.length; ++i) {
                this.mNodeArray[i].interpolatePathDataNode(startPathData[i], endPathData[i], fraction);
            }
            return this.mNodeArray;
        }
    }
}

