/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.layout;

import androidx.ui.core.Constraints;
import androidx.ui.core.ConstraintsKt;
import androidx.ui.core.IntrinsicMeasurable;
import androidx.ui.core.IntrinsicMeasureScope;
import androidx.ui.core.LayoutDirection;
import androidx.ui.core.LayoutModifier;
import androidx.ui.core.Measurable;
import androidx.ui.core.MeasureScope;
import androidx.ui.core.Modifier;
import androidx.ui.core.Placeable;
import androidx.ui.unit.IntSize;
import androidx.ui.unit.IntSizeKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003J\t\u0010\u0006\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0007\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J$\u0010\u0013\u001a\u00020\r*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J$\u0010\u001a\u001a\u00020\r*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J$\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J$\u0010!\u001a\u00020\r*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J$\u0010\"\u001a\u00020\r*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006#"}, d2={"Landroidx/ui/layout/AspectRatioModifier;", "Landroidx/ui/core/LayoutModifier;", "aspectRatio", "", "getAspectRatio", "()F", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "findSizeWith", "Landroidx/ui/unit/IntSize;", "Landroidx/ui/core/Constraints;", "maxIntrinsicHeight", "Landroidx/ui/core/IntrinsicMeasureScope;", "measurable", "Landroidx/ui/core/IntrinsicMeasurable;", "width", "layoutDirection", "Landroidx/ui/core/LayoutDirection;", "maxIntrinsicWidth", "height", "measure", "Landroidx/ui/core/MeasureScope$MeasureResult;", "Landroidx/ui/core/MeasureScope;", "Landroidx/ui/core/Measurable;", "constraints", "minIntrinsicHeight", "minIntrinsicWidth", "ui-layout_release"})
final class AspectRatioModifier
implements LayoutModifier {
    private final float aspectRatio;

    public AspectRatioModifier(float aspectRatio) {
        this.aspectRatio = aspectRatio;
        boolean bl = this.getAspectRatio() > 0.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "aspectRatio " + this.getAspectRatio() + " must be > 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public final float getAspectRatio() {
        return this.aspectRatio;
    }

    @NotNull
    public MeasureScope.MeasureResult measure(@NotNull MeasureScope $this$measure, @NotNull Measurable measurable, @NotNull Constraints constraints, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)$this$measure, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        IntSize size = this.findSizeWith(constraints, this.getAspectRatio());
        Constraints wrappedConstraints = size != null ? Constraints.Companion.fixed(size.getWidth(), size.getHeight()) : constraints;
        Placeable placeable = $this$measure.measure(measurable, wrappedConstraints);
        return MeasureScope.layout$default((MeasureScope)$this$measure, (int)placeable.getWidth(), (int)placeable.getHeight(), null, (Function1)((Function1)new Function1<Placeable.PlacementScope, Unit>(placeable){
            private final /* synthetic */ Placeable $placeable;
            {
                this.$placeable = $placeable;
                super(1);
            }

            public final void invoke(@NotNull Placeable.PlacementScope placementScope) {
                Intrinsics.checkNotNullParameter((Object)placementScope, (String)"<this>");
                placementScope.place(this.$placeable, 0, 0);
            }
        }), (int)4, null);
    }

    public int minIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$minIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height2, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        return height2 != Integer.MAX_VALUE ? MathKt.roundToInt((float)((float)height2 * this.getAspectRatio())) : $this$minIntrinsicWidth.minIntrinsicWidth(measurable, height2);
    }

    public int maxIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$maxIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height2, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        return height2 != Integer.MAX_VALUE ? MathKt.roundToInt((float)((float)height2 * this.getAspectRatio())) : $this$maxIntrinsicWidth.maxIntrinsicWidth(measurable, height2);
    }

    public int minIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$minIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width2, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        return width2 != Integer.MAX_VALUE ? MathKt.roundToInt((float)((float)width2 / this.getAspectRatio())) : $this$minIntrinsicHeight.minIntrinsicHeight(measurable, width2);
    }

    public int maxIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$maxIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width2, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        return width2 != Integer.MAX_VALUE ? MathKt.roundToInt((float)((float)width2 / this.getAspectRatio())) : $this$maxIntrinsicHeight.maxIntrinsicHeight(measurable, width2);
    }

    private final IntSize findSizeWith(Constraints $this$findSizeWith, float aspectRatio) {
        IntSize size;
        IntSize size2;
        IntSize size3;
        int width2;
        IntSize size4;
        int height2;
        int maxWidth = $this$findSizeWith.getMaxWidth();
        if (maxWidth != Integer.MAX_VALUE && (height2 = MathKt.roundToInt((float)((float)maxWidth / aspectRatio))) > 0 && ConstraintsKt.satisfiedBy((Constraints)$this$findSizeWith, (IntSize)(size4 = IntSizeKt.IntSize((int)maxWidth, (int)height2)))) {
            return size4;
        }
        int maxHeight = $this$findSizeWith.getMaxHeight();
        if (maxHeight != Integer.MAX_VALUE && (width2 = MathKt.roundToInt((float)((float)maxHeight * aspectRatio))) > 0 && ConstraintsKt.satisfiedBy((Constraints)$this$findSizeWith, (IntSize)(size3 = IntSizeKt.IntSize((int)width2, (int)maxHeight)))) {
            return size3;
        }
        int minWidth = $this$findSizeWith.getMinWidth();
        int height3 = MathKt.roundToInt((float)((float)minWidth / aspectRatio));
        if (height3 > 0 && ConstraintsKt.satisfiedBy((Constraints)$this$findSizeWith, (IntSize)(size2 = IntSizeKt.IntSize((int)minWidth, (int)height3)))) {
            return size2;
        }
        int minHeight = $this$findSizeWith.getMinHeight();
        int width3 = MathKt.roundToInt((float)((float)minHeight * aspectRatio));
        if (width3 > 0 && ConstraintsKt.satisfiedBy((Constraints)$this$findSizeWith, (IntSize)(size = IntSizeKt.IntSize((int)width3, (int)minHeight)))) {
            return size;
        }
        return null;
    }

    public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Modifier.Element, ? extends R> operation) {
        return (R)Modifier.Element.DefaultImpls.foldIn((Modifier.Element)this, initial, operation);
    }

    public <R> R foldOut(R initial, @NotNull Function2<? super Modifier.Element, ? super R, ? extends R> operation) {
        return (R)Modifier.Element.DefaultImpls.foldOut((Modifier.Element)this, initial, operation);
    }

    public boolean all(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return Modifier.Element.DefaultImpls.all((Modifier.Element)this, predicate);
    }

    public boolean any(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return Modifier.Element.DefaultImpls.any((Modifier.Element)this, predicate);
    }

    @NotNull
    public Modifier plus(@NotNull Modifier other) {
        return Modifier.DefaultImpls.plus((Modifier)this, (Modifier)other);
    }

    public final float component1() {
        return this.aspectRatio;
    }

    @NotNull
    public final AspectRatioModifier copy(float aspectRatio) {
        return new AspectRatioModifier(aspectRatio);
    }

    public static /* synthetic */ AspectRatioModifier copy$default(AspectRatioModifier this_, float aspectRatio, int n, Object object) {
        if ((n & 1) != 0) {
            aspectRatio = this_.aspectRatio;
        }
        return this_.copy(aspectRatio);
    }

    @NotNull
    public String toString() {
        return "AspectRatioModifier(aspectRatio=" + this.aspectRatio + ")";
    }

    public int hashCode() {
        return Float.hashCode(this.aspectRatio);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AspectRatioModifier)) {
            return false;
        }
        Object object = other;
        AspectRatioModifier aspectRatioModifier = (AspectRatioModifier)object;
        return Intrinsics.areEqual((Object)Float.valueOf(this.aspectRatio), (Object)Float.valueOf(aspectRatioModifier.aspectRatio));
    }
}

