/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation.shape.corner;

import androidx.ui.foundation.shape.corner.CornerBasedShape;
import androidx.ui.foundation.shape.corner.CornerSize;
import androidx.ui.geometry.Size;
import androidx.ui.geometry.SizeKt;
import androidx.ui.graphics.AndroidPathKt;
import androidx.ui.graphics.Outline;
import androidx.ui.graphics.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B \u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003J(\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Landroidx/ui/foundation/shape/corner/CutCornerShape;", "Landroidx/ui/foundation/shape/corner/CornerBasedShape;", "topLeft", "Landroidx/ui/foundation/shape/corner/CornerSize;", "topRight", "bottomRight", "bottomLeft", "copy", "createOutline", "Landroidx/ui/graphics/Outline;", "size", "Landroidx/ui/geometry/Size;", "", "toString", "", "ui-foundation_release"})
public final class CutCornerShape
extends CornerBasedShape {
    public CutCornerShape(@NotNull CornerSize topLeft, @NotNull CornerSize topRight, @NotNull CornerSize bottomRight, @NotNull CornerSize bottomLeft) {
        Intrinsics.checkNotNullParameter((Object)topLeft, (String)"topLeft");
        Intrinsics.checkNotNullParameter((Object)topRight, (String)"topRight");
        Intrinsics.checkNotNullParameter((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkNotNullParameter((Object)bottomLeft, (String)"bottomLeft");
        super(topLeft, topRight, bottomRight, bottomLeft);
    }

    @Override
    @NotNull
    public Outline createOutline(@NotNull Size size, float topLeft, float topRight, float bottomRight, float bottomLeft) {
        Outline outline;
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        if (topLeft + topRight + bottomLeft + bottomRight == 0.0f) {
            outline = (Outline)new Outline.Rectangle(SizeKt.toRect((Size)size));
        } else {
            Path path;
            Path path2 = AndroidPathKt.Path();
            boolean bl = false;
            boolean bl2 = false;
            Path $this$createOutline_u24lambda_u2d0 = path2;
            boolean bl3 = false;
            float cornerSize = topLeft;
            $this$createOutline_u24lambda_u2d0.moveTo(0.0f, cornerSize);
            $this$createOutline_u24lambda_u2d0.lineTo(cornerSize, 0.0f);
            cornerSize = topRight;
            $this$createOutline_u24lambda_u2d0.lineTo(size.getWidth() - cornerSize, 0.0f);
            $this$createOutline_u24lambda_u2d0.lineTo(size.getWidth(), cornerSize);
            cornerSize = bottomRight;
            $this$createOutline_u24lambda_u2d0.lineTo(size.getWidth(), size.getHeight() - cornerSize);
            $this$createOutline_u24lambda_u2d0.lineTo(size.getWidth() - cornerSize, size.getHeight());
            cornerSize = bottomLeft;
            $this$createOutline_u24lambda_u2d0.lineTo(cornerSize, size.getHeight());
            $this$createOutline_u24lambda_u2d0.lineTo(0.0f, size.getHeight() - cornerSize);
            $this$createOutline_u24lambda_u2d0.close();
            Path path3 = path = path2;
            outline = (Outline)new Outline.Generic(path3);
        }
        return outline;
    }

    @Override
    @NotNull
    public CutCornerShape copy(@NotNull CornerSize topLeft, @NotNull CornerSize topRight, @NotNull CornerSize bottomRight, @NotNull CornerSize bottomLeft) {
        Intrinsics.checkNotNullParameter((Object)topLeft, (String)"topLeft");
        Intrinsics.checkNotNullParameter((Object)topRight, (String)"topRight");
        Intrinsics.checkNotNullParameter((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkNotNullParameter((Object)bottomLeft, (String)"bottomLeft");
        return new CutCornerShape(topLeft, topRight, bottomRight, bottomLeft);
    }

    @NotNull
    public String toString() {
        return "CutCornerShape(topLeft = " + this.getTopLeft() + ", topRight = " + this.getTopRight() + ", bottomRight = " + this.getBottomRight() + ", bottomLeft = " + this.getBottomLeft() + ")";
    }
}

