/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation;

import androidx.ui.core.ContentDrawScope;
import androidx.ui.core.DrawModifier;
import androidx.ui.core.Modifier;
import androidx.ui.foundation.DrawBorderCache;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.RRect;
import androidx.ui.geometry.RRectKt;
import androidx.ui.geometry.Radius;
import androidx.ui.geometry.Rect;
import androidx.ui.geometry.Size;
import androidx.ui.geometry.SizeKt;
import androidx.ui.graphics.Brush;
import androidx.ui.graphics.Outline;
import androidx.ui.graphics.Path;
import androidx.ui.graphics.Shape;
import androidx.ui.graphics.drawscope.DrawScope;
import androidx.ui.graphics.drawscope.DrawStyle;
import androidx.ui.graphics.drawscope.Fill;
import androidx.ui.graphics.drawscope.Stroke;
import androidx.ui.unit.Density;
import androidx.ui.unit.Dp;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00f8\u0001\u0000J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0016J,\u0010\u0014\u001a\u00020\u0012*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0002R\u0013\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Landroidx/ui/foundation/DrawBorder;", "Landroidx/ui/core/DrawModifier;", "cache", "Landroidx/ui/foundation/DrawBorderCache;", "shape", "Landroidx/ui/graphics/Shape;", "borderWidth", "Landroidx/ui/unit/Dp;", "brush", "Landroidx/ui/graphics/Brush;", "F", "equals", "", "other", "", "hashCode", "", "draw", "", "Landroidx/ui/core/ContentDrawScope;", "drawRoundRectBorder", "Landroidx/ui/graphics/drawscope/DrawScope;", "borderSize", "", "rect", "Landroidx/ui/geometry/Rect;", "radius", "ui-foundation_release"})
public final class DrawBorder
implements DrawModifier {
    private final DrawBorderCache cache;
    private final Shape shape;
    private final float borderWidth;
    private final Brush brush;

    private DrawBorder(DrawBorderCache cache, Shape shape, float borderWidth, Brush brush) {
        this.cache = cache;
        this.shape = shape;
        this.borderWidth = borderWidth;
        this.brush = brush;
        this.cache.setLastShape(this.shape);
        this.cache.setBorderSize-ipo6vVg(this.borderWidth);
    }

    public void draw(@NotNull ContentDrawScope $this$draw) {
        float borderSize;
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        ContentDrawScope density = $this$draw;
        DrawBorderCache drawBorderCache = this.cache;
        boolean bl = false;
        boolean bl2 = false;
        DrawBorderCache $this$draw_u24lambda_u2d0 = drawBorderCache;
        boolean bl3 = false;
        $this$draw.drawContent();
        $this$draw_u24lambda_u2d0.setModifierSize($this$draw.getSize());
        Outline outline = $this$draw_u24lambda_u2d0.modifierSizeOutline((Density)density);
        float f = borderSize = Dp.equals-impl0((float)this.borderWidth, (float)Dp.Companion.getHairline()) ? 1.0f : this.borderWidth * density.getDensity();
        if (borderSize <= 0.0f || $this$draw.getSize().getMinDimension() <= 0.0f) {
            return;
        }
        if (outline instanceof Outline.Rectangle) {
            this.drawRoundRectBorder((DrawScope)$this$draw, borderSize, ((Outline.Rectangle)outline).getRect(), 0.0f, this.brush);
        } else if (outline instanceof Outline.Rounded && RRectKt.isSimple((RRect)((Outline.Rounded)outline).getRrect())) {
            float radius = ((Outline.Rounded)outline).getRrect().getBottomLeftRadiusY();
            this.drawRoundRectBorder((DrawScope)$this$draw, borderSize, RRectKt.outerRect((RRect)((Outline.Rounded)outline).getRrect()), radius, this.brush);
        } else {
            DrawScope.drawPath$default((DrawScope)((DrawScope)$this$draw), (Path)$this$draw_u24lambda_u2d0.borderPath((Density)density, borderSize), (Brush)this.brush, (float)0.0f, null, null, null, (int)60, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawRoundRectBorder(DrawScope $this$drawRoundRectBorder, float borderSize, Rect rect, float radius, Brush brush) {
        long l;
        void y$iv;
        void x$iv;
        boolean fillWithBorder = borderSize * (float)2 >= rect.getMinDimension();
        DrawStyle style = fillWithBorder ? (DrawStyle)Fill.INSTANCE : (DrawStyle)new Stroke(borderSize, 0.0f, null, null, null, 30, null);
        float delta = fillWithBorder ? 0.0f : borderSize / (float)2;
        float f = rect.getLeft() + delta;
        float f2 = rect.getTop() + delta;
        Brush brush2 = brush;
        DrawScope drawScope = $this$drawRoundRectBorder;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var13_15 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var13_15);
        void var17_21 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits((float)var17_21);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        Offset offset = new Offset(l2);
        Size size = SizeKt.Size((float)(rect.getWidth() - (float)2 * delta), (float)(rect.getHeight() - (float)2 * delta));
        float y$iv2 = radius;
        boolean $i$f$Radius = false;
        boolean $i$f$packFloats2 = false;
        float f3 = radius;
        boolean bl3 = false;
        long v1$iv$iv$iv = Float.floatToIntBits(f3);
        float f4 = y$iv2;
        boolean bl4 = false;
        long v2$iv$iv$iv = Float.floatToIntBits(f4);
        long l3 = Radius.constructor-impl((long)(v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL));
        DrawScope.drawRoundRect-TLscAYA$default((DrawScope)drawScope, (Brush)brush2, (Offset)offset, (Size)size, (long)l3, (float)0.0f, (DrawStyle)style, null, null, (int)208, null);
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? (Class<?>)null : object.getClass())) {
            return false;
        }
        object = other;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.ui.foundation.DrawBorder");
        }
        DrawBorder cfr_ignored_0 = (DrawBorder)object;
        if (!Intrinsics.areEqual((Object)this.shape, (Object)((DrawBorder)other).shape)) {
            return false;
        }
        if (!Dp.equals-impl0((float)this.borderWidth, (float)((DrawBorder)other).borderWidth)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.brush, (Object)((DrawBorder)other).brush);
    }

    public int hashCode() {
        int result = this.shape.hashCode();
        result = 31 * result + Dp.hashCode-impl((float)this.borderWidth);
        result = 31 * result + this.brush.hashCode();
        return result;
    }

    public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Modifier.Element, ? extends R> operation) {
        return (R)Modifier.Element.DefaultImpls.foldIn((Modifier.Element)this, initial, operation);
    }

    public <R> R foldOut(R initial, @NotNull Function2<? super Modifier.Element, ? super R, ? extends R> operation) {
        return (R)Modifier.Element.DefaultImpls.foldOut((Modifier.Element)this, initial, operation);
    }

    public boolean all(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return Modifier.Element.DefaultImpls.all((Modifier.Element)this, predicate);
    }

    public boolean any(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return Modifier.Element.DefaultImpls.any((Modifier.Element)this, predicate);
    }

    @NotNull
    public Modifier plus(@NotNull Modifier other) {
        return Modifier.DefaultImpls.plus((Modifier)this, (Modifier)other);
    }

    public /* synthetic */ DrawBorder(@NotNull DrawBorderCache drawBorderCache, @NotNull Shape shape, float f, @NotNull Brush brush, @NotNull DefaultConstructorMarker defaultConstructorMarker) {
        this(drawBorderCache, shape, f, brush);
    }
}

