/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation;

import androidx.ui.core.ContentDrawScope;
import androidx.ui.core.DrawModifier;
import androidx.ui.core.Modifier;
import androidx.ui.geometry.Size;
import androidx.ui.graphics.Outline;
import androidx.ui.graphics.RectangleShapeKt;
import androidx.ui.graphics.Shape;
import androidx.ui.unit.Density;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BQ\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u0012,\u0010\t\u001a(\u0012\u0004\u0012\u00020\u0006\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\b\bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c2\u0003J\u001a\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\bH\u00c2\u0003J/\u0010\u0014\u001a(\u0012\u0004\u0012\u00020\u0006\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\b\bH\u00c2\u0003J^\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0019\b\u0002\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b2.\b\u0002\u0010\t\u001a(\u0012\u0004\u0012\u00020\u0006\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\b\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\f\u0010\u001e\u001a\u00020\u0007*\u00020\u0006H\u0016R4\u0010\t\u001a(\u0012\u0004\u0012\u00020\u0006\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/ui/foundation/DrawBackground;", "Landroidx/ui/core/DrawModifier;", "shape", "Landroidx/ui/graphics/Shape;", "drawRect", "Lkotlin/Function1;", "Landroidx/ui/core/ContentDrawScope;", "", "Lkotlin/ExtensionFunctionType;", "drawOutline", "Lkotlin/Function2;", "Landroidx/ui/graphics/Outline;", "Lkotlin/ParameterName;", "name", "outline", "lastOutline", "lastSize", "Landroidx/ui/geometry/Size;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "draw", "ui-foundation_release"})
final class DrawBackground
implements DrawModifier {
    private final Shape shape;
    private final Function1<ContentDrawScope, Unit> drawRect;
    private final Function2<ContentDrawScope, Outline, Unit> drawOutline;
    private Size lastSize;
    private Outline lastOutline;

    public DrawBackground(@NotNull Shape shape, @NotNull Function1<? super ContentDrawScope, Unit> drawRect, @NotNull Function2<? super ContentDrawScope, ? super Outline, Unit> drawOutline) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(drawRect, (String)"drawRect");
        Intrinsics.checkNotNullParameter(drawOutline, (String)"drawOutline");
        this.shape = shape;
        this.drawRect = drawRect;
        this.drawOutline = drawOutline;
    }

    public void draw(@NotNull ContentDrawScope $this$draw) {
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        if (this.shape == RectangleShapeKt.getRectangleShape()) {
            this.drawRect.invoke((Object)$this$draw);
        } else {
            Outline outline;
            if (Intrinsics.areEqual((Object)$this$draw.getSize(), (Object)this.lastSize)) {
                Outline outline2 = this.lastOutline;
                Intrinsics.checkNotNull((Object)outline2);
                outline = outline2;
            } else {
                outline = this.shape.createOutline($this$draw.getSize(), (Density)$this$draw);
            }
            Outline localOutline = outline;
            this.drawOutline.invoke((Object)$this$draw, (Object)localOutline);
            this.lastOutline = localOutline;
            this.lastSize = $this$draw.getSize();
        }
        $this$draw.drawContent();
    }

    public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Modifier.Element, ? extends R> operation) {
        return (R)Modifier.Element.DefaultImpls.foldIn((Modifier.Element)this, initial, operation);
    }

    public <R> R foldOut(R initial, @NotNull Function2<? super Modifier.Element, ? super R, ? extends R> operation) {
        return (R)Modifier.Element.DefaultImpls.foldOut((Modifier.Element)this, initial, operation);
    }

    public boolean all(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return Modifier.Element.DefaultImpls.all((Modifier.Element)this, predicate);
    }

    public boolean any(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return Modifier.Element.DefaultImpls.any((Modifier.Element)this, predicate);
    }

    @NotNull
    public Modifier plus(@NotNull Modifier other) {
        return Modifier.DefaultImpls.plus((Modifier)this, (Modifier)other);
    }

    private final Shape component1() {
        return this.shape;
    }

    private final Function1<ContentDrawScope, Unit> component2() {
        return this.drawRect;
    }

    private final Function2<ContentDrawScope, Outline, Unit> component3() {
        return this.drawOutline;
    }

    @NotNull
    public final DrawBackground copy(@NotNull Shape shape, @NotNull Function1<? super ContentDrawScope, Unit> drawRect, @NotNull Function2<? super ContentDrawScope, ? super Outline, Unit> drawOutline) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(drawRect, (String)"drawRect");
        Intrinsics.checkNotNullParameter(drawOutline, (String)"drawOutline");
        return new DrawBackground(shape, drawRect, drawOutline);
    }

    public static /* synthetic */ DrawBackground copy$default(DrawBackground this_, Shape shape, Function1 drawRect, Function2 drawOutline, int n, Object object) {
        if ((n & 1) != 0) {
            shape = this_.shape;
        }
        if ((n & 2) != 0) {
            drawRect = this_.drawRect;
        }
        if ((n & 4) != 0) {
            drawOutline = this_.drawOutline;
        }
        return this_.copy(shape, drawRect, drawOutline);
    }

    @NotNull
    public String toString() {
        return "DrawBackground(shape=" + this.shape + ", drawRect=" + this.drawRect + ", drawOutline=" + this.drawOutline + ")";
    }

    public int hashCode() {
        return (this.shape.hashCode() * 31 + this.drawRect.hashCode()) * 31 + this.drawOutline.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DrawBackground)) {
            return false;
        }
        Object object = other;
        DrawBackground drawBackground2 = (DrawBackground)object;
        if (!Intrinsics.areEqual((Object)this.shape, (Object)drawBackground2.shape)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.drawRect, drawBackground2.drawRect)) {
            return false;
        }
        return Intrinsics.areEqual(this.drawOutline, drawBackground2.drawOutline);
    }
}

