/*
 * Decompiled with CFR 0.152.
 */
package androidx.savedstate;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.savedstate.SavedStateRegistry;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSavedStateRegistry<S>
implements SavedStateRegistry<S> {
    private SafeIterableMap<String, SavedStateRegistry.SavedStateProvider<S>> mComponents = new SafeIterableMap();
    private Map<String, S> mSavedState;
    private boolean mRestored;

    @Override
    @MainThread
    @Nullable
    public final S consumeRestoredStateForKey(@NonNull String key) {
        if (!this.mRestored) {
            throw new IllegalStateException("You can consumeRestoredStateForKey only after super.onCreate of corresponding component");
        }
        S state = null;
        if (this.mSavedState != null) {
            state = this.mSavedState.remove(key);
            if (this.mSavedState.isEmpty()) {
                this.mSavedState = null;
            }
        }
        return state;
    }

    @Override
    @MainThread
    public final void registerSavedStateProvider(@NonNull String key, @NonNull SavedStateRegistry.SavedStateProvider<S> provider) {
        SavedStateRegistry.SavedStateProvider previous = (SavedStateRegistry.SavedStateProvider)this.mComponents.putIfAbsent((Object)key, provider);
        if (previous != null) {
            throw new IllegalArgumentException("SavedStateProvider with the given key is already registered");
        }
    }

    @Override
    @MainThread
    public final void unregisterSavedStateProvider(@NonNull String key) {
        this.mComponents.remove((Object)key);
    }

    @Override
    @MainThread
    public final boolean isRestored() {
        return this.mRestored;
    }

    @MainThread
    protected final void restoreSavedState(@Nullable Map<String, S> initialState) {
        if (initialState != null) {
            this.mSavedState = new HashMap<String, S>(initialState);
        }
        this.mRestored = true;
    }

    @MainThread
    @NonNull
    protected final Map<String, S> saveState() {
        HashMap savedState = new HashMap();
        if (this.mSavedState != null) {
            savedState.putAll(this.mSavedState);
        }
        SafeIterableMap.IteratorWithAdditions it = this.mComponents.iteratorWithAdditions();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            savedState.put((String)entry.getKey(), ((SavedStateRegistry.SavedStateProvider)entry.getValue()).saveState());
        }
        return savedState;
    }
}

