/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.util.List;
import java.util.Set;

public class DatabaseConfiguration {
    @NonNull
    public final SupportSQLiteOpenHelper.Factory sqliteOpenHelperFactory;
    @NonNull
    public final Context context;
    @Nullable
    public final String name;
    @NonNull
    public final RoomDatabase.MigrationContainer migrationContainer;
    @Nullable
    public final List<RoomDatabase.Callback> callbacks;
    public final boolean allowMainThreadQueries;
    public final RoomDatabase.JournalMode journalMode;
    public final boolean requireMigration;
    private final Set<Integer> mMigrationNotRequiredFrom;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public DatabaseConfiguration(@NonNull Context context, @Nullable String name, @NonNull SupportSQLiteOpenHelper.Factory sqliteOpenHelperFactory, @NonNull RoomDatabase.MigrationContainer migrationContainer, @Nullable List<RoomDatabase.Callback> callbacks, boolean allowMainThreadQueries, RoomDatabase.JournalMode journalMode, boolean requireMigration, @Nullable Set<Integer> migrationNotRequiredFrom) {
        this.sqliteOpenHelperFactory = sqliteOpenHelperFactory;
        this.context = context;
        this.name = name;
        this.migrationContainer = migrationContainer;
        this.callbacks = callbacks;
        this.allowMainThreadQueries = allowMainThreadQueries;
        this.journalMode = journalMode;
        this.requireMigration = requireMigration;
        this.mMigrationNotRequiredFrom = migrationNotRequiredFrom;
    }

    public boolean isMigrationRequiredFrom(int version) {
        return this.requireMigration && (this.mMigrationNotRequiredFrom == null || !this.mMigrationNotRequiredFrom.contains(version));
    }
}

