/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Database;
import androidx.room.SkipQueryVerification;
import androidx.room.ext.AnnotationBox;
import androidx.room.ext.Element_extKt;
import androidx.room.ext.RoomTypeNames;
import androidx.room.log.RLog;
import androidx.room.parser.Table;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.DaoProcessor;
import androidx.room.processor.DatabaseViewProcessor;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.QueryInterpreter;
import androidx.room.verifier.DatabaseVerificationErrors;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.verifier.QueryResultInfo;
import androidx.room.vo.Dao;
import androidx.room.vo.DaoMethod;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.Entity;
import androidx.room.vo.Field;
import androidx.room.vo.ForeignKey;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.HasFieldsKt;
import androidx.room.vo.Index;
import androidx.room.vo.InsertionMethod;
import androidx.room.vo.Pojo;
import androidx.room.vo.ShortcutEntity;
import androidx.room.vo.ShortcutMethod;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0013J\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u001cJ\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u001e\u0010$\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J,\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u001e\u0010(\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J,\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u001cH\u0002J$\u0010*\u001a\u00020!2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010,\u001a\u00020-H\u0002R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006."}, d2={"Landroidx/room/processor/DatabaseProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "element", "Ljavax/lang/model/element/TypeElement;", "(Landroidx/room/processor/Context;Ljavax/lang/model/element/TypeElement;)V", "baseClassElement", "Ljavax/lang/model/type/TypeMirror;", "getBaseClassElement", "()Ljavax/lang/model/type/TypeMirror;", "baseClassElement$delegate", "Lkotlin/Lazy;", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Ljavax/lang/model/element/TypeElement;", "doProcess", "Landroidx/room/vo/Database;", "process", "processDatabaseViews", "", "Landroidx/room/vo/DatabaseView;", "dbAnnotation", "Landroidx/room/ext/AnnotationBox;", "Landroidx/room/Database;", "processEntities", "", "Landroidx/room/vo/Entity;", "resolveDatabaseViews", "views", "validateExternalContentFts", "", "dbElement", "entities", "validateForeignKeys", "validateUniqueDaoClasses", "daoMethods", "Landroidx/room/vo/DaoMethod;", "validateUniqueIndices", "validateUniqueTableAndViewNames", "verifyDatabaseViews", "map", "dbVerifier", "Landroidx/room/verifier/DatabaseVerifier;", "room-compiler"})
public final class DatabaseProcessor {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy baseClassElement$delegate;
    @NotNull
    private final TypeElement element;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DatabaseProcessor.class), "baseClassElement", "getBaseClassElement()Ljavax/lang/model/type/TypeMirror;"))};
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final TypeMirror getBaseClassElement() {
        Lazy lazy = this.baseClassElement$delegate;
        DatabaseProcessor databaseProcessor = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (TypeMirror)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final androidx.room.vo.Database process() {
        try {
            androidx.room.vo.Database database = this.doProcess();
            return database;
        }
        finally {
            block3: {
                DatabaseVerifier databaseVerifier = this.context.getDatabaseVerifier();
                if (databaseVerifier == null) break block3;
                databaseVerifier.closeConnection(this.context);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final androidx.room.vo.Database doProcess() {
        Object object;
        boolean bl;
        List daoMethods;
        List<DatabaseView> views;
        List<Entity> entities;
        AnnotationBox<Database> dbAnnotation;
        block8: {
            void $this$mapTo$iv$iv;
            Iterable $this$filterNotTo$iv$iv;
            Element it;
            Iterable $this$filterTo$iv$iv;
            AnnotationBox<Database> annotationBox = Element_extKt.toAnnotationBox(this.element, Reflection.getOrCreateKotlinClass(Database.class));
            if (annotationBox == null) {
                Intrinsics.throwNpe();
            }
            dbAnnotation = annotationBox;
            entities = this.processEntities(dbAnnotation, this.element);
            Map<TypeElement, DatabaseView> viewsMap = this.processDatabaseViews(dbAnnotation);
            this.validateForeignKeys(this.element, entities);
            this.validateExternalContentFts(this.element, entities);
            boolean extendsRoomDb = this.context.getProcessingEnv().getTypeUtils().isAssignable(MoreElements.asType((Element)this.element).asType(), this.getBaseClassElement());
            this.context.getChecker().check(extendsRoomDb, this.element, ProcessorErrors.INSTANCE.getDB_MUST_EXTEND_ROOM_DB(), new Object[0]);
            List<? extends Element> allMembers = this.context.getProcessingEnv().getElementUtils().getAllMembers(this.element);
            views = this.resolveDatabaseViews(CollectionsKt.toList((Iterable)viewsMap.values()));
            QueryInterpreter queryInterpreter = new QueryInterpreter(this.context, CollectionsKt.plus((Collection)entities, (Iterable)views));
            DatabaseVerifier dbVerifier = Element_extKt.hasAnnotation((Element)this.element, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(SkipQueryVerification.class)) ? null : DatabaseVerifier.Companion.create(this.context, this.element, entities, views);
            this.context.setDatabaseVerifier(dbVerifier);
            if (dbVerifier != null) {
                this.verifyDatabaseViews(viewsMap, dbVerifier);
            }
            this.validateUniqueTableAndViewNames(this.element, entities, views);
            DeclaredType declaredType = MoreTypes.asDeclared((TypeMirror)this.element.asType());
            List<? extends Element> list = allMembers;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"allMembers");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Element)element$iv$iv;
                boolean bl2 = false;
                Element element = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
                if (!(Element_extKt.hasAnyOf(element, Modifier.ABSTRACT) && it.getKind() == ElementKind.METHOD)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$filterNot = false;
            $this$filterTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (Element)element$iv$iv;
                boolean bl3 = false;
                Element element = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
                Element containing = element.getEnclosingElement();
                if (MoreElements.isType((Element)containing) && Intrinsics.areEqual((Object)TypeName.get((TypeMirror)containing.asType()), (Object)RoomTypeNames.INSTANCE.getROOM_DB())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ExecutableElement executable;
                it = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                ExecutableElement executableElement = executable = MoreElements.asExecutable((Element)it);
                Intrinsics.checkExpressionValueIsNotNull((Object)executableElement, (String)"executable");
                TypeMirror typeMirror2 = executableElement.getReturnType();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"executable.returnType");
                TypeElement daoType = Type_mirror_extKt.asTypeElement(typeMirror2);
                DeclaredType declaredType2 = declaredType;
                Intrinsics.checkExpressionValueIsNotNull((Object)declaredType2, (String)"declaredType");
                Dao dao = new DaoProcessor(this.context, daoType, declaredType2, dbVerifier, queryInterpreter).process();
                DaoMethod daoMethod = new DaoMethod(executable, executable.getSimpleName().toString(), dao);
                collection.add(daoMethod);
            }
            daoMethods = (List)destination$iv$iv;
            this.validateUniqueDaoClasses(this.element, daoMethods, entities);
            this.validateUniqueIndices(this.element, entities);
            Iterable $this$any$iv = entities;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Entity it2 = (Entity)element$iv;
                    boolean bl5 = false;
                    object = it2.getForeignKeys();
                    boolean bl6 = false;
                    if (!(!object.isEmpty())) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        boolean hasForeignKeys = bl;
        int n = dbAnnotation.getValue().version();
        TypeMirror typeMirror3 = MoreElements.asType((Element)this.element).asType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror3, (String)"MoreElements.asType(element).asType()");
        boolean bl7 = hasForeignKeys;
        boolean bl8 = dbAnnotation.getValue().exportSchema();
        List list = daoMethods;
        List<DatabaseView> list2 = views;
        List<Entity> list3 = entities;
        object = typeMirror3;
        TypeElement typeElement = this.element;
        int n2 = n;
        androidx.room.vo.Database database = new androidx.room.vo.Database(typeElement, (TypeMirror)object, list3, list2, list, n2, bl8, bl7);
        return database;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateForeignKeys(TypeElement element, List<? extends Entity> entities) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = entities;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Entity entity = (Entity)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            String string = it.getTableName();
            map2.put(string, element$iv$iv);
        }
        Map byTableName = destination$iv$iv;
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = entity.getForeignKeys();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$mapNotNullTo$iv$iv;
                ForeignKey foreignKey = (ForeignKey)element$iv2;
                boolean bl2 = false;
                Entity parent = (Entity)byTableName.get(foreignKey.getParentTable());
                if (parent == null) {
                    this.context.getLogger().e(element, ProcessorErrors.INSTANCE.foreignKeyMissingParentEntityInDatabase(foreignKey.getParentTable(), entity.getElement().getQualifiedName().toString()), new Object[0]);
                    continue;
                }
                Iterable $this$mapNotNull$iv = foreignKey.getParentColumns();
                boolean $i$f$mapNotNull = false;
                Object object = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach3 = false;
                Object object2 = $this$forEach$iv$iv$iv.iterator();
                while (object2.hasNext()) {
                    Field field;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = object2.next();
                    boolean bl3 = false;
                    String columnName = (String)element$iv$iv;
                    boolean bl4 = false;
                    Field parentField = HasFieldsKt.findFieldByColumnName(parent, columnName);
                    if (parentField == null) {
                        this.context.getLogger().e(entity.getElement(), ProcessorErrors.INSTANCE.foreignKeyParentColumnDoesNotExist(parent.getElement().getQualifiedName().toString(), columnName, HasFieldsKt.getColumnNames(parent)), new Object[0]);
                    }
                    if (parentField == null) continue;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    Field it$iv$iv = field;
                    boolean bl7 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List parentFields = (List)destination$iv$iv2;
                if (parentFields.size() != foreignKey.getParentColumns().size() || parent.isUnique(foreignKey.getParentColumns())) continue;
                $this$mapNotNull$iv = foreignKey.getChildFields();
                List<String> list = foreignKey.getParentColumns();
                String string = entity.getElement().getQualifiedName().toString();
                String string2 = parent.getElement().getQualifiedName().toString();
                ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                Element element2 = parent.getElement();
                RLog rLog = this.context.getLogger();
                boolean $i$f$map = false;
                $this$mapNotNullTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    object2 = (Field)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl8 = false;
                    String string3 = it.getColumnName();
                    collection.add(string3);
                }
                Collection<String> collection2 = collection = (List)destination$iv$iv2;
                List<String> list2 = list;
                object = string;
                rLog.e(element2, processorErrors.foreignKeyMissingIndexInParent(string2, list2, (String)object, (List<String>)collection2), new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueIndices(TypeElement element, List<? extends Entity> entities) {
        void $this$filterTo$iv$iv;
        Object $this$groupByTo$iv$iv;
        Object list$iv$iv;
        Object object;
        Object object2;
        Object object3;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = entities;
        boolean $i$f$flatMap = false;
        Object object4 = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Entity entity = (Entity)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = entity.getIndices();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object3 = (Index)item$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl2 = false;
                object = new Pair((Object)it.getName(), (Object)entity);
                object2.add(object);
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object5;
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = (String)it.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object5 = answer$iv$iv$iv;
            } else {
                object5 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object5;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv;
        boolean element$iv$iv = false;
        list$iv$iv = iterator.entrySet().iterator();
        while (list$iv$iv.hasNext()) {
            Map.Entry element$iv$iv2;
            Map.Entry it = element$iv$iv2 = (Map.Entry)list$iv$iv.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        Object $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object4 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = object4.entrySet().iterator();
        while (iterator2.hasNext()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl4 = false;
            Iterable $this$distinctBy$iv = (Iterable)it.getValue();
            boolean $i$f$distinctBy = false;
            HashSet<TypeName> set$iv = new HashSet<TypeName>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                Pair it2 = (Pair)e$iv;
                boolean bl5 = false;
                TypeName key$iv = ((Entity)it2.getSecond()).getTypeName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            if (((List)list$iv).size() <= 1) continue;
            $this$distinctBy$iv = (Iterable)it.getValue();
            object3 = (String)it.getKey();
            object2 = ProcessorErrors.INSTANCE;
            Element element2 = element;
            object = this.context.getLogger();
            boolean $i$f$map = false;
            set$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                Pair bl5 = (Pair)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl6 = false;
                String string = ((Entity)it3.getSecond()).getTypeName() + " > " + (String)it3.getFirst();
                collection.add(string);
            }
            collection = (List)destination$iv$iv3;
            ((RLog)object).e(element2, ((ProcessorErrors)object2).duplicateIndexInDatabase((String)object3, (List<String>)collection), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueDaoClasses(TypeElement dbElement, List<DaoMethod> daoMethods, List<? extends Entity> entities) {
        Iterator<Map.Entry<String, ShortcutEntity>> iterator;
        Map<String, ShortcutEntity> map2;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object $this$groupByTo$iv$iv;
        DaoMethod it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Entity entity = (Entity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeName typeName2 = ((Pojo)((Object)it)).getTypeName();
            collection.add(typeName2);
        }
        Set entityTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$groupBy$iv = daoMethods;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            it = (DaoMethod)element$iv$iv;
            boolean bl4 = false;
            ClassName key$iv$iv = it.getDao().getTypeName();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$groupByTo$iv$iv = $this$forEach$iv;
        boolean bl = false;
        Iterator $i$f$groupByTo22 = $this$groupByTo$iv$iv.entrySet().iterator();
        while ($i$f$groupByTo22.hasNext()) {
            Collection<String> collection;
            Iterator $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map.Entry element$iv;
            Map.Entry it2 = element$iv = $i$f$groupByTo22.next();
            boolean bl3 = false;
            if (((List)it2.getValue()).size() <= 1) continue;
            Iterable bl4 = (Iterable)it2.getValue();
            TypeName typeName3 = (TypeName)it2.getKey();
            $this$getOrPut$iv$iv$iv = ProcessorErrors.INSTANCE;
            boolean $i$f$map2 = false;
            value$iv$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            map2 = $this$mapTo$iv$iv2.iterator();
            while (map2.hasNext()) {
                void it3;
                Object item$iv$iv = map2.next();
                iterator = (DaoMethod)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl5 = false;
                String string = it3.getName();
                collection.add(string);
            }
            collection = (List)destination$iv$iv2;
            String error = ((ProcessorErrors)$this$getOrPut$iv$iv$iv).duplicateDao(typeName3, (List<String>)collection);
            Iterable $this$forEach$iv2 = (Iterable)it2.getValue();
            boolean $i$f$forEach2 = false;
            $this$mapTo$iv$iv2 = $this$forEach$iv2.iterator();
            while ($this$mapTo$iv$iv2.hasNext()) {
                Object element$iv2 = $this$mapTo$iv$iv2.next();
                DaoMethod daoMethod = (DaoMethod)element$iv2;
                boolean bl6 = false;
                this.context.getLogger().e(daoMethod.getElement(), ProcessorErrors.INSTANCE.getDAO_METHOD_CONFLICTS_WITH_OTHERS(), new Object[0]);
            }
            this.context.getLogger().e(dbElement, error, new Object[0]);
        }
        Function3 check2 = (Function3)new Function3<Element, Dao, TypeName, Unit>(this, entityTypeNames, dbElement){
            final /* synthetic */ DatabaseProcessor this$0;
            final /* synthetic */ Set $entityTypeNames;
            final /* synthetic */ TypeElement $dbElement;

            public final void invoke(@NotNull Element element, @NotNull Dao dao, @Nullable TypeName typeName2) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    Intrinsics.checkParameterIsNotNull((Object)dao, (String)"dao");
                    TypeName typeName3 = typeName2;
                    if (typeName3 == null) break block1;
                    TypeName typeName4 = typeName3;
                    boolean bl = false;
                    boolean bl2 = false;
                    TypeName it = typeName4;
                    boolean bl3 = false;
                    if (!this.$entityTypeNames.contains(typeName2)) {
                        RLog rLog = this.this$0.getContext().getLogger();
                        String string = this.$dbElement.getQualifiedName().toString();
                        String string2 = dao.getTypeName().toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dao.typeName.toString()");
                        String string3 = typeName2.toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"typeName.toString()");
                        rLog.e(element, ProcessorErrors.INSTANCE.shortcutEntityIsNotInDatabase(string, string2, string3), new Object[0]);
                    }
                }
            }
            {
                this.this$0 = databaseProcessor;
                this.$entityTypeNames = set;
                this.$dbElement = typeElement;
                super(3);
            }
        };
        Iterable $this$forEach$iv3 = daoMethods;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            Map.Entry<String, ShortcutEntity> it4;
            Map.Entry<String, ShortcutEntity> element$iv3;
            boolean bl7;
            boolean $i$f$forEach4;
            Map<String, ShortcutEntity> $this$forEach$iv4;
            Object method;
            DaoMethod daoMethod = (DaoMethod)element$iv;
            boolean bl8 = false;
            Iterable $this$forEach$iv5 = daoMethod.getDao().getShortcutMethods();
            boolean $i$f$forEach5 = false;
            for (Object element$iv4 : $this$forEach$iv5) {
                method = (ShortcutMethod)element$iv4;
                boolean bl9 = false;
                $this$forEach$iv4 = ((ShortcutMethod)method).getEntities();
                $i$f$forEach4 = false;
                map2 = $this$forEach$iv4;
                bl7 = false;
                iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    it4 = element$iv3 = (Map.Entry<String, ShortcutEntity>)iterator.next();
                    boolean bl10 = false;
                    check2.invoke((Object)((ShortcutMethod)method).getElement(), (Object)daoMethod.getDao(), (Object)((ShortcutEntity)it4.getValue()).getEntityTypeName());
                }
            }
            $this$forEach$iv5 = daoMethod.getDao().getInsertionMethods();
            $i$f$forEach5 = false;
            for (Object element$iv4 : $this$forEach$iv5) {
                method = (InsertionMethod)element$iv4;
                boolean bl11 = false;
                $this$forEach$iv4 = ((InsertionMethod)method).getEntities();
                $i$f$forEach4 = false;
                map2 = $this$forEach$iv4;
                bl7 = false;
                iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    it4 = element$iv3 = iterator.next();
                    boolean bl12 = false;
                    check2.invoke((Object)((InsertionMethod)method).getElement(), (Object)daoMethod.getDao(), (Object)it4.getValue().getEntityTypeName());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueTableAndViewNames(TypeElement dbElement, List<? extends Entity> entities, List<DatabaseView> views) {
        void $this$filterTo$iv$iv;
        Object $this$groupByTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Triple triple;
        Object object;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            String string;
            void it;
            Entity entity = (Entity)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getTableName();
            Intrinsics.checkExpressionValueIsNotNull((Object)Locale.US, (String)"Locale.US");
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase((Locale)object), (String)"(this as java.lang.String).toLowerCase(locale)");
            TypeElement typeElement = it.getElement();
            String string4 = it.getTypeName().toString();
            String string5 = string;
            triple = new Triple((Object)string5, (Object)string4, (Object)typeElement);
            collection.add(triple);
        }
        List entitiesInfo = (List)destination$iv$iv;
        Iterable $this$map$iv2 = views;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            String string;
            Locale locale;
            void it;
            DatabaseView bl = (DatabaseView)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            object = it.getViewName();
            Intrinsics.checkExpressionValueIsNotNull((Object)Locale.US, (String)"Locale.US");
            boolean bl4 = false;
            Object object2 = object;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((String)object2).toLowerCase(locale), (String)"(this as java.lang.String).toLowerCase(locale)");
            TypeElement typeElement = it.getElement();
            String string6 = it.getTypeName().toString();
            String string7 = string;
            triple = new Triple((Object)string7, (Object)string6, (Object)typeElement);
            collection.add(triple);
        }
        List viewsInfo = (List)destination$iv$iv2;
        Iterable $this$groupBy$iv = CollectionsKt.plus((Collection)entitiesInfo, (Iterable)viewsInfo);
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        item$iv$iv2 = $this$groupByTo$iv$iv.iterator();
        while (item$iv$iv2.hasNext()) {
            Object object3;
            String name;
            Object element$iv$iv = item$iv$iv2.next();
            Triple $dstr$name$_u24__u24$_u24__u24 = (Triple)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = name = (String)$dstr$name$_u24__u24$_u24__u24.component1();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl5 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$filter$iv = destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        item$iv$iv2 = $this$filterTo$iv$iv;
        boolean element$iv$iv = false;
        Iterator list$iv$iv = item$iv$iv2.entrySet().iterator();
        while (list$iv$iv.hasNext()) {
            Map.Entry element$iv$iv2;
            Map.Entry it = element$iv$iv2 = list$iv$iv.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        Object $this$forEach$iv = destination$iv$iv2;
        boolean $i$f$forEach = false;
        Object object4 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = object4.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Map.Entry element$iv;
            Map.Entry byName = element$iv = iterator.next();
            boolean bl6 = false;
            Iterable element$iv$iv2 = (Iterable)byName.getValue();
            object = (String)byName.getKey();
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            boolean $i$f$map3 = false;
            void $i$f$getOrPut = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv3) {
                void $dstr$_u24__u24$typeName$_u24__u24;
                String typeName2;
                Triple triple2 = (Triple)item$iv$iv4;
                collection2 = destination$iv$iv3;
                boolean bl7 = false;
                String string = typeName2 = (String)$dstr$_u24__u24$typeName$_u24__u24.component2();
                collection2.add(string);
            }
            collection2 = (List)destination$iv$iv3;
            String error = processorErrors.duplicateTableNames((String)object, (List<String>)collection2);
            Iterable $this$forEach$iv2 = (Iterable)byName.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Triple $dstr$_u24__u24$_u24__u24$element = (Triple)element$iv2;
                boolean bl8 = false;
                TypeElement element = (TypeElement)$dstr$_u24__u24$_u24__u24$element.component3();
                this.context.getLogger().e(element, error, new Object[0]);
            }
            this.context.getLogger().e(dbElement, error, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateExternalContentFts(TypeElement dbElement, List<? extends Entity> entities) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = CollectionsKt.filterIsInstance((Iterable)entities, FtsEntity.class);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FtsEntity it = (FtsEntity)element$iv$iv;
            boolean bl = false;
            if (it.getFtsOptions().getContentEntity() == null || entities.contains(it.getFtsOptions().getContentEntity())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FtsEntity it = (FtsEntity)element$iv;
            boolean bl = false;
            RLog rLog = this.context.getLogger();
            Element element = dbElement;
            String string = it.getElement().getQualifiedName().toString();
            Entity entity = it.getFtsOptions().getContentEntity();
            if (entity == null) {
                Intrinsics.throwNpe();
            }
            rLog.e(element, ProcessorErrors.INSTANCE.missingExternalContentEntity(string, entity.getElement().getQualifiedName().toString()), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> processEntities(AnnotationBox<Database> dbAnnotation, TypeElement element) {
        void $this$mapTo$iv$iv;
        List<TypeMirror> entityList = dbAnnotation.getAsTypeMirrorList("entities");
        Collection collection = entityList;
        Object object = this.context.getChecker();
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        ((Checks)object).check(bl2, element, ProcessorErrors.INSTANCE.getDATABASE_ANNOTATION_MUST_HAVE_LIST_OF_ENTITIES(), new Object[0]);
        Iterable $this$map$iv = entityList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeMirror typeMirror2 = (TypeMirror)item$iv$iv;
            object = destination$iv$iv;
            boolean bl3 = false;
            Entity entity = EntityProcessorKt.EntityProcessor$default(this.context, Type_mirror_extKt.asTypeElement((TypeMirror)it), null, 4, null).process();
            object.add(entity);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<TypeElement, DatabaseView> processDatabaseViews(AnnotationBox<Database> dbAnnotation) {
        void $this$mapTo$iv$iv;
        List<TypeMirror> viewList = dbAnnotation.getAsTypeMirrorList("views");
        Iterable $this$map$iv = viewList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeMirror typeMirror2 = (TypeMirror)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeElement viewElement = Type_mirror_extKt.asTypeElement((TypeMirror)it);
            Pair pair = TuplesKt.to((Object)viewElement, (Object)new DatabaseViewProcessor(this.context, viewElement, null, 4, null).process());
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final void verifyDatabaseViews(Map<TypeElement, DatabaseView> map2, DatabaseVerifier dbVerifier) {
        Map<TypeElement, DatabaseView> map3 = map2;
        boolean bl = false;
        Iterator<Map.Entry<TypeElement, DatabaseView>> iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TypeElement, DatabaseView> entry;
            Map.Entry<TypeElement, DatabaseView> entry2 = entry = iterator.next();
            boolean bl2 = false;
            TypeElement viewElement = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            DatabaseView view = entry2.getValue();
            if (Element_extKt.hasAnnotation((Element)viewElement, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(SkipQueryVerification.class))) continue;
            view.getQuery().setResultInfo(dbVerifier.analyze(view.getQuery().getOriginal()));
            QueryResultInfo queryResultInfo = view.getQuery().getResultInfo();
            if ((queryResultInfo != null ? queryResultInfo.getError() : null) == null) continue;
            RLog rLog = this.context.getLogger();
            Element element = viewElement;
            QueryResultInfo queryResultInfo2 = view.getQuery().getResultInfo();
            if (queryResultInfo2 == null) {
                Intrinsics.throwNpe();
            }
            SQLException sQLException = queryResultInfo2.getError();
            if (sQLException == null) {
                Intrinsics.throwNpe();
            }
            rLog.e(element, DatabaseVerificationErrors.INSTANCE.cannotVerifyQuery(sQLException), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DatabaseView> resolveDatabaseViews(@NotNull List<DatabaseView> views) {
        Object object;
        Iterator $this$mapTo$iv$iv;
        boolean $i$f$map;
        Object object2;
        Object object3;
        Iterator<DatabaseView> $this$mapTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull(views, (String)"views");
        if (views.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = views;
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv;
        Iterable<String> destination$iv$iv = (Set<String>)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10)));
        boolean $i$f$mapTo = false;
        Object object4 = $this$mapTo$iv$iv2.iterator();
        while (object4.hasNext()) {
            void it;
            Object item$iv$iv = object4.next();
            DatabaseView databaseView = (DatabaseView)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            object2 = it.getViewName();
            object3.add(object2);
        }
        List viewNames = (List)destination$iv$iv;
        Function1<String, Boolean> $fun$isTable$1 = new Function1<String, Boolean>(viewNames){
            final /* synthetic */ List $viewNames;

            public final boolean invoke(@NotNull String name) {
                boolean bl;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Iterable $this$none$iv = this.$viewNames;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.equals((String)it, (String)name, (boolean)true)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }
            {
                this.$viewNames = list;
                super(1);
            }
        };
        for (DatabaseView view : views) {
            void $this$map$iv2;
            destination$iv$iv = view.getQuery().getTables();
            object3 = view.getTables();
            $i$f$map = false;
            object4 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator bl = $this$mapTo$iv$iv.iterator();
            while (bl.hasNext()) {
                void $dstr$name$_u24__u24;
                Object item$iv$iv = bl.next();
                Table table = (Table)item$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl2 = false;
                String name = $dstr$name$_u24__u24.component1();
                object = name;
                object2.add(object);
            }
            object2 = (List)destination$iv$iv2;
            object3.addAll((Collection)object2);
        }
        List unresolvedViews = CollectionsKt.toMutableList((Collection)views);
        boolean $this$map$iv2 = false;
        Map resolvedViews = new LinkedHashMap();
        $i$f$map = false;
        List result = new ArrayList();
        do {
            DatabaseView view;
            Iterator $this$filterTo$iv$iv;
            Map destination$iv$iv2 = resolvedViews;
            boolean $i$f$mapTo2 = false;
            $this$mapTo$iv$iv = destination$iv$iv2.entrySet().iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                Map.Entry bl = $i$f$map = $this$mapTo$iv$iv.next();
                boolean item$iv$iv = false;
                String viewName = (String)bl.getKey();
                bl = $i$f$map;
                item$iv$iv = false;
                Set tables = (Set)bl.getValue();
                for (DatabaseView view2 : unresolvedViews) {
                    if (!view2.getTables().removeIf(new Predicate<String>(viewName){
                        final /* synthetic */ String $viewName;

                        public final boolean test(@NotNull String it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return StringsKt.equals((String)it, (String)this.$viewName, (boolean)true);
                        }
                        {
                            this.$viewName = string;
                        }
                    })) continue;
                    view2.getTables().addAll(tables);
                }
            }
            int countNewlyResolved = 0;
            Iterable $this$filter$iv = unresolvedViews;
            boolean $i$f$filter = false;
            Iterable tables = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator $dstr$name$_u24__u24 = $this$filterTo$iv$iv.iterator();
            while ($dstr$name$_u24__u24.hasNext()) {
                boolean bl;
                Object element$iv$iv;
                block14: {
                    element$iv$iv = $dstr$name$_u24__u24.next();
                    view = (DatabaseView)element$iv$iv;
                    boolean bl3 = false;
                    Iterable $this$all$iv = view.getTables();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String it = (String)element$iv;
                            boolean bl4 = false;
                            if ($fun$isTable$1.invoke(it)) continue;
                            bl = false;
                            break block14;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv3;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv = $this$filterTo$iv$iv.next();
                DatabaseView view3 = (DatabaseView)element$iv;
                boolean bl = false;
                resolvedViews.put(view3.getViewName(), view3.getTables());
                unresolvedViews.remove(view3);
                result.add(view3);
                int element$iv$iv = countNewlyResolved;
                countNewlyResolved = element$iv$iv + 1;
            }
            if (countNewlyResolved == 0) {
                Collection<String> collection;
                void $this$mapTo$iv$iv3;
                void $this$map$iv3;
                $this$forEach$iv = unresolvedViews;
                object = ProcessorErrors.INSTANCE;
                object2 = this.element;
                object3 = this.context.getLogger();
                boolean $i$f$map3 = false;
                $this$filterTo$iv$iv = $this$map$iv3;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    void it;
                    view = (DatabaseView)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl = false;
                    String string = it.getViewName();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv3;
                ((RLog)object3).e((Element)object2, ((ProcessorErrors)object).viewCircularReferenceDetected((List<String>)collection), new Object[0]);
                break;
            }
            object4 = unresolvedViews;
            boolean bl = false;
        } while (!object4.isEmpty());
        return result;
    }

    @NotNull
    public final TypeElement getElement() {
        return this.element;
    }

    public DatabaseProcessor(@NotNull Context baseContext, @NotNull TypeElement element) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.element = element;
        this.context = Context.fork$default(baseContext, this.element, null, 2, null);
        this.baseClassElement$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TypeMirror>(this){
            final /* synthetic */ DatabaseProcessor this$0;

            public final TypeMirror invoke() {
                return this.this$0.getContext().getProcessingEnv().getElementUtils().getTypeElement(RoomTypeNames.INSTANCE.getROOM_DB().packageName() + "." + RoomTypeNames.INSTANCE.getROOM_DB().simpleName()).asType();
            }
            {
                this.this$0 = databaseProcessor;
                super(0);
            }
        }));
    }
}

