/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.annotation.VisibleForTesting;
import androidx.room.ext.Javapoet_extKt;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.SupportDbTypeNames;
import androidx.room.solver.CodeGenScope;
import androidx.room.vo.Database;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.Entity;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.Pojo;
import androidx.room.writer.FtsTableInfoValidationWriter;
import androidx.room.writer.TableInfoValidationWriter;
import androidx.room.writer.ValidationWriter;
import androidx.room.writer.ViewInfoValidationWriter;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\bH\u0002J\b\u0010\u0016\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\"\u001a\u00020\u001e*\u00020#2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006%"}, d2={"Landroidx/room/writer/SQLiteOpenHelperWriter;", "", "database", "Landroidx/room/vo/Database;", "(Landroidx/room/vo/Database;)V", "getDatabase", "()Landroidx/room/vo/Database;", "createCreateAllTables", "Lcom/squareup/javapoet/MethodSpec;", "createDropAllTables", "scope", "Landroidx/room/solver/CodeGenScope;", "createDropTableQuery", "", "entity", "Landroidx/room/vo/Entity;", "createDropViewQuery", "view", "Landroidx/room/vo/DatabaseView;", "createOnCreate", "createOnOpen", "createOnPostMigrate", "createOnPreMigrate", "createOpenCallback", "Lcom/squareup/javapoet/TypeSpec;", "createTableQuery", "createValidateMigration", "", "createViewQuery", "write", "", "outVar", "configuration", "Lcom/squareup/javapoet/ParameterSpec;", "invokeCallbacks", "Lcom/squareup/javapoet/MethodSpec$Builder;", "methodName", "room-compiler"})
public final class SQLiteOpenHelperWriter {
    @NotNull
    private final Database database;

    public final void write(@NotNull String outVar, @NotNull ParameterSpec configuration, @NotNull CodeGenScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)outVar, (String)"outVar");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        CodeBlock.Builder builder = scope.builder();
        boolean bl = false;
        boolean bl2 = false;
        CodeBlock.Builder $this$apply = builder;
        boolean bl3 = false;
        String sqliteConfigVar = scope.getTmpVar("_sqliteConfig");
        String callbackVar = scope.getTmpVar("_openCallback");
        $this$apply.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getN() + ", " + Javapoet_extKt.getL() + ", " + Javapoet_extKt.getS() + ", " + Javapoet_extKt.getS() + ')', new Object[]{SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER_CALLBACK(), callbackVar, RoomTypeNames.INSTANCE.getOPEN_HELPER(), configuration, this.createOpenCallback(scope), this.database.getIdentityHash(), this.database.getLegacyIdentityHash()});
        $this$apply.addStatement(StringsKt.trimIndent((String)("\n                    final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = " + Javapoet_extKt.getT() + ".builder(" + Javapoet_extKt.getN() + ".context)\n                    .name(" + Javapoet_extKt.getN() + ".name)\n                    .callback(" + Javapoet_extKt.getL() + ")\n                    .build()\n                    ")), new Object[]{SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER_CONFIG(), sqliteConfigVar, SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER_CONFIG(), configuration, configuration, callbackVar});
        $this$apply.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getN() + " = " + Javapoet_extKt.getN() + ".sqliteOpenHelperFactory.create(" + Javapoet_extKt.getL() + ')', new Object[]{SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER(), outVar, configuration, sqliteConfigVar});
    }

    private final TypeSpec createOpenCallback(CodeGenScope scope) {
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)Javapoet_extKt.getL(), (Object[])new Object[]{this.database.getVersion()});
        boolean bl = false;
        boolean bl2 = false;
        TypeSpec.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.superclass((TypeName)RoomTypeNames.INSTANCE.getOPEN_HELPER_DELEGATE());
        $this$apply.addMethod(this.createCreateAllTables());
        $this$apply.addMethod(this.createDropAllTables(scope.fork()));
        $this$apply.addMethod(this.createOnCreate(scope.fork()));
        $this$apply.addMethod(this.createOnOpen(scope.fork()));
        $this$apply.addMethod(this.createOnPreMigrate());
        $this$apply.addMethod(this.createOnPostMigrate());
        $this$apply.addMethods((Iterable)this.createValidateMigration(scope.fork()));
        TypeSpec typeSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeSpec, (String)"TypeSpec.anonymousClassB\u2026ork()))\n        }.build()");
        return typeSpec;
    }

    private final List<MethodSpec> createValidateMigration(CodeGenScope scope) {
        List list;
        boolean bl = false;
        List methodSpecs = new ArrayList();
        ArrayDeque entities = new ArrayDeque(this.database.getEntities());
        ArrayDeque views = new ArrayDeque(this.database.getViews());
        ParameterSpec dbParam = ParameterSpec.builder((TypeName)((TypeName)SupportDbTypeNames.INSTANCE.getDB()), (String)"_db", (Modifier[])new Modifier[0]).build();
        while (!entities.isEmpty() || !views.isEmpty()) {
            CodeGenScope methodScope;
            int statementCount;
            ValidationWriter validationWriter;
            boolean isPrimaryMethod = methodSpecs.isEmpty();
            String methodName2 = isPrimaryMethod ? "onValidateSchema" : "onValidateSchema" + (methodSpecs.size() + 1);
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName2);
            list = methodSpecs;
            boolean bl2 = false;
            boolean bl3 = false;
            MethodSpec.Builder $this$apply = builder;
            boolean bl4 = false;
            if (isPrimaryMethod) {
                $this$apply.addModifiers(new Modifier[]{Modifier.PROTECTED});
                $this$apply.addAnnotation(Override.class);
            } else {
                $this$apply.addModifiers(new Modifier[]{Modifier.PRIVATE});
            }
            $this$apply.returns((TypeName)RoomTypeNames.INSTANCE.getOPEN_HELPER_VALIDATION_RESULT());
            $this$apply.addParameter(dbParam);
            for (statementCount = 0; !entities.isEmpty() && statementCount < 1000; statementCount += validationWriter.statementCount()) {
                ValidationWriter validationWriter2;
                methodScope = scope.fork();
                Entity entity = (Entity)entities.poll();
                Entity entity2 = entity;
                if (entity2 instanceof FtsEntity) {
                    validationWriter2 = new FtsTableInfoValidationWriter((FtsEntity)entity);
                } else {
                    Entity entity3 = entity;
                    Intrinsics.checkExpressionValueIsNotNull((Object)entity3, (String)"entity");
                    validationWriter2 = new TableInfoValidationWriter(entity3);
                }
                validationWriter = validationWriter2;
                ParameterSpec parameterSpec = dbParam;
                Intrinsics.checkExpressionValueIsNotNull((Object)parameterSpec, (String)"dbParam");
                validationWriter.write(parameterSpec, methodScope);
                $this$apply.addCode(methodScope.builder().build());
            }
            while (!views.isEmpty() && statementCount < 1000) {
                DatabaseView view;
                methodScope = scope.fork();
                DatabaseView databaseView = view = (DatabaseView)views.poll();
                Intrinsics.checkExpressionValueIsNotNull((Object)databaseView, (String)"view");
                validationWriter = new ViewInfoValidationWriter(databaseView);
                ParameterSpec parameterSpec = dbParam;
                Intrinsics.checkExpressionValueIsNotNull((Object)parameterSpec, (String)"dbParam");
                validationWriter.write(parameterSpec, methodScope);
                $this$apply.addCode(methodScope.builder().build());
                statementCount += validationWriter.statementCount();
            }
            if (!isPrimaryMethod) {
                $this$apply.addStatement("return new " + Javapoet_extKt.getT() + "(true, null)", new Object[]{RoomTypeNames.INSTANCE.getOPEN_HELPER_VALIDATION_RESULT()});
            }
            MethodSpec.Builder builder2 = builder;
            MethodSpec methodSpec = builder2.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026  }\n            }.build()");
            list.add(methodSpec);
        }
        if (methodSpecs.size() > 1) {
            MethodSpec.Builder builder = ((MethodSpec)methodSpecs.get(0)).toBuilder();
            int n = 0;
            list = methodSpecs;
            boolean bl5 = false;
            boolean bl6 = false;
            MethodSpec.Builder $this$apply = builder;
            boolean bl7 = false;
            String resultVar = scope.getTmpVar("_result");
            $this$apply.addStatement(Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL(), new Object[]{RoomTypeNames.INSTANCE.getOPEN_HELPER_VALIDATION_RESULT(), resultVar});
            Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)methodSpecs, (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MethodSpec it = (MethodSpec)element$iv;
                boolean bl8 = false;
                $this$apply.addStatement(Javapoet_extKt.getL() + " = " + it.name + '(' + Javapoet_extKt.getN() + ')', new Object[]{resultVar, dbParam});
                $this$apply.beginControlFlow("if (!" + Javapoet_extKt.getL() + ".isValid)", new Object[]{resultVar});
                $this$apply.addStatement("return " + Javapoet_extKt.getL(), new Object[]{resultVar});
                $this$apply.endControlFlow();
            }
            $this$apply.addStatement("return new " + Javapoet_extKt.getT() + "(true, null)", new Object[]{RoomTypeNames.INSTANCE.getOPEN_HELPER_VALIDATION_RESULT()});
            MethodSpec.Builder builder3 = builder;
            MethodSpec methodSpec = builder3.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"methodSpecs[0].toBuilder\u2026LT)\n            }.build()");
            list.set(n, methodSpec);
        } else if (methodSpecs.size() == 1) {
            MethodSpec.Builder builder = ((MethodSpec)methodSpecs.get(0)).toBuilder();
            int n = 0;
            list = methodSpecs;
            boolean bl9 = false;
            boolean bl10 = false;
            MethodSpec.Builder $this$apply = builder;
            boolean bl11 = false;
            $this$apply.addStatement("return new " + Javapoet_extKt.getT() + "(true, null)", new Object[]{RoomTypeNames.INSTANCE.getOPEN_HELPER_VALIDATION_RESULT()});
            MethodSpec.Builder builder4 = builder;
            MethodSpec methodSpec = builder4.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"methodSpecs[0].toBuilder\u2026LT)\n            }.build()");
            list.set(n, methodSpec);
        }
        return methodSpecs;
    }

    private final MethodSpec createOnCreate(CodeGenScope scope) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"onCreate");
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.addModifiers(new Modifier[]{Modifier.PROTECTED});
        $this$apply.addAnnotation(Override.class);
        $this$apply.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        this.invokeCallbacks($this$apply, scope, "onCreate");
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026reate\")\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createOnOpen(CodeGenScope scope) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"onOpen");
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $this$apply.addAnnotation(Override.class);
        $this$apply.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        $this$apply.addStatement("mDatabase = _db", new Object[0]);
        if (this.database.getEnableForeignKeys()) {
            $this$apply.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{"PRAGMA foreign_keys = ON"});
        }
        $this$apply.addStatement("internalInitInvalidationTracker(_db)", new Object[0]);
        this.invokeCallbacks($this$apply, scope, "onOpen");
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026nOpen\")\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createCreateAllTables() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"createAllTables");
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $this$apply.addAnnotation(Override.class);
        $this$apply.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        List list = this.database.getBundle().buildCreateQueries();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"database.bundle.buildCreateQueries()");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl4 = false;
            $this$apply.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{it});
        }
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026      }\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createDropAllTables(CodeGenScope scope) {
        Pojo it;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"dropAllTables");
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $this$apply.addAnnotation(Override.class);
        $this$apply.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        Iterable $this$forEach$iv = this.database.getEntities();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Entity)element$iv;
            boolean bl4 = false;
            $this$apply.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{this.createDropTableQuery((Entity)it)});
        }
        $this$forEach$iv = this.database.getViews();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (DatabaseView)element$iv;
            boolean bl5 = false;
            $this$apply.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{this.createDropViewQuery((DatabaseView)it)});
        }
        this.invokeCallbacks($this$apply, scope, "onDestructiveMigration");
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026ation\")\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createOnPreMigrate() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"onPreMigrate");
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $this$apply.addAnnotation(Override.class);
        $this$apply.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        $this$apply.addStatement(Javapoet_extKt.getT() + ".dropFtsSyncTriggers(" + Javapoet_extKt.getL() + ')', new Object[]{RoomTypeNames.INSTANCE.getDB_UTIL(), "_db"});
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026 \"_db\")\n        }.build()");
        return methodSpec;
    }

    /*
     * WARNING - void declaration
     */
    private final MethodSpec createOnPostMigrate() {
        void $this$flatMapTo$iv$iv;
        FtsEntity it;
        Iterable $this$filterTo$iv$iv;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"onPostMigrate");
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $this$apply.addAnnotation(Override.class);
        $this$apply.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        Iterable $this$filter$iv = CollectionsKt.filterIsInstance((Iterable)this.database.getEntities(), FtsEntity.class);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FtsEntity)element$iv$iv;
            boolean bl4 = false;
            if (!(it.getFtsOptions().getContentEntity() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (FtsEntity)element$iv$iv;
            boolean bl5 = false;
            Iterable list$iv$iv = it.getContentSyncTriggerCreateQueries();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String syncTriggerQuery = (String)element$iv;
            boolean bl6 = false;
            $this$apply.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{syncTriggerQuery});
        }
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026      }\n        }.build()");
        return methodSpec;
    }

    private final void invokeCallbacks(@NotNull MethodSpec.Builder $this$invokeCallbacks, CodeGenScope scope, String methodName2) {
        String iVar = scope.getTmpVar("_i");
        String sizeVar = scope.getTmpVar("_size");
        MethodSpec.Builder builder = $this$invokeCallbacks.beginControlFlow("if (mCallbacks != null)", new Object[0]);
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$apply = builder;
        boolean bl3 = false;
        MethodSpec.Builder builder2 = $this$apply.beginControlFlow("for (int " + Javapoet_extKt.getN() + " = 0, " + Javapoet_extKt.getN() + " = mCallbacks.size(); " + Javapoet_extKt.getN() + " < " + Javapoet_extKt.getN() + "; " + Javapoet_extKt.getN() + "++)", new Object[]{iVar, sizeVar, iVar, sizeVar, iVar});
        boolean bl4 = false;
        boolean bl5 = false;
        MethodSpec.Builder $this$apply2 = builder2;
        boolean bl6 = false;
        $this$apply2.addStatement("mCallbacks.get(" + Javapoet_extKt.getN() + ")." + Javapoet_extKt.getN() + "(_db)", new Object[]{iVar, methodName2});
        $this$apply.endControlFlow();
        $this$invokeCallbacks.endControlFlow();
    }

    @VisibleForTesting
    @NotNull
    public final String createTableQuery(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return entity.getCreateTableQuery();
    }

    @VisibleForTesting
    @NotNull
    public final String createViewQuery(@NotNull DatabaseView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return view.getCreateViewQuery();
    }

    @VisibleForTesting
    @NotNull
    public final String createDropTableQuery(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return "DROP TABLE IF EXISTS `" + entity.getTableName() + '`';
    }

    @VisibleForTesting
    @NotNull
    public final String createDropViewQuery(@NotNull DatabaseView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return "DROP VIEW IF EXISTS `" + view.getViewName() + '`';
    }

    @NotNull
    public final Database getDatabase() {
        return this.database;
    }

    public SQLiteOpenHelperWriter(@NotNull Database database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        this.database = database;
    }
}

