/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.annotation.VisibleForTesting;
import androidx.room.ext.Javapoet_extKt;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.SupportDbTypeNames;
import androidx.room.solver.CodeGenScope;
import androidx.room.vo.Database;
import androidx.room.vo.Entity;
import androidx.room.writer.TableInfoValidationWriter;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u001b\u001a\u00020\u0017*\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Landroidx/room/writer/SQLiteOpenHelperWriter;", "", "database", "Landroidx/room/vo/Database;", "(Landroidx/room/vo/Database;)V", "getDatabase", "()Landroidx/room/vo/Database;", "createCreateAllTables", "Lcom/squareup/javapoet/MethodSpec;", "createDropAllTables", "createDropTableQuery", "", "entity", "Landroidx/room/vo/Entity;", "createOnCreate", "scope", "Landroidx/room/solver/CodeGenScope;", "createOnOpen", "createOpenCallback", "Lcom/squareup/javapoet/TypeSpec;", "createQuery", "createValidateMigration", "write", "", "outVar", "configuration", "Lcom/squareup/javapoet/ParameterSpec;", "invokeCallbacks", "Lcom/squareup/javapoet/MethodSpec$Builder;", "methodName", "room-compiler"})
public final class SQLiteOpenHelperWriter {
    @NotNull
    private final Database database;

    public final void write(@NotNull String outVar, @NotNull ParameterSpec configuration, @NotNull CodeGenScope scope) {
        CodeBlock.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)outVar, (String)"outVar");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        CodeBlock.Builder $receiver = builder = scope.builder();
        String sqliteConfigVar = scope.getTmpVar("_sqliteConfig");
        String callbackVar = scope.getTmpVar("_openCallback");
        $receiver.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getN() + ", " + Javapoet_extKt.getL() + ", " + Javapoet_extKt.getS() + ", " + Javapoet_extKt.getS() + ')', new Object[]{SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER_CALLBACK(), callbackVar, RoomTypeNames.INSTANCE.getOPEN_HELPER(), configuration, this.createOpenCallback(scope), this.database.getIdentityHash(), this.database.getLegacyIdentityHash()});
        $receiver.addStatement(StringsKt.trimIndent((String)("\n                    final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = " + Javapoet_extKt.getT() + ".builder(" + Javapoet_extKt.getN() + ".context)\n                    .name(" + Javapoet_extKt.getN() + ".name)\n                    .callback(" + Javapoet_extKt.getL() + ")\n                    .build()\n                    ")), new Object[]{SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER_CONFIG(), sqliteConfigVar, SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER_CONFIG(), configuration, configuration, callbackVar});
        $receiver.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getN() + " = " + Javapoet_extKt.getN() + ".sqliteOpenHelperFactory.create(" + Javapoet_extKt.getL() + ')', new Object[]{SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER(), outVar, configuration, sqliteConfigVar});
    }

    private final TypeSpec createOpenCallback(CodeGenScope scope) {
        TypeSpec.Builder builder;
        TypeSpec.Builder $receiver = builder = TypeSpec.anonymousClassBuilder((String)Javapoet_extKt.getL(), (Object[])new Object[]{this.database.getVersion()});
        $receiver.superclass((TypeName)RoomTypeNames.INSTANCE.getOPEN_HELPER_DELEGATE());
        $receiver.addMethod(this.createCreateAllTables());
        $receiver.addMethod(this.createDropAllTables());
        $receiver.addMethod(this.createOnCreate(scope.fork()));
        $receiver.addMethod(this.createOnOpen(scope.fork()));
        $receiver.addMethod(this.createValidateMigration(scope.fork()));
        TypeSpec typeSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeSpec, (String)"TypeSpec.anonymousClassB\u2026ork()))\n        }.build()");
        return typeSpec;
    }

    private final MethodSpec createValidateMigration(CodeGenScope scope) {
        MethodSpec.Builder builder;
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"validateMigration");
        $receiver.addModifiers(new Modifier[]{Modifier.PROTECTED});
        $receiver.addAnnotation(Override.class);
        ParameterSpec dbParam = ParameterSpec.builder((TypeName)((TypeName)SupportDbTypeNames.INSTANCE.getDB()), (String)"_db", (Modifier[])new Modifier[0]).build();
        $receiver.addParameter(dbParam);
        Iterable $receiver$iv = this.database.getEntities();
        for (Object element$iv : $receiver$iv) {
            Entity entity = (Entity)element$iv;
            CodeGenScope methodScope = scope.fork();
            TableInfoValidationWriter tableInfoValidationWriter = new TableInfoValidationWriter(entity);
            ParameterSpec parameterSpec = dbParam;
            Intrinsics.checkExpressionValueIsNotNull((Object)parameterSpec, (String)"dbParam");
            tableInfoValidationWriter.write(parameterSpec, methodScope);
            $receiver.addCode(methodScope.builder().build());
        }
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026      }\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createOnCreate(CodeGenScope scope) {
        MethodSpec.Builder builder;
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"onCreate");
        $receiver.addModifiers(new Modifier[]{Modifier.PROTECTED});
        $receiver.addAnnotation(Override.class);
        $receiver.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        this.invokeCallbacks($receiver, scope, "onCreate");
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026reate\")\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createOnOpen(CodeGenScope scope) {
        MethodSpec.Builder builder;
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"onOpen");
        $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $receiver.addAnnotation(Override.class);
        $receiver.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        $receiver.addStatement("mDatabase = _db", new Object[0]);
        if (this.database.getEnableForeignKeys()) {
            $receiver.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{"PRAGMA foreign_keys = ON"});
        }
        $receiver.addStatement("internalInitInvalidationTracker(_db)", new Object[0]);
        this.invokeCallbacks($receiver, scope, "onOpen");
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026nOpen\")\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createCreateAllTables() {
        MethodSpec.Builder builder;
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"createAllTables");
        $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $receiver.addAnnotation(Override.class);
        $receiver.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        List list = this.database.getBundle().buildCreateQueries();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"database.bundle.buildCreateQueries()");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            $receiver.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{it});
        }
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026      }\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createDropAllTables() {
        MethodSpec.Builder builder;
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"dropAllTables");
        $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $receiver.addAnnotation(Override.class);
        $receiver.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        Iterable $receiver$iv = this.database.getEntities();
        for (Object element$iv : $receiver$iv) {
            Entity it = (Entity)element$iv;
            $receiver.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{this.createDropTableQuery(it)});
        }
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026      }\n        }.build()");
        return methodSpec;
    }

    private final void invokeCallbacks(@NotNull MethodSpec.Builder $receiver, CodeGenScope scope, String methodName2) {
        MethodSpec.Builder builder;
        MethodSpec.Builder builder2;
        String iVar = scope.getTmpVar("_i");
        String sizeVar = scope.getTmpVar("_size");
        MethodSpec.Builder $receiver2 = builder2 = $receiver.beginControlFlow("if (mCallbacks != null)", new Object[0]);
        MethodSpec.Builder $receiver3 = builder = $receiver2.beginControlFlow("for (int " + Javapoet_extKt.getN() + " = 0, " + Javapoet_extKt.getN() + " = mCallbacks.size(); " + Javapoet_extKt.getN() + " < " + Javapoet_extKt.getN() + "; " + Javapoet_extKt.getN() + "++)", new Object[]{iVar, sizeVar, iVar, sizeVar, iVar});
        $receiver3.addStatement("mCallbacks.get(" + Javapoet_extKt.getN() + ")." + Javapoet_extKt.getN() + "(_db)", new Object[]{iVar, methodName2});
        $receiver2.endControlFlow();
        $receiver.endControlFlow();
    }

    @VisibleForTesting
    @NotNull
    public final String createQuery(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return entity.getCreateTableQuery();
    }

    @VisibleForTesting
    @NotNull
    public final String createDropTableQuery(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return "DROP TABLE IF EXISTS `" + entity.getTableName() + '`';
    }

    @NotNull
    public final Database getDatabase() {
        return this.database;
    }

    public SQLiteOpenHelperWriter(@NotNull Database database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        this.database = database;
    }
}

