/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.paging.DataSource;
import androidx.paging.PagedList;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Scheduler;
import io.reactivex.functions.Cancellable;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Executor;

public final class RxPagedListBuilder<Key, Value> {
    private Key mInitialLoadKey;
    private PagedList.Config mConfig;
    private DataSource.Factory<Key, Value> mDataSourceFactory;
    private PagedList.BoundaryCallback mBoundaryCallback;
    private Executor mNotifyExecutor;
    private Executor mFetchExecutor;
    private Scheduler mFetchScheduler;
    private Scheduler mNotifyScheduler;

    public RxPagedListBuilder(@NonNull DataSource.Factory<Key, Value> dataSourceFactory, @NonNull PagedList.Config config) {
        if (config == null) {
            throw new IllegalArgumentException("PagedList.Config must be provided");
        }
        if (dataSourceFactory == null) {
            throw new IllegalArgumentException("DataSource.Factory must be provided");
        }
        this.mDataSourceFactory = dataSourceFactory;
        this.mConfig = config;
    }

    public RxPagedListBuilder(@NonNull DataSource.Factory<Key, Value> dataSourceFactory, int pageSize) {
        this(dataSourceFactory, new PagedList.Config.Builder().setPageSize(pageSize).build());
    }

    @NonNull
    public RxPagedListBuilder<Key, Value> setInitialLoadKey(@Nullable Key key) {
        this.mInitialLoadKey = key;
        return this;
    }

    @NonNull
    public RxPagedListBuilder<Key, Value> setBoundaryCallback(@Nullable PagedList.BoundaryCallback<Value> boundaryCallback) {
        this.mBoundaryCallback = boundaryCallback;
        return this;
    }

    @NonNull
    public RxPagedListBuilder<Key, Value> setNotifyScheduler(@NonNull Scheduler scheduler) {
        this.mNotifyScheduler = scheduler;
        final Scheduler.Worker worker = scheduler.createWorker();
        this.mNotifyExecutor = new Executor(){

            @Override
            public void execute(@NonNull Runnable command) {
                worker.schedule(command);
            }
        };
        return this;
    }

    @NonNull
    public RxPagedListBuilder<Key, Value> setFetchScheduler(final @NonNull Scheduler scheduler) {
        this.mFetchExecutor = new Executor(){

            @Override
            public void execute(@NonNull Runnable command) {
                scheduler.scheduleDirect(command);
            }
        };
        this.mFetchScheduler = scheduler;
        return this;
    }

    @NonNull
    @SuppressLint(value={"RestrictedApi"})
    public Observable<PagedList<Value>> buildObservable() {
        if (this.mNotifyExecutor == null) {
            this.mNotifyExecutor = ArchTaskExecutor.getMainThreadExecutor();
            this.mNotifyScheduler = Schedulers.from((Executor)this.mNotifyExecutor);
        }
        if (this.mFetchExecutor == null) {
            this.mFetchExecutor = ArchTaskExecutor.getIOThreadExecutor();
            this.mFetchScheduler = Schedulers.from((Executor)this.mFetchExecutor);
        }
        return Observable.create(new PagingObservableOnSubscribe<Key, Value>(this.mInitialLoadKey, this.mConfig, this.mBoundaryCallback, this.mDataSourceFactory, this.mNotifyExecutor, this.mFetchExecutor)).observeOn(this.mNotifyScheduler).subscribeOn(this.mFetchScheduler);
    }

    @NonNull
    public Flowable<PagedList<Value>> buildFlowable(@NonNull BackpressureStrategy backpressureStrategy) {
        return this.buildObservable().toFlowable(backpressureStrategy);
    }

    static class PagingObservableOnSubscribe<Key, Value>
    implements ObservableOnSubscribe<PagedList<Value>>,
    DataSource.InvalidatedCallback,
    Cancellable,
    Runnable {
        @Nullable
        private final Key mInitialLoadKey;
        @NonNull
        private final PagedList.Config mConfig;
        @Nullable
        private final PagedList.BoundaryCallback mBoundaryCallback;
        @NonNull
        private final DataSource.Factory<Key, Value> mDataSourceFactory;
        @NonNull
        private final Executor mNotifyExecutor;
        @NonNull
        private final Executor mFetchExecutor;
        @Nullable
        private PagedList<Value> mList;
        @Nullable
        private DataSource<Key, Value> mDataSource;
        private ObservableEmitter<PagedList<Value>> mEmitter;

        PagingObservableOnSubscribe(@Nullable Key initialLoadKey, @NonNull PagedList.Config config, @Nullable PagedList.BoundaryCallback boundaryCallback, @NonNull DataSource.Factory<Key, Value> dataSourceFactory, @NonNull Executor notifyExecutor, @NonNull Executor fetchExecutor) {
            this.mInitialLoadKey = initialLoadKey;
            this.mConfig = config;
            this.mBoundaryCallback = boundaryCallback;
            this.mDataSourceFactory = dataSourceFactory;
            this.mNotifyExecutor = notifyExecutor;
            this.mFetchExecutor = fetchExecutor;
        }

        public void subscribe(ObservableEmitter<PagedList<Value>> emitter) throws Exception {
            this.mEmitter = emitter;
            this.mEmitter.setCancellable((Cancellable)this);
            this.mEmitter.onNext(this.createPagedList());
        }

        public void cancel() throws Exception {
            if (this.mDataSource != null) {
                this.mDataSource.removeInvalidatedCallback((DataSource.InvalidatedCallback)this);
            }
        }

        @Override
        public void run() {
            this.mEmitter.onNext(this.createPagedList());
        }

        public void onInvalidated() {
            if (!this.mEmitter.isDisposed()) {
                this.mFetchExecutor.execute(this);
            }
        }

        private PagedList<Value> createPagedList() {
            Object initializeKey = this.mInitialLoadKey;
            if (this.mList != null) {
                initializeKey = this.mList.getLastKey();
            }
            do {
                if (this.mDataSource != null) {
                    this.mDataSource.removeInvalidatedCallback((DataSource.InvalidatedCallback)this);
                }
                this.mDataSource = this.mDataSourceFactory.create();
                this.mDataSource.addInvalidatedCallback((DataSource.InvalidatedCallback)this);
                this.mList = new PagedList.Builder(this.mDataSource, this.mConfig).setNotifyExecutor(this.mNotifyExecutor).setFetchExecutor(this.mFetchExecutor).setBoundaryCallback(this.mBoundaryCallback).setInitialKey(initializeKey).build();
            } while (this.mList.isDetached());
            return this.mList;
        }
    }
}

