/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.lifecycle.ComputableLiveData;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.paging.PagedList;
import java.util.concurrent.Executor;

public final class LivePagedListBuilder<Key, Value> {
    private Key mInitialLoadKey;
    private PagedList.Config mConfig;
    private DataSource.Factory<Key, Value> mDataSourceFactory;
    private PagedList.BoundaryCallback mBoundaryCallback;
    private Executor mFetchExecutor = ArchTaskExecutor.getIOThreadExecutor();

    public LivePagedListBuilder(@NonNull DataSource.Factory<Key, Value> dataSourceFactory, @NonNull PagedList.Config config) {
        if (config == null) {
            throw new IllegalArgumentException("PagedList.Config must be provided");
        }
        if (dataSourceFactory == null) {
            throw new IllegalArgumentException("DataSource.Factory must be provided");
        }
        this.mDataSourceFactory = dataSourceFactory;
        this.mConfig = config;
    }

    public LivePagedListBuilder(@NonNull DataSource.Factory<Key, Value> dataSourceFactory, int pageSize) {
        this(dataSourceFactory, new PagedList.Config.Builder().setPageSize(pageSize).build());
    }

    @NonNull
    public LivePagedListBuilder<Key, Value> setInitialLoadKey(@Nullable Key key) {
        this.mInitialLoadKey = key;
        return this;
    }

    @NonNull
    public LivePagedListBuilder<Key, Value> setBoundaryCallback(@Nullable PagedList.BoundaryCallback<Value> boundaryCallback) {
        this.mBoundaryCallback = boundaryCallback;
        return this;
    }

    @NonNull
    public LivePagedListBuilder<Key, Value> setFetchExecutor(@NonNull Executor fetchExecutor) {
        this.mFetchExecutor = fetchExecutor;
        return this;
    }

    @NonNull
    public LiveData<PagedList<Value>> build() {
        return LivePagedListBuilder.create(this.mInitialLoadKey, this.mConfig, this.mBoundaryCallback, this.mDataSourceFactory, ArchTaskExecutor.getMainThreadExecutor(), this.mFetchExecutor);
    }

    @AnyThread
    @NonNull
    private static <Key, Value> LiveData<PagedList<Value>> create(final @Nullable Key initialLoadKey, final @NonNull PagedList.Config config, final @Nullable PagedList.BoundaryCallback boundaryCallback, final @NonNull DataSource.Factory<Key, Value> dataSourceFactory, final @NonNull Executor notifyExecutor, final @NonNull Executor fetchExecutor) {
        return new ComputableLiveData<PagedList<Value>>(fetchExecutor){
            @Nullable
            private PagedList<Value> mList;
            @Nullable
            private DataSource<Key, Value> mDataSource;
            private final DataSource.InvalidatedCallback mCallback;
            {
                super(arg0);
                this.mCallback = new DataSource.InvalidatedCallback(){

                    public void onInvalidated() {
                        this.invalidate();
                    }
                };
            }

            protected PagedList<Value> compute() {
                Object initializeKey = initialLoadKey;
                if (this.mList != null) {
                    initializeKey = this.mList.getLastKey();
                }
                do {
                    if (this.mDataSource != null) {
                        this.mDataSource.removeInvalidatedCallback(this.mCallback);
                    }
                    this.mDataSource = dataSourceFactory.create();
                    this.mDataSource.addInvalidatedCallback(this.mCallback);
                    this.mList = new PagedList.Builder(this.mDataSource, config).setNotifyExecutor(notifyExecutor).setFetchExecutor(fetchExecutor).setBoundaryCallback(boundaryCallback).setInitialKey(initializeKey).build();
                } while (this.mList.isDetached());
                return this.mList;
            }
        }.getLiveData();
    }
}

