/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.paging.PagedList;
import androidx.paging.PagedStorageDiffHelper;
import androidx.recyclerview.widget.AdapterListUpdateCallback;
import androidx.recyclerview.widget.AsyncDifferConfig;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListUpdateCallback;
import androidx.recyclerview.widget.RecyclerView;
import java.util.concurrent.Executor;

public class AsyncPagedListDiffer<T> {
    final ListUpdateCallback mUpdateCallback;
    final AsyncDifferConfig<T> mConfig;
    Executor mMainThreadExecutor = ArchTaskExecutor.getMainThreadExecutor();
    @Nullable
    PagedListListener<T> mListener;
    private boolean mIsContiguous;
    private int mLastAccessIndex;
    private PagedList<T> mPagedList;
    private PagedList<T> mSnapshot;
    int mMaxScheduledGeneration;
    private PagedList.Callback mPagedListCallback = new PagedList.Callback(){

        public void onInserted(int position, int count) {
            AsyncPagedListDiffer.this.mUpdateCallback.onInserted(position, count);
        }

        public void onRemoved(int position, int count) {
            AsyncPagedListDiffer.this.mUpdateCallback.onRemoved(position, count);
        }

        public void onChanged(int position, int count) {
            AsyncPagedListDiffer.this.mUpdateCallback.onChanged(position, count, null);
        }
    };

    public AsyncPagedListDiffer(@NonNull RecyclerView.Adapter adapter, @NonNull DiffUtil.ItemCallback<T> diffCallback) {
        this.mUpdateCallback = new AdapterListUpdateCallback(adapter);
        this.mConfig = new AsyncDifferConfig.Builder(diffCallback).build();
    }

    public AsyncPagedListDiffer(@NonNull ListUpdateCallback listUpdateCallback, @NonNull AsyncDifferConfig<T> config) {
        this.mUpdateCallback = listUpdateCallback;
        this.mConfig = config;
    }

    @Nullable
    public T getItem(int index) {
        if (this.mPagedList == null) {
            if (this.mSnapshot == null) {
                throw new IndexOutOfBoundsException("Item count is zero, getItem() call is invalid");
            }
            return (T)this.mSnapshot.get(index);
        }
        this.mPagedList.loadAround(index);
        return (T)this.mPagedList.get(index);
    }

    public int getItemCount() {
        if (this.mPagedList != null) {
            return this.mPagedList.size();
        }
        return this.mSnapshot == null ? 0 : this.mSnapshot.size();
    }

    public void submitList(final PagedList<T> pagedList) {
        if (pagedList != null) {
            if (this.mPagedList == null && this.mSnapshot == null) {
                this.mIsContiguous = pagedList.isContiguous();
            } else if (pagedList.isContiguous() != this.mIsContiguous) {
                throw new IllegalArgumentException("AsyncPagedListDiffer cannot handle both contiguous and non-contiguous lists.");
            }
        }
        final int runGeneration = ++this.mMaxScheduledGeneration;
        if (pagedList == this.mPagedList) {
            return;
        }
        if (pagedList == null) {
            int removedCount = this.getItemCount();
            if (this.mPagedList != null) {
                this.mPagedList.removeWeakCallback(this.mPagedListCallback);
                this.mPagedList = null;
            } else if (this.mSnapshot != null) {
                this.mSnapshot = null;
            }
            this.mUpdateCallback.onRemoved(0, removedCount);
            if (this.mListener != null) {
                this.mListener.onCurrentListChanged(null);
            }
            return;
        }
        if (this.mPagedList == null && this.mSnapshot == null) {
            this.mPagedList = pagedList;
            pagedList.addWeakCallback(null, this.mPagedListCallback);
            this.mUpdateCallback.onInserted(0, pagedList.size());
            if (this.mListener != null) {
                this.mListener.onCurrentListChanged(pagedList);
            }
            return;
        }
        if (this.mPagedList != null) {
            this.mPagedList.removeWeakCallback(this.mPagedListCallback);
            this.mSnapshot = (PagedList)this.mPagedList.snapshot();
            this.mPagedList = null;
        }
        if (this.mSnapshot == null || this.mPagedList != null) {
            throw new IllegalStateException("must be in snapshot state to diff");
        }
        final PagedList<T> oldSnapshot = this.mSnapshot;
        final PagedList newSnapshot = (PagedList)pagedList.snapshot();
        this.mConfig.getBackgroundThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                final DiffUtil.DiffResult result = PagedStorageDiffHelper.computeDiff(oldSnapshot.mStorage, newSnapshot.mStorage, AsyncPagedListDiffer.this.mConfig.getDiffCallback());
                AsyncPagedListDiffer.this.mMainThreadExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (AsyncPagedListDiffer.this.mMaxScheduledGeneration == runGeneration) {
                            AsyncPagedListDiffer.this.latchPagedList(pagedList, newSnapshot, result, oldSnapshot.mLastLoad);
                        }
                    }
                });
            }
        });
    }

    void latchPagedList(@NonNull PagedList<T> newList, @NonNull PagedList<T> diffSnapshot, @NonNull DiffUtil.DiffResult diffResult, int lastAccessIndex) {
        if (this.mSnapshot == null || this.mPagedList != null) {
            throw new IllegalStateException("must be in snapshot state to apply diff");
        }
        PagedList<T> previousSnapshot = this.mSnapshot;
        this.mPagedList = newList;
        this.mSnapshot = null;
        PagedStorageDiffHelper.dispatchDiff(this.mUpdateCallback, previousSnapshot.mStorage, newList.mStorage, diffResult);
        newList.addWeakCallback(diffSnapshot, this.mPagedListCallback);
        int newPosition = PagedStorageDiffHelper.transformAnchorIndex(diffResult, previousSnapshot.mStorage, diffSnapshot.mStorage, lastAccessIndex);
        this.mPagedList.mLastLoad = Math.max(0, Math.min(this.mPagedList.size(), newPosition));
        if (this.mListener != null) {
            this.mListener.onCurrentListChanged(this.mPagedList);
        }
    }

    @Nullable
    public PagedList<T> getCurrentList() {
        if (this.mSnapshot != null) {
            return this.mSnapshot;
        }
        return this.mPagedList;
    }

    static interface PagedListListener<T> {
        public void onCurrentListChanged(@Nullable PagedList<T> var1);
    }
}

