/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.IntRange;
import androidx.paging.PagingConfig;
import androidx.paging.PagingSource;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B;\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJT\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0002\u0010\u00152\u0006\u0010\u0007\u001a\u00020\b26\u0010\u0016\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u0002H\u00150\u0017H\u0082\b\u00a2\u0006\u0002\u0010\u001cJ\u0015\u0010\u001d\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001eJ\u001c\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\r\u0010 \u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010!J\u0006\u0010\"\u001a\u00020#J\r\u0010$\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010!R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Landroidx/paging/PagingState;", "Key", "", "Value", "pages", "", "Landroidx/paging/PagingSource$LoadResult$Page;", "anchorPosition", "", "config", "Landroidx/paging/PagingConfig;", "leadingPlaceholderCount", "(Ljava/util/List;Ljava/lang/Integer;Landroidx/paging/PagingConfig;I)V", "getAnchorPosition", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getConfig", "()Landroidx/paging/PagingConfig;", "getPages", "()Ljava/util/List;", "anchorPositionToPagedIndices", "T", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "pageIndex", "index", "(ILkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "closestItemToPosition", "(I)Ljava/lang/Object;", "closestPageToPosition", "firstItemOrNull", "()Ljava/lang/Object;", "isEmpty", "", "lastItemOrNull", "paging-common"})
public final class PagingState<Key, Value> {
    @NotNull
    private final List<PagingSource.LoadResult.Page<Key, Value>> pages;
    @Nullable
    private final Integer anchorPosition;
    @NotNull
    private final PagingConfig config;
    private final int leadingPlaceholderCount;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Value closestItemToPosition(int anchorPosition) {
        void index;
        PagingSource.LoadResult.Page<Key, Value> element$iv;
        PagingSource.LoadResult.Page firstNonEmptyPage;
        int pageIndex;
        block9: {
            Object element$iv22;
            block8: {
                int index$iv;
                boolean bl;
                block7: {
                    Iterable $this$all$iv = this.pages;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv3 : $this$all$iv) {
                            PagingSource.LoadResult.Page it = (PagingSource.LoadResult.Page)element$iv3;
                            boolean bl2 = false;
                            if (it.getData().isEmpty()) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return null;
                }
                PagingState this_$iv = this;
                boolean $i$f$anchorPositionToPagedIndices = false;
                int pageIndex$iv = 0;
                for (index$iv = anchorPosition - this_$iv.leadingPlaceholderCount; pageIndex$iv < CollectionsKt.getLastIndex(this_$iv.getPages()) && index$iv > CollectionsKt.getLastIndex(this_$iv.getPages().get(pageIndex$iv).getData()); index$iv -= this_$iv.getPages().get(pageIndex$iv).getData().size(), ++pageIndex$iv) {
                }
                int it = index$iv;
                pageIndex = pageIndex$iv;
                boolean bl3 = false;
                Iterable $this$first$iv = this.pages;
                boolean $i$f$first = false;
                for (Object element$iv22 : $this$first$iv) {
                    PagingSource.LoadResult.Page it2 = (PagingSource.LoadResult.Page)element$iv22;
                    boolean bl4 = false;
                    Collection collection = it2.getData();
                    boolean bl5 = false;
                    if (!(!collection.isEmpty())) continue;
                    break block8;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            firstNonEmptyPage = (PagingSource.LoadResult.Page)element$iv22;
            List<PagingSource.LoadResult.Page<Key, Value>> $this$last$iv = this.pages;
            boolean $i$f$last = false;
            ListIterator<PagingSource.LoadResult.Page<Key, Value>> iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
            while (iterator$iv.hasPrevious()) {
                PagingSource.LoadResult.Page<Key, Value> it = element$iv = iterator$iv.previous();
                boolean bl = false;
                Collection collection = it.getData();
                boolean bl6 = false;
                if (!(!collection.isEmpty())) continue;
                break block9;
            }
            throw (Throwable)new NoSuchElementException("List contains no element matching the predicate.");
        }
        PagingSource.LoadResult.Page<Key, Value> lastNonEmptyPage = element$iv;
        return (Value)(index < 0 ? CollectionsKt.first(firstNonEmptyPage.getData()) : (pageIndex == CollectionsKt.getLastIndex(this.pages) && index > CollectionsKt.getLastIndex(((PagingSource.LoadResult.Page)CollectionsKt.last(this.pages)).getData()) ? CollectionsKt.last(lastNonEmptyPage.getData()) : this.pages.get(pageIndex).getData().get((int)index)));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PagingSource.LoadResult.Page<Key, Value> closestPageToPosition(int anchorPosition) {
        void index;
        int index$iv;
        boolean bl;
        block5: {
            Iterable $this$all$iv = this.pages;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PagingSource.LoadResult.Page it = (PagingSource.LoadResult.Page)element$iv;
                    boolean bl2 = false;
                    if (it.getData().isEmpty()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        PagingState this_$iv = this;
        boolean $i$f$anchorPositionToPagedIndices = false;
        int pageIndex$iv = 0;
        for (index$iv = anchorPosition - this_$iv.leadingPlaceholderCount; pageIndex$iv < CollectionsKt.getLastIndex(this_$iv.getPages()) && index$iv > CollectionsKt.getLastIndex(this_$iv.getPages().get(pageIndex$iv).getData()); index$iv -= this_$iv.getPages().get(pageIndex$iv).getData().size(), ++pageIndex$iv) {
        }
        int it = index$iv;
        int pageIndex = pageIndex$iv;
        boolean bl3 = false;
        return index < 0 ? (PagingSource.LoadResult.Page<Key, Value>)CollectionsKt.first(this.pages) : this.pages.get(pageIndex);
    }

    public final boolean isEmpty() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.pages;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PagingSource.LoadResult.Page it = (PagingSource.LoadResult.Page)element$iv;
                    boolean bl2 = false;
                    if (it.getData().isEmpty()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Nullable
    public final Value firstItemOrNull() {
        Object object;
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.pages;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PagingSource.LoadResult.Page it = (PagingSource.LoadResult.Page)element$iv;
                boolean bl = false;
                Collection collection = it.getData();
                boolean bl2 = false;
                if (!(!collection.isEmpty())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return (Value)((object = (PagingSource.LoadResult.Page)v0) != null && (object = ((PagingSource.LoadResult.Page)object).getData()) != null ? CollectionsKt.firstOrNull((List)object) : null);
    }

    @Nullable
    public final Value lastItemOrNull() {
        Object object;
        PagingSource.LoadResult.Page<Key, Value> page;
        block1: {
            List<PagingSource.LoadResult.Page<Key, Value>> $this$lastOrNull$iv = this.pages;
            boolean $i$f$lastOrNull = false;
            ListIterator<PagingSource.LoadResult.Page<Key, Value>> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                PagingSource.LoadResult.Page<Key, Value> element$iv;
                PagingSource.LoadResult.Page<Key, Value> it = element$iv = iterator$iv.previous();
                boolean bl = false;
                Collection collection = it.getData();
                boolean bl2 = false;
                if (!(!collection.isEmpty())) continue;
                page = element$iv;
                break block1;
            }
            page = null;
        }
        return (Value)((object = (PagingSource.LoadResult.Page)page) != null && (object = ((PagingSource.LoadResult.Page)object).getData()) != null ? CollectionsKt.lastOrNull((List)object) : null);
    }

    private final <T> T anchorPositionToPagedIndices(int anchorPosition, Function2<? super Integer, ? super Integer, ? extends T> block) {
        int index;
        int $i$f$anchorPositionToPagedIndices = 0;
        int pageIndex = 0;
        for (index = anchorPosition - this.leadingPlaceholderCount; pageIndex < CollectionsKt.getLastIndex(this.getPages()) && index > CollectionsKt.getLastIndex(this.getPages().get(pageIndex).getData()); index -= this.getPages().get(pageIndex).getData().size(), ++pageIndex) {
        }
        return (T)block.invoke((Object)pageIndex, (Object)index);
    }

    @NotNull
    public final List<PagingSource.LoadResult.Page<Key, Value>> getPages() {
        return this.pages;
    }

    @Nullable
    public final Integer getAnchorPosition() {
        return this.anchorPosition;
    }

    @NotNull
    public final PagingConfig getConfig() {
        return this.config;
    }

    public PagingState(@NotNull List<PagingSource.LoadResult.Page<Key, Value>> pages, @Nullable Integer anchorPosition, @NotNull PagingConfig config, @IntRange(from=0L) int leadingPlaceholderCount) {
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.pages = pages;
        this.anchorPosition = anchorPosition;
        this.config = config;
        this.leadingPlaceholderCount = leadingPlaceholderCount;
    }
}

