/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.CombinedLoadStates;
import androidx.paging.ItemSnapshotList;
import androidx.paging.LoadState;
import androidx.paging.LoadStates;
import androidx.paging.LoadType;
import androidx.paging.NullPaddedList;
import androidx.paging.PageEvent;
import androidx.paging.PagePresenter$WhenMappings;
import androidx.paging.TransformablePage;
import androidx.paging.ViewportHint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u0000 5*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u000256B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u001e\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002J\u0015\u0010$\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00020\b\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00028\u00002\u0006\u0010'\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010%J\u001e\u0010(\u001a\u00020\u001a2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010*\u001a\u00020\u001a2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,2\u0006\u0010\u001f\u001a\u00020 J\f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000.J\b\u0010/\u001a\u000200H\u0016J\u000e\u00101\u001a\u0002022\u0006\u0010\u001b\u001a\u00020\bJ\u0018\u00103\u001a\u00020\b*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f04H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u001e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\nR\u001e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\n\u00a8\u00067"}, d2={"Landroidx/paging/PagePresenter;", "T", "", "Landroidx/paging/NullPaddedList;", "insertEvent", "Landroidx/paging/PageEvent$Insert;", "(Landroidx/paging/PageEvent$Insert;)V", "originalPageOffsetFirst", "", "getOriginalPageOffsetFirst", "()I", "originalPageOffsetLast", "getOriginalPageOffsetLast", "pages", "", "Landroidx/paging/TransformablePage;", "<set-?>", "placeholdersAfter", "getPlaceholdersAfter", "placeholdersBefore", "getPlaceholdersBefore", "size", "getSize", "storageCount", "getStorageCount", "checkIndex", "", "index", "dropPages", "drop", "Landroidx/paging/PageEvent$Drop;", "callback", "Landroidx/paging/PagePresenter$ProcessPageEventCallback;", "dropPagesWithOffsets", "pageOffsetsToDrop", "Lkotlin/ranges/IntRange;", "get", "(I)Ljava/lang/Object;", "getFromStorage", "localIndex", "insertPage", "insert", "processEvent", "pageEvent", "Landroidx/paging/PageEvent;", "snapshot", "Landroidx/paging/ItemSnapshotList;", "toString", "", "viewportHintForPresenterIndex", "Landroidx/paging/ViewportHint;", "fullCount", "", "Companion", "ProcessPageEventCallback", "paging-common"})
public final class PagePresenter<T>
implements NullPaddedList<T> {
    private final List<TransformablePage<T>> pages;
    private int storageCount;
    private int placeholdersBefore;
    private int placeholdersAfter;
    private static final PagePresenter<Object> INITIAL;
    public static final Companion Companion;

    @Override
    public int getStorageCount() {
        return this.storageCount;
    }

    private final int getOriginalPageOffsetFirst() {
        Integer n = ArraysKt.min((int[])((TransformablePage)CollectionsKt.first(this.pages)).getOriginalPageOffsets());
        if (n == null) {
            Intrinsics.throwNpe();
        }
        return n;
    }

    private final int getOriginalPageOffsetLast() {
        Integer n = ArraysKt.max((int[])((TransformablePage)CollectionsKt.last(this.pages)).getOriginalPageOffsets());
        if (n == null) {
            Intrinsics.throwNpe();
        }
        return n;
    }

    @Override
    public int getPlaceholdersBefore() {
        return this.placeholdersBefore;
    }

    @Override
    public int getPlaceholdersAfter() {
        return this.placeholdersAfter;
    }

    private final void checkIndex(int index) {
        if (index < 0 || index >= this.getSize()) {
            throw (Throwable)new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getSize());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        int n = this.getStorageCount();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<T> arrayList = new ArrayList<T>(n);
        boolean bl3 = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void it;
            int n4 = n2++;
            boolean bl4 = false;
            int n5 = n4;
            ArrayList<T> arrayList2 = arrayList;
            boolean bl5 = false;
            T t = this.getFromStorage((int)it);
            arrayList2.add(t);
        }
        String items = CollectionsKt.joinToString$default((Iterable)arrayList, null, null, null, (int)0, null, null, (int)63, null);
        return "[(" + this.getPlaceholdersBefore() + " placeholders), " + items + ", (" + this.getPlaceholdersAfter() + " placeholders)]";
    }

    @Nullable
    public final T get(int index) {
        this.checkIndex(index);
        int localIndex = index - this.getPlaceholdersBefore();
        if (localIndex < 0 || localIndex >= this.getStorageCount()) {
            return null;
        }
        return this.getFromStorage(localIndex);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ItemSnapshotList<T> snapshot() {
        List list;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = this.pages;
        int n = this.getPlaceholdersAfter();
        int n2 = this.getPlaceholdersBefore();
        boolean $i$f$flatMap = false;
        void var3_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TransformablePage it = (TransformablePage)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getData();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list2 = list = (List)destination$iv$iv;
        int n3 = n;
        int n4 = n2;
        return new ItemSnapshotList(n4, n3, list2);
    }

    @Override
    @NotNull
    public T getFromStorage(int localIndex) {
        int indexInPage;
        int pageSize;
        int pageIndex = 0;
        int localPageCount = this.pages.size();
        for (indexInPage = localIndex; pageIndex < localPageCount && (pageSize = this.pages.get(pageIndex).getData().size()) <= indexInPage; indexInPage -= pageSize, ++pageIndex) {
        }
        return this.pages.get(pageIndex).getData().get(indexInPage);
    }

    @Override
    public int getSize() {
        return this.getPlaceholdersBefore() + this.getStorageCount() + this.getPlaceholdersAfter();
    }

    /*
     * WARNING - void declaration
     */
    private final int fullCount(@NotNull List<TransformablePage<T>> $this$fullCount) {
        Iterable $this$sumBy$iv = $this$fullCount;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            TransformablePage transformablePage = (TransformablePage)element$iv;
            int n = sum$iv;
            boolean bl = false;
            int n2 = it.getData().size();
            sum$iv = n + n2;
        }
        return sum$iv;
    }

    public final void processEvent(@NotNull PageEvent<T> pageEvent, @NotNull ProcessPageEventCallback callback) {
        block1: {
            PageEvent<T> pageEvent2;
            block2: {
                block0: {
                    Intrinsics.checkParameterIsNotNull(pageEvent, (String)"pageEvent");
                    Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
                    pageEvent2 = pageEvent;
                    if (!(pageEvent2 instanceof PageEvent.Insert)) break block0;
                    this.insertPage((PageEvent.Insert)pageEvent, callback);
                    break block1;
                }
                if (!(pageEvent2 instanceof PageEvent.Drop)) break block2;
                this.dropPages((PageEvent.Drop)pageEvent, callback);
                break block1;
            }
            if (!(pageEvent2 instanceof PageEvent.LoadStateUpdate)) break block1;
            callback.onStateUpdate(((PageEvent.LoadStateUpdate)pageEvent).getLoadType(), ((PageEvent.LoadStateUpdate)pageEvent).getFromMediator(), ((PageEvent.LoadStateUpdate)pageEvent).getLoadState());
        }
    }

    @NotNull
    public final ViewportHint viewportHintForPresenterIndex(int index) {
        int indexInPage;
        int pageIndex = 0;
        for (indexInPage = index - this.getPlaceholdersBefore(); indexInPage >= this.pages.get(pageIndex).getData().size() && pageIndex < CollectionsKt.getLastIndex(this.pages); indexInPage -= this.pages.get(pageIndex).getData().size(), ++pageIndex) {
        }
        return this.pages.get(pageIndex).viewportHintFor(indexInPage, index - this.getPlaceholdersBefore(), this.getSize() - index - this.getPlaceholdersAfter() - 1, this.getOriginalPageOffsetFirst(), this.getOriginalPageOffsetLast());
    }

    private final void insertPage(PageEvent.Insert<T> insert, ProcessPageEventCallback callback) {
        block7: {
            LoadState state;
            boolean fromMediator;
            LoadState state$iv;
            int count = this.fullCount(insert.getPages());
            int oldSize = this.getSize();
            switch (PagePresenter$WhenMappings.$EnumSwitchMapping$0[insert.getLoadType().ordinal()]) {
                case 1: {
                    throw (Throwable)new IllegalArgumentException();
                }
                case 2: {
                    int n = this.getPlaceholdersBefore();
                    boolean bl = false;
                    int placeholdersChangedCount = Math.min(n, count);
                    int placeholdersChangedPos = this.getPlaceholdersBefore() - placeholdersChangedCount;
                    int itemsInsertedCount = count - placeholdersChangedCount;
                    int itemsInsertedPos = 0;
                    this.pages.addAll(0, (Collection)insert.getPages());
                    this.storageCount = this.getStorageCount() + count;
                    this.placeholdersBefore = insert.getPlaceholdersBefore();
                    callback.onChanged(placeholdersChangedPos, placeholdersChangedCount);
                    callback.onInserted(itemsInsertedPos, itemsInsertedCount);
                    int placeholderInsertedCount = this.getSize() - oldSize - itemsInsertedCount;
                    if (placeholderInsertedCount > 0) {
                        callback.onInserted(0, placeholderInsertedCount);
                        break;
                    }
                    if (placeholderInsertedCount >= 0) break;
                    callback.onRemoved(0, -placeholderInsertedCount);
                    break;
                }
                case 3: {
                    int placeholdersChangedPos = this.getPlaceholdersAfter();
                    int itemsInsertedCount = 0;
                    int placeholdersChangedCount = Math.min(placeholdersChangedPos, count);
                    placeholdersChangedPos = this.getPlaceholdersBefore() + this.getStorageCount();
                    itemsInsertedCount = count - placeholdersChangedCount;
                    int itemsInsertedPos = placeholdersChangedPos + placeholdersChangedCount;
                    this.pages.addAll(this.pages.size(), (Collection)insert.getPages());
                    this.storageCount = this.getStorageCount() + count;
                    this.placeholdersAfter = insert.getPlaceholdersAfter();
                    callback.onChanged(placeholdersChangedPos, placeholdersChangedCount);
                    callback.onInserted(itemsInsertedPos, itemsInsertedCount);
                    int placeholderInsertedCount = this.getSize() - oldSize - itemsInsertedCount;
                    if (placeholderInsertedCount > 0) {
                        callback.onInserted(this.getSize() - placeholderInsertedCount, placeholderInsertedCount);
                        break;
                    }
                    if (placeholderInsertedCount >= 0) break;
                    callback.onRemoved(this.getSize(), -placeholderInsertedCount);
                    break;
                }
            }
            CombinedLoadStates this_$iv = insert.getCombinedLoadStates();
            boolean $i$f$forEach = false;
            LoadStates this_$iv$iv = this_$iv.getSource();
            boolean $i$f$forEach2 = false;
            LoadState placeholderInsertedCount = this_$iv$iv.getRefresh();
            LoadType type$iv = LoadType.REFRESH;
            boolean bl = false;
            void var12_15 = state$iv;
            boolean bl2 = false;
            LoadType type = type$iv;
            boolean bl3 = false;
            callback.onStateUpdate(type, fromMediator, state);
            state$iv = this_$iv$iv.getPrepend();
            type$iv = LoadType.PREPEND;
            bl = false;
            state = state$iv;
            fromMediator = false;
            type = type$iv;
            bl3 = false;
            callback.onStateUpdate(type, fromMediator, state);
            state$iv = this_$iv$iv.getAppend();
            type$iv = LoadType.APPEND;
            bl = false;
            state = state$iv;
            fromMediator = false;
            type = type$iv;
            bl3 = false;
            callback.onStateUpdate(type, fromMediator, state);
            LoadStates loadStates = this_$iv.getMediator();
            if (loadStates == null) break block7;
            this_$iv$iv = loadStates;
            $i$f$forEach2 = false;
            state$iv = this_$iv$iv.getRefresh();
            type$iv = LoadType.REFRESH;
            boolean bl4 = false;
            state = state$iv;
            fromMediator = true;
            type = type$iv;
            bl3 = false;
            callback.onStateUpdate(type, fromMediator, state);
            state$iv = this_$iv$iv.getPrepend();
            type$iv = LoadType.PREPEND;
            bl4 = false;
            state = state$iv;
            fromMediator = true;
            type = type$iv;
            bl3 = false;
            callback.onStateUpdate(type, fromMediator, state);
            state$iv = this_$iv$iv.getAppend();
            type$iv = LoadType.APPEND;
            bl4 = false;
            state = state$iv;
            fromMediator = true;
            type = type$iv;
            bl3 = false;
            callback.onStateUpdate(type, fromMediator, state);
        }
    }

    private final int dropPagesWithOffsets(IntRange pageOffsetsToDrop) {
        int removeCount = 0;
        Iterator<TransformablePage<T>> pageIterator = this.pages.iterator();
        while (pageIterator.hasNext()) {
            boolean bl;
            TransformablePage<T> page;
            block2: {
                page = pageIterator.next();
                int[] $this$any$iv = page.getOriginalPageOffsets();
                boolean $i$f$any = false;
                int[] nArray = $this$any$iv;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int element$iv;
                    int it = element$iv = nArray[i];
                    boolean bl2 = false;
                    if (!pageOffsetsToDrop.contains(it)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            removeCount += page.getData().size();
            pageIterator.remove();
        }
        return removeCount;
    }

    private final void dropPages(PageEvent.Drop<T> drop, ProcessPageEventCallback callback) {
        int oldSize = this.getSize();
        if (drop.getLoadType() == LoadType.PREPEND) {
            int oldPlaceholdersBefore = this.getPlaceholdersBefore();
            int n = drop.getMinPageOffset();
            int itemDropCount = this.dropPagesWithOffsets(new IntRange(n, drop.getMaxPageOffset()));
            this.storageCount = this.getStorageCount() - itemDropCount;
            this.placeholdersBefore = drop.getPlaceholdersRemaining();
            int expectedSize = this.getSize();
            int placeholdersToInsert = expectedSize - oldSize;
            if (placeholdersToInsert > 0) {
                callback.onInserted(0, placeholdersToInsert);
            } else if (placeholdersToInsert < 0) {
                callback.onRemoved(0, -placeholdersToInsert);
            }
            int n2 = 0;
            int n3 = oldPlaceholdersBefore + placeholdersToInsert;
            boolean bl = false;
            int firstItemIndex = Math.max(n2, n3);
            int changeCount = drop.getPlaceholdersRemaining() - firstItemIndex;
            if (changeCount > 0) {
                callback.onChanged(firstItemIndex, changeCount);
            }
            callback.onStateUpdate(LoadType.PREPEND, false, LoadState.NotLoading.Companion.getIncomplete$paging_common());
        } else {
            int n;
            int changeCount;
            int oldPlaceholdersAfter = this.getPlaceholdersAfter();
            int expectedSize = drop.getMinPageOffset();
            int itemDropCount = this.dropPagesWithOffsets(new IntRange(expectedSize, drop.getMaxPageOffset()));
            this.storageCount = this.getStorageCount() - itemDropCount;
            this.placeholdersAfter = drop.getPlaceholdersRemaining();
            expectedSize = this.getSize();
            int placeholdersToInsert = expectedSize - oldSize;
            if (placeholdersToInsert > 0) {
                callback.onInserted(oldSize, placeholdersToInsert);
            } else if (placeholdersToInsert < 0) {
                callback.onRemoved(oldSize + placeholdersToInsert, -placeholdersToInsert);
            }
            if (placeholdersToInsert < 0) {
                changeCount = -placeholdersToInsert;
                boolean bl = false;
                n = Math.min(oldPlaceholdersAfter, changeCount);
            } else {
                n = 0;
            }
            int oldPlaceholdersRemoved = n;
            changeCount = drop.getPlaceholdersRemaining() - (oldPlaceholdersAfter - oldPlaceholdersRemoved);
            if (changeCount > 0) {
                callback.onChanged(this.getSize() - drop.getPlaceholdersRemaining(), changeCount);
            }
            callback.onStateUpdate(LoadType.APPEND, false, LoadState.NotLoading.Companion.getIncomplete$paging_common());
        }
    }

    public PagePresenter(@NotNull PageEvent.Insert<T> insertEvent) {
        Intrinsics.checkParameterIsNotNull(insertEvent, (String)"insertEvent");
        this.pages = CollectionsKt.toMutableList((Collection)insertEvent.getPages());
        this.storageCount = this.fullCount(insertEvent.getPages());
        this.placeholdersBefore = insertEvent.getPlaceholdersBefore();
        this.placeholdersAfter = insertEvent.getPlaceholdersAfter();
    }

    static {
        Companion = new Companion(null);
        INITIAL = new PagePresenter<Object>(PageEvent.Insert.Companion.getEMPTY_REFRESH_LOCAL());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J \u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&\u00a8\u0006\u0010"}, d2={"Landroidx/paging/PagePresenter$ProcessPageEventCallback;", "", "onChanged", "", "position", "", "count", "onInserted", "onRemoved", "onStateUpdate", "loadType", "Landroidx/paging/LoadType;", "fromMediator", "", "loadState", "Landroidx/paging/LoadState;", "paging-common"})
    public static interface ProcessPageEventCallback {
        public void onChanged(int var1, int var2);

        public void onInserted(int var1, int var2);

        public void onRemoved(int var1, int var2);

        public void onStateUpdate(@NotNull LoadType var1, boolean var2, @NotNull LoadState var3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0004\"\b\b\u0001\u0010\u0006*\u00020\u0001H\u0000\u00a2\u0006\u0002\b\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/paging/PagePresenter$Companion;", "", "()V", "INITIAL", "Landroidx/paging/PagePresenter;", "initial", "T", "initial$paging_common", "paging-common"})
    public static final class Companion {
        @NotNull
        public final <T> PagePresenter<T> initial$paging_common() {
            PagePresenter pagePresenter = INITIAL;
            if (pagePresenter == null) {
                throw new TypeCastException("null cannot be cast to non-null type androidx.paging.PagePresenter<T>");
            }
            return pagePresenter;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

