/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.AnyThread;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.paging.ContiguousDataSource;
import androidx.paging.ContiguousPagedList;
import androidx.paging.DataSource;
import androidx.paging.PagedStorage;
import androidx.paging.PositionalDataSource;
import androidx.paging.SnapshotPagedList;
import androidx.paging.TiledPagedList;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class PagedList<T>
extends AbstractList<T> {
    @NonNull
    final Executor mMainThreadExecutor;
    @NonNull
    final Executor mBackgroundThreadExecutor;
    @Nullable
    final BoundaryCallback<T> mBoundaryCallback;
    @NonNull
    final Config mConfig;
    @NonNull
    final PagedStorage<T> mStorage;
    int mLastLoad = 0;
    T mLastItem = null;
    final int mRequiredRemainder;
    boolean mBoundaryCallbackBeginDeferred = false;
    boolean mBoundaryCallbackEndDeferred = false;
    private int mLowestIndexAccessed = Integer.MAX_VALUE;
    private int mHighestIndexAccessed = Integer.MIN_VALUE;
    private final AtomicBoolean mDetached = new AtomicBoolean(false);
    private final ArrayList<WeakReference<Callback>> mCallbacks = new ArrayList();
    final ArrayList<WeakReference<LoadStateListener>> mListeners = new ArrayList();
    final LoadStateManager mLoadStateManager = new LoadStateManager(){

        @Override
        protected void onStateChanged(final @NonNull LoadType type, final @NonNull LoadState state, final @Nullable Throwable error) {
            PagedList.this.mMainThreadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    for (int i = PagedList.this.mListeners.size() - 1; i >= 0; --i) {
                        LoadStateListener currentListener = (LoadStateListener)PagedList.this.mListeners.get(i).get();
                        if (currentListener == null) {
                            PagedList.this.mListeners.remove(i);
                            continue;
                        }
                        currentListener.onLoadStateChanged(type, state, error);
                    }
                }
            });
        }
    };

    static boolean equalsHelper(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }

    public void retry() {
    }

    PagedList(@NonNull PagedStorage<T> storage, @NonNull Executor mainThreadExecutor, @NonNull Executor backgroundThreadExecutor, @Nullable BoundaryCallback<T> boundaryCallback, @NonNull Config config) {
        this.mStorage = storage;
        this.mMainThreadExecutor = mainThreadExecutor;
        this.mBackgroundThreadExecutor = backgroundThreadExecutor;
        this.mBoundaryCallback = boundaryCallback;
        this.mConfig = config;
        this.mRequiredRemainder = this.mConfig.prefetchDistance * 2 + this.mConfig.pageSize;
    }

    @NonNull
    static <K, T> PagedList<T> create(@NonNull DataSource<K, T> dataSource, @NonNull Executor notifyExecutor, @NonNull Executor fetchExecutor, @Nullable BoundaryCallback<T> boundaryCallback, @NonNull Config config, @Nullable K key) {
        if (dataSource.isContiguous() || !config.enablePlaceholders) {
            int lastLoad = -1;
            if (!dataSource.isContiguous()) {
                dataSource = ((PositionalDataSource)dataSource).wrapAsContiguousWithoutPlaceholders();
                if (key != null) {
                    lastLoad = (Integer)key;
                }
            }
            ContiguousDataSource contigDataSource = (ContiguousDataSource)dataSource;
            return new ContiguousPagedList<K, T>(contigDataSource, notifyExecutor, fetchExecutor, boundaryCallback, config, key, lastLoad);
        }
        return new TiledPagedList<T>((PositionalDataSource)dataSource, notifyExecutor, fetchExecutor, boundaryCallback, config, key != null ? (Integer)key : 0);
    }

    @Override
    @Nullable
    public T get(int index) {
        T item = this.mStorage.get(index);
        if (item != null) {
            this.mLastItem = item;
        }
        return item;
    }

    public void loadAround(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        this.mLastLoad = index + this.getPositionOffset();
        this.loadAroundInternal(index);
        this.mLowestIndexAccessed = Math.min(this.mLowestIndexAccessed, index);
        this.mHighestIndexAccessed = Math.max(this.mHighestIndexAccessed, index);
        this.tryDispatchBoundaryCallbacks(true);
    }

    @AnyThread
    void deferBoundaryCallbacks(final boolean deferEmpty, final boolean deferBegin, final boolean deferEnd) {
        if (this.mBoundaryCallback == null) {
            throw new IllegalStateException("Can't defer BoundaryCallback, no instance");
        }
        if (this.mLowestIndexAccessed == Integer.MAX_VALUE) {
            this.mLowestIndexAccessed = this.mStorage.size();
        }
        if (this.mHighestIndexAccessed == Integer.MIN_VALUE) {
            this.mHighestIndexAccessed = 0;
        }
        if (deferEmpty || deferBegin || deferEnd) {
            this.mMainThreadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (deferEmpty) {
                        PagedList.this.mBoundaryCallback.onZeroItemsLoaded();
                    }
                    if (deferBegin) {
                        PagedList.this.mBoundaryCallbackBeginDeferred = true;
                    }
                    if (deferEnd) {
                        PagedList.this.mBoundaryCallbackEndDeferred = true;
                    }
                    PagedList.this.tryDispatchBoundaryCallbacks(false);
                }
            });
        }
    }

    void tryDispatchBoundaryCallbacks(boolean post) {
        boolean dispatchEnd;
        final boolean dispatchBegin = this.mBoundaryCallbackBeginDeferred && this.mLowestIndexAccessed <= this.mConfig.prefetchDistance;
        boolean bl = dispatchEnd = this.mBoundaryCallbackEndDeferred && this.mHighestIndexAccessed >= this.size() - 1 - this.mConfig.prefetchDistance;
        if (!dispatchBegin && !dispatchEnd) {
            return;
        }
        if (dispatchBegin) {
            this.mBoundaryCallbackBeginDeferred = false;
        }
        if (dispatchEnd) {
            this.mBoundaryCallbackEndDeferred = false;
        }
        if (post) {
            this.mMainThreadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    PagedList.this.dispatchBoundaryCallbacks(dispatchBegin, dispatchEnd);
                }
            });
        } else {
            this.dispatchBoundaryCallbacks(dispatchBegin, dispatchEnd);
        }
    }

    void dispatchBoundaryCallbacks(boolean begin, boolean end) {
        if (begin) {
            this.mBoundaryCallback.onItemAtFrontLoaded(this.mStorage.getFirstLoadedItem());
        }
        if (end) {
            this.mBoundaryCallback.onItemAtEndLoaded(this.mStorage.getLastLoadedItem());
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    void offsetAccessIndices(int offset) {
        this.mLastLoad += offset;
        this.mLowestIndexAccessed += offset;
        this.mHighestIndexAccessed += offset;
    }

    @Override
    public int size() {
        return this.mStorage.size();
    }

    public int getLoadedCount() {
        return this.mStorage.getLoadedCount();
    }

    public boolean isImmutable() {
        return this.isDetached();
    }

    @NonNull
    public List<T> snapshot() {
        if (this.isImmutable()) {
            return this;
        }
        return new SnapshotPagedList(this);
    }

    abstract boolean isContiguous();

    @NonNull
    public Config getConfig() {
        return this.mConfig;
    }

    @NonNull
    public abstract DataSource<?, T> getDataSource();

    @Nullable
    public abstract Object getLastKey();

    public boolean isDetached() {
        return this.mDetached.get();
    }

    public void detach() {
        this.mDetached.set(true);
    }

    public int getPositionOffset() {
        return this.mStorage.getPositionOffset();
    }

    public void addWeakLoadStateListener(@NonNull LoadStateListener listener) {
        for (int i = this.mListeners.size() - 1; i >= 0; --i) {
            LoadStateListener currentListener = (LoadStateListener)this.mListeners.get(i).get();
            if (currentListener != null) continue;
            this.mListeners.remove(i);
        }
        this.mListeners.add(new WeakReference<LoadStateListener>(listener));
        listener.onLoadStateChanged(LoadType.REFRESH, this.mLoadStateManager.getRefresh(), this.mLoadStateManager.getRefreshError());
        listener.onLoadStateChanged(LoadType.START, this.mLoadStateManager.getStart(), this.mLoadStateManager.getStartError());
        listener.onLoadStateChanged(LoadType.END, this.mLoadStateManager.getEnd(), this.mLoadStateManager.getEndError());
    }

    public void removeWeakLoadStateListener(@NonNull LoadStateListener listener) {
        for (int i = this.mListeners.size() - 1; i >= 0; --i) {
            LoadStateListener currentListener = (LoadStateListener)this.mListeners.get(i).get();
            if (currentListener != null && currentListener != listener) continue;
            this.mListeners.remove(i);
        }
    }

    public void addWeakCallback(@Nullable List<T> previousSnapshot, @NonNull Callback callback) {
        if (previousSnapshot != null && previousSnapshot != this) {
            if (previousSnapshot.isEmpty()) {
                if (!this.mStorage.isEmpty()) {
                    callback.onInserted(0, this.mStorage.size());
                }
            } else {
                PagedList storageSnapshot = (PagedList)previousSnapshot;
                this.dispatchUpdatesSinceSnapshot(storageSnapshot, callback);
            }
        }
        for (int i = this.mCallbacks.size() - 1; i >= 0; --i) {
            Callback currentCallback = (Callback)this.mCallbacks.get(i).get();
            if (currentCallback != null) continue;
            this.mCallbacks.remove(i);
        }
        this.mCallbacks.add(new WeakReference<Callback>(callback));
    }

    public void removeWeakCallback(@NonNull Callback callback) {
        for (int i = this.mCallbacks.size() - 1; i >= 0; --i) {
            Callback currentCallback = (Callback)this.mCallbacks.get(i).get();
            if (currentCallback != null && currentCallback != callback) continue;
            this.mCallbacks.remove(i);
        }
    }

    void notifyInserted(int position, int count) {
        if (count != 0) {
            for (int i = this.mCallbacks.size() - 1; i >= 0; --i) {
                Callback callback = (Callback)this.mCallbacks.get(i).get();
                if (callback == null) continue;
                callback.onInserted(position, count);
            }
        }
    }

    void notifyChanged(int position, int count) {
        if (count != 0) {
            for (int i = this.mCallbacks.size() - 1; i >= 0; --i) {
                Callback callback = (Callback)this.mCallbacks.get(i).get();
                if (callback == null) continue;
                callback.onChanged(position, count);
            }
        }
    }

    void notifyRemoved(int position, int count) {
        if (count != 0) {
            for (int i = this.mCallbacks.size() - 1; i >= 0; --i) {
                Callback callback = (Callback)this.mCallbacks.get(i).get();
                if (callback == null) continue;
                callback.onRemoved(position, count);
            }
        }
    }

    abstract void dispatchUpdatesSinceSnapshot(@NonNull PagedList<T> var1, @NonNull Callback var2);

    abstract void loadAroundInternal(int var1);

    @MainThread
    public static abstract class BoundaryCallback<T> {
        public void onZeroItemsLoaded() {
        }

        public void onItemAtFrontLoaded(@NonNull T itemAtFront) {
        }

        public void onItemAtEndLoaded(@NonNull T itemAtEnd) {
        }
    }

    public static class Config {
        public static final int MAX_SIZE_UNBOUNDED = Integer.MAX_VALUE;
        public final int pageSize;
        public final int prefetchDistance;
        public final boolean enablePlaceholders;
        public final int maxSize;
        public final int initialLoadSizeHint;

        Config(int pageSize, int prefetchDistance, boolean enablePlaceholders, int initialLoadSizeHint, int maxSize) {
            this.pageSize = pageSize;
            this.prefetchDistance = prefetchDistance;
            this.enablePlaceholders = enablePlaceholders;
            this.initialLoadSizeHint = initialLoadSizeHint;
            this.maxSize = maxSize;
        }

        public static final class Builder {
            static final int DEFAULT_INITIAL_PAGE_MULTIPLIER = 3;
            private int mPageSize = -1;
            private int mPrefetchDistance = -1;
            private int mInitialLoadSizeHint = -1;
            private boolean mEnablePlaceholders = true;
            private int mMaxSize = Integer.MAX_VALUE;

            @NonNull
            public Builder setPageSize(@IntRange(from=1L) int pageSize) {
                if (pageSize < 1) {
                    throw new IllegalArgumentException("Page size must be a positive number");
                }
                this.mPageSize = pageSize;
                return this;
            }

            @NonNull
            public Builder setPrefetchDistance(@IntRange(from=0L) int prefetchDistance) {
                this.mPrefetchDistance = prefetchDistance;
                return this;
            }

            @NonNull
            public Builder setEnablePlaceholders(boolean enablePlaceholders) {
                this.mEnablePlaceholders = enablePlaceholders;
                return this;
            }

            @NonNull
            public Builder setInitialLoadSizeHint(@IntRange(from=1L) int initialLoadSizeHint) {
                this.mInitialLoadSizeHint = initialLoadSizeHint;
                return this;
            }

            @NonNull
            public Builder setMaxSize(@IntRange(from=2L) int maxSize) {
                this.mMaxSize = maxSize;
                return this;
            }

            @NonNull
            public Config build() {
                if (this.mPrefetchDistance < 0) {
                    this.mPrefetchDistance = this.mPageSize;
                }
                if (this.mInitialLoadSizeHint < 0) {
                    this.mInitialLoadSizeHint = this.mPageSize * 3;
                }
                if (!this.mEnablePlaceholders && this.mPrefetchDistance == 0) {
                    throw new IllegalArgumentException("Placeholders and prefetch are the only ways to trigger loading of more data in the PagedList, so either placeholders must be enabled, or prefetch distance must be > 0.");
                }
                if (this.mMaxSize != Integer.MAX_VALUE && this.mMaxSize < this.mPageSize + this.mPrefetchDistance * 2) {
                    throw new IllegalArgumentException("Maximum size must be at least pageSize + 2*prefetchDist, pageSize=" + this.mPageSize + ", prefetchDist=" + this.mPrefetchDistance + ", maxSize=" + this.mMaxSize);
                }
                return new Config(this.mPageSize, this.mPrefetchDistance, this.mEnablePlaceholders, this.mInitialLoadSizeHint, this.mMaxSize);
            }
        }
    }

    public static abstract class Callback {
        public abstract void onChanged(int var1, int var2);

        public abstract void onInserted(int var1, int var2);

        public abstract void onRemoved(int var1, int var2);
    }

    public static final class Builder<Key, Value> {
        private final DataSource<Key, Value> mDataSource;
        private final Config mConfig;
        private Executor mNotifyExecutor;
        private Executor mFetchExecutor;
        private BoundaryCallback mBoundaryCallback;
        private Key mInitialKey;

        public Builder(@NonNull DataSource<Key, Value> dataSource, @NonNull Config config) {
            if (dataSource == null) {
                throw new IllegalArgumentException("DataSource may not be null");
            }
            if (config == null) {
                throw new IllegalArgumentException("Config may not be null");
            }
            this.mDataSource = dataSource;
            this.mConfig = config;
        }

        public Builder(@NonNull DataSource<Key, Value> dataSource, int pageSize) {
            this(dataSource, new Config.Builder().setPageSize(pageSize).build());
        }

        @NonNull
        public Builder<Key, Value> setNotifyExecutor(@NonNull Executor notifyExecutor) {
            this.mNotifyExecutor = notifyExecutor;
            return this;
        }

        @NonNull
        public Builder<Key, Value> setFetchExecutor(@NonNull Executor fetchExecutor) {
            this.mFetchExecutor = fetchExecutor;
            return this;
        }

        @NonNull
        public Builder<Key, Value> setBoundaryCallback(@Nullable BoundaryCallback boundaryCallback) {
            this.mBoundaryCallback = boundaryCallback;
            return this;
        }

        @NonNull
        public Builder<Key, Value> setInitialKey(@Nullable Key initialKey) {
            this.mInitialKey = initialKey;
            return this;
        }

        @WorkerThread
        @NonNull
        public PagedList<Value> build() {
            if (this.mNotifyExecutor == null) {
                throw new IllegalArgumentException("MainThreadExecutor required");
            }
            if (this.mFetchExecutor == null) {
                throw new IllegalArgumentException("BackgroundThreadExecutor required");
            }
            return PagedList.create(this.mDataSource, this.mNotifyExecutor, this.mFetchExecutor, this.mBoundaryCallback, this.mConfig, this.mInitialKey);
        }
    }

    static abstract class LoadStateManager {
        @NonNull
        private LoadState mRefresh = LoadState.IDLE;
        @Nullable
        private Throwable mRefreshError = null;
        @NonNull
        private LoadState mStart = LoadState.IDLE;
        @Nullable
        private Throwable mStartError = null;
        @NonNull
        private LoadState mEnd = LoadState.IDLE;
        @Nullable
        private Throwable mEndError = null;

        LoadStateManager() {
        }

        @NonNull
        public LoadState getRefresh() {
            return this.mRefresh;
        }

        @NonNull
        public LoadState getStart() {
            return this.mStart;
        }

        @NonNull
        public LoadState getEnd() {
            return this.mEnd;
        }

        @Nullable
        public Throwable getRefreshError() {
            return this.mRefreshError;
        }

        @Nullable
        public Throwable getStartError() {
            return this.mStartError;
        }

        @Nullable
        public Throwable getEndError() {
            return this.mEndError;
        }

        void setState(@NonNull LoadType type, @NonNull LoadState state, @Nullable Throwable error) {
            boolean hasError;
            boolean expectError = state == LoadState.RETRYABLE_ERROR || state == LoadState.ERROR;
            boolean bl = hasError = error != null;
            if (expectError != hasError) {
                throw new IllegalArgumentException("Error states must be accompanied by a throwable, other states must not");
            }
            switch (type) {
                case REFRESH: {
                    if (this.mRefresh.equals((Object)state) && PagedList.equalsHelper(this.mRefreshError, error)) {
                        return;
                    }
                    this.mRefresh = state;
                    this.mRefreshError = error;
                    break;
                }
                case START: {
                    if (this.mStart.equals((Object)state) && PagedList.equalsHelper(this.mStartError, error)) {
                        return;
                    }
                    this.mStart = state;
                    this.mStartError = error;
                    break;
                }
                case END: {
                    if (this.mEnd.equals((Object)state) && PagedList.equalsHelper(this.mEndError, error)) {
                        return;
                    }
                    this.mEnd = state;
                    this.mEndError = error;
                }
            }
            this.onStateChanged(type, state, error);
        }

        protected abstract void onStateChanged(@NonNull LoadType var1, @NonNull LoadState var2, @Nullable Throwable var3);
    }

    public static interface LoadStateListener {
        public void onLoadStateChanged(@NonNull LoadType var1, @NonNull LoadState var2, @Nullable Throwable var3);
    }

    public static enum LoadState {
        IDLE,
        LOADING,
        DONE,
        ERROR,
        RETRYABLE_ERROR;

    }

    public static enum LoadType {
        REFRESH,
        START,
        END;

    }
}

