/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.util.Function;
import androidx.paging.ContiguousDataSource;
import androidx.paging.DataSource;
import androidx.paging.PageResult;
import androidx.paging.WrapperItemKeyedDataSource;
import java.util.List;
import java.util.concurrent.Executor;

public abstract class ItemKeyedDataSource<Key, Value>
extends ContiguousDataSource<Key, Value> {
    @Override
    @Nullable
    final Key getKey(int position, Value item) {
        if (item == null) {
            return null;
        }
        return this.getKey(item);
    }

    @Override
    final void dispatchLoadInitial(@Nullable Key key, int initialLoadSize, int pageSize, boolean enablePlaceholders, @NonNull Executor mainThreadExecutor, @NonNull PageResult.Receiver<Value> receiver) {
        LoadInitialCallbackImpl<Value> callback = new LoadInitialCallbackImpl<Value>(this, enablePlaceholders, receiver);
        this.loadInitial(new LoadInitialParams<Key>(key, initialLoadSize, enablePlaceholders), callback);
        callback.mCallbackHelper.setPostExecutor(mainThreadExecutor);
    }

    @Override
    final void dispatchLoadAfter(int currentEndIndex, @NonNull Value currentEndItem, int pageSize, @NonNull Executor mainThreadExecutor, @NonNull PageResult.Receiver<Value> receiver) {
        this.loadAfter(new LoadParams<Key>(this.getKey(currentEndItem), pageSize), new LoadCallbackImpl<Value>(this, 1, mainThreadExecutor, receiver));
    }

    @Override
    final void dispatchLoadBefore(int currentBeginIndex, @NonNull Value currentBeginItem, int pageSize, @NonNull Executor mainThreadExecutor, @NonNull PageResult.Receiver<Value> receiver) {
        this.loadBefore(new LoadParams<Key>(this.getKey(currentBeginItem), pageSize), new LoadCallbackImpl<Value>(this, 2, mainThreadExecutor, receiver));
    }

    public abstract void loadInitial(@NonNull LoadInitialParams<Key> var1, @NonNull LoadInitialCallback<Value> var2);

    public abstract void loadAfter(@NonNull LoadParams<Key> var1, @NonNull LoadCallback<Value> var2);

    public abstract void loadBefore(@NonNull LoadParams<Key> var1, @NonNull LoadCallback<Value> var2);

    @NonNull
    public abstract Key getKey(@NonNull Value var1);

    @Override
    @NonNull
    public final <ToValue> ItemKeyedDataSource<Key, ToValue> mapByPage(@NonNull Function<List<Value>, List<ToValue>> function) {
        return new WrapperItemKeyedDataSource(this, function);
    }

    @Override
    @NonNull
    public final <ToValue> ItemKeyedDataSource<Key, ToValue> map(@NonNull Function<Value, ToValue> function) {
        return this.mapByPage((Function)ItemKeyedDataSource.createListFunction(function));
    }

    static class LoadCallbackImpl<Value>
    extends LoadCallback<Value> {
        final DataSource.LoadCallbackHelper<Value> mCallbackHelper;

        LoadCallbackImpl(@NonNull ItemKeyedDataSource dataSource, int type, @Nullable Executor mainThreadExecutor, @NonNull PageResult.Receiver<Value> receiver) {
            this.mCallbackHelper = new DataSource.LoadCallbackHelper<Value>(dataSource, type, mainThreadExecutor, receiver);
        }

        @Override
        public void onResult(@NonNull List<Value> data) {
            if (!this.mCallbackHelper.dispatchInvalidResultIfInvalid()) {
                this.mCallbackHelper.dispatchResultToReceiver(new PageResult<Value>(data, 0, 0, 0));
            }
        }
    }

    static class LoadInitialCallbackImpl<Value>
    extends LoadInitialCallback<Value> {
        final DataSource.LoadCallbackHelper<Value> mCallbackHelper;
        private final boolean mCountingEnabled;

        LoadInitialCallbackImpl(@NonNull ItemKeyedDataSource dataSource, boolean countingEnabled, @NonNull PageResult.Receiver<Value> receiver) {
            this.mCallbackHelper = new DataSource.LoadCallbackHelper<Value>(dataSource, 0, null, receiver);
            this.mCountingEnabled = countingEnabled;
        }

        @Override
        public void onResult(@NonNull List<Value> data, int position, int totalCount) {
            if (!this.mCallbackHelper.dispatchInvalidResultIfInvalid()) {
                DataSource.LoadCallbackHelper.validateInitialLoadParams(data, position, totalCount);
                int trailingUnloadedCount = totalCount - position - data.size();
                if (this.mCountingEnabled) {
                    this.mCallbackHelper.dispatchResultToReceiver(new PageResult<Value>(data, position, trailingUnloadedCount, 0));
                } else {
                    this.mCallbackHelper.dispatchResultToReceiver(new PageResult<Value>(data, position));
                }
            }
        }

        @Override
        public void onResult(@NonNull List<Value> data) {
            if (!this.mCallbackHelper.dispatchInvalidResultIfInvalid()) {
                this.mCallbackHelper.dispatchResultToReceiver(new PageResult<Value>(data, 0, 0, 0));
            }
        }
    }

    public static abstract class LoadCallback<Value> {
        public abstract void onResult(@NonNull List<Value> var1);
    }

    public static abstract class LoadInitialCallback<Value>
    extends LoadCallback<Value> {
        public abstract void onResult(@NonNull List<Value> var1, int var2, int var3);
    }

    public static class LoadParams<Key> {
        public final Key key;
        public final int requestedLoadSize;

        public LoadParams(Key key, int requestedLoadSize) {
            this.key = key;
            this.requestedLoadSize = requestedLoadSize;
        }
    }

    public static class LoadInitialParams<Key> {
        @Nullable
        public final Key requestedInitialKey;
        public final int requestedLoadSize;
        public final boolean placeholdersEnabled;

        public LoadInitialParams(@Nullable Key requestedInitialKey, int requestedLoadSize, boolean placeholdersEnabled) {
            this.requestedInitialKey = requestedInitialKey;
            this.requestedLoadSize = requestedLoadSize;
            this.placeholdersEnabled = placeholdersEnabled;
        }
    }
}

