/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.arch.core.util.Function;
import androidx.paging.PageResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class DataSource<Key, Value> {
    private AtomicBoolean mInvalid = new AtomicBoolean(false);
    private CopyOnWriteArrayList<InvalidatedCallback> mOnInvalidatedCallbacks = new CopyOnWriteArrayList();

    @NonNull
    static <X, Y> Function<List<X>, List<Y>> createListFunction(final @NonNull Function<X, Y> innerFunc) {
        return new Function<List<X>, List<Y>>(){

            public List<Y> apply(@NonNull List<X> source) {
                ArrayList<Object> out = new ArrayList<Object>(source.size());
                for (int i = 0; i < source.size(); ++i) {
                    out.add(innerFunc.apply(source.get(i)));
                }
                return out;
            }
        };
    }

    static <A, B> List<B> convert(Function<List<A>, List<B>> function, List<A> source) {
        List dest = (List)function.apply(source);
        if (dest.size() != source.size()) {
            throw new IllegalStateException("Invalid Function " + function + " changed return size. This is not supported.");
        }
        return dest;
    }

    DataSource() {
    }

    @NonNull
    public abstract <ToValue> DataSource<Key, ToValue> mapByPage(@NonNull Function<List<Value>, List<ToValue>> var1);

    @NonNull
    public abstract <ToValue> DataSource<Key, ToValue> map(@NonNull Function<Value, ToValue> var1);

    abstract boolean isContiguous();

    @AnyThread
    public void addInvalidatedCallback(@NonNull InvalidatedCallback onInvalidatedCallback) {
        this.mOnInvalidatedCallbacks.add(onInvalidatedCallback);
    }

    @AnyThread
    public void removeInvalidatedCallback(@NonNull InvalidatedCallback onInvalidatedCallback) {
        this.mOnInvalidatedCallbacks.remove(onInvalidatedCallback);
    }

    @AnyThread
    public void invalidate() {
        if (this.mInvalid.compareAndSet(false, true)) {
            for (InvalidatedCallback callback : this.mOnInvalidatedCallbacks) {
                callback.onInvalidated();
            }
        }
    }

    @WorkerThread
    public boolean isInvalid() {
        return this.mInvalid.get();
    }

    public static interface InvalidatedCallback {
        @AnyThread
        public void onInvalidated();
    }

    static class LoadCallbackHelper<T> {
        final int mResultType;
        private final DataSource mDataSource;
        private final PageResult.Receiver<T> mReceiver;
        private final Object mSignalLock = new Object();
        private Executor mPostExecutor = null;
        private boolean mHasSignalled = false;

        static void validateInitialLoadParams(@NonNull List<?> data, int position, int totalCount) {
            if (position < 0) {
                throw new IllegalArgumentException("Position must be non-negative");
            }
            if (data.size() + position > totalCount) {
                throw new IllegalArgumentException("List size + position too large, last item in list beyond totalCount.");
            }
            if (data.size() == 0 && totalCount > 0) {
                throw new IllegalArgumentException("Initial result cannot be empty if items are present in data set.");
            }
        }

        LoadCallbackHelper(@NonNull DataSource dataSource, int resultType, @Nullable Executor mainThreadExecutor, @NonNull PageResult.Receiver<T> receiver) {
            this.mDataSource = dataSource;
            this.mResultType = resultType;
            this.mPostExecutor = mainThreadExecutor;
            this.mReceiver = receiver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setPostExecutor(Executor postExecutor) {
            Object object = this.mSignalLock;
            synchronized (object) {
                this.mPostExecutor = postExecutor;
            }
        }

        boolean dispatchInvalidResultIfInvalid() {
            if (this.mDataSource.isInvalid()) {
                this.dispatchResultToReceiver(PageResult.getInvalidResult());
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatchResultToReceiver(final @NonNull PageResult<T> result) {
            Executor executor;
            Object object = this.mSignalLock;
            synchronized (object) {
                if (this.mHasSignalled) {
                    throw new IllegalStateException("callback.onResult already called, cannot call again.");
                }
                this.mHasSignalled = true;
                executor = this.mPostExecutor;
            }
            if (executor != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        LoadCallbackHelper.this.mReceiver.onPageResult(LoadCallbackHelper.this.mResultType, result);
                    }
                });
            } else {
                this.mReceiver.onPageResult(this.mResultType, result);
            }
        }
    }

    public static abstract class Factory<Key, Value> {
        public abstract DataSource<Key, Value> create();

        @NonNull
        public <ToValue> Factory<Key, ToValue> map(@NonNull Function<Value, ToValue> function) {
            return this.mapByPage(DataSource.createListFunction(function));
        }

        @NonNull
        public <ToValue> Factory<Key, ToValue> mapByPage(final @NonNull Function<List<Value>, List<ToValue>> function) {
            return new Factory<Key, ToValue>(){

                @Override
                public DataSource<Key, ToValue> create() {
                    return Factory.this.create().mapByPage(function);
                }
            };
        }
    }
}

