/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.ui;

import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.customview.widget.Openable;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavOptions;
import androidx.navigation.ui.ActionBarOnDestinationChangedListener;
import androidx.navigation.ui.AppBarConfiguration;
import androidx.navigation.ui.CollapsingToolbarOnDestinationChangedListener;
import androidx.navigation.ui.R;
import androidx.navigation.ui.ToolbarOnDestinationChangedListener;
import com.google.android.material.appbar.CollapsingToolbarLayout;
import com.google.android.material.bottomnavigation.BottomNavigationView;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.navigation.NavigationView;
import java.lang.ref.WeakReference;
import java.util.Set;

public final class NavigationUI {
    private NavigationUI() {
    }

    public static boolean onNavDestinationSelected(@NonNull MenuItem item, @NonNull NavController navController) {
        NavOptions.Builder builder = new NavOptions.Builder().setLaunchSingleTop(true).setEnterAnim(R.anim.nav_default_enter_anim).setExitAnim(R.anim.nav_default_exit_anim).setPopEnterAnim(R.anim.nav_default_pop_enter_anim).setPopExitAnim(R.anim.nav_default_pop_exit_anim);
        if ((item.getOrder() & 0x30000) == 0) {
            builder.setPopUpTo(NavigationUI.findStartDestination(navController.getGraph()).getId(), false);
        }
        NavOptions options = builder.build();
        try {
            navController.navigate(item.getItemId(), null, options);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean navigateUp(@NonNull NavController navController, @Nullable Openable openableLayout) {
        return NavigationUI.navigateUp(navController, new AppBarConfiguration.Builder(navController.getGraph()).setOpenableLayout(openableLayout).build());
    }

    public static boolean navigateUp(@NonNull NavController navController, @NonNull AppBarConfiguration configuration) {
        Openable openableLayout = configuration.getOpenableLayout();
        NavDestination currentDestination = navController.getCurrentDestination();
        Set<Integer> topLevelDestinations = configuration.getTopLevelDestinations();
        if (openableLayout != null && currentDestination != null && NavigationUI.matchDestinations(currentDestination, topLevelDestinations)) {
            openableLayout.open();
            return true;
        }
        if (navController.navigateUp()) {
            return true;
        }
        if (configuration.getFallbackOnNavigateUpListener() != null) {
            return configuration.getFallbackOnNavigateUpListener().onNavigateUp();
        }
        return false;
    }

    public static void setupActionBarWithNavController(@NonNull AppCompatActivity activity, @NonNull NavController navController) {
        NavigationUI.setupActionBarWithNavController(activity, navController, new AppBarConfiguration.Builder(navController.getGraph()).build());
    }

    public static void setupActionBarWithNavController(@NonNull AppCompatActivity activity, @NonNull NavController navController, @Nullable Openable openableLayout) {
        NavigationUI.setupActionBarWithNavController(activity, navController, new AppBarConfiguration.Builder(navController.getGraph()).setOpenableLayout(openableLayout).build());
    }

    public static void setupActionBarWithNavController(@NonNull AppCompatActivity activity, @NonNull NavController navController, @NonNull AppBarConfiguration configuration) {
        navController.addOnDestinationChangedListener((NavController.OnDestinationChangedListener)new ActionBarOnDestinationChangedListener(activity, configuration));
    }

    public static void setupWithNavController(@NonNull Toolbar toolbar, @NonNull NavController navController) {
        NavigationUI.setupWithNavController(toolbar, navController, new AppBarConfiguration.Builder(navController.getGraph()).build());
    }

    public static void setupWithNavController(@NonNull Toolbar toolbar, @NonNull NavController navController, @Nullable Openable openableLayout) {
        NavigationUI.setupWithNavController(toolbar, navController, new AppBarConfiguration.Builder(navController.getGraph()).setOpenableLayout(openableLayout).build());
    }

    public static void setupWithNavController(@NonNull Toolbar toolbar, final @NonNull NavController navController, final @NonNull AppBarConfiguration configuration) {
        navController.addOnDestinationChangedListener((NavController.OnDestinationChangedListener)new ToolbarOnDestinationChangedListener(toolbar, configuration));
        toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NavigationUI.navigateUp(navController, configuration);
            }
        });
    }

    public static void setupWithNavController(@NonNull CollapsingToolbarLayout collapsingToolbarLayout, @NonNull Toolbar toolbar, @NonNull NavController navController) {
        NavigationUI.setupWithNavController(collapsingToolbarLayout, toolbar, navController, new AppBarConfiguration.Builder(navController.getGraph()).build());
    }

    public static void setupWithNavController(@NonNull CollapsingToolbarLayout collapsingToolbarLayout, @NonNull Toolbar toolbar, @NonNull NavController navController, @Nullable Openable openableLayout) {
        NavigationUI.setupWithNavController(collapsingToolbarLayout, toolbar, navController, new AppBarConfiguration.Builder(navController.getGraph()).setOpenableLayout(openableLayout).build());
    }

    public static void setupWithNavController(@NonNull CollapsingToolbarLayout collapsingToolbarLayout, @NonNull Toolbar toolbar, final @NonNull NavController navController, final @NonNull AppBarConfiguration configuration) {
        navController.addOnDestinationChangedListener((NavController.OnDestinationChangedListener)new CollapsingToolbarOnDestinationChangedListener(collapsingToolbarLayout, toolbar, configuration));
        toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NavigationUI.navigateUp(navController, configuration);
            }
        });
    }

    public static void setupWithNavController(final @NonNull NavigationView navigationView, final @NonNull NavController navController) {
        navigationView.setNavigationItemSelectedListener(new NavigationView.OnNavigationItemSelectedListener(){

            public boolean onNavigationItemSelected(@NonNull MenuItem item) {
                boolean handled = NavigationUI.onNavDestinationSelected(item, navController);
                if (handled) {
                    ViewParent parent = navigationView.getParent();
                    if (parent instanceof Openable) {
                        ((Openable)parent).close();
                    } else {
                        BottomSheetBehavior bottomSheetBehavior = NavigationUI.findBottomSheetBehavior((View)navigationView);
                        if (bottomSheetBehavior != null) {
                            bottomSheetBehavior.setState(5);
                        }
                    }
                }
                return handled;
            }
        });
        final WeakReference<NavigationView> weakReference = new WeakReference<NavigationView>(navigationView);
        navController.addOnDestinationChangedListener(new NavController.OnDestinationChangedListener(){

            public void onDestinationChanged(@NonNull NavController controller, @NonNull NavDestination destination, @Nullable Bundle arguments) {
                NavigationView view = (NavigationView)weakReference.get();
                if (view == null) {
                    navController.removeOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
                    return;
                }
                Menu menu = view.getMenu();
                int size = menu.size();
                for (int h = 0; h < size; ++h) {
                    MenuItem item = menu.getItem(h);
                    item.setChecked(NavigationUI.matchDestination(destination, item.getItemId()));
                }
            }
        });
    }

    static BottomSheetBehavior findBottomSheetBehavior(@NonNull View view) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            ViewParent parent = view.getParent();
            if (parent instanceof View) {
                return NavigationUI.findBottomSheetBehavior((View)parent);
            }
            return null;
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        if (!(behavior instanceof BottomSheetBehavior)) {
            return null;
        }
        return (BottomSheetBehavior)behavior;
    }

    public static void setupWithNavController(@NonNull BottomNavigationView bottomNavigationView, final @NonNull NavController navController) {
        bottomNavigationView.setOnNavigationItemSelectedListener(new BottomNavigationView.OnNavigationItemSelectedListener(){

            public boolean onNavigationItemSelected(@NonNull MenuItem item) {
                return NavigationUI.onNavDestinationSelected(item, navController);
            }
        });
        final WeakReference<BottomNavigationView> weakReference = new WeakReference<BottomNavigationView>(bottomNavigationView);
        navController.addOnDestinationChangedListener(new NavController.OnDestinationChangedListener(){

            public void onDestinationChanged(@NonNull NavController controller, @NonNull NavDestination destination, @Nullable Bundle arguments) {
                BottomNavigationView view = (BottomNavigationView)weakReference.get();
                if (view == null) {
                    navController.removeOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
                    return;
                }
                Menu menu = view.getMenu();
                int size = menu.size();
                for (int h = 0; h < size; ++h) {
                    MenuItem item = menu.getItem(h);
                    if (!NavigationUI.matchDestination(destination, item.getItemId())) continue;
                    item.setChecked(true);
                }
            }
        });
    }

    static boolean matchDestination(@NonNull NavDestination destination, @IdRes int destId) {
        NavDestination currentDestination = destination;
        while (currentDestination.getId() != destId && currentDestination.getParent() != null) {
            currentDestination = currentDestination.getParent();
        }
        return currentDestination.getId() == destId;
    }

    static boolean matchDestinations(@NonNull NavDestination destination, @NonNull Set<Integer> destinationIds) {
        NavDestination currentDestination = destination;
        do {
            if (!destinationIds.contains(currentDestination.getId())) continue;
            return true;
        } while ((currentDestination = currentDestination.getParent()) != null);
        return false;
    }

    static NavDestination findStartDestination(@NonNull NavGraph graph) {
        NavGraph startDestination = graph;
        while (startDestination instanceof NavGraph) {
            NavGraph parent = startDestination;
            startDestination = parent.findNode(parent.getStartDestination());
        }
        return startDestination;
    }
}

