/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.ui;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.appcompat.graphics.drawable.DrawerArrowDrawable;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.navigation.FloatingWindow;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.ui.AppBarConfiguration;
import androidx.navigation.ui.NavigationUI;
import androidx.navigation.ui.R;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
abstract class AbstractAppBarOnDestinationChangedListener
implements NavController.OnDestinationChangedListener {
    private final Context mContext;
    private final Set<Integer> mTopLevelDestinations;
    @Nullable
    private final WeakReference<DrawerLayout> mDrawerLayoutWeakReference;
    private DrawerArrowDrawable mArrowDrawable;
    private ValueAnimator mAnimator;

    AbstractAppBarOnDestinationChangedListener(@NonNull Context context, @NonNull AppBarConfiguration configuration) {
        this.mContext = context;
        this.mTopLevelDestinations = configuration.getTopLevelDestinations();
        DrawerLayout drawerLayout = configuration.getDrawerLayout();
        this.mDrawerLayoutWeakReference = drawerLayout != null ? new WeakReference<DrawerLayout>(drawerLayout) : null;
    }

    protected abstract void setTitle(CharSequence var1);

    protected abstract void setNavigationIcon(Drawable var1, @StringRes int var2);

    public void onDestinationChanged(@NonNull NavController controller, @NonNull NavDestination destination, @Nullable Bundle arguments) {
        DrawerLayout drawerLayout;
        if (destination instanceof FloatingWindow) {
            return;
        }
        DrawerLayout drawerLayout2 = drawerLayout = this.mDrawerLayoutWeakReference != null ? (DrawerLayout)this.mDrawerLayoutWeakReference.get() : null;
        if (this.mDrawerLayoutWeakReference != null && drawerLayout == null) {
            controller.removeOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
            return;
        }
        CharSequence label = destination.getLabel();
        if (!TextUtils.isEmpty((CharSequence)label)) {
            StringBuffer title = new StringBuffer();
            Pattern fillInPattern = Pattern.compile("\\{(.+?)\\}");
            Matcher matcher = fillInPattern.matcher(label);
            while (matcher.find()) {
                String argName = matcher.group(1);
                if (arguments != null && arguments.containsKey(argName)) {
                    matcher.appendReplacement(title, "");
                    title.append(arguments.get(argName).toString());
                    continue;
                }
                throw new IllegalArgumentException("Could not find " + argName + " in " + arguments + " to fill label " + label);
            }
            matcher.appendTail(title);
            this.setTitle(title);
        }
        boolean isTopLevelDestination = NavigationUI.matchDestinations(destination, this.mTopLevelDestinations);
        if (drawerLayout == null && isTopLevelDestination) {
            this.setNavigationIcon(null, 0);
        } else {
            this.setActionBarUpIndicator(drawerLayout != null && isTopLevelDestination);
        }
    }

    private void setActionBarUpIndicator(boolean showAsDrawerIndicator) {
        float endValue;
        boolean animate = true;
        if (this.mArrowDrawable == null) {
            this.mArrowDrawable = new DrawerArrowDrawable(this.mContext);
            animate = false;
        }
        this.setNavigationIcon((Drawable)this.mArrowDrawable, showAsDrawerIndicator ? R.string.nav_app_bar_open_drawer_description : R.string.nav_app_bar_navigate_up_description);
        float f = endValue = showAsDrawerIndicator ? 0.0f : 1.0f;
        if (animate) {
            float startValue = this.mArrowDrawable.getProgress();
            if (this.mAnimator != null) {
                this.mAnimator.cancel();
            }
            this.mAnimator = ObjectAnimator.ofFloat((Object)this.mArrowDrawable, (String)"progress", (float[])new float[]{startValue, endValue});
            this.mAnimator.start();
        } else {
            this.mArrowDrawable.setProgress(endValue);
        }
    }
}

