/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.navigation.FloatingWindow;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.fragment.NavHostFragment;
import androidx.navigation.fragment.R;

@Navigator.Name(value="dialog")
public final class DialogFragmentNavigator
extends Navigator<Destination> {
    private static final String TAG = "DialogFragmentNavigator";
    private static final String KEY_DIALOG_COUNT = "androidx-nav-dialogfragment:navigator:count";
    private static final String DIALOG_TAG = "androidx-nav-fragment:navigator:dialog:";
    private final Context mContext;
    private final FragmentManager mFragmentManager;
    private int mDialogCount = 0;
    private LifecycleEventObserver mObserver = new LifecycleEventObserver(){

        public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
            DialogFragment dialogFragment;
            if (event == Lifecycle.Event.ON_STOP && !(dialogFragment = (DialogFragment)source).requireDialog().isShowing()) {
                NavHostFragment.findNavController((Fragment)dialogFragment).popBackStack();
            }
        }
    };

    public DialogFragmentNavigator(@NonNull Context context, @NonNull FragmentManager manager) {
        this.mContext = context;
        this.mFragmentManager = manager;
    }

    public boolean popBackStack() {
        if (this.mDialogCount == 0) {
            return false;
        }
        if (this.mFragmentManager.isStateSaved()) {
            Log.i((String)TAG, (String)"Ignoring popBackStack() call: FragmentManager has already saved its state");
            return false;
        }
        Fragment existingFragment = this.mFragmentManager.findFragmentByTag(DIALOG_TAG + --this.mDialogCount);
        if (existingFragment != null) {
            existingFragment.getLifecycle().removeObserver((LifecycleObserver)this.mObserver);
            ((DialogFragment)existingFragment).dismiss();
        }
        return true;
    }

    @NonNull
    public Destination createDestination() {
        return new Destination(this);
    }

    @Nullable
    public NavDestination navigate(@NonNull Destination destination, @Nullable Bundle args, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        Fragment frag;
        if (this.mFragmentManager.isStateSaved()) {
            Log.i((String)TAG, (String)"Ignoring navigate() call: FragmentManager has already saved its state");
            return null;
        }
        String className = destination.getClassName();
        if (className.charAt(0) == '.') {
            className = this.mContext.getPackageName() + className;
        }
        if (!DialogFragment.class.isAssignableFrom((frag = this.mFragmentManager.getFragmentFactory().instantiate(this.mContext.getClassLoader(), className)).getClass())) {
            throw new IllegalArgumentException("Dialog destination " + destination.getClassName() + " is not an instance of DialogFragment");
        }
        DialogFragment dialogFragment = (DialogFragment)frag;
        dialogFragment.setArguments(args);
        dialogFragment.getLifecycle().addObserver((LifecycleObserver)this.mObserver);
        dialogFragment.show(this.mFragmentManager, DIALOG_TAG + this.mDialogCount++);
        return destination;
    }

    @Nullable
    public Bundle onSaveState() {
        if (this.mDialogCount == 0) {
            return null;
        }
        Bundle b = new Bundle();
        b.putInt(KEY_DIALOG_COUNT, this.mDialogCount);
        return b;
    }

    public void onRestoreState(@Nullable Bundle savedState) {
        if (savedState != null) {
            this.mDialogCount = savedState.getInt(KEY_DIALOG_COUNT, 0);
            for (int index = 0; index < this.mDialogCount; ++index) {
                DialogFragment fragment = (DialogFragment)this.mFragmentManager.findFragmentByTag(DIALOG_TAG + index);
                if (fragment == null) {
                    throw new IllegalStateException("DialogFragment " + index + " doesn't exist in the FragmentManager");
                }
                fragment.getLifecycle().addObserver((LifecycleObserver)this.mObserver);
            }
        }
    }

    @NavDestination.ClassType(value=DialogFragment.class)
    public static class Destination
    extends NavDestination
    implements FloatingWindow {
        private String mClassName;

        public Destination(@NonNull NavigatorProvider navigatorProvider) {
            this((Navigator<? extends Destination>)navigatorProvider.getNavigator(DialogFragmentNavigator.class));
        }

        public Destination(@NonNull Navigator<? extends Destination> fragmentNavigator) {
            super(fragmentNavigator);
        }

        @CallSuper
        public void onInflate(@NonNull Context context, @NonNull AttributeSet attrs) {
            super.onInflate(context, attrs);
            TypedArray a = context.getResources().obtainAttributes(attrs, R.styleable.DialogFragmentNavigator);
            String className = a.getString(R.styleable.DialogFragmentNavigator_android_name);
            if (className != null) {
                this.setClassName(className);
            }
            a.recycle();
        }

        @NonNull
        public final Destination setClassName(@NonNull String className) {
            this.mClassName = className;
            return this;
        }

        @NonNull
        public final String getClassName() {
            if (this.mClassName == null) {
                throw new IllegalStateException("DialogFragment class was not set");
            }
            return this.mClassName;
        }
    }
}

