/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.navigation.NavArgument;
import androidx.navigation.NavDeepLinkRequest;
import androidx.navigation.NavType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NavDeepLink {
    private static final Pattern SCHEME_PATTERN = Pattern.compile("^[a-zA-Z]+[+\\w\\-.]*:");
    private final ArrayList<String> mArguments = new ArrayList();
    private final Map<String, ParamQuery> mParamArgMap = new HashMap<String, ParamQuery>();
    private Pattern mPattern = null;
    private boolean mExactDeepLink = false;
    private boolean mIsParameterizedQuery = false;
    private final String mUri;
    private final String mAction;
    private Pattern mMimeTypePattern = null;
    private final String mMimeType;

    NavDeepLink(@Nullable String uri, @Nullable String action, @Nullable String mimeType) {
        this.mUri = uri;
        this.mAction = action;
        this.mMimeType = mimeType;
        if (uri != null) {
            Uri parameterizedUri = Uri.parse((String)uri);
            this.mIsParameterizedQuery = parameterizedUri.getQuery() != null;
            StringBuilder uriRegex = new StringBuilder("^");
            if (!SCHEME_PATTERN.matcher(uri).find()) {
                uriRegex.append("http[s]?://");
            }
            Pattern fillInPattern = Pattern.compile("\\{(.+?)\\}");
            if (this.mIsParameterizedQuery) {
                Matcher matcher = Pattern.compile("(\\?)").matcher(uri);
                if (matcher.find()) {
                    this.buildPathRegex(uri.substring(0, matcher.start()), uriRegex, fillInPattern);
                }
                this.mExactDeepLink = false;
                for (String paramName : parameterizedUri.getQueryParameterNames()) {
                    StringBuilder argRegex = new StringBuilder();
                    String queryParam = parameterizedUri.getQueryParameter(paramName);
                    matcher = fillInPattern.matcher(queryParam);
                    int appendPos = 0;
                    ParamQuery param = new ParamQuery();
                    while (matcher.find()) {
                        param.addArgumentName(matcher.group(1));
                        argRegex.append(Pattern.quote(queryParam.substring(appendPos, matcher.start())));
                        argRegex.append("(.+?)?");
                        appendPos = matcher.end();
                    }
                    if (appendPos < queryParam.length()) {
                        argRegex.append(Pattern.quote(queryParam.substring(appendPos)));
                    }
                    param.setParamRegex(argRegex.toString().replace(".*", "\\E.*\\Q"));
                    this.mParamArgMap.put(paramName, param);
                }
            } else {
                this.mExactDeepLink = this.buildPathRegex(uri, uriRegex, fillInPattern);
            }
            String finalRegex = uriRegex.toString().replace(".*", "\\E.*\\Q");
            this.mPattern = Pattern.compile(finalRegex);
        }
        if (mimeType != null) {
            Pattern mimeTypePattern = Pattern.compile("^[\\s\\S]+/[\\s\\S]+$");
            Matcher mimeTypeMatcher = mimeTypePattern.matcher(mimeType);
            if (!mimeTypeMatcher.matches()) {
                throw new IllegalArgumentException("The given mimeType " + mimeType + " does not match to required \"type/subtype\" format");
            }
            MimeType splitMimeType = new MimeType(mimeType);
            String mimeTypeRegex = "^(" + splitMimeType.mType + "|[*]+)/(" + splitMimeType.mSubType + "|[*]+)$";
            String finalRegex = mimeTypeRegex.replace("*|[*]", "[\\s\\S]");
            this.mMimeTypePattern = Pattern.compile(finalRegex);
        }
    }

    NavDeepLink(@NonNull String uri) {
        this(uri, null, null);
    }

    private boolean buildPathRegex(@NonNull String uri, StringBuilder uriRegex, Pattern fillInPattern) {
        boolean exactDeepLink;
        Matcher matcher = fillInPattern.matcher(uri);
        int appendPos = 0;
        boolean bl = exactDeepLink = !uri.contains(".*");
        while (matcher.find()) {
            String argName = matcher.group(1);
            this.mArguments.add(argName);
            uriRegex.append(Pattern.quote(uri.substring(appendPos, matcher.start())));
            uriRegex.append("(.+?)");
            appendPos = matcher.end();
            exactDeepLink = false;
        }
        if (appendPos < uri.length()) {
            uriRegex.append(Pattern.quote(uri.substring(appendPos)));
        }
        uriRegex.append("($|(\\?(.)*))");
        return exactDeepLink;
    }

    boolean matches(@NonNull Uri uri) {
        return this.matches(new NavDeepLinkRequest(uri, null, null));
    }

    boolean matches(@NonNull NavDeepLinkRequest deepLinkRequest) {
        if (!this.matchUri(deepLinkRequest.getUri())) {
            return false;
        }
        if (!this.matchAction(deepLinkRequest.getAction())) {
            return false;
        }
        return this.matchMimeType(deepLinkRequest.getMimeType());
    }

    private boolean matchUri(Uri uri) {
        if (uri == null == (this.mPattern != null)) {
            return false;
        }
        return uri == null || this.mPattern.matcher(uri.toString()).matches();
    }

    private boolean matchAction(String action) {
        if (action == null == (this.mAction != null)) {
            return false;
        }
        return action == null || this.mAction.equals(action);
    }

    private boolean matchMimeType(String mimeType) {
        if (mimeType == null == (this.mMimeType != null)) {
            return false;
        }
        return mimeType == null || this.mMimeTypePattern.matcher(mimeType).matches();
    }

    boolean isExactDeepLink() {
        return this.mExactDeepLink;
    }

    @Nullable
    public String getUriPattern() {
        return this.mUri;
    }

    @Nullable
    public String getAction() {
        return this.mAction;
    }

    @Nullable
    public String getMimeType() {
        return this.mMimeType;
    }

    int getMimeTypeMatchRating(@NonNull String mimeType) {
        if (this.mMimeType == null || !this.mMimeTypePattern.matcher(mimeType).matches()) {
            return -1;
        }
        return new MimeType(this.mMimeType).compareTo(new MimeType(mimeType));
    }

    @Nullable
    Bundle getMatchingArguments(@NonNull Uri deepLink, @NonNull Map<String, NavArgument> arguments) {
        Matcher matcher = this.mPattern.matcher(deepLink.toString());
        if (!matcher.matches()) {
            return null;
        }
        Bundle bundle = new Bundle();
        int size = this.mArguments.size();
        for (int index = 0; index < size; ++index) {
            NavArgument argument;
            String value;
            String argumentName = this.mArguments.get(index);
            if (!this.parseArgument(bundle, argumentName, value = Uri.decode((String)matcher.group(index + 1)), argument = arguments.get(argumentName))) continue;
            return null;
        }
        if (this.mIsParameterizedQuery) {
            for (String paramName : this.mParamArgMap.keySet()) {
                Matcher argMatcher = null;
                ParamQuery storedParam = this.mParamArgMap.get(paramName);
                String inputParams = deepLink.getQueryParameter(paramName);
                if (inputParams != null && !(argMatcher = Pattern.compile(storedParam.getParamRegex()).matcher(inputParams)).matches()) {
                    return null;
                }
                for (int index = 0; index < storedParam.size(); ++index) {
                    String value = null;
                    if (argMatcher != null) {
                        value = Uri.decode((String)argMatcher.group(index + 1));
                    }
                    String argName = storedParam.getArgumentName(index);
                    NavArgument argument = arguments.get(argName);
                    if (value == null || value.replaceAll("[{}]", "").equals(argName) || !this.parseArgument(bundle, argName, value, argument)) continue;
                    return null;
                }
            }
        }
        return bundle;
    }

    private boolean parseArgument(Bundle bundle, String name, String value, NavArgument argument) {
        if (argument != null) {
            NavType<?> type = argument.getType();
            try {
                type.parseAndPut(bundle, name, value);
            }
            catch (IllegalArgumentException e) {
                return true;
            }
        } else {
            bundle.putString(name, value);
        }
        return false;
    }

    public static final class Builder {
        private String mUriPattern;
        private String mAction;
        private String mMimeType;

        Builder() {
        }

        @NonNull
        public static Builder fromUriPattern(@NonNull String uriPattern) {
            Builder builder = new Builder();
            builder.setUriPattern(uriPattern);
            return builder;
        }

        @NonNull
        public static Builder fromAction(@NonNull String action) {
            if (action.isEmpty()) {
                throw new IllegalArgumentException("The NavDeepLink cannot have an empty action.");
            }
            Builder builder = new Builder();
            builder.setAction(action);
            return builder;
        }

        @NonNull
        public static Builder fromMimeType(@NonNull String mimeType) {
            Builder builder = new Builder();
            builder.setMimeType(mimeType);
            return builder;
        }

        @NonNull
        public Builder setUriPattern(@NonNull String uriPattern) {
            this.mUriPattern = uriPattern;
            return this;
        }

        @NonNull
        public Builder setAction(@NonNull String action) {
            if (action.isEmpty()) {
                throw new IllegalArgumentException("The NavDeepLink cannot have an empty action.");
            }
            this.mAction = action;
            return this;
        }

        @NonNull
        public Builder setMimeType(@NonNull String mimeType) {
            this.mMimeType = mimeType;
            return this;
        }

        @NonNull
        public NavDeepLink build() {
            return new NavDeepLink(this.mUriPattern, this.mAction, this.mMimeType);
        }
    }

    private static class MimeType
    implements Comparable<MimeType> {
        String mType;
        String mSubType;

        MimeType(@NonNull String mimeType) {
            String[] typeAndSubType = mimeType.split("/", -1);
            this.mType = typeAndSubType[0];
            this.mSubType = typeAndSubType[1];
        }

        @Override
        public int compareTo(@NonNull MimeType o) {
            int result = 0;
            if (this.mType.equals(o.mType)) {
                result += 2;
            }
            if (this.mSubType.equals(o.mSubType)) {
                ++result;
            }
            return result;
        }
    }

    private static class ParamQuery {
        private String mParamRegex;
        private ArrayList<String> mArguments = new ArrayList();

        ParamQuery() {
        }

        void setParamRegex(String paramRegex) {
            this.mParamRegex = paramRegex;
        }

        String getParamRegex() {
            return this.mParamRegex;
        }

        void addArgumentName(String name) {
            this.mArguments.add(name);
        }

        String getArgumentName(int index) {
            return this.mArguments.get(index);
        }

        public int size() {
            return this.mArguments.size();
        }
    }
}

