/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.LifecycleObserver;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Lifecycle {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    AtomicReference<Object> mInternalScopeRef = new AtomicReference();

    @MainThread
    public abstract void addObserver(@NonNull LifecycleObserver var1);

    @MainThread
    public abstract void removeObserver(@NonNull LifecycleObserver var1);

    @MainThread
    @NonNull
    public abstract State getCurrentState();

    public static enum State {
        DESTROYED,
        INITIALIZED,
        CREATED,
        STARTED,
        RESUMED;


        public boolean isAtLeast(@NonNull State state) {
            return this.compareTo(state) >= 0;
        }
    }

    public static enum Event {
        ON_CREATE,
        ON_START,
        ON_RESUME,
        ON_PAUSE,
        ON_STOP,
        ON_DESTROY,
        ON_ANY;


        @Nullable
        public static Event downFrom(@NonNull State state) {
            switch (state) {
                case CREATED: {
                    return ON_DESTROY;
                }
                case STARTED: {
                    return ON_STOP;
                }
                case RESUMED: {
                    return ON_PAUSE;
                }
            }
            return null;
        }

        @Nullable
        public static Event downTo(@NonNull State state) {
            switch (state) {
                case DESTROYED: {
                    return ON_DESTROY;
                }
                case CREATED: {
                    return ON_STOP;
                }
                case STARTED: {
                    return ON_PAUSE;
                }
            }
            return null;
        }

        @Nullable
        public static Event upFrom(@NonNull State state) {
            switch (state) {
                case INITIALIZED: {
                    return ON_CREATE;
                }
                case CREATED: {
                    return ON_START;
                }
                case STARTED: {
                    return ON_RESUME;
                }
            }
            return null;
        }

        @Nullable
        public static Event upTo(@NonNull State state) {
            switch (state) {
                case CREATED: {
                    return ON_CREATE;
                }
                case STARTED: {
                    return ON_START;
                }
                case RESUMED: {
                    return ON_RESUME;
                }
            }
            return null;
        }

        @NonNull
        public State getTargetState() {
            switch (this) {
                case ON_CREATE: 
                case ON_STOP: {
                    return State.CREATED;
                }
                case ON_START: 
                case ON_PAUSE: {
                    return State.STARTED;
                }
                case ON_RESUME: {
                    return State.RESUMED;
                }
                case ON_DESTROY: {
                    return State.DESTROYED;
                }
            }
            throw new IllegalArgumentException((Object)((Object)this) + " has no target state");
        }
    }
}

