/*
 * Decompiled with CFR 0.152.
 */
package androidx.hilt.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.activity.ComponentActivity;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.Fragment;
import androidx.hilt.lifecycle.HiltViewModelFactory;
import androidx.hilt.lifecycle.ViewModelAssistedFactory;
import androidx.lifecycle.SavedStateViewModelFactory;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.savedstate.SavedStateRegistryOwner;
import dagger.Module;
import dagger.Provides;
import dagger.hilt.InstallIn;
import dagger.hilt.android.components.ActivityComponent;
import dagger.hilt.android.components.FragmentComponent;
import dagger.hilt.android.internal.lifecycle.DefaultActivityViewModelFactory;
import dagger.hilt.android.internal.lifecycle.DefaultFragmentViewModelFactory;
import dagger.multibindings.IntoSet;
import dagger.multibindings.Multibinds;
import java.util.Map;
import javax.inject.Provider;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public final class ViewModelFactoryModules {
    private ViewModelFactoryModules() {
    }

    @Module
    @InstallIn(value={FragmentComponent.class})
    public static final class FragmentModule {
        @Provides
        @IntoSet
        @NonNull
        @DefaultFragmentViewModelFactory
        static ViewModelProvider.Factory provideFactory(@NonNull Fragment fragment, @NonNull Application application, @NonNull Map<String, Provider<ViewModelAssistedFactory<? extends ViewModel>>> viewModelFactories) {
            Bundle defaultArgs = fragment.getArguments();
            SavedStateViewModelFactory delegate = new SavedStateViewModelFactory(application, (SavedStateRegistryOwner)fragment, defaultArgs);
            return new HiltViewModelFactory((SavedStateRegistryOwner)fragment, defaultArgs, delegate, viewModelFactories);
        }

        private FragmentModule() {
        }
    }

    @Module
    @InstallIn(value={ActivityComponent.class})
    public static abstract class ActivityModule {
        @Multibinds
        @NonNull
        abstract Map<String, ViewModelAssistedFactory<? extends ViewModel>> viewModelFactoriesMap();

        @Provides
        @IntoSet
        @NonNull
        @DefaultActivityViewModelFactory
        static ViewModelProvider.Factory provideFactory(@NonNull Activity activity, @NonNull Application application, @NonNull Map<String, Provider<ViewModelAssistedFactory<? extends ViewModel>>> viewModelFactories) {
            ComponentActivity owner = (ComponentActivity)activity;
            Bundle defaultArgs = activity.getIntent() != null ? activity.getIntent().getExtras() : null;
            SavedStateViewModelFactory delegate = new SavedStateViewModelFactory(application, (SavedStateRegistryOwner)owner, defaultArgs);
            return new HiltViewModelFactory((SavedStateRegistryOwner)owner, defaultArgs, delegate, viewModelFactories);
        }
    }
}

