/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.processing;

import android.databinding.tool.store.Location;
import android.databinding.tool.util.StringUtils;
import java.util.List;

public class ScopedErrorReport {
    private final String mFilePath;
    private final List<Location> mLocations;

    ScopedErrorReport(String filePath, List<Location> locations) {
        this.mFilePath = filePath;
        this.mLocations = locations;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    public List<Location> getLocations() {
        return this.mLocations;
    }

    public boolean isValid() {
        return StringUtils.isNotBlank(this.mFilePath);
    }

    public String toUserReadableString() {
        StringBuilder sb = new StringBuilder();
        if (this.mFilePath != null) {
            sb.append("File:");
            sb.append(this.mFilePath);
        }
        if (this.mLocations != null && this.mLocations.size() > 0) {
            if (this.mLocations.size() > 1) {
                sb.append("Locations:");
                for (Location location : this.mLocations) {
                    sb.append("\n    ").append(location.toUserReadableString());
                }
            } else {
                sb.append("\n    Location: ").append(this.mLocations.get(0).toUserReadableString());
            }
        }
        return sb.toString();
    }
}

