/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.store;

import android.databinding.parser.XMLLexer;
import android.databinding.parser.XMLParser;
import android.databinding.parser.XMLParserBaseVisitor;
import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.scopes.FileScopeProvider;
import android.databinding.tool.store.Location;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.L;
import android.databinding.tool.util.ParserHelper;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.RelativizableFile;
import android.databinding.tool.util.StringUtils;
import android.databinding.tool.util.XmlEditor;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.commons.io.FileUtils;
import org.mozilla.universalchardet.UniversalDetector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class LayoutFileParser {
    private static final String XPATH_BINDING_LAYOUT = "/layout";
    private static final String LAYOUT_PREFIX = "@layout/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle.LayoutFileBundle parseXml(RelativizableFile input, File outputFile, String pkg, LayoutXmlProcessor.OriginalFileLookup originalFileLookup, boolean isViewBindingEnabled) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        File inputFile = input.getAbsoluteFile();
        File originalFile = originalFileLookup.getOriginalFileFor(inputFile);
        if (originalFile == null) {
            originalFile = inputFile;
        }
        final String originalFilePath = originalFile.getAbsolutePath();
        try {
            Scope.enter(new FileScopeProvider(){

                @Override
                public String provideScopeFilePath() {
                    return originalFilePath;
                }
            });
            String encoding = LayoutFileParser.findEncoding(inputFile);
            LayoutFileParser.stripFile(inputFile, outputFile, encoding, originalFileLookup);
            ResourceBundle.LayoutFileBundle layoutFileBundle = LayoutFileParser.parseOriginalXml(RelativizableFile.fromAbsoluteFile(originalFile, input.getBaseDir()), pkg, encoding, isViewBindingEnabled);
            return layoutFileBundle;
        }
        finally {
            Scope.exit();
        }
    }

    public static boolean stripSingleLayoutFile(File layoutFile, File outputFile) throws IOException {
        String encoding = LayoutFileParser.findEncoding(layoutFile);
        String noExt = ParserHelper.stripExtension(layoutFile.getName());
        String binderId = layoutFile.getParentFile().getName() + '/' + noExt;
        String res = XmlEditor.strip(layoutFile, binderId, encoding);
        if (res != null) {
            FileUtils.writeStringToFile((File)outputFile, (String)res, (String)encoding);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle.LayoutFileBundle parseOriginalXml(RelativizableFile originalFile, String pkg, String encoding, boolean isViewBindingEnabled) throws IOException {
        final File original = originalFile.getAbsoluteFile();
        try {
            XMLParser.ElementContext rootView;
            XMLParser.ElementContext data;
            Scope.enter(new FileScopeProvider(){

                @Override
                public String provideScopeFilePath() {
                    return original.getAbsolutePath();
                }
            });
            String xmlNoExtension = ParserHelper.stripExtension(original.getName());
            FileInputStream fin = new FileInputStream(original);
            InputStreamReader reader = new InputStreamReader((InputStream)fin, encoding);
            ANTLRInputStream inputStream = new ANTLRInputStream((Reader)reader);
            XMLLexer lexer = new XMLLexer((CharStream)inputStream);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            XMLParser parser = new XMLParser((TokenStream)tokenStream);
            XMLParser.DocumentContext expr = parser.document();
            XMLParser.ElementContext root = expr.element();
            boolean isBindingData = "layout".equals(root.elmName.getText());
            if (isBindingData) {
                data = LayoutFileParser.getDataNode(root);
                rootView = LayoutFileParser.getViewNode(original, root);
            } else if (isViewBindingEnabled) {
                if ("true".equalsIgnoreCase(LayoutFileParser.attributeMap(root).get("tools:viewBindingIgnore"))) {
                    L.d("Ignoring %s for view binding", originalFile);
                    ResourceBundle.LayoutFileBundle layoutFileBundle = null;
                    return layoutFileBundle;
                }
                data = null;
                rootView = root;
            } else {
                ResourceBundle.LayoutFileBundle layoutFileBundle = null;
                return layoutFileBundle;
            }
            boolean isMerge = "merge".equals(rootView.elmName.getText());
            if (isBindingData && isMerge && !LayoutFileParser.filter(rootView, "include").isEmpty()) {
                L.e("<include> elements are not supported as direct children of <merge> elements", new Object[0]);
                ResourceBundle.LayoutFileBundle layoutFileBundle = null;
                return layoutFileBundle;
            }
            ResourceBundle.LayoutFileBundle bundle = new ResourceBundle.LayoutFileBundle(originalFile, xmlNoExtension, original.getParentFile().getName(), pkg, isMerge, isBindingData, LayoutFileParser.getViewName(rootView));
            String newTag = original.getParentFile().getName() + '/' + xmlNoExtension;
            LayoutFileParser.parseData(original, data, bundle);
            LayoutFileParser.parseExpressions(newTag, rootView, isMerge, bundle);
            ResourceBundle.LayoutFileBundle layoutFileBundle = bundle;
            return layoutFileBundle;
        }
        finally {
            Scope.exit();
        }
    }

    private static boolean isProcessedElement(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return false;
        }
        if ("view".equals(name) || "include".equals(name) || name.indexOf(46) >= 0) {
            return true;
        }
        return !name.toLowerCase().equals(name);
    }

    private static void parseExpressions(String newTag, final XMLParser.ElementContext rootView, final boolean isMerge, ResourceBundle.LayoutFileBundle bundle) {
        final ArrayList bindingElements = new ArrayList();
        final ArrayList otherElementsWithIds = new ArrayList();
        rootView.accept(new XMLParserBaseVisitor<Void>(){

            @Override
            public Void visitElement(XMLParser.ElementContext ctx) {
                if (this.filter(ctx)) {
                    bindingElements.add(ctx);
                } else {
                    String name = ctx.elmName.getText();
                    if (LayoutFileParser.isProcessedElement(name) && LayoutFileParser.attributeMap(ctx).containsKey("android:id")) {
                        otherElementsWithIds.add(ctx);
                    }
                }
                this.visitChildren((RuleNode)ctx);
                return null;
            }

            private boolean filter(XMLParser.ElementContext ctx) {
                if (isMerge ? ctx.getParent().getParent() == rootView : ctx == rootView) {
                    return true;
                }
                return this.hasIncludeChild(ctx) || XmlEditor.hasExpressionAttributes(ctx) || "include".equals(ctx.elmName.getText());
            }

            private boolean hasIncludeChild(XMLParser.ElementContext ctx) {
                for (XMLParser.ElementContext elementContext : XmlEditor.elements(ctx)) {
                    if (!"include".equals(elementContext.elmName.getText())) continue;
                    return true;
                }
                return false;
            }
        });
        HashMap<XMLParser.ElementContext, String> nodeTagMap = new HashMap<XMLParser.ElementContext, String>();
        L.d("number of binding nodes %d", bindingElements.size());
        int tagNumber = 0;
        for (XMLParser.ElementContext parent : bindingElements) {
            String tag;
            Map<String, String> attributes = LayoutFileParser.attributeMap(parent);
            String nodeName = parent.elmName.getText();
            String viewName = null;
            String includedLayoutName = null;
            String id = attributes.get("android:id");
            String originalTag = attributes.get("android:tag");
            if ("include".equals(nodeName)) {
                String includeValue = attributes.get("layout");
                if (Strings.isNullOrEmpty((String)includeValue)) {
                    L.e("%s must include a layout", new Object[]{parent});
                }
                if (!includeValue.startsWith(LAYOUT_PREFIX)) {
                    L.e("included value (%s) must start with %s.", includeValue, LAYOUT_PREFIX);
                }
                includedLayoutName = includeValue.substring(LAYOUT_PREFIX.length());
                ParserRuleContext myParentContent = parent.getParent();
                Preconditions.check(myParentContent instanceof XMLParser.ContentContext, "parent of an include tag must be a content context but it is %s", myParentContent.getClass().getCanonicalName());
                ParserRuleContext parserRuleContext = myParentContent.getParent();
                Preconditions.check(parserRuleContext instanceof XMLParser.ElementContext, "grandparent of an include tag must be an element context but it is %s", parserRuleContext.getClass().getCanonicalName());
                tag = (String)nodeTagMap.get(parserRuleContext);
            } else {
                if ("fragment".equals(nodeName)) {
                    if (!XmlEditor.hasExpressionAttributes(parent)) continue;
                    L.e("fragments do not support data binding expressions.", new Object[0]);
                    continue;
                }
                viewName = LayoutFileParser.getViewName(parent);
                tag = rootView == parent || isMerge && parent.getParent().getParent() == rootView ? newTag + "_" + tagNumber : "binding_" + tagNumber;
                ++tagNumber;
            }
            ResourceBundle.BindingTargetBundle bindingTargetBundle = bundle.createBindingTarget(id, viewName, true, tag, originalTag, new Location(parent));
            nodeTagMap.put(parent, tag);
            bindingTargetBundle.setIncludedLayout(includedLayoutName);
            for (XMLParser.AttributeContext attributeContext : XmlEditor.expressionAttributes(parent)) {
                String value = LayoutFileParser.escapeQuotes(attributeContext.attrValue.getText(), true);
                boolean isOneWay = value.startsWith("@{");
                boolean isTwoWay = value.startsWith("@={");
                if (!isOneWay && !isTwoWay) continue;
                if (value.charAt(value.length() - 1) != '}') {
                    L.e("Expecting '}' in expression '%s'", attributeContext.attrValue.getText());
                }
                int startIndex = isTwoWay ? 3 : 2;
                int endIndex = value.length() - 1;
                String strippedValue = value.substring(startIndex, endIndex);
                Location attrLocation = new Location(attributeContext);
                Location valueLocation = new Location();
                valueLocation.startLine = attributeContext.attrValue.getLine() - 1;
                valueLocation.startOffset = attributeContext.attrValue.getCharPositionInLine() + attributeContext.attrValue.getText().indexOf(strippedValue);
                valueLocation.endLine = attrLocation.endLine;
                valueLocation.endOffset = attrLocation.endOffset - 2;
                bindingTargetBundle.addBinding(LayoutFileParser.escapeQuotes(attributeContext.attrName.getText(), false), strippedValue, isTwoWay, attrLocation, valueLocation);
            }
        }
        for (XMLParser.ElementContext elm : otherElementsWithIds) {
            String id = LayoutFileParser.attributeMap(elm).get("android:id");
            String className = LayoutFileParser.getViewName(elm);
            bundle.createBindingTarget(id, className, true, null, null, new Location(elm));
        }
    }

    private static String getViewName(XMLParser.ElementContext elm) {
        String viewName = elm.elmName.getText();
        if ("view".equals(viewName)) {
            String classNode = LayoutFileParser.attributeMap(elm).get("class");
            if (Strings.isNullOrEmpty((String)classNode)) {
                L.e("No class attribute for 'view' node", new Object[0]);
            }
            viewName = classNode;
        } else if ("include".equals(viewName) && !XmlEditor.hasExpressionAttributes(elm)) {
            viewName = "android.view.View";
        }
        return viewName;
    }

    private static void parseData(File xml, XMLParser.ElementContext data, ResourceBundle.LayoutFileBundle bundle) {
        String name;
        String type;
        Map<String, String> attrMap;
        if (data == null) {
            return;
        }
        for (XMLParser.ElementContext imp : LayoutFileParser.filter(data, "import")) {
            attrMap = LayoutFileParser.attributeMap(imp);
            type = attrMap.get("type");
            String alias = attrMap.get("alias");
            Preconditions.check(StringUtils.isNotBlank(type), "Type of an import cannot be empty. %s in %s", imp.toStringTree(), xml);
            if (Strings.isNullOrEmpty((String)alias)) {
                alias = type.substring(type.lastIndexOf(46) + 1);
            }
            bundle.addImport(alias, type, new Location(imp));
        }
        for (XMLParser.ElementContext variable : LayoutFileParser.filter(data, "variable")) {
            attrMap = LayoutFileParser.attributeMap(variable);
            type = attrMap.get("type");
            String name2 = attrMap.get("name");
            Preconditions.checkNotNull(type, "variable must have a type definition %s in %s", variable.toStringTree(), xml);
            Preconditions.checkNotNull(name2, "variable must have a name %s in %s", variable.toStringTree(), xml);
            bundle.addVariable(name2, type, new Location(variable), true);
        }
        XMLParser.AttributeContext className = LayoutFileParser.findAttribute(data, "class");
        if (className != null && StringUtils.isNotBlank(name = LayoutFileParser.escapeQuotes(className.attrValue.getText(), true))) {
            Location location = new Location(className.attrValue.getLine() - 1, className.attrValue.getCharPositionInLine() + 1, className.attrValue.getLine() - 1, className.attrValue.getCharPositionInLine() + name.length());
            bundle.setBindingClass(name, location);
        }
    }

    private static XMLParser.ElementContext getDataNode(XMLParser.ElementContext root) {
        List<XMLParser.ElementContext> data = LayoutFileParser.filter(root, "data");
        if (data.isEmpty()) {
            return null;
        }
        Preconditions.check(data.size() == 1, "XML layout can have only 1 data tag", new Object[0]);
        return data.get(0);
    }

    private static XMLParser.ElementContext getViewNode(File xml, XMLParser.ElementContext root) {
        List<XMLParser.ElementContext> view = LayoutFileParser.filterNot(root, "data");
        Preconditions.check(view.size() == 1, "XML layout %s must have 1 view but has %s. root children count %s", xml, view.size(), root.getChildCount());
        return view.get(0);
    }

    private static List<XMLParser.ElementContext> filter(XMLParser.ElementContext root, String name) {
        ArrayList<XMLParser.ElementContext> result = new ArrayList<XMLParser.ElementContext>();
        if (root == null) {
            return result;
        }
        XMLParser.ContentContext content = root.content();
        if (content == null) {
            return result;
        }
        for (XMLParser.ElementContext elementContext : XmlEditor.elements(root)) {
            if (!name.equals(elementContext.elmName.getText())) continue;
            result.add(elementContext);
        }
        return result;
    }

    private static List<XMLParser.ElementContext> filterNot(XMLParser.ElementContext root, String name) {
        ArrayList<XMLParser.ElementContext> result = new ArrayList<XMLParser.ElementContext>();
        if (root == null) {
            return result;
        }
        XMLParser.ContentContext content = root.content();
        if (content == null) {
            return result;
        }
        for (XMLParser.ElementContext elementContext : XmlEditor.elements(root)) {
            if (name.equals(elementContext.elmName.getText())) continue;
            result.add(elementContext);
        }
        return result;
    }

    private static void stripFile(File xml, File out, String encoding, LayoutXmlProcessor.OriginalFileLookup originalFileLookup) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        File actualFile;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(xml);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        File file = actualFile = originalFileLookup == null ? null : originalFileLookup.getOriginalFileFor(xml);
        if (actualFile == null) {
            actualFile = xml;
        }
        String noExt = ParserHelper.stripExtension(actualFile.getName());
        String binderId = actualFile.getParentFile().getName() + '/' + noExt;
        boolean changed = LayoutFileParser.isBindingLayout(doc, xPath);
        if (changed) {
            LayoutFileParser.stripBindingTags(xml, out, binderId, encoding);
        } else if (!xml.equals(out)) {
            FileUtils.copyFile((File)xml, (File)out);
        }
    }

    private static boolean isBindingLayout(Document doc, XPath xPath) throws XPathExpressionException {
        return !LayoutFileParser.get(doc, xPath, XPATH_BINDING_LAYOUT).isEmpty();
    }

    private static List<Node> get(Document doc, XPath xPath, String pattern) throws XPathExpressionException {
        XPathExpression expr = xPath.compile(pattern);
        return LayoutFileParser.toList((NodeList)expr.evaluate(doc, XPathConstants.NODESET));
    }

    private static List<Node> toList(NodeList nodeList) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            result.add(nodeList.item(i));
        }
        return result;
    }

    private static void stripBindingTags(File xml, File output, String newTag, String encoding) throws IOException {
        String res = XmlEditor.strip(xml, newTag, encoding);
        Preconditions.checkNotNull(res, "layout file should've changed %s", xml.getAbsolutePath());
        if (res != null) {
            L.d("file %s has changed, overwriting %s", xml.getAbsolutePath(), output.getAbsolutePath());
            FileUtils.writeStringToFile((File)output, (String)res, (String)encoding);
        }
    }

    private static String findEncoding(File f) throws IOException {
        try (FileInputStream fin = new FileInputStream(f);){
            int nread;
            UniversalDetector universalDetector = new UniversalDetector(null);
            byte[] buf = new byte[4096];
            while ((nread = fin.read(buf)) > 0 && !universalDetector.isDone()) {
                universalDetector.handleData(buf, 0, nread);
            }
            universalDetector.dataEnd();
            String encoding = universalDetector.getDetectedCharset();
            if (encoding == null) {
                encoding = "utf-8";
            }
            String string = encoding;
            return string;
        }
    }

    private static Map<String, String> attributeMap(XMLParser.ElementContext root) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (XMLParser.AttributeContext attributeContext : XmlEditor.attributes(root)) {
            result.put(LayoutFileParser.escapeQuotes(attributeContext.attrName.getText(), false), LayoutFileParser.escapeQuotes(attributeContext.attrValue.getText(), true));
        }
        return result;
    }

    private static XMLParser.AttributeContext findAttribute(XMLParser.ElementContext element, String name) {
        for (XMLParser.AttributeContext attr : element.attribute()) {
            if (!LayoutFileParser.escapeQuotes(attr.attrName.getText(), false).equals(name)) continue;
            return attr;
        }
        return null;
    }

    private static String escapeQuotes(String textWithQuotes, boolean unescapeValue) {
        char last;
        char first = textWithQuotes.charAt(0);
        int start = 0;
        int end = textWithQuotes.length();
        if (first == '\"' || first == '\'') {
            start = 1;
        }
        if ((last = textWithQuotes.charAt(textWithQuotes.length() - 1)) == '\"' || last == '\'') {
            --end;
        }
        String val = textWithQuotes.substring(start, end);
        if (unescapeValue) {
            return StringUtils.unescapeXml(val);
        }
        return val;
    }

    private LayoutFileParser() {
    }
}

