/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.util.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u001c\n\u0002\u0010$\n\u0002\b\u0003\b\u0007\u0018\u0000 02\u00020\u0001:\u000201B\u008d\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\b\u0010\r\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0014\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0012\u0012\u0006\u0010\u0016\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050/R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\r\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0019R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0019R\u0011\u0010#\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b#\u0010 R\u0011\u0010\u0016\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010 R\u0011\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010 R\u0011\u0010$\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b$\u0010 R\u0011\u0010%\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b%\u0010 R\u0011\u0010\u0014\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010 R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010 R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0019\u00a8\u00062"}, d2={"Landroid/databinding/tool/CompilerArguments;", "", "artifactType", "Landroid/databinding/tool/CompilerArguments$Type;", "modulePackage", "", "minApi", "", "sdkDir", "Ljava/io/File;", "buildDir", "layoutInfoDir", "classLogDir", "baseFeatureInfoDir", "featureInfoDir", "aarOutDir", "exportClassListOutFile", "enableDebugLogs", "", "printEncodedErrorLogs", "isTestVariant", "isEnabledForTests", "isEnableV2", "(Landroid/databinding/tool/CompilerArguments$Type;Ljava/lang/String;ILjava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;ZZZZZ)V", "getAarOutDir", "()Ljava/io/File;", "getArtifactType", "()Landroid/databinding/tool/CompilerArguments$Type;", "getBaseFeatureInfoDir", "getBuildDir", "getClassLogDir", "getEnableDebugLogs", "()Z", "getExportClassListOutFile", "getFeatureInfoDir", "isApp", "isFeature", "isLibrary", "getLayoutInfoDir", "getMinApi", "()I", "getModulePackage", "()Ljava/lang/String;", "getPrintEncodedErrorLogs", "getSdkDir", "copyAsV1", "toMap", "", "Companion", "Type", "databinding-compiler-common"})
public final class CompilerArguments {
    @NotNull
    private final Type artifactType;
    @NotNull
    private final String modulePackage;
    private final int minApi;
    @NotNull
    private final File sdkDir;
    @NotNull
    private final File buildDir;
    @NotNull
    private final File layoutInfoDir;
    @NotNull
    private final File classLogDir;
    @Nullable
    private final File baseFeatureInfoDir;
    @Nullable
    private final File featureInfoDir;
    @Nullable
    private final File aarOutDir;
    @Nullable
    private final File exportClassListOutFile;
    private final boolean enableDebugLogs;
    private final boolean printEncodedErrorLogs;
    private final boolean isTestVariant;
    private final boolean isEnabledForTests;
    private final boolean isEnableV2;
    private static final String PREFIX = "android.databinding.";
    private static final String PARAM_ARTIFACT_TYPE = "android.databinding.artifactType";
    private static final String PARAM_MODULE_PACKAGE = "android.databinding.modulePackage";
    private static final String PARAM_MIN_API = "android.databinding.minApi";
    private static final String PARAM_SDK_DIR = "android.databinding.sdkDir";
    private static final String PARAM_BUILD_DIR = "android.databinding.buildDir";
    private static final String PARAM_LAYOUT_INFO_DIR = "android.databinding.layoutInfoDir";
    private static final String PARAM_CLASS_LOG_DIR = "android.databinding.classLogDir";
    private static final String PARAM_BASE_FEATURE_INFO_DIR = "android.databinding.baseFeatureInfoDir";
    private static final String PARAM_FEATURE_INFO_DIR = "android.databinding.featureInfoDir";
    private static final String PARAM_AAR_OUT_DIR = "android.databinding.aarOutDir";
    private static final String PARAM_EXPORT_CLASS_LIST_OUT_FILE = "android.databinding.exportClassListOutFile";
    private static final String PARAM_ENABLE_DEBUG_LOGS = "android.databinding.enableDebugLogs";
    private static final String PARAM_PRINT_ENCODED_ERROR_LOGS = "android.databinding.printEncodedErrorLogs";
    private static final String PARAM_IS_TEST_VARIANT = "android.databinding.isTestVariant";
    private static final String PARAM_ENABLE_FOR_TESTS = "android.databinding.enableForTests";
    private static final String PARAM_ENABLE_V2 = "android.databinding.enableV2";
    @JvmField
    @NotNull
    public static final Set<String> ALL_PARAMS;
    public static final Companion Companion;

    public final boolean isApp() {
        return Intrinsics.areEqual((Object)((Object)this.artifactType), (Object)((Object)Type.APPLICATION));
    }

    public final boolean isLibrary() {
        return Intrinsics.areEqual((Object)((Object)this.artifactType), (Object)((Object)Type.LIBRARY));
    }

    public final boolean isFeature() {
        return Intrinsics.areEqual((Object)((Object)this.artifactType), (Object)((Object)Type.FEATURE));
    }

    @NotNull
    public final CompilerArguments copyAsV1(@NotNull String modulePackage) {
        Map argMap;
        Intrinsics.checkParameterIsNotNull((Object)modulePackage, (String)"modulePackage");
        Map map = argMap = MapsKt.toMutableMap(this.toMap());
        String string = PARAM_MODULE_PACKAGE;
        String string2 = modulePackage;
        map.put(string, string2);
        map = argMap;
        string = PARAM_ENABLE_V2;
        string2 = CompilerArguments.Companion.booleanToString(false);
        map.put(string, string2);
        return Companion.readFromOptions(argMap);
    }

    @NotNull
    public final Map<String, String> toMap() {
        String string;
        String string2;
        Object it;
        HashMap args = new HashMap();
        Object object = args;
        String string3 = PARAM_ARTIFACT_TYPE;
        Object object2 = this.artifactType.name();
        object.put(string3, object2);
        object = args;
        string3 = PARAM_MODULE_PACKAGE;
        object2 = this.modulePackage;
        object.put(string3, object2);
        object = args;
        string3 = PARAM_MIN_API;
        object2 = String.valueOf(this.minApi);
        object.put(string3, object2);
        object = args;
        string3 = PARAM_SDK_DIR;
        String string4 = this.sdkDir.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"sdkDir.path");
        object2 = string4;
        object.put(string3, object2);
        object = args;
        string3 = PARAM_BUILD_DIR;
        String string5 = this.buildDir.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"buildDir.path");
        object2 = string5;
        object.put(string3, object2);
        object = args;
        string3 = PARAM_LAYOUT_INFO_DIR;
        String string6 = this.layoutInfoDir.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"layoutInfoDir.path");
        object2 = string6;
        object.put(string3, object2);
        object = args;
        string3 = PARAM_CLASS_LOG_DIR;
        String string7 = this.classLogDir.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"classLogDir.path");
        object2 = string7;
        object.put(string3, object2);
        File file = this.baseFeatureInfoDir;
        if (file != null) {
            it = object = file;
            object2 = args;
            string2 = PARAM_BASE_FEATURE_INFO_DIR;
            String string8 = ((File)it).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"it.path");
            string = string8;
            object2.put(string2, string);
        }
        File file2 = this.featureInfoDir;
        if (file2 != null) {
            it = object = file2;
            object2 = args;
            string2 = PARAM_FEATURE_INFO_DIR;
            String string9 = ((File)it).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"it.path");
            string = string9;
            object2.put(string2, string);
        }
        File file3 = this.aarOutDir;
        if (file3 != null) {
            it = object = file3;
            object2 = args;
            string2 = PARAM_AAR_OUT_DIR;
            String string10 = ((File)it).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"it.path");
            string = string10;
            object2.put(string2, string);
        }
        File file4 = this.exportClassListOutFile;
        if (file4 != null) {
            it = object = file4;
            object2 = args;
            string2 = PARAM_EXPORT_CLASS_LIST_OUT_FILE;
            String string11 = ((File)it).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"it.path");
            string = string11;
            object2.put(string2, string);
        }
        object = args;
        string3 = PARAM_ENABLE_DEBUG_LOGS;
        object2 = CompilerArguments.Companion.booleanToString(this.enableDebugLogs);
        object.put(string3, object2);
        object = args;
        string3 = PARAM_PRINT_ENCODED_ERROR_LOGS;
        object2 = CompilerArguments.Companion.booleanToString(this.printEncodedErrorLogs);
        object.put(string3, object2);
        object = args;
        string3 = PARAM_IS_TEST_VARIANT;
        object2 = CompilerArguments.Companion.booleanToString(this.isTestVariant);
        object.put(string3, object2);
        object = args;
        string3 = PARAM_ENABLE_FOR_TESTS;
        object2 = CompilerArguments.Companion.booleanToString(this.isEnabledForTests);
        object.put(string3, object2);
        object = args;
        string3 = PARAM_ENABLE_V2;
        object2 = CompilerArguments.Companion.booleanToString(this.isEnableV2);
        object.put(string3, object2);
        return args;
    }

    @NotNull
    public final Type getArtifactType() {
        return this.artifactType;
    }

    @NotNull
    public final String getModulePackage() {
        return this.modulePackage;
    }

    public final int getMinApi() {
        return this.minApi;
    }

    @NotNull
    public final File getSdkDir() {
        return this.sdkDir;
    }

    @NotNull
    public final File getBuildDir() {
        return this.buildDir;
    }

    @NotNull
    public final File getLayoutInfoDir() {
        return this.layoutInfoDir;
    }

    @NotNull
    public final File getClassLogDir() {
        return this.classLogDir;
    }

    @Nullable
    public final File getBaseFeatureInfoDir() {
        return this.baseFeatureInfoDir;
    }

    @Nullable
    public final File getFeatureInfoDir() {
        return this.featureInfoDir;
    }

    @Nullable
    public final File getAarOutDir() {
        return this.aarOutDir;
    }

    @Nullable
    public final File getExportClassListOutFile() {
        return this.exportClassListOutFile;
    }

    public final boolean getEnableDebugLogs() {
        return this.enableDebugLogs;
    }

    public final boolean getPrintEncodedErrorLogs() {
        return this.printEncodedErrorLogs;
    }

    public final boolean isTestVariant() {
        return this.isTestVariant;
    }

    public final boolean isEnabledForTests() {
        return this.isEnabledForTests;
    }

    public final boolean isEnableV2() {
        return this.isEnableV2;
    }

    public CompilerArguments(@NotNull Type artifactType, @NotNull String modulePackage, int minApi, @NotNull File sdkDir, @NotNull File buildDir, @NotNull File layoutInfoDir, @NotNull File classLogDir, @Nullable File baseFeatureInfoDir, @Nullable File featureInfoDir, @Nullable File aarOutDir, @Nullable File exportClassListOutFile, boolean enableDebugLogs, boolean printEncodedErrorLogs, boolean isTestVariant, boolean isEnabledForTests, boolean isEnableV2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)artifactType), (String)"artifactType");
        Intrinsics.checkParameterIsNotNull((Object)modulePackage, (String)"modulePackage");
        Intrinsics.checkParameterIsNotNull((Object)sdkDir, (String)"sdkDir");
        Intrinsics.checkParameterIsNotNull((Object)buildDir, (String)"buildDir");
        Intrinsics.checkParameterIsNotNull((Object)layoutInfoDir, (String)"layoutInfoDir");
        Intrinsics.checkParameterIsNotNull((Object)classLogDir, (String)"classLogDir");
        this.artifactType = artifactType;
        this.modulePackage = modulePackage;
        this.minApi = minApi;
        this.sdkDir = sdkDir;
        this.buildDir = buildDir;
        this.layoutInfoDir = layoutInfoDir;
        this.classLogDir = classLogDir;
        this.baseFeatureInfoDir = baseFeatureInfoDir;
        this.featureInfoDir = featureInfoDir;
        this.aarOutDir = aarOutDir;
        this.exportClassListOutFile = exportClassListOutFile;
        this.enableDebugLogs = enableDebugLogs;
        this.printEncodedErrorLogs = printEncodedErrorLogs;
        this.isTestVariant = isTestVariant;
        this.isEnabledForTests = isEnabledForTests;
        this.isEnableV2 = isEnableV2;
        Preconditions.check(Intrinsics.areEqual((Object)((Object)this.artifactType), (Object)((Object)Type.FEATURE)) ^ true || this.featureInfoDir != null, "Must provide a feature info folder while compiling a non-base feature module", new Object[0]);
        Preconditions.check(Intrinsics.areEqual((Object)((Object)this.artifactType), (Object)((Object)Type.LIBRARY)) ^ true || this.isTestVariant || this.aarOutDir != null, "Must specify bundle folder (aar out folder) for library projects", new Object[0]);
        Preconditions.check(Intrinsics.areEqual((Object)((Object)this.artifactType), (Object)((Object)Type.LIBRARY)) ^ true || this.isTestVariant || this.exportClassListOutFile != null, "Must provide a folder to export generated class list", new Object[0]);
    }

    static {
        Companion = new Companion(null);
        HashSet hashSet = Sets.newHashSet((Object[])new String[]{PARAM_ARTIFACT_TYPE, PARAM_MODULE_PACKAGE, PARAM_MIN_API, PARAM_SDK_DIR, PARAM_BUILD_DIR, PARAM_LAYOUT_INFO_DIR, PARAM_CLASS_LOG_DIR, PARAM_BASE_FEATURE_INFO_DIR, PARAM_FEATURE_INFO_DIR, PARAM_AAR_OUT_DIR, PARAM_EXPORT_CLASS_LIST_OUT_FILE, PARAM_ENABLE_DEBUG_LOGS, PARAM_PRINT_ENCODED_ERROR_LOGS, PARAM_IS_TEST_VARIANT, PARAM_ENABLE_FOR_TESTS, PARAM_ENABLE_V2});
        Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"Sets.newHashSet(\n       \u2026PARAM_ENABLE_V2\n        )");
        ALL_PARAMS = hashSet;
    }

    @JvmStatic
    @NotNull
    public static final CompilerArguments readFromOptions(@NotNull Map<String, String> options) {
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        return Companion.readFromOptions(options);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroid/databinding/tool/CompilerArguments$Type;", "", "(Ljava/lang/String;I)V", "APPLICATION", "LIBRARY", "FEATURE", "databinding-compiler-common"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type APPLICATION;
        public static final /* enum */ Type LIBRARY;
        public static final /* enum */ Type FEATURE;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[3];
            Type[] typeArray2 = typeArray;
            typeArray[0] = APPLICATION = new Type();
            typeArray[1] = LIBRARY = new Type();
            typeArray[2] = FEATURE = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001dH\u0007J\u0012\u0010\u001e\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroid/databinding/tool/CompilerArguments$Companion;", "", "()V", "ALL_PARAMS", "", "", "PARAM_AAR_OUT_DIR", "PARAM_ARTIFACT_TYPE", "PARAM_BASE_FEATURE_INFO_DIR", "PARAM_BUILD_DIR", "PARAM_CLASS_LOG_DIR", "PARAM_ENABLE_DEBUG_LOGS", "PARAM_ENABLE_FOR_TESTS", "PARAM_ENABLE_V2", "PARAM_EXPORT_CLASS_LIST_OUT_FILE", "PARAM_FEATURE_INFO_DIR", "PARAM_IS_TEST_VARIANT", "PARAM_LAYOUT_INFO_DIR", "PARAM_MIN_API", "PARAM_MODULE_PACKAGE", "PARAM_PRINT_ENCODED_ERROR_LOGS", "PARAM_SDK_DIR", "PREFIX", "booleanToString", "boolValue", "", "readFromOptions", "Landroid/databinding/tool/CompilerArguments;", "options", "", "stringToBoolean", "databinding-compiler-common"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final CompilerArguments readFromOptions(@NotNull Map<String, String> options) {
            File file;
            File file2;
            File file3;
            File file4;
            File file5;
            File file6;
            File file7;
            String it;
            CompilerArguments compilerArguments;
            CompilerArguments compilerArguments2;
            Type type;
            String string;
            int n;
            File file8;
            File file9;
            File file10;
            File file11;
            String string2;
            CompilerArguments compilerArguments3;
            Intrinsics.checkParameterIsNotNull(options, (String)"options");
            CompilerArguments compilerArguments4 = compilerArguments3;
            CompilerArguments compilerArguments5 = compilerArguments3;
            String string3 = options.get(CompilerArguments.PARAM_ARTIFACT_TYPE);
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            Type type2 = Type.valueOf(string3);
            String string4 = options.get(CompilerArguments.PARAM_MODULE_PACKAGE);
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            String string5 = string4;
            String string6 = options.get(CompilerArguments.PARAM_MIN_API);
            if (string6 == null) {
                Intrinsics.throwNpe();
            }
            int n2 = Integer.parseInt(string6);
            String string7 = options.get(CompilerArguments.PARAM_SDK_DIR);
            if (string7 == null) {
                Intrinsics.throwNpe();
            }
            File file12 = new File(string7);
            String string8 = options.get(CompilerArguments.PARAM_BUILD_DIR);
            if (string8 == null) {
                Intrinsics.throwNpe();
            }
            File file13 = new File(string8);
            String string9 = options.get(CompilerArguments.PARAM_LAYOUT_INFO_DIR);
            if (string9 == null) {
                Intrinsics.throwNpe();
            }
            File file14 = new File(string9);
            String string10 = options.get(CompilerArguments.PARAM_CLASS_LOG_DIR);
            if (string10 == null) {
                Intrinsics.throwNpe();
            }
            File file15 = new File(string10);
            String string11 = options.get(CompilerArguments.PARAM_BASE_FEATURE_INFO_DIR);
            if (string11 != null) {
                string2 = string11;
                file11 = file15;
                file10 = file14;
                file9 = file13;
                file8 = file12;
                n = n2;
                string = string5;
                type = type2;
                compilerArguments2 = compilerArguments4;
                compilerArguments = compilerArguments5;
                it = string2;
                file7 = new File(it);
                compilerArguments5 = compilerArguments;
                compilerArguments4 = compilerArguments2;
                type2 = type;
                string5 = string;
                n2 = n;
                file12 = file8;
                file13 = file9;
                file14 = file10;
                file15 = file11;
                file6 = file7;
            } else {
                file6 = null;
            }
            String string12 = options.get(CompilerArguments.PARAM_FEATURE_INFO_DIR);
            if (string12 != null) {
                string2 = string12;
                file7 = file6;
                file11 = file15;
                file10 = file14;
                file9 = file13;
                file8 = file12;
                n = n2;
                string = string5;
                type = type2;
                compilerArguments2 = compilerArguments4;
                compilerArguments = compilerArguments5;
                it = string2;
                file5 = new File(it);
                compilerArguments5 = compilerArguments;
                compilerArguments4 = compilerArguments2;
                type2 = type;
                string5 = string;
                n2 = n;
                file12 = file8;
                file13 = file9;
                file14 = file10;
                file15 = file11;
                file6 = file7;
                file4 = file5;
            } else {
                file4 = null;
            }
            String string13 = options.get(CompilerArguments.PARAM_AAR_OUT_DIR);
            if (string13 != null) {
                string2 = string13;
                file5 = file4;
                file7 = file6;
                file11 = file15;
                file10 = file14;
                file9 = file13;
                file8 = file12;
                n = n2;
                string = string5;
                type = type2;
                compilerArguments2 = compilerArguments4;
                compilerArguments = compilerArguments5;
                it = string2;
                file3 = new File(it);
                compilerArguments5 = compilerArguments;
                compilerArguments4 = compilerArguments2;
                type2 = type;
                string5 = string;
                n2 = n;
                file12 = file8;
                file13 = file9;
                file14 = file10;
                file15 = file11;
                file6 = file7;
                file4 = file5;
                file2 = file3;
            } else {
                file2 = null;
            }
            String string14 = options.get(CompilerArguments.PARAM_EXPORT_CLASS_LIST_OUT_FILE);
            if (string14 != null) {
                string2 = string14;
                file3 = file2;
                file5 = file4;
                file7 = file6;
                file11 = file15;
                file10 = file14;
                file9 = file13;
                file8 = file12;
                n = n2;
                string = string5;
                type = type2;
                compilerArguments2 = compilerArguments4;
                compilerArguments = compilerArguments5;
                it = string2;
                File file16 = new File(it);
                compilerArguments5 = compilerArguments;
                compilerArguments4 = compilerArguments2;
                type2 = type;
                string5 = string;
                n2 = n;
                file12 = file8;
                file13 = file9;
                file14 = file10;
                file15 = file11;
                file6 = file7;
                file4 = file5;
                file2 = file3;
                file = file16;
            } else {
                file = null;
            }
            compilerArguments4(type2, string5, n2, file12, file13, file14, file15, file6, file4, file2, file, this.stringToBoolean(options.get(CompilerArguments.PARAM_ENABLE_DEBUG_LOGS)), this.stringToBoolean(options.get(CompilerArguments.PARAM_PRINT_ENCODED_ERROR_LOGS)), this.stringToBoolean(options.get(CompilerArguments.PARAM_IS_TEST_VARIANT)), this.stringToBoolean(options.get(CompilerArguments.PARAM_ENABLE_FOR_TESTS)), this.stringToBoolean(options.get(CompilerArguments.PARAM_ENABLE_V2)));
            return compilerArguments5;
        }

        private final String booleanToString(boolean boolValue) {
            return boolValue ? "1" : "0";
        }

        private final boolean stringToBoolean(String boolValue) {
            String string;
            String string2 = boolValue;
            if (string2 != null) {
                String string3;
                String string4 = string3 = string2;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            } else {
                string = null;
            }
            return Intrinsics.areEqual(string, (Object)"1");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

