/*
 * Decompiled with CFR 0.152.
 */
package androidx.databinding.adapters;

import android.animation.LayoutTransition;
import android.annotation.TargetApi;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import androidx.annotation.RestrictTo;
import androidx.databinding.BindingAdapter;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@BindingMethods(value={@BindingMethod(type=ViewGroup.class, attribute="android:alwaysDrawnWithCache", method="setAlwaysDrawnWithCacheEnabled"), @BindingMethod(type=ViewGroup.class, attribute="android:animationCache", method="setAnimationCacheEnabled"), @BindingMethod(type=ViewGroup.class, attribute="android:splitMotionEvents", method="setMotionEventSplittingEnabled")})
public class ViewGroupBindingAdapter {
    @TargetApi(value=11)
    @BindingAdapter(value={"android:animateLayoutChanges"})
    public static void setAnimateLayoutChanges(ViewGroup view, boolean animate) {
        if (animate) {
            view.setLayoutTransition(new LayoutTransition());
        } else {
            view.setLayoutTransition(null);
        }
    }

    @BindingAdapter(value={"android:onChildViewAdded", "android:onChildViewRemoved"}, requireAll=false)
    public static void setListener(ViewGroup view, final OnChildViewAdded added, final OnChildViewRemoved removed) {
        if (added == null && removed == null) {
            view.setOnHierarchyChangeListener(null);
        } else {
            view.setOnHierarchyChangeListener(new ViewGroup.OnHierarchyChangeListener(){

                public void onChildViewAdded(View parent, View child) {
                    if (added != null) {
                        added.onChildViewAdded(parent, child);
                    }
                }

                public void onChildViewRemoved(View parent, View child) {
                    if (removed != null) {
                        removed.onChildViewRemoved(parent, child);
                    }
                }
            });
        }
    }

    @BindingAdapter(value={"android:onAnimationStart", "android:onAnimationEnd", "android:onAnimationRepeat"}, requireAll=false)
    public static void setListener(ViewGroup view, final OnAnimationStart start, final OnAnimationEnd end, final OnAnimationRepeat repeat) {
        if (start == null && end == null && repeat == null) {
            view.setLayoutAnimationListener(null);
        } else {
            view.setLayoutAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    if (start != null) {
                        start.onAnimationStart(animation);
                    }
                }

                public void onAnimationEnd(Animation animation) {
                    if (end != null) {
                        end.onAnimationEnd(animation);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                    if (repeat != null) {
                        repeat.onAnimationRepeat(animation);
                    }
                }
            });
        }
    }

    public static interface OnAnimationRepeat {
        public void onAnimationRepeat(Animation var1);
    }

    public static interface OnAnimationEnd {
        public void onAnimationEnd(Animation var1);
    }

    public static interface OnAnimationStart {
        public void onAnimationStart(Animation var1);
    }

    public static interface OnChildViewRemoved {
        public void onChildViewRemoved(View var1, View var2);
    }

    public static interface OnChildViewAdded {
        public void onChildViewAdded(View var1, View var2);
    }
}

