/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorSpace;
import android.graphics.Point;
import android.graphics.PointF;
import androidx.annotation.ColorInt;
import androidx.annotation.RequiresApi;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a#\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0086\b\u001a7\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0087\b\u001a)\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010H\u0086\b\u00f8\u0001\u0000\u001a\u0015\u0010\u0011\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\n\u001a\u0015\u0010\u0011\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0014H\u0086\n\u001a\u001d\u0010\u0015\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0086\n\u001a'\u0010\u0018\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\bH\u0086\b\u001a'\u0010\u001a\u001a\u00020\u000f*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\b\b\u0001\u0010\u001b\u001a\u00020\u0003H\u0086\n\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"createBitmap", "Landroid/graphics/Bitmap;", "width", "", "height", "config", "Landroid/graphics/Bitmap$Config;", "hasAlpha", "", "colorSpace", "Landroid/graphics/ColorSpace;", "applyCanvas", "block", "Lkotlin/Function1;", "Landroid/graphics/Canvas;", "", "Lkotlin/ExtensionFunctionType;", "contains", "p", "Landroid/graphics/Point;", "Landroid/graphics/PointF;", "get", "x", "y", "scale", "filter", "set", "color", "core-ktx_release"})
public final class BitmapKt {
    @NotNull
    public static final Bitmap applyCanvas(@NotNull Bitmap $this$applyCanvas, @NotNull Function1<? super Canvas, Unit> block) {
        int $i$f$applyCanvas = 0;
        Intrinsics.checkNotNullParameter((Object)$this$applyCanvas, (String)"$this$applyCanvas");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Canvas c = new Canvas($this$applyCanvas);
        block.invoke((Object)c);
        return $this$applyCanvas;
    }

    public static final int get(@NotNull Bitmap $this$get, int x, int y) {
        int $i$f$get = 0;
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"$this$get");
        return $this$get.getPixel(x, y);
    }

    public static final void set(@NotNull Bitmap $this$set, int x, int y, @ColorInt int color) {
        int $i$f$set = 0;
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"$this$set");
        $this$set.setPixel(x, y, color);
    }

    @NotNull
    public static final Bitmap scale(@NotNull Bitmap $this$scale, int width, int height, boolean filter) {
        int $i$f$scale = 0;
        Intrinsics.checkNotNullParameter((Object)$this$scale, (String)"$this$scale");
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)$this$scale, (int)width, (int)height, (boolean)filter);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"Bitmap.createScaledBitma\u2026s, width, height, filter)");
        return bitmap;
    }

    public static /* synthetic */ Bitmap scale$default(Bitmap $this$scale, int width, int height, boolean filter, int n, Object object) {
        if ((n & 4) != 0) {
            filter = true;
        }
        boolean $i$f$scale = false;
        Intrinsics.checkNotNullParameter((Object)$this$scale, (String)"$this$scale");
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)$this$scale, (int)width, (int)height, (boolean)filter);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"Bitmap.createScaledBitma\u2026s, width, height, filter)");
        return bitmap;
    }

    @NotNull
    public static final Bitmap createBitmap(int width, int height, @NotNull Bitmap.Config config) {
        int $i$f$createBitmap = 0;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"Bitmap.createBitmap(width, height, config)");
        return bitmap;
    }

    public static /* synthetic */ Bitmap createBitmap$default(int width, int height, Bitmap.Config config, int n, Object object) {
        if ((n & 4) != 0) {
            config = Bitmap.Config.ARGB_8888;
        }
        boolean $i$f$createBitmap = false;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"Bitmap.createBitmap(width, height, config)");
        return bitmap;
    }

    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap createBitmap(int width, int height, @NotNull Bitmap.Config config, boolean hasAlpha, @NotNull ColorSpace colorSpace) {
        int $i$f$createBitmap = 0;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config, (boolean)hasAlpha, (ColorSpace)colorSpace);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"Bitmap.createBitmap(widt\u2026ig, hasAlpha, colorSpace)");
        return bitmap;
    }

    public static /* synthetic */ Bitmap createBitmap$default(int width, int height, Bitmap.Config config, boolean hasAlpha, ColorSpace colorSpace, int n, Object object) {
        if ((n & 4) != 0) {
            config = Bitmap.Config.ARGB_8888;
        }
        if ((n & 8) != 0) {
            hasAlpha = true;
        }
        if ((n & 0x10) != 0) {
            ColorSpace colorSpace2 = ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB);
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace2, (String)"ColorSpace.get(ColorSpace.Named.SRGB)");
            colorSpace = colorSpace2;
        }
        boolean $i$f$createBitmap = false;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config, (boolean)hasAlpha, (ColorSpace)colorSpace);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"Bitmap.createBitmap(widt\u2026ig, hasAlpha, colorSpace)");
        return bitmap;
    }

    public static final boolean contains(@NotNull Bitmap $this$contains, @NotNull Point p) {
        int $i$f$contains = 0;
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"$this$contains");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return p.x >= 0 && p.x < $this$contains.getWidth() && p.y >= 0 && p.y < $this$contains.getHeight();
    }

    public static final boolean contains(@NotNull Bitmap $this$contains, @NotNull PointF p) {
        int $i$f$contains = 0;
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"$this$contains");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return p.x >= 0.0f && p.x < (float)$this$contains.getWidth() && p.y >= 0.0f && p.y < (float)$this$contains.getHeight();
    }
}

