/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets;

import androidx.constraintlayout.solver.LinearSystem;
import androidx.constraintlayout.solver.widgets.Analyzer;
import androidx.constraintlayout.solver.widgets.ChainHead;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.solver.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.solver.widgets.ResolutionAnchor;

public class Optimizer {
    public static final int OPTIMIZATION_NONE = 0;
    public static final int OPTIMIZATION_DIRECT = 1;
    public static final int OPTIMIZATION_BARRIER = 2;
    public static final int OPTIMIZATION_CHAIN = 4;
    public static final int OPTIMIZATION_DIMENSIONS = 8;
    public static final int OPTIMIZATION_RATIO = 16;
    public static final int OPTIMIZATION_GROUPS = 32;
    public static final int OPTIMIZATION_GRAPH = 64;
    public static final int OPTIMIZATION_GRAPH_WRAP = 128;
    public static final int OPTIMIZATION_STANDARD = 7;
    static boolean[] flags = new boolean[3];
    static final int FLAG_USE_OPTIMIZE = 0;
    static final int FLAG_CHAIN_DANGLING = 1;
    static final int FLAG_RECOMPUTE_BOUNDS = 2;

    static void checkMatchParent(ConstraintWidgetContainer container, LinearSystem system, ConstraintWidget widget) {
        widget.mHorizontalResolution = -1;
        widget.mVerticalResolution = -1;
        if (container.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            int left = widget.mLeft.mMargin;
            int right = container.getWidth() - widget.mRight.mMargin;
            widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
            widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
            system.addEquality(widget.mLeft.mSolverVariable, left);
            system.addEquality(widget.mRight.mSolverVariable, right);
            widget.mHorizontalResolution = 2;
            widget.setHorizontalDimension(left, right);
        }
        if (container.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            int top = widget.mTop.mMargin;
            int bottom = container.getHeight() - widget.mBottom.mMargin;
            widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
            widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
            system.addEquality(widget.mTop.mSolverVariable, top);
            system.addEquality(widget.mBottom.mSolverVariable, bottom);
            if (widget.mBaselineDistance > 0 || widget.getVisibility() == 8) {
                widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
            }
            widget.mVerticalResolution = 2;
            widget.setVerticalDimension(top, bottom);
        }
    }

    private static boolean optimizableMatchConstraint(ConstraintWidget constraintWidget, int orientation) {
        if (constraintWidget.mListDimensionBehaviors[orientation] != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            return false;
        }
        if (orientation == 0) {
            if (constraintWidget.mMatchConstraintDefaultWidth != 0) {
                return false;
            }
            if (constraintWidget.mMatchConstraintMinWidth != 0 || constraintWidget.mMatchConstraintMaxWidth != 0) {
                return false;
            }
        } else {
            if (constraintWidget.mMatchConstraintDefaultHeight != 0) {
                return false;
            }
            if (constraintWidget.mMatchConstraintMinHeight != 0 || constraintWidget.mMatchConstraintMaxHeight != 0) {
                return false;
            }
        }
        return true;
    }

    private static boolean optimizableRatio(ConstraintWidget widget, int orientation, int optimizationLevel) {
        if (widget.mDimensionRatio != 0.0f) {
            if (widget.mListDimensionBehaviors[orientation == 0 ? 1 : 0] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                return false;
            }
            if ((optimizationLevel & 0x10) != 16) {
                return false;
            }
        }
        return true;
    }

    static void analyze(int optimisationLevel, ConstraintWidget widget) {
        boolean isOptimizableVerticalMatch;
        boolean isOptimizableHorizontalMatch;
        widget.updateResolutionNodes();
        ResolutionAnchor leftNode = widget.mLeft.getResolutionNode();
        ResolutionAnchor topNode = widget.mTop.getResolutionNode();
        ResolutionAnchor rightNode = widget.mRight.getResolutionNode();
        ResolutionAnchor bottomNode = widget.mBottom.getResolutionNode();
        boolean optimiseDimensions = (optimisationLevel & 8) == 8;
        boolean bl = isOptimizableHorizontalMatch = widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && Optimizer.optimizableMatchConstraint(widget, 0);
        if (leftNode.type != 4 && rightNode.type != 4) {
            if (widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.FIXED || isOptimizableHorizontalMatch && widget.getVisibility() == 8) {
                if (widget.mLeft.mTarget == null && widget.mRight.mTarget == null) {
                    leftNode.setType(1);
                    rightNode.setType(1);
                    if (optimiseDimensions) {
                        rightNode.dependsOn(leftNode, 1, widget.getResolutionWidth());
                    } else {
                        rightNode.dependsOn(leftNode, widget.getWidth());
                    }
                } else if (widget.mLeft.mTarget != null && widget.mRight.mTarget == null) {
                    leftNode.setType(1);
                    rightNode.setType(1);
                    if (optimiseDimensions) {
                        rightNode.dependsOn(leftNode, 1, widget.getResolutionWidth());
                    } else {
                        rightNode.dependsOn(leftNode, widget.getWidth());
                    }
                } else if (widget.mLeft.mTarget == null && widget.mRight.mTarget != null) {
                    leftNode.setType(1);
                    rightNode.setType(1);
                    leftNode.dependsOn(rightNode, -widget.getWidth());
                    if (optimiseDimensions) {
                        leftNode.dependsOn(rightNode, -1, widget.getResolutionWidth());
                    } else {
                        leftNode.dependsOn(rightNode, -widget.getWidth());
                    }
                } else if (widget.mLeft.mTarget != null && widget.mRight.mTarget != null) {
                    leftNode.setType(2);
                    rightNode.setType(2);
                    if (optimiseDimensions) {
                        widget.getResolutionWidth().addDependent(leftNode);
                        widget.getResolutionWidth().addDependent(rightNode);
                        leftNode.setOpposite(rightNode, -1, widget.getResolutionWidth());
                        rightNode.setOpposite(leftNode, 1, widget.getResolutionWidth());
                    } else {
                        leftNode.setOpposite(rightNode, -widget.getWidth());
                        rightNode.setOpposite(leftNode, widget.getWidth());
                    }
                }
            } else if (isOptimizableHorizontalMatch && Optimizer.optimizableRatio(widget, 0, optimisationLevel)) {
                Analyzer.resolveDimensionRatio(widget);
                int width = widget.getWidth();
                leftNode.setType(1);
                rightNode.setType(1);
                if (widget.mLeft.mTarget == null && widget.mRight.mTarget == null) {
                    if (optimiseDimensions) {
                        rightNode.dependsOn(leftNode, 1, widget.getResolutionWidth());
                    } else {
                        rightNode.dependsOn(leftNode, width);
                    }
                } else if (widget.mLeft.mTarget != null && widget.mRight.mTarget == null) {
                    if (optimiseDimensions) {
                        rightNode.dependsOn(leftNode, 1, widget.getResolutionWidth());
                    } else {
                        rightNode.dependsOn(leftNode, width);
                    }
                } else if (widget.mLeft.mTarget == null && widget.mRight.mTarget != null) {
                    if (optimiseDimensions) {
                        leftNode.dependsOn(rightNode, -1, widget.getResolutionWidth());
                    } else {
                        leftNode.dependsOn(rightNode, -width);
                    }
                } else if (widget.mLeft.mTarget != null && widget.mRight.mTarget != null) {
                    if (optimiseDimensions) {
                        widget.getResolutionWidth().addDependent(leftNode);
                        widget.getResolutionWidth().addDependent(rightNode);
                    }
                    if (widget.mDimensionRatio == 0.0f) {
                        leftNode.setType(3);
                        rightNode.setType(3);
                        leftNode.setOpposite(rightNode, 0.0f);
                        rightNode.setOpposite(leftNode, 0.0f);
                    } else {
                        leftNode.setType(2);
                        rightNode.setType(2);
                        leftNode.setOpposite(rightNode, -width);
                        rightNode.setOpposite(leftNode, width);
                        widget.setWidth(width);
                    }
                }
            }
        }
        boolean bl2 = isOptimizableVerticalMatch = widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && Optimizer.optimizableMatchConstraint(widget, 1);
        if (topNode.type != 4 && bottomNode.type != 4) {
            if (widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.FIXED || isOptimizableVerticalMatch && widget.getVisibility() == 8) {
                if (widget.mTop.mTarget == null && widget.mBottom.mTarget == null) {
                    topNode.setType(1);
                    bottomNode.setType(1);
                    if (optimiseDimensions) {
                        bottomNode.dependsOn(topNode, 1, widget.getResolutionHeight());
                    } else {
                        bottomNode.dependsOn(topNode, widget.getHeight());
                    }
                    if (widget.mBaseline.mTarget != null) {
                        widget.mBaseline.getResolutionNode().setType(1);
                        topNode.dependsOn(1, widget.mBaseline.getResolutionNode(), -widget.mBaselineDistance);
                    }
                } else if (widget.mTop.mTarget != null && widget.mBottom.mTarget == null) {
                    topNode.setType(1);
                    bottomNode.setType(1);
                    if (optimiseDimensions) {
                        bottomNode.dependsOn(topNode, 1, widget.getResolutionHeight());
                    } else {
                        bottomNode.dependsOn(topNode, widget.getHeight());
                    }
                    if (widget.mBaselineDistance > 0) {
                        widget.mBaseline.getResolutionNode().dependsOn(1, topNode, widget.mBaselineDistance);
                    }
                } else if (widget.mTop.mTarget == null && widget.mBottom.mTarget != null) {
                    topNode.setType(1);
                    bottomNode.setType(1);
                    if (optimiseDimensions) {
                        topNode.dependsOn(bottomNode, -1, widget.getResolutionHeight());
                    } else {
                        topNode.dependsOn(bottomNode, -widget.getHeight());
                    }
                    if (widget.mBaselineDistance > 0) {
                        widget.mBaseline.getResolutionNode().dependsOn(1, topNode, widget.mBaselineDistance);
                    }
                } else if (widget.mTop.mTarget != null && widget.mBottom.mTarget != null) {
                    topNode.setType(2);
                    bottomNode.setType(2);
                    if (optimiseDimensions) {
                        topNode.setOpposite(bottomNode, -1, widget.getResolutionHeight());
                        bottomNode.setOpposite(topNode, 1, widget.getResolutionHeight());
                        widget.getResolutionHeight().addDependent(topNode);
                        widget.getResolutionWidth().addDependent(bottomNode);
                    } else {
                        topNode.setOpposite(bottomNode, -widget.getHeight());
                        bottomNode.setOpposite(topNode, widget.getHeight());
                    }
                    if (widget.mBaselineDistance > 0) {
                        widget.mBaseline.getResolutionNode().dependsOn(1, topNode, widget.mBaselineDistance);
                    }
                }
            } else if (isOptimizableVerticalMatch && Optimizer.optimizableRatio(widget, 1, optimisationLevel)) {
                Analyzer.resolveDimensionRatio(widget);
                int height = widget.getHeight();
                topNode.setType(1);
                bottomNode.setType(1);
                if (widget.mTop.mTarget == null && widget.mBottom.mTarget == null) {
                    if (optimiseDimensions) {
                        bottomNode.dependsOn(topNode, 1, widget.getResolutionHeight());
                    } else {
                        bottomNode.dependsOn(topNode, height);
                    }
                } else if (widget.mTop.mTarget != null && widget.mBottom.mTarget == null) {
                    if (optimiseDimensions) {
                        bottomNode.dependsOn(topNode, 1, widget.getResolutionHeight());
                    } else {
                        bottomNode.dependsOn(topNode, height);
                    }
                } else if (widget.mTop.mTarget == null && widget.mBottom.mTarget != null) {
                    if (optimiseDimensions) {
                        topNode.dependsOn(bottomNode, -1, widget.getResolutionHeight());
                    } else {
                        topNode.dependsOn(bottomNode, -height);
                    }
                } else if (widget.mTop.mTarget != null && widget.mBottom.mTarget != null) {
                    if (optimiseDimensions) {
                        widget.getResolutionHeight().addDependent(topNode);
                        widget.getResolutionWidth().addDependent(bottomNode);
                    }
                    if (widget.mDimensionRatio == 0.0f) {
                        topNode.setType(3);
                        bottomNode.setType(3);
                        topNode.setOpposite(bottomNode, 0.0f);
                        bottomNode.setOpposite(topNode, 0.0f);
                    } else {
                        topNode.setType(2);
                        bottomNode.setType(2);
                        topNode.setOpposite(bottomNode, -height);
                        bottomNode.setOpposite(topNode, height);
                        widget.setHeight(height);
                        if (widget.mBaselineDistance > 0) {
                            widget.mBaseline.getResolutionNode().dependsOn(1, topNode, widget.mBaselineDistance);
                        }
                    }
                }
            }
        }
    }

    static boolean applyChainOptimized(ConstraintWidgetContainer container, LinearSystem system, int orientation, int offset, ChainHead chainHead) {
        block36: {
            float distance;
            float firstOffset;
            float extraMargin;
            ResolutionAnchor firstNode;
            int numVisibleWidgets;
            boolean isChainSpreadInside;
            boolean isChainSpread;
            ConstraintWidget next;
            ConstraintWidget widget;
            ConstraintWidget firstVisibleWidget;
            ConstraintWidget last;
            ConstraintWidget first;
            block35: {
                first = chainHead.mFirst;
                last = chainHead.mLast;
                firstVisibleWidget = chainHead.mFirstVisibleWidget;
                ConstraintWidget lastVisibleWidget = chainHead.mLastVisibleWidget;
                ConstraintWidget head = chainHead.mHead;
                widget = first;
                next = null;
                boolean done = false;
                int numMatchConstraints = chainHead.mWidgetsMatchCount;
                float totalWeights = chainHead.mTotalWeight;
                ConstraintWidget firstMatchConstraintsWidget = chainHead.mFirstMatchConstraintWidget;
                ConstraintWidget previousMatchConstraintsWidget = chainHead.mLastMatchConstraintWidget;
                boolean isWrapContent = container.mListDimensionBehaviors[orientation] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                isChainSpread = false;
                isChainSpreadInside = false;
                boolean isChainPacked = false;
                float totalSize = chainHead.mTotalSize;
                float totalMargins = chainHead.mTotalMargins;
                numVisibleWidgets = chainHead.mVisibleWidgets;
                if (!chainHead.mOptimizable) {
                    return false;
                }
                if (orientation == 0) {
                    isChainSpread = head.mHorizontalChainStyle == 0;
                    isChainSpreadInside = head.mHorizontalChainStyle == 1;
                    isChainPacked = head.mHorizontalChainStyle == 2;
                } else {
                    isChainSpread = head.mVerticalChainStyle == 0;
                    isChainSpreadInside = head.mVerticalChainStyle == 1;
                    isChainPacked = head.mVerticalChainStyle == 2;
                }
                firstNode = first.mListAnchors[offset].getResolutionNode();
                ResolutionAnchor lastNode = last.mListAnchors[offset + 1].getResolutionNode();
                if (firstNode.target == null || lastNode.target == null) {
                    return false;
                }
                if (firstNode.target.state != 1 || lastNode.target.state != 1) {
                    return false;
                }
                extraMargin = 0.0f;
                if (isChainPacked || isChainSpread || isChainSpreadInside) {
                    if (firstVisibleWidget != null) {
                        extraMargin = firstVisibleWidget.mListAnchors[offset].getMargin();
                    }
                    if (lastVisibleWidget != null) {
                        extraMargin += (float)lastVisibleWidget.mListAnchors[offset + 1].getMargin();
                    }
                }
                firstOffset = firstNode.target.resolvedOffset;
                float lastOffset = lastNode.target.resolvedOffset;
                distance = 0.0f;
                distance = firstOffset < lastOffset ? lastOffset - firstOffset - totalSize : firstOffset - lastOffset - totalSize;
                if (numMatchConstraints > 0) {
                    if (widget.getParent() != null && widget.getParent().mListDimensionBehaviors[orientation] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        return false;
                    }
                    if (firstVisibleWidget != null) {
                        distance -= (float)firstVisibleWidget.mListAnchors[offset].getMargin();
                    }
                    if (lastVisibleWidget != null) {
                        distance -= (float)lastVisibleWidget.mListAnchors[offset + 1].getMargin();
                    }
                    widget = first;
                    float position = firstOffset;
                    while (widget != null) {
                        if (LinearSystem.sMetrics != null) {
                            --LinearSystem.sMetrics.nonresolvedWidgets;
                            ++LinearSystem.sMetrics.resolvedWidgets;
                            ++LinearSystem.sMetrics.chainConnectionResolved;
                        }
                        if ((next = widget.mNextChainWidget[orientation]) != null || widget == last) {
                            float dimension;
                            if (widget.getDimensionBehaviour(orientation) == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                                dimension = distance / (float)numMatchConstraints;
                                if (totalWeights > 0.0f) {
                                    dimension = widget.mWeight[orientation] == -1.0f ? 0.0f : widget.mWeight[orientation] * distance / totalWeights;
                                }
                                if (widget.getVisibility() == 8) {
                                    dimension = 0.0f;
                                }
                            } else {
                                dimension = widget.getLength(orientation);
                            }
                            widget.mListAnchors[offset].getResolutionNode().resolve(firstNode.resolvedTarget, position += (float)widget.mListAnchors[offset].getMargin());
                            widget.mListAnchors[offset + 1].getResolutionNode().resolve(firstNode.resolvedTarget, position + dimension);
                            widget.mListAnchors[offset].getResolutionNode().addResolvedValue(system);
                            widget.mListAnchors[offset + 1].getResolutionNode().addResolvedValue(system);
                            position += dimension;
                            position += (float)widget.mListAnchors[offset + 1].getMargin();
                        }
                        widget = next;
                    }
                    return true;
                }
                if (distance < 0.0f) {
                    isChainSpread = false;
                    isChainSpreadInside = false;
                    isChainPacked = true;
                }
                if (!isChainPacked) break block35;
                distance -= extraMargin;
                widget = first;
                distance = firstOffset + distance * first.getBiasPercent(orientation);
                while (widget != null) {
                    if (LinearSystem.sMetrics != null) {
                        --LinearSystem.sMetrics.nonresolvedWidgets;
                        ++LinearSystem.sMetrics.resolvedWidgets;
                        ++LinearSystem.sMetrics.chainConnectionResolved;
                    }
                    if ((next = widget.mNextChainWidget[orientation]) != null || widget == last) {
                        float dimension = 0.0f;
                        dimension = orientation == 0 ? (float)widget.getWidth() : (float)widget.getHeight();
                        widget.mListAnchors[offset].getResolutionNode().resolve(firstNode.resolvedTarget, distance += (float)widget.mListAnchors[offset].getMargin());
                        widget.mListAnchors[offset + 1].getResolutionNode().resolve(firstNode.resolvedTarget, distance + dimension);
                        widget.mListAnchors[offset].getResolutionNode().addResolvedValue(system);
                        widget.mListAnchors[offset + 1].getResolutionNode().addResolvedValue(system);
                        distance += dimension;
                        distance += (float)widget.mListAnchors[offset + 1].getMargin();
                    }
                    widget = next;
                }
                break block36;
            }
            if (!isChainSpread && !isChainSpreadInside) break block36;
            if (isChainSpread) {
                distance -= extraMargin;
            } else if (isChainSpreadInside) {
                distance -= extraMargin;
            }
            widget = first;
            float gap = distance / (float)(numVisibleWidgets + 1);
            if (isChainSpreadInside) {
                gap = numVisibleWidgets > 1 ? distance / (float)(numVisibleWidgets - 1) : distance / 2.0f;
            }
            distance = firstOffset;
            if (first.getVisibility() != 8) {
                distance += gap;
            }
            if (isChainSpreadInside && numVisibleWidgets > 1) {
                distance = firstOffset + (float)firstVisibleWidget.mListAnchors[offset].getMargin();
            }
            if (isChainSpread && firstVisibleWidget != null) {
                distance += (float)firstVisibleWidget.mListAnchors[offset].getMargin();
            }
            while (widget != null) {
                if (LinearSystem.sMetrics != null) {
                    --LinearSystem.sMetrics.nonresolvedWidgets;
                    ++LinearSystem.sMetrics.resolvedWidgets;
                    ++LinearSystem.sMetrics.chainConnectionResolved;
                }
                if ((next = widget.mNextChainWidget[orientation]) != null || widget == last) {
                    float dimension = 0.0f;
                    dimension = orientation == 0 ? (float)widget.getWidth() : (float)widget.getHeight();
                    if (widget != firstVisibleWidget) {
                        distance += (float)widget.mListAnchors[offset].getMargin();
                    }
                    widget.mListAnchors[offset].getResolutionNode().resolve(firstNode.resolvedTarget, distance);
                    widget.mListAnchors[offset + 1].getResolutionNode().resolve(firstNode.resolvedTarget, distance + dimension);
                    widget.mListAnchors[offset].getResolutionNode().addResolvedValue(system);
                    widget.mListAnchors[offset + 1].getResolutionNode().addResolvedValue(system);
                    distance += dimension + (float)widget.mListAnchors[offset + 1].getMargin();
                    if (next != null && next.getVisibility() != 8) {
                        distance += gap;
                    }
                }
                widget = next;
            }
        }
        return true;
    }

    static void setOptimizedWidget(ConstraintWidget widget, int orientation, int resolvedOffset) {
        int startOffset = orientation * 2;
        int endOffset = startOffset + 1;
        widget.mListAnchors[startOffset].getResolutionNode().resolvedTarget = widget.getParent().mListAnchors[startOffset].getResolutionNode();
        widget.mListAnchors[startOffset].getResolutionNode().resolvedOffset = resolvedOffset;
        widget.mListAnchors[startOffset].getResolutionNode().state = 1;
        widget.mListAnchors[endOffset].getResolutionNode().resolvedTarget = widget.getParent().mListAnchors[startOffset].getResolutionNode();
        widget.mListAnchors[endOffset].getResolutionNode().resolvedOffset = widget.getLength(orientation) + resolvedOffset;
        widget.mListAnchors[endOffset].getResolutionNode().state = 1;
    }

    public static final boolean enabled(int optimizationLevel, int optimization) {
        return (optimizationLevel & optimization) == optimization;
    }
}

