/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.hardware.display.DisplayManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Display;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.annotation.RestrictTo;
import androidx.camera.core.Camera;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.FocusMeteringResult;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.core.VideoCapture;
import androidx.camera.core.impl.LensFacingConverter;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.view.CameraXModule;
import androidx.camera.view.FlashModeConverter;
import androidx.camera.view.PreviewView;
import androidx.camera.view.R;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.util.concurrent.Executor;

public final class CameraView
extends FrameLayout {
    static final String TAG = CameraView.class.getSimpleName();
    static final int INDEFINITE_VIDEO_DURATION = -1;
    static final int INDEFINITE_VIDEO_SIZE = -1;
    private static final String EXTRA_SUPER = "super";
    private static final String EXTRA_ZOOM_RATIO = "zoom_ratio";
    private static final String EXTRA_PINCH_TO_ZOOM_ENABLED = "pinch_to_zoom_enabled";
    private static final String EXTRA_FLASH = "flash";
    private static final String EXTRA_MAX_VIDEO_DURATION = "max_video_duration";
    private static final String EXTRA_MAX_VIDEO_SIZE = "max_video_size";
    private static final String EXTRA_SCALE_TYPE = "scale_type";
    private static final String EXTRA_CAMERA_DIRECTION = "camera_direction";
    private static final String EXTRA_CAPTURE_MODE = "captureMode";
    private static final int LENS_FACING_NONE = 0;
    private static final int LENS_FACING_FRONT = 1;
    private static final int LENS_FACING_BACK = 2;
    private static final int FLASH_MODE_AUTO = 1;
    private static final int FLASH_MODE_ON = 2;
    private static final int FLASH_MODE_OFF = 4;
    private long mDownEventTimestamp;
    private PinchToZoomGestureDetector mPinchToZoomGestureDetector;
    private boolean mIsPinchToZoomEnabled = true;
    CameraXModule mCameraModule;
    private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

        public void onDisplayAdded(int displayId) {
        }

        public void onDisplayRemoved(int displayId) {
        }

        public void onDisplayChanged(int displayId) {
            CameraView.this.mCameraModule.invalidateView();
        }
    };
    private PreviewView mPreviewView;
    private MotionEvent mUpEvent;

    public CameraView(@NonNull Context context) {
        this(context, null);
    }

    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    @RequiresApi(value=21)
    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void bindToLifecycle(@NonNull LifecycleOwner lifecycleOwner) {
        this.mCameraModule.bindToLifecycle(lifecycleOwner);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        this.mPreviewView = new PreviewView(this.getContext());
        this.addView((View)this.mPreviewView, 0);
        this.mCameraModule = new CameraXModule(this);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CameraView);
            this.setScaleType(PreviewView.ScaleType.fromId(a.getInteger(R.styleable.CameraView_scaleType, this.getScaleType().getId())));
            this.setPinchToZoomEnabled(a.getBoolean(R.styleable.CameraView_pinchToZoomEnabled, this.isPinchToZoomEnabled()));
            this.setCaptureMode(CaptureMode.fromId(a.getInteger(R.styleable.CameraView_captureMode, this.getCaptureMode().getId())));
            int lensFacing = a.getInt(R.styleable.CameraView_lensFacing, 2);
            switch (lensFacing) {
                case 0: {
                    this.setCameraLensFacing(null);
                    break;
                }
                case 1: {
                    this.setCameraLensFacing(0);
                    break;
                }
                case 2: {
                    this.setCameraLensFacing(1);
                    break;
                }
            }
            int flashMode = a.getInt(R.styleable.CameraView_flash, 0);
            switch (flashMode) {
                case 1: {
                    this.setFlash(0);
                    break;
                }
                case 2: {
                    this.setFlash(1);
                    break;
                }
                case 4: {
                    this.setFlash(2);
                    break;
                }
            }
            a.recycle();
        }
        if (this.getBackground() == null) {
            this.setBackgroundColor(-15658735);
        }
        this.mPinchToZoomGestureDetector = new PinchToZoomGestureDetector(context);
    }

    @NonNull
    protected FrameLayout.LayoutParams generateDefaultLayoutParams() {
        return new FrameLayout.LayoutParams(-1, -1);
    }

    @NonNull
    protected Parcelable onSaveInstanceState() {
        Bundle state = new Bundle();
        state.putParcelable(EXTRA_SUPER, super.onSaveInstanceState());
        state.putInt(EXTRA_SCALE_TYPE, this.getScaleType().getId());
        state.putFloat(EXTRA_ZOOM_RATIO, this.getZoomRatio());
        state.putBoolean(EXTRA_PINCH_TO_ZOOM_ENABLED, this.isPinchToZoomEnabled());
        state.putString(EXTRA_FLASH, FlashModeConverter.nameOf(this.getFlash()));
        state.putLong(EXTRA_MAX_VIDEO_DURATION, this.getMaxVideoDuration());
        state.putLong(EXTRA_MAX_VIDEO_SIZE, this.getMaxVideoSize());
        if (this.getCameraLensFacing() != null) {
            state.putString(EXTRA_CAMERA_DIRECTION, LensFacingConverter.nameOf((int)this.getCameraLensFacing()));
        }
        state.putInt(EXTRA_CAPTURE_MODE, this.getCaptureMode().getId());
        return state;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable savedState) {
        if (savedState instanceof Bundle) {
            Bundle state = (Bundle)savedState;
            super.onRestoreInstanceState(state.getParcelable(EXTRA_SUPER));
            this.setScaleType(PreviewView.ScaleType.fromId(state.getInt(EXTRA_SCALE_TYPE)));
            this.setZoomRatio(state.getFloat(EXTRA_ZOOM_RATIO));
            this.setPinchToZoomEnabled(state.getBoolean(EXTRA_PINCH_TO_ZOOM_ENABLED));
            this.setFlash(FlashModeConverter.valueOf(state.getString(EXTRA_FLASH)));
            this.setMaxVideoDuration(state.getLong(EXTRA_MAX_VIDEO_DURATION));
            this.setMaxVideoSize(state.getLong(EXTRA_MAX_VIDEO_SIZE));
            String lensFacingString = state.getString(EXTRA_CAMERA_DIRECTION);
            this.setCameraLensFacing(TextUtils.isEmpty((CharSequence)lensFacingString) ? null : Integer.valueOf(LensFacingConverter.valueOf((String)lensFacingString)));
            this.setCaptureMode(CaptureMode.fromId(state.getInt(EXTRA_CAPTURE_MODE)));
        } else {
            super.onRestoreInstanceState(savedState);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        DisplayManager dpyMgr = (DisplayManager)this.getContext().getSystemService("display");
        dpyMgr.registerDisplayListener(this.mDisplayListener, new Handler(Looper.getMainLooper()));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        DisplayManager dpyMgr = (DisplayManager)this.getContext().getSystemService("display");
        dpyMgr.unregisterDisplayListener(this.mDisplayListener);
    }

    @NonNull
    public LiveData<PreviewView.StreamState> getPreviewStreamState() {
        return this.mPreviewView.getPreviewStreamState();
    }

    @NonNull
    PreviewView getPreviewView() {
        return this.mPreviewView;
    }

    @SuppressLint(value={"MissingPermission"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.getMeasuredWidth() > 0 && this.getMeasuredHeight() > 0) {
            this.mCameraModule.bindToLifecycleAfterViewMeasured();
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @SuppressLint(value={"MissingPermission"})
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mCameraModule.bindToLifecycleAfterViewMeasured();
        this.mCameraModule.invalidateView();
        super.onLayout(changed, left, top, right, bottom);
    }

    int getDisplaySurfaceRotation() {
        Display display = this.getDisplay();
        if (display == null) {
            return 0;
        }
        return display.getRotation();
    }

    @NonNull
    public PreviewView.ScaleType getScaleType() {
        return this.mPreviewView.getScaleType();
    }

    public void setScaleType(@NonNull PreviewView.ScaleType scaleType) {
        this.mPreviewView.setScaleType(scaleType);
    }

    @NonNull
    public CaptureMode getCaptureMode() {
        return this.mCameraModule.getCaptureMode();
    }

    public void setCaptureMode(@NonNull CaptureMode captureMode) {
        this.mCameraModule.setCaptureMode(captureMode);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public long getMaxVideoDuration() {
        return this.mCameraModule.getMaxVideoDuration();
    }

    private void setMaxVideoDuration(long duration) {
        this.mCameraModule.setMaxVideoDuration(duration);
    }

    private long getMaxVideoSize() {
        return this.mCameraModule.getMaxVideoSize();
    }

    private void setMaxVideoSize(long size) {
        this.mCameraModule.setMaxVideoSize(size);
    }

    public void takePicture(@NonNull Executor executor, @NonNull ImageCapture.OnImageCapturedCallback callback) {
        this.mCameraModule.takePicture(executor, callback);
    }

    public void takePicture(@NonNull ImageCapture.OutputFileOptions outputFileOptions, @NonNull Executor executor, @NonNull ImageCapture.OnImageSavedCallback callback) {
        this.mCameraModule.takePicture(outputFileOptions, executor, callback);
    }

    public void startRecording(@NonNull File file, @NonNull Executor executor, @NonNull VideoCapture.OnVideoSavedCallback callback) {
        VideoCapture.OutputFileOptions options = new VideoCapture.OutputFileOptions.Builder(file).build();
        this.startRecording(options, executor, callback);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void startRecording(@NonNull VideoCapture.OutputFileOptions outputFileOptions, @NonNull Executor executor, @NonNull VideoCapture.OnVideoSavedCallback callback) {
        this.mCameraModule.startRecording(outputFileOptions, executor, callback);
    }

    public void stopRecording() {
        this.mCameraModule.stopRecording();
    }

    public boolean isRecording() {
        return this.mCameraModule.isRecording();
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public boolean hasCameraWithLensFacing(int lensFacing) {
        return this.mCameraModule.hasCameraWithLensFacing(lensFacing);
    }

    public void toggleCamera() {
        this.mCameraModule.toggleCamera();
    }

    public void setCameraLensFacing(@Nullable Integer lensFacing) {
        this.mCameraModule.setCameraLensFacing(lensFacing);
    }

    @Nullable
    public Integer getCameraLensFacing() {
        return this.mCameraModule.getLensFacing();
    }

    public int getFlash() {
        return this.mCameraModule.getFlash();
    }

    public void setFlash(int flashMode) {
        this.mCameraModule.setFlash(flashMode);
    }

    private long delta() {
        return System.currentTimeMillis() - this.mDownEventTimestamp;
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.mCameraModule.isPaused()) {
            return false;
        }
        if (this.isPinchToZoomEnabled()) {
            this.mPinchToZoomGestureDetector.onTouchEvent(event);
        }
        if (event.getPointerCount() == 2 && this.isPinchToZoomEnabled() && this.isZoomSupported()) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                this.mDownEventTimestamp = System.currentTimeMillis();
                break;
            }
            case 1: {
                if (this.delta() >= (long)ViewConfiguration.getLongPressTimeout() || !this.mCameraModule.isBoundToLifecycle()) break;
                this.mUpEvent = event;
                this.performClick();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean performClick() {
        super.performClick();
        float x = this.mUpEvent != null ? this.mUpEvent.getX() : this.getX() + (float)this.getWidth() / 2.0f;
        float y = this.mUpEvent != null ? this.mUpEvent.getY() : this.getY() + (float)this.getHeight() / 2.0f;
        this.mUpEvent = null;
        Camera camera = this.mCameraModule.getCamera();
        if (camera != null) {
            MeteringPointFactory pointFactory = this.mPreviewView.getMeteringPointFactory();
            float afPointWidth = 0.16666667f;
            float aePointWidth = afPointWidth * 1.5f;
            MeteringPoint afPoint = pointFactory.createPoint(x, y, afPointWidth);
            MeteringPoint aePoint = pointFactory.createPoint(x, y, aePointWidth);
            ListenableFuture future = camera.getCameraControl().startFocusAndMetering(new FocusMeteringAction.Builder(afPoint, 1).addPoint(aePoint, 2).build());
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<FocusMeteringResult>(){

                public void onSuccess(@Nullable FocusMeteringResult result) {
                }

                public void onFailure(Throwable t) {
                    throw new RuntimeException(t);
                }
            }, (Executor)CameraXExecutors.directExecutor());
        } else {
            Logger.d((String)TAG, (String)"cannot access camera");
        }
        return true;
    }

    float rangeLimit(float val, float max, float min) {
        return Math.min(Math.max(val, min), max);
    }

    public boolean isPinchToZoomEnabled() {
        return this.mIsPinchToZoomEnabled;
    }

    public void setPinchToZoomEnabled(boolean enabled) {
        this.mIsPinchToZoomEnabled = enabled;
    }

    public float getZoomRatio() {
        return this.mCameraModule.getZoomRatio();
    }

    public void setZoomRatio(float zoomRatio) {
        this.mCameraModule.setZoomRatio(zoomRatio);
    }

    public float getMinZoomRatio() {
        return this.mCameraModule.getMinZoomRatio();
    }

    public float getMaxZoomRatio() {
        return this.mCameraModule.getMaxZoomRatio();
    }

    public boolean isZoomSupported() {
        return this.mCameraModule.isZoomSupported();
    }

    public void enableTorch(boolean torch) {
        this.mCameraModule.enableTorch(torch);
    }

    public boolean isTorchOn() {
        return this.mCameraModule.isTorchOn();
    }

    private class PinchToZoomGestureDetector
    extends ScaleGestureDetector
    implements ScaleGestureDetector.OnScaleGestureListener {
        PinchToZoomGestureDetector(Context context) {
            this(context, new S());
        }

        PinchToZoomGestureDetector(Context context, S s) {
            super(context, (ScaleGestureDetector.OnScaleGestureListener)s);
            s.setRealGestureDetector(this);
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float scale = detector.getScaleFactor();
            scale = scale > 1.0f ? 1.0f + (scale - 1.0f) * 2.0f : 1.0f - (1.0f - scale) * 2.0f;
            float newRatio = CameraView.this.getZoomRatio() * scale;
            newRatio = CameraView.this.rangeLimit(newRatio, CameraView.this.getMaxZoomRatio(), CameraView.this.getMinZoomRatio());
            CameraView.this.setZoomRatio(newRatio);
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
        }
    }

    static class S
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleGestureDetector.OnScaleGestureListener mListener;

        S() {
        }

        void setRealGestureDetector(ScaleGestureDetector.OnScaleGestureListener l) {
            this.mListener = l;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            return this.mListener.onScale(detector);
        }
    }

    public static enum CaptureMode {
        IMAGE(0),
        VIDEO(1),
        MIXED(2);

        private final int mId;

        int getId() {
            return this.mId;
        }

        private CaptureMode(int id) {
            this.mId = id;
        }

        static CaptureMode fromId(int id) {
            for (CaptureMode f : CaptureMode.values()) {
                if (f.mId != id) continue;
                return f;
            }
            throw new IllegalArgumentException();
        }
    }
}

