/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import android.util.Size;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.experimental.UseExperimental;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ExperimentalUseCaseGroup;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseGroup;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.lifecycle.ProcessCameraProvider;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;

abstract class CameraController {
    private static final String TAG = "CameraController";
    static final CameraSelector CAMERA_SELECTOR = CameraSelector.DEFAULT_BACK_CAMERA;
    @Nullable
    Preview mPreview;
    @Nullable
    private Size mPreviewSize;
    @Nullable
    Camera mCamera;
    @Nullable
    ProcessCameraProvider mCameraProvider;

    CameraController(@NonNull Context context) {
        Futures.addCallback((ListenableFuture)ProcessCameraProvider.getInstance((Context)context), (FutureCallback)new FutureCallback<ProcessCameraProvider>(){

            @SuppressLint(value={"MissingPermission"})
            public void onSuccess(@Nullable ProcessCameraProvider provider) {
                CameraController.this.mCameraProvider = provider;
                CameraController.this.mCamera = CameraController.this.startCamera();
            }

            public void onFailure(Throwable t) {
                throw new RuntimeException("CameraX failed to initialize.", t);
            }
        }, (Executor)CameraXExecutors.mainThreadExecutor());
    }

    @Nullable
    abstract Camera startCamera();

    @SuppressLint(value={"MissingPermission"})
    @MainThread
    void attachPreviewSurface(Preview.SurfaceProvider surfaceProvider, int width, int height) {
        Threads.checkMainThread();
        if (width == 0 || height == 0) {
            return;
        }
        Size newPreviewSize = new Size(width, height);
        if (newPreviewSize.equals((Object)this.mPreviewSize) && this.mPreview != null) {
            this.mPreview.setSurfaceProvider(surfaceProvider);
            return;
        }
        if (this.mPreview != null && this.mCameraProvider != null) {
            this.mCameraProvider.unbind(new UseCase[]{this.mPreview});
        }
        this.mPreview = this.createPreview(surfaceProvider, newPreviewSize);
        this.mPreviewSize = newPreviewSize;
        this.mCamera = this.startCamera();
    }

    @MainThread
    void clearPreviewSurface() {
        Threads.checkMainThread();
        if (this.mCameraProvider != null) {
            this.mCameraProvider.unbindAll();
        }
        this.mPreviewSize = null;
        this.mPreview = null;
        this.mCamera = null;
    }

    @MainThread
    Preview createPreview(Preview.SurfaceProvider surfaceProvider, Size previewSize) {
        Threads.checkMainThread();
        Preview preview = new Preview.Builder().setTargetResolution(previewSize).build();
        preview.setSurfaceProvider(surfaceProvider);
        return preview;
    }

    @UseExperimental(markerClass=ExperimentalUseCaseGroup.class)
    protected UseCaseGroup createUseCaseGroup() {
        UseCaseGroup.Builder builder = new UseCaseGroup.Builder();
        if (this.mPreview == null) {
            Log.d((String)TAG, (String)"PreviewView is not ready.");
            return null;
        }
        builder.addUseCase((UseCase)this.mPreview);
        return builder.build();
    }
}

