/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.camera.core.MeteringPointFactory;

public class TextureViewMeteringPointFactory
extends MeteringPointFactory {
    private final TextureView mTextureView;

    public TextureViewMeteringPointFactory(@NonNull TextureView textureView) {
        this.mTextureView = textureView;
    }

    @NonNull
    protected PointF translatePoint(float x, float y) {
        Matrix transform = new Matrix();
        this.mTextureView.getTransform(transform);
        Matrix inverse = new Matrix();
        transform.invert(inverse);
        float[] pt = new float[]{x, y};
        inverse.mapPoints(pt);
        float[] surfaceTextureMat = new float[16];
        this.mTextureView.getSurfaceTexture().getTransformMatrix(surfaceTextureMat);
        Matrix surfaceTextureTransform = this.glMatrixToGraphicsMatrix(surfaceTextureMat);
        float[] pt2 = new float[]{pt[0] / (float)this.mTextureView.getWidth(), ((float)this.mTextureView.getHeight() - pt[1]) / (float)this.mTextureView.getHeight()};
        surfaceTextureTransform.mapPoints(pt2);
        return new PointF(pt2[0], pt2[1]);
    }

    private Matrix glMatrixToGraphicsMatrix(float[] glMatrix) {
        float[] convert = new float[]{glMatrix[0], glMatrix[4], glMatrix[12], glMatrix[1], glMatrix[5], glMatrix[13], glMatrix[3], glMatrix[7], glMatrix[15]};
        Matrix graphicsMatrix = new Matrix();
        graphicsMatrix.setValues(convert);
        return graphicsMatrix;
    }
}

