/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.os.Looper;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.UiThread;
import androidx.camera.core.AspectRatio;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.CameraOrientationUtil;
import androidx.camera.core.CameraX;
import androidx.camera.core.FlashMode;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureConfig;
import androidx.camera.core.Preview;
import androidx.camera.core.PreviewConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.VideoCapture;
import androidx.camera.core.VideoCaptureConfig;
import androidx.camera.view.CameraView;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

final class CameraXModule {
    public static final String TAG = "CameraXModule";
    private static final int MAX_VIEW_DIMENSION = 2000;
    private static final float UNITY_ZOOM_SCALE = 1.0f;
    private static final float ZOOM_NOT_SUPPORTED = 1.0f;
    private static final Rational ASPECT_RATIO_16_9 = new Rational(16, 9);
    private static final Rational ASPECT_RATIO_4_3 = new Rational(4, 3);
    private static final Rational ASPECT_RATIO_9_16 = new Rational(9, 16);
    private static final Rational ASPECT_RATIO_3_4 = new Rational(3, 4);
    private final CameraManager mCameraManager;
    private final PreviewConfig.Builder mPreviewConfigBuilder;
    private final VideoCaptureConfig.Builder mVideoCaptureConfigBuilder;
    private final ImageCaptureConfig.Builder mImageCaptureConfigBuilder;
    private final CameraView mCameraView;
    final AtomicBoolean mVideoIsRecording = new AtomicBoolean(false);
    private CameraView.CaptureMode mCaptureMode = CameraView.CaptureMode.IMAGE;
    private long mMaxVideoDuration = -1L;
    private long mMaxVideoSize = -1L;
    private FlashMode mFlash = FlashMode.OFF;
    @Nullable
    private ImageCapture mImageCapture;
    @Nullable
    private VideoCapture mVideoCapture;
    @Nullable
    Preview mPreview;
    @Nullable
    LifecycleOwner mCurrentLifecycle;
    private final LifecycleObserver mCurrentLifecycleObserver = new LifecycleObserver(){

        @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
        public void onDestroy(LifecycleOwner owner) {
            if (owner == CameraXModule.this.mCurrentLifecycle) {
                CameraXModule.this.clearCurrentLifecycle();
                CameraXModule.this.mPreview.removePreviewOutputListener();
            }
        }
    };
    @Nullable
    private LifecycleOwner mNewLifecycle;
    private float mZoomLevel = 1.0f;
    @Nullable
    private Rect mCropRegion;
    @Nullable
    private CameraX.LensFacing mCameraLensFacing = CameraX.LensFacing.BACK;

    CameraXModule(CameraView view) {
        this.mCameraView = view;
        this.mCameraManager = (CameraManager)view.getContext().getSystemService("camera");
        this.mPreviewConfigBuilder = new PreviewConfig.Builder().setTargetName("Preview");
        this.mImageCaptureConfigBuilder = new ImageCaptureConfig.Builder().setTargetName("ImageCapture");
        this.mVideoCaptureConfigBuilder = new VideoCaptureConfig.Builder().setTargetName("VideoCapture");
    }

    private static Rect rescaleViewRectToSensorRect(Rect view, Rect sensor) {
        int newWidth = Math.round((float)(view.width() * sensor.width()) / 2000.0f);
        int newHeight = Math.round((float)(view.height() * sensor.height()) / 2000.0f);
        int halfViewDimension = 1000;
        int leftOffset = Math.round((float)((view.left + halfViewDimension) * sensor.width()) / 2000.0f) + sensor.left;
        int topOffset = Math.round((float)((view.top + halfViewDimension) * sensor.height()) / 2000.0f) + sensor.top;
        Rect scaled = new Rect();
        scaled.left = leftOffset;
        scaled.top = topOffset;
        scaled.right = scaled.left + newWidth;
        scaled.bottom = scaled.top + newHeight;
        return scaled;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void bindToLifecycle(LifecycleOwner lifecycleOwner) {
        this.mNewLifecycle = lifecycleOwner;
        if (this.getMeasuredWidth() > 0 && this.getMeasuredHeight() > 0) {
            this.bindToLifecycleAfterViewMeasured();
        }
    }

    @RequiresPermission(value="android.permission.CAMERA")
    void bindToLifecycleAfterViewMeasured() {
        Rational targetAspectRatio;
        boolean isDisplayPortrait;
        int cameraOrientation;
        if (this.mNewLifecycle == null) {
            return;
        }
        this.clearCurrentLifecycle();
        this.mCurrentLifecycle = this.mNewLifecycle;
        this.mNewLifecycle = null;
        if (this.mCurrentLifecycle.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            this.mCurrentLifecycle = null;
            throw new IllegalArgumentException("Cannot bind to lifecycle in a destroyed state.");
        }
        try {
            Set<CameraX.LensFacing> available = this.getAvailableCameraLensFacing();
            if (available.isEmpty()) {
                Log.w((String)TAG, (String)"Unable to bindToLifeCycle since no cameras available");
                this.mCameraLensFacing = null;
            }
            if (this.mCameraLensFacing != null && !available.contains(this.mCameraLensFacing)) {
                Log.w((String)TAG, (String)("Camera does not exist with direction " + this.mCameraLensFacing));
                this.mCameraLensFacing = available.iterator().next();
                Log.w((String)TAG, (String)("Defaulting to primary camera with direction " + this.mCameraLensFacing));
            }
            if (this.mCameraLensFacing == null) {
                return;
            }
            CameraInfo cameraInfo = CameraX.getCameraInfo((CameraX.LensFacing)this.getLensFacing());
            cameraOrientation = cameraInfo.getSensorRotationDegrees();
        }
        catch (CameraInfoUnavailableException e) {
            throw new IllegalStateException("Unable to get Camera Info.", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to bind to lifecycle.", e);
        }
        boolean bl = isDisplayPortrait = this.getDisplayRotationDegrees() == 0 || this.getDisplayRotationDegrees() == 180;
        if (this.getCaptureMode() == CameraView.CaptureMode.IMAGE) {
            this.mImageCaptureConfigBuilder.setTargetAspectRatio(AspectRatio.RATIO_4_3);
            targetAspectRatio = isDisplayPortrait ? ASPECT_RATIO_3_4 : ASPECT_RATIO_4_3;
        } else {
            this.mImageCaptureConfigBuilder.setTargetAspectRatio(AspectRatio.RATIO_16_9);
            targetAspectRatio = isDisplayPortrait ? ASPECT_RATIO_9_16 : ASPECT_RATIO_16_9;
        }
        this.mImageCaptureConfigBuilder.setTargetRotation(this.getDisplaySurfaceRotation());
        this.mImageCaptureConfigBuilder.setLensFacing(this.mCameraLensFacing);
        this.mImageCapture = new ImageCapture(this.mImageCaptureConfigBuilder.build());
        this.mVideoCaptureConfigBuilder.setTargetRotation(this.getDisplaySurfaceRotation());
        this.mVideoCaptureConfigBuilder.setLensFacing(this.mCameraLensFacing);
        this.mVideoCapture = new VideoCapture(this.mVideoCaptureConfigBuilder.build());
        this.mPreviewConfigBuilder.setLensFacing(this.mCameraLensFacing);
        int height = (int)((float)this.getMeasuredWidth() / targetAspectRatio.floatValue());
        this.mPreviewConfigBuilder.setTargetResolution(new Size(this.getMeasuredWidth(), height));
        this.mPreview = new Preview(this.mPreviewConfigBuilder.build());
        this.mPreview.setOnPreviewOutputUpdateListener(new Preview.OnPreviewOutputUpdateListener(){

            public void onUpdated(@NonNull Preview.PreviewOutput output) {
                boolean needReverse = cameraOrientation != 0 && cameraOrientation != 180;
                int textureWidth = needReverse ? output.getTextureSize().getHeight() : output.getTextureSize().getWidth();
                int textureHeight = needReverse ? output.getTextureSize().getWidth() : output.getTextureSize().getHeight();
                CameraXModule.this.onPreviewSourceDimensUpdated(textureWidth, textureHeight);
                CameraXModule.this.setSurfaceTexture(output.getSurfaceTexture());
            }
        });
        if (this.getCaptureMode() == CameraView.CaptureMode.IMAGE) {
            CameraX.bindToLifecycle((LifecycleOwner)this.mCurrentLifecycle, (UseCase[])new UseCase[]{this.mImageCapture, this.mPreview});
        } else if (this.getCaptureMode() == CameraView.CaptureMode.VIDEO) {
            CameraX.bindToLifecycle((LifecycleOwner)this.mCurrentLifecycle, (UseCase[])new UseCase[]{this.mVideoCapture, this.mPreview});
        } else {
            CameraX.bindToLifecycle((LifecycleOwner)this.mCurrentLifecycle, (UseCase[])new UseCase[]{this.mImageCapture, this.mVideoCapture, this.mPreview});
        }
        this.setZoomLevel(this.mZoomLevel);
        this.mCurrentLifecycle.getLifecycle().addObserver(this.mCurrentLifecycleObserver);
        this.setFlash(this.getFlash());
    }

    public void open() {
        throw new UnsupportedOperationException("Explicit open/close of camera not yet supported. Use bindtoLifecycle() instead.");
    }

    public void close() {
        throw new UnsupportedOperationException("Explicit open/close of camera not yet supported. Use bindtoLifecycle() instead.");
    }

    public void takePicture(Executor executor, ImageCapture.OnImageCapturedListener listener) {
        if (this.mImageCapture == null) {
            return;
        }
        if (this.getCaptureMode() == CameraView.CaptureMode.VIDEO) {
            throw new IllegalStateException("Can not take picture under VIDEO capture mode.");
        }
        if (listener == null) {
            throw new IllegalArgumentException("OnImageCapturedListener should not be empty");
        }
        this.mImageCapture.takePicture(executor, listener);
    }

    public void takePicture(File saveLocation, Executor executor, ImageCapture.OnImageSavedListener listener) {
        if (this.mImageCapture == null) {
            return;
        }
        if (this.getCaptureMode() == CameraView.CaptureMode.VIDEO) {
            throw new IllegalStateException("Can not take picture under VIDEO capture mode.");
        }
        if (listener == null) {
            throw new IllegalArgumentException("OnImageSavedListener should not be empty");
        }
        ImageCapture.Metadata metadata = new ImageCapture.Metadata();
        metadata.isReversedHorizontal = this.mCameraLensFacing == CameraX.LensFacing.FRONT;
        this.mImageCapture.takePicture(saveLocation, metadata, executor, listener);
    }

    public void startRecording(File file, Executor executor, final VideoCapture.OnVideoSavedListener listener) {
        if (this.mVideoCapture == null) {
            return;
        }
        if (this.getCaptureMode() == CameraView.CaptureMode.IMAGE) {
            throw new IllegalStateException("Can not record video under IMAGE capture mode.");
        }
        if (listener == null) {
            throw new IllegalArgumentException("OnVideoSavedListener should not be empty");
        }
        this.mVideoIsRecording.set(true);
        this.mVideoCapture.startRecording(file, executor, new VideoCapture.OnVideoSavedListener(){

            public void onVideoSaved(@NonNull File savedFile) {
                CameraXModule.this.mVideoIsRecording.set(false);
                listener.onVideoSaved(savedFile);
            }

            public void onError(@NonNull VideoCapture.VideoCaptureError videoCaptureError, @NonNull String message, @Nullable Throwable cause) {
                CameraXModule.this.mVideoIsRecording.set(false);
                Log.e((String)CameraXModule.TAG, (String)message, (Throwable)cause);
                listener.onError(videoCaptureError, message, cause);
            }
        });
    }

    public void stopRecording() {
        if (this.mVideoCapture == null) {
            return;
        }
        this.mVideoCapture.stopRecording();
    }

    public boolean isRecording() {
        return this.mVideoIsRecording.get();
    }

    @SuppressLint(value={"MissingPermission"})
    public void setCameraLensFacing(@Nullable CameraX.LensFacing lensFacing) {
        if (this.mCameraLensFacing != lensFacing) {
            this.mCameraLensFacing = lensFacing;
            if (this.mCurrentLifecycle != null) {
                this.bindToLifecycle(this.mCurrentLifecycle);
            }
        }
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public boolean hasCameraWithLensFacing(CameraX.LensFacing lensFacing) {
        String cameraId;
        try {
            cameraId = CameraX.getCameraWithLensFacing((CameraX.LensFacing)lensFacing);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to query lens facing.", e);
        }
        return cameraId != null;
    }

    @Nullable
    public CameraX.LensFacing getLensFacing() {
        return this.mCameraLensFacing;
    }

    public void toggleCamera() {
        Set<CameraX.LensFacing> availableCameraLensFacing = this.getAvailableCameraLensFacing();
        if (availableCameraLensFacing.isEmpty()) {
            return;
        }
        if (this.mCameraLensFacing == null) {
            this.setCameraLensFacing(availableCameraLensFacing.iterator().next());
            return;
        }
        if (this.mCameraLensFacing == CameraX.LensFacing.BACK && availableCameraLensFacing.contains(CameraX.LensFacing.FRONT)) {
            this.setCameraLensFacing(CameraX.LensFacing.FRONT);
            return;
        }
        if (this.mCameraLensFacing == CameraX.LensFacing.FRONT && availableCameraLensFacing.contains(CameraX.LensFacing.BACK)) {
            this.setCameraLensFacing(CameraX.LensFacing.BACK);
            return;
        }
    }

    public float getZoomLevel() {
        return this.mZoomLevel;
    }

    public void setZoomLevel(float zoomLevel) {
        Rect sensorSize;
        this.mZoomLevel = zoomLevel;
        if (this.mPreview == null) {
            return;
        }
        try {
            sensorSize = this.getSensorSize(this.getActiveCamera());
            if (sensorSize == null) {
                Log.e((String)TAG, (String)"Failed to get the sensor size.");
                return;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to get the sensor size.", (Throwable)e);
            return;
        }
        float minZoom = this.getMinZoomLevel();
        float maxZoom = this.getMaxZoomLevel();
        if (this.mZoomLevel < minZoom) {
            Log.e((String)TAG, (String)"Requested zoom level is less than minimum zoom level.");
        }
        if (this.mZoomLevel > maxZoom) {
            Log.e((String)TAG, (String)"Requested zoom level is greater than maximum zoom level.");
        }
        this.mZoomLevel = Math.max(minZoom, Math.min(maxZoom, this.mZoomLevel));
        float zoomScaleFactor = maxZoom == minZoom ? minZoom : (this.mZoomLevel - minZoom) / (maxZoom - minZoom);
        int minWidth = Math.round((float)sensorSize.width() / maxZoom);
        int minHeight = Math.round((float)sensorSize.height() / maxZoom);
        int diffWidth = sensorSize.width() - minWidth;
        int diffHeight = sensorSize.height() - minHeight;
        float cropWidth = (float)diffWidth * zoomScaleFactor;
        float cropHeight = (float)diffHeight * zoomScaleFactor;
        Rect cropRegion = new Rect((int)Math.ceil(cropWidth / 2.0f - 0.5f), (int)Math.ceil(cropHeight / 2.0f - 0.5f), (int)Math.floor((float)sensorSize.width() - cropWidth / 2.0f + 0.5f), (int)Math.floor((float)sensorSize.height() - cropHeight / 2.0f + 0.5f));
        if (cropRegion.width() < 50 || cropRegion.height() < 50) {
            Log.e((String)TAG, (String)"Crop region is too small to compute 3A stats, so ignoring further zoom.");
            return;
        }
        this.mCropRegion = cropRegion;
        this.mPreview.zoom(cropRegion);
    }

    public float getMinZoomLevel() {
        return 1.0f;
    }

    public float getMaxZoomLevel() {
        try {
            CameraCharacteristics characteristics = this.mCameraManager.getCameraCharacteristics(this.getActiveCamera());
            Float maxZoom = (Float)characteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
            if (maxZoom == null) {
                return 1.0f;
            }
            if (maxZoom.floatValue() == 1.0f) {
                return 1.0f;
            }
            return maxZoom.floatValue();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to get SCALER_AVAILABLE_MAX_DIGITAL_ZOOM.", (Throwable)e);
            return 1.0f;
        }
    }

    public boolean isZoomSupported() {
        return this.getMaxZoomLevel() != 1.0f;
    }

    @SuppressLint(value={"MissingPermission"})
    private void rebindToLifecycle() {
        if (this.mCurrentLifecycle != null) {
            this.bindToLifecycle(this.mCurrentLifecycle);
        }
    }

    int getRelativeCameraOrientation(boolean compensateForMirroring) {
        int rotationDegrees = 0;
        try {
            CameraInfo cameraInfo = CameraX.getCameraInfo((CameraX.LensFacing)this.getLensFacing());
            rotationDegrees = cameraInfo.getSensorRotationDegrees(this.getDisplaySurfaceRotation());
            if (compensateForMirroring) {
                rotationDegrees = (360 - rotationDegrees) % 360;
            }
        }
        catch (CameraInfoUnavailableException e) {
            Log.e((String)TAG, (String)"Failed to get CameraInfo", (Throwable)e);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to query camera", (Throwable)e);
        }
        return rotationDegrees;
    }

    public void invalidateView() {
        this.transformPreview();
        this.updateViewInfo();
    }

    void clearCurrentLifecycle() {
        if (this.mCurrentLifecycle != null) {
            CameraX.unbind((UseCase[])new UseCase[]{this.mImageCapture, this.mVideoCapture, this.mPreview});
        }
        this.mCurrentLifecycle = null;
    }

    private Rect getSensorSize(String cameraId) throws CameraAccessException {
        CameraCharacteristics characteristics = this.mCameraManager.getCameraCharacteristics(cameraId);
        return (Rect)characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
    }

    String getActiveCamera() throws CameraInfoUnavailableException {
        return CameraX.getCameraWithLensFacing((CameraX.LensFacing)this.mCameraLensFacing);
    }

    @UiThread
    private void transformPreview() {
        int previewWidth = this.getPreviewWidth();
        int previewHeight = this.getPreviewHeight();
        int displayOrientation = this.getDisplayRotationDegrees();
        Matrix matrix = new Matrix();
        int rotation = -displayOrientation;
        int px = (int)Math.round((double)previewWidth / 2.0);
        int py = (int)Math.round((double)previewHeight / 2.0);
        matrix.postRotate((float)rotation, (float)px, (float)py);
        if (displayOrientation == 90 || displayOrientation == 270) {
            float xScale = (float)previewWidth / (float)previewHeight;
            float yScale = (float)previewHeight / (float)previewWidth;
            matrix.postScale(xScale, yScale, (float)px, (float)py);
        }
        this.setTransform(matrix);
    }

    private void updateViewInfo() {
        if (this.mImageCapture != null) {
            this.mImageCapture.setTargetAspectRatioCustom(new Rational(this.getWidth(), this.getHeight()));
            this.mImageCapture.setTargetRotation(this.getDisplaySurfaceRotation());
        }
        if (this.mVideoCapture != null) {
            this.mVideoCapture.setTargetRotation(this.getDisplaySurfaceRotation());
        }
    }

    @RequiresPermission(value="android.permission.CAMERA")
    private Set<CameraX.LensFacing> getAvailableCameraLensFacing() {
        LinkedHashSet<CameraX.LensFacing> available = new LinkedHashSet<CameraX.LensFacing>(Arrays.asList(CameraX.LensFacing.values()));
        if (this.mCurrentLifecycle != null) {
            if (!this.hasCameraWithLensFacing(CameraX.LensFacing.BACK)) {
                available.remove(CameraX.LensFacing.BACK);
            }
            if (!this.hasCameraWithLensFacing(CameraX.LensFacing.FRONT)) {
                available.remove(CameraX.LensFacing.FRONT);
            }
        }
        return available;
    }

    public FlashMode getFlash() {
        return this.mFlash;
    }

    public void setFlash(FlashMode flash) {
        this.mFlash = flash;
        if (this.mImageCapture == null) {
            return;
        }
        this.mImageCapture.setFlashMode(flash);
    }

    public void enableTorch(boolean torch) {
        if (this.mPreview == null) {
            return;
        }
        this.mPreview.enableTorch(torch);
    }

    public boolean isTorchOn() {
        if (this.mPreview == null) {
            return false;
        }
        return this.mPreview.isTorchOn();
    }

    public Context getContext() {
        return this.mCameraView.getContext();
    }

    public int getWidth() {
        return this.mCameraView.getWidth();
    }

    public int getHeight() {
        return this.mCameraView.getHeight();
    }

    public int getDisplayRotationDegrees() {
        return CameraOrientationUtil.surfaceRotationToDegrees((int)this.getDisplaySurfaceRotation());
    }

    protected int getDisplaySurfaceRotation() {
        return this.mCameraView.getDisplaySurfaceRotation();
    }

    public void setSurfaceTexture(SurfaceTexture st) {
        this.mCameraView.setSurfaceTexture(st);
    }

    private int getPreviewWidth() {
        return this.mCameraView.getPreviewWidth();
    }

    private int getPreviewHeight() {
        return this.mCameraView.getPreviewHeight();
    }

    private int getMeasuredWidth() {
        return this.mCameraView.getMeasuredWidth();
    }

    private int getMeasuredHeight() {
        return this.mCameraView.getMeasuredHeight();
    }

    void setTransform(final Matrix matrix) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.mCameraView.post(new Runnable(){

                @Override
                public void run() {
                    CameraXModule.this.setTransform(matrix);
                }
            });
        } else {
            this.mCameraView.setTransform(matrix);
        }
    }

    void onPreviewSourceDimensUpdated(int width, int height) {
        this.mCameraView.onPreviewSourceDimensUpdated(width, height);
    }

    public CameraView.CaptureMode getCaptureMode() {
        return this.mCaptureMode;
    }

    public void setCaptureMode(CameraView.CaptureMode captureMode) {
        this.mCaptureMode = captureMode;
        this.rebindToLifecycle();
    }

    public long getMaxVideoDuration() {
        return this.mMaxVideoDuration;
    }

    public void setMaxVideoDuration(long duration) {
        this.mMaxVideoDuration = duration;
    }

    public long getMaxVideoSize() {
        return this.mMaxVideoSize;
    }

    public void setMaxVideoSize(long size) {
        this.mMaxVideoSize = size;
    }

    public boolean isPaused() {
        return false;
    }
}

