/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.utils;

import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.CameraOrientationUtil;

public final class UseCaseConfigUtil {
    private UseCaseConfigUtil() {
    }

    public static void updateTargetRotationAndRelatedConfigs(@NonNull UseCaseConfig.Builder<?, ?, ?> builder, int newRotation) {
        ImageOutputConfig config = (ImageOutputConfig)builder.getUseCaseConfig();
        int oldRotation = config.getTargetRotation(-1);
        if (oldRotation == -1 || oldRotation != newRotation) {
            ((ImageOutputConfig.Builder)((Object)builder)).setTargetRotation(newRotation);
        }
        if (oldRotation == -1 || newRotation == -1 || oldRotation == newRotation) {
            return;
        }
        int oldRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees(oldRotation);
        int newRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees(newRotation);
        if (Math.abs(newRotationDegrees - oldRotationDegrees) % 180 == 90) {
            Size targetResolution = config.getTargetResolution(null);
            Rational targetAspectRatioCustom = config.getTargetAspectRatioCustom(null);
            if (targetResolution != null) {
                ((ImageOutputConfig.Builder)((Object)builder)).setTargetResolution(new Size(targetResolution.getHeight(), targetResolution.getWidth()));
            }
            if (targetAspectRatioCustom != null) {
                ((ImageOutputConfig.Builder)((Object)builder)).setTargetAspectRatioCustom(new Rational(targetAspectRatioCustom.getDenominator(), targetAspectRatioCustom.getNumerator()));
            }
        }
    }
}

