/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.camera.core.impl.SurfaceConfig;
import java.util.ArrayList;
import java.util.List;

public final class SurfaceCombination {
    private final List<SurfaceConfig> mSurfaceConfigList = new ArrayList<SurfaceConfig>();

    private static void generateArrangements(List<int[]> arrangementsResultList, int n, int[] result, int index) {
        if (index >= result.length) {
            arrangementsResultList.add((int[])result.clone());
            return;
        }
        for (int i = 0; i < n; ++i) {
            boolean included = false;
            for (int j = 0; j < index; ++j) {
                if (i != result[j]) continue;
                included = true;
                break;
            }
            if (included) continue;
            result[index] = i;
            SurfaceCombination.generateArrangements(arrangementsResultList, n, result, index + 1);
        }
    }

    public boolean addSurfaceConfig(@NonNull SurfaceConfig surfaceConfig) {
        return this.mSurfaceConfigList.add(surfaceConfig);
    }

    public boolean removeSurfaceConfig(@NonNull SurfaceConfig surfaceConfig) {
        return this.mSurfaceConfigList.remove(surfaceConfig);
    }

    @NonNull
    public List<SurfaceConfig> getSurfaceConfigList() {
        return this.mSurfaceConfigList;
    }

    public boolean isSupported(@NonNull List<SurfaceConfig> configList) {
        boolean isSupported = false;
        if (configList.isEmpty()) {
            return true;
        }
        if (configList.size() > this.mSurfaceConfigList.size()) {
            return false;
        }
        List<int[]> elementsArrangements = this.getElementsArrangements(this.mSurfaceConfigList.size());
        for (int[] elementsArrangement : elementsArrangements) {
            boolean checkResult = true;
            for (int index = 0; index < this.mSurfaceConfigList.size() && (elementsArrangement[index] >= configList.size() || (checkResult &= this.mSurfaceConfigList.get(index).isSupported(configList.get(elementsArrangement[index])))); ++index) {
            }
            if (!checkResult) continue;
            isSupported = true;
            break;
        }
        return isSupported;
    }

    private List<int[]> getElementsArrangements(int n) {
        ArrayList<int[]> arrangementsResultList = new ArrayList<int[]>();
        SurfaceCombination.generateArrangements(arrangementsResultList, n, new int[n], 0);
        return arrangementsResultList;
    }
}

