/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageInfoProcessor;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.internal.ThreadConfig;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

public final class PreviewConfig
implements UseCaseConfig<Preview>,
ImageOutputConfig,
ThreadConfig {
    public static final Config.Option<ImageInfoProcessor> IMAGE_INFO_PROCESSOR = Config.Option.create("camerax.core.preview.imageInfoProcessor", ImageInfoProcessor.class);
    public static final Config.Option<CaptureProcessor> OPTION_PREVIEW_CAPTURE_PROCESSOR = Config.Option.create("camerax.core.preview.captureProcessor", CaptureProcessor.class);
    private final OptionsBundle mConfig;

    public PreviewConfig(@NonNull OptionsBundle config) {
        this.mConfig = config;
    }

    @Override
    public boolean containsOption(@NonNull Config.Option<?> id) {
        return this.mConfig.containsOption(id);
    }

    @Override
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id) {
        return this.mConfig.retrieveOption(id);
    }

    @Override
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id, @Nullable ValueT valueIfMissing) {
        return this.mConfig.retrieveOption(id, valueIfMissing);
    }

    @Override
    public void findOptions(@NonNull String idStem, @NonNull Config.OptionMatcher matcher) {
        this.mConfig.findOptions(idStem, matcher);
    }

    @Override
    @NonNull
    public Set<Config.Option<?>> listOptions() {
        return this.mConfig.listOptions();
    }

    @Override
    @Nullable
    public Class<Preview> getTargetClass(@Nullable Class<Preview> valueIfMissing) {
        Class<Preview> storedClass = this.retrieveOption(OPTION_TARGET_CLASS, valueIfMissing);
        return storedClass;
    }

    @Override
    @NonNull
    public Class<Preview> getTargetClass() {
        Class storedClass = (Class)this.retrieveOption(OPTION_TARGET_CLASS);
        return storedClass;
    }

    @Override
    @Nullable
    public String getTargetName(@Nullable String valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_NAME, valueIfMissing);
    }

    @Override
    @NonNull
    public String getTargetName() {
        return (String)this.retrieveOption(OPTION_TARGET_NAME);
    }

    @Override
    @Nullable
    public Rational getTargetAspectRatioCustom(@Nullable Rational valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_ASPECT_RATIO_CUSTOM, valueIfMissing);
    }

    @Override
    @NonNull
    public Rational getTargetAspectRatioCustom() {
        return (Rational)this.retrieveOption(OPTION_TARGET_ASPECT_RATIO_CUSTOM);
    }

    @Override
    public boolean hasTargetAspectRatio() {
        return this.containsOption(OPTION_TARGET_ASPECT_RATIO);
    }

    @Override
    public int getTargetAspectRatio() {
        return (Integer)this.retrieveOption(OPTION_TARGET_ASPECT_RATIO);
    }

    @Override
    public int getTargetRotation(int valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_ROTATION, valueIfMissing);
    }

    @Override
    public int getTargetRotation() {
        return (Integer)this.retrieveOption(OPTION_TARGET_ROTATION);
    }

    @Override
    @Nullable
    public Size getTargetResolution(@Nullable Size valueIfMissing) {
        return this.retrieveOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, valueIfMissing);
    }

    @Override
    @NonNull
    public Size getTargetResolution() {
        return this.retrieveOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION);
    }

    @Override
    @Nullable
    public Size getDefaultResolution(@Nullable Size valueIfMissing) {
        return this.retrieveOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION, valueIfMissing);
    }

    @Override
    @NonNull
    public Size getDefaultResolution() {
        return this.retrieveOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION);
    }

    @Override
    @Nullable
    public Size getMaxResolution(@Nullable Size valueIfMissing) {
        return this.retrieveOption(OPTION_MAX_RESOLUTION, valueIfMissing);
    }

    @Override
    @NonNull
    public Size getMaxResolution() {
        return (Size)this.retrieveOption(OPTION_MAX_RESOLUTION);
    }

    @Override
    @Nullable
    public List<Pair<Integer, Size[]>> getSupportedResolutions(@Nullable List<Pair<Integer, Size[]>> valueIfMissing) {
        return this.retrieveOption(OPTION_SUPPORTED_RESOLUTIONS, valueIfMissing);
    }

    @Override
    @NonNull
    public List<Pair<Integer, Size[]>> getSupportedResolutions() {
        return (List)this.retrieveOption(OPTION_SUPPORTED_RESOLUTIONS);
    }

    @Override
    @Nullable
    public Executor getBackgroundExecutor(@Nullable Executor valueIfMissing) {
        return this.retrieveOption(OPTION_BACKGROUND_EXECUTOR, valueIfMissing);
    }

    @Override
    @NonNull
    public Executor getBackgroundExecutor() {
        return (Executor)this.retrieveOption(OPTION_BACKGROUND_EXECUTOR);
    }

    @Override
    @Nullable
    public SessionConfig getDefaultSessionConfig(@Nullable SessionConfig valueIfMissing) {
        return this.retrieveOption(OPTION_DEFAULT_SESSION_CONFIG, valueIfMissing);
    }

    @Override
    @NonNull
    public SessionConfig getDefaultSessionConfig() {
        return (SessionConfig)this.retrieveOption(OPTION_DEFAULT_SESSION_CONFIG);
    }

    @Override
    @Nullable
    public SessionConfig.OptionUnpacker getSessionOptionUnpacker(@Nullable SessionConfig.OptionUnpacker valueIfMissing) {
        return this.retrieveOption(OPTION_SESSION_CONFIG_UNPACKER, valueIfMissing);
    }

    @Override
    @NonNull
    public SessionConfig.OptionUnpacker getSessionOptionUnpacker() {
        return (SessionConfig.OptionUnpacker)this.retrieveOption(OPTION_SESSION_CONFIG_UNPACKER);
    }

    @Override
    @Nullable
    public CaptureConfig getDefaultCaptureConfig(@Nullable CaptureConfig valueIfMissing) {
        return this.retrieveOption(OPTION_DEFAULT_CAPTURE_CONFIG, valueIfMissing);
    }

    @Override
    @NonNull
    public CaptureConfig getDefaultCaptureConfig() {
        return (CaptureConfig)this.retrieveOption(OPTION_DEFAULT_CAPTURE_CONFIG);
    }

    @Override
    @Nullable
    public CaptureConfig.OptionUnpacker getCaptureOptionUnpacker(@Nullable CaptureConfig.OptionUnpacker valueIfMissing) {
        return this.retrieveOption(OPTION_CAPTURE_CONFIG_UNPACKER, valueIfMissing);
    }

    @Override
    @NonNull
    public CaptureConfig.OptionUnpacker getCaptureOptionUnpacker() {
        return (CaptureConfig.OptionUnpacker)this.retrieveOption(OPTION_CAPTURE_CONFIG_UNPACKER);
    }

    @Override
    public int getSurfaceOccupancyPriority(int valueIfMissing) {
        return this.retrieveOption(OPTION_SURFACE_OCCUPANCY_PRIORITY, valueIfMissing);
    }

    @Override
    public int getSurfaceOccupancyPriority() {
        return (Integer)this.retrieveOption(OPTION_SURFACE_OCCUPANCY_PRIORITY);
    }

    @Override
    @Nullable
    public CameraSelector getCameraSelector(@Nullable CameraSelector valueIfMissing) {
        return this.retrieveOption(OPTION_CAMERA_SELECTOR, valueIfMissing);
    }

    @Override
    @NonNull
    public CameraSelector getCameraSelector() {
        return (CameraSelector)this.retrieveOption(OPTION_CAMERA_SELECTOR);
    }

    @Override
    @Nullable
    public UseCase.EventCallback getUseCaseEventCallback(@Nullable UseCase.EventCallback valueIfMissing) {
        return this.retrieveOption(OPTION_USE_CASE_EVENT_CALLBACK, valueIfMissing);
    }

    @Override
    @NonNull
    public UseCase.EventCallback getUseCaseEventCallback() {
        return (UseCase.EventCallback)this.retrieveOption(OPTION_USE_CASE_EVENT_CALLBACK);
    }

    @Nullable
    public ImageInfoProcessor getImageInfoProcessor(@Nullable ImageInfoProcessor valueIfMissing) {
        return this.retrieveOption(IMAGE_INFO_PROCESSOR, valueIfMissing);
    }

    @NonNull
    ImageInfoProcessor getImageInfoProcessor() {
        return this.retrieveOption(IMAGE_INFO_PROCESSOR);
    }

    @Nullable
    public CaptureProcessor getCaptureProcessor(@Nullable CaptureProcessor valueIfMissing) {
        return this.retrieveOption(OPTION_PREVIEW_CAPTURE_PROCESSOR, valueIfMissing);
    }

    @NonNull
    public CaptureProcessor getCaptureProcessor() {
        return this.retrieveOption(OPTION_PREVIEW_CAPTURE_PROCESSOR);
    }

    @Override
    public int getInputFormat() {
        return (Integer)this.retrieveOption(OPTION_INPUT_FORMAT);
    }
}

