/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.os.Handler;
import android.os.HandlerThread;
import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraX;
import androidx.camera.core.ProcessingSurface;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.CaptureStage;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageInfoProcessor;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.PreviewConfig;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.CameraCaptureResultImageInfo;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.ThreadConfig;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;

public final class Preview
extends UseCase {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Defaults DEFAULT_CONFIG = new Defaults();
    private static final String TAG = "Preview";
    private static final Executor DEFAULT_SURFACE_PROVIDER_EXECUTOR = CameraXExecutors.mainThreadExecutor();
    @Nullable
    private HandlerThread mProcessingPreviewThread;
    @Nullable
    private Handler mProcessingPreviewHandler;
    @Nullable
    SurfaceProvider mSurfaceProvider;
    @NonNull
    Executor mSurfaceProviderExecutor = DEFAULT_SURFACE_PROVIDER_EXECUTOR;
    @Nullable
    private CallbackToFutureAdapter.Completer<Pair<SurfaceProvider, Executor>> mSurfaceProviderCompleter;
    @Nullable
    private Size mLatestResolution;
    private DeferrableSurface mSessionDeferrableSurface;

    @MainThread
    Preview(@NonNull PreviewConfig config) {
        super(config);
    }

    SessionConfig.Builder createPipeline(final @NonNull String cameraId, final @NonNull PreviewConfig config, final @NonNull Size resolution) {
        Threads.checkMainThread();
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.Builder.createFrom(config);
        CaptureProcessor captureProcessor = config.getCaptureProcessor(null);
        SurfaceRequest surfaceRequest = new SurfaceRequest(resolution);
        this.setUpSurfaceProviderWrap(surfaceRequest);
        if (captureProcessor != null) {
            CaptureStage.DefaultCaptureStage captureStage = new CaptureStage.DefaultCaptureStage();
            if (this.mProcessingPreviewThread == null) {
                this.mProcessingPreviewThread = new HandlerThread("CameraX-preview_processing");
                this.mProcessingPreviewThread.start();
                this.mProcessingPreviewHandler = new Handler(this.mProcessingPreviewThread.getLooper());
            }
            ProcessingSurface processingSurface = new ProcessingSurface(resolution.getWidth(), resolution.getHeight(), config.getInputFormat(), this.mProcessingPreviewHandler, captureStage, captureProcessor, surfaceRequest.getDeferrableSurface());
            sessionConfigBuilder.addCameraCaptureCallback(processingSurface.getCameraCaptureCallback());
            this.mSessionDeferrableSurface = processingSurface;
            sessionConfigBuilder.setTag(captureStage.getId());
        } else {
            final ImageInfoProcessor processor = config.getImageInfoProcessor(null);
            if (processor != null) {
                sessionConfigBuilder.addCameraCaptureCallback(new CameraCaptureCallback(){

                    @Override
                    public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
                        super.onCaptureCompleted(cameraCaptureResult);
                        if (processor.process(new CameraCaptureResultImageInfo(cameraCaptureResult))) {
                            Preview.this.notifyUpdated();
                        }
                    }
                });
            }
            this.mSessionDeferrableSurface = surfaceRequest.getDeferrableSurface();
        }
        sessionConfigBuilder.addSurface(this.mSessionDeferrableSurface);
        sessionConfigBuilder.addErrorListener(new SessionConfig.ErrorListener(){

            @Override
            public void onError(@NonNull SessionConfig sessionConfig, @NonNull SessionConfig.SessionError error) {
                if (Preview.this.isCurrentlyBoundCamera(cameraId)) {
                    SessionConfig.Builder sessionConfigBuilder = Preview.this.createPipeline(cameraId, config, resolution);
                    Preview.this.updateSessionConfig(sessionConfigBuilder.build());
                    Preview.this.notifyReset();
                }
            }
        });
        return sessionConfigBuilder;
    }

    private void setUpSurfaceProviderWrap(final @NonNull SurfaceRequest surfaceRequest) {
        ListenableFuture future = CallbackToFutureAdapter.getFuture(completer -> {
            if (this.mSurfaceProviderCompleter != null) {
                this.mSurfaceProviderCompleter.setCancelled();
            }
            this.mSurfaceProviderCompleter = completer;
            if (this.mSurfaceProvider != null) {
                this.mSurfaceProviderCompleter.set((Object)new Pair((Object)this.mSurfaceProvider, (Object)this.mSurfaceProviderExecutor));
                this.mSurfaceProviderCompleter = null;
            }
            return "surface provider and executor future";
        });
        Futures.addCallback(future, new FutureCallback<Pair<SurfaceProvider, Executor>>(){

            @Override
            public void onSuccess(@Nullable Pair<SurfaceProvider, Executor> result) {
                if (result == null) {
                    return;
                }
                SurfaceProvider surfaceProvider = (SurfaceProvider)result.first;
                Executor executor = (Executor)result.second;
                if (surfaceProvider != null && executor != null) {
                    executor.execute(() -> surfaceProvider.onSurfaceRequested(surfaceRequest));
                }
            }

            @Override
            public void onFailure(Throwable t) {
                surfaceRequest.getDeferrableSurface().close();
            }
        }, CameraXExecutors.directExecutor());
    }

    @UiThread
    public void setSurfaceProvider(@NonNull Executor executor, @Nullable SurfaceProvider surfaceProvider) {
        Threads.checkMainThread();
        if (surfaceProvider == null) {
            this.mSurfaceProvider = null;
            this.notifyInactive();
        } else {
            this.mSurfaceProvider = surfaceProvider;
            this.mSurfaceProviderExecutor = executor;
            this.notifyActive();
            this.onSurfaceProviderAvailable();
            if (this.mSessionDeferrableSurface != null) {
                this.mSessionDeferrableSurface.close();
            }
            this.notifyReset();
        }
    }

    private void onSurfaceProviderAvailable() {
        if (this.mSurfaceProviderCompleter != null) {
            this.mSurfaceProviderCompleter.set((Object)new Pair((Object)this.mSurfaceProvider, (Object)this.mSurfaceProviderExecutor));
            this.mSurfaceProviderCompleter = null;
        } else if (this.mLatestResolution != null) {
            this.updateConfigAndOutput(this.getBoundCameraId(), (PreviewConfig)this.getUseCaseConfig(), this.mLatestResolution);
        }
    }

    @UiThread
    public void setSurfaceProvider(@Nullable SurfaceProvider surfaceProvider) {
        this.setSurfaceProvider(DEFAULT_SURFACE_PROVIDER_EXECUTOR, surfaceProvider);
    }

    private void updateConfigAndOutput(@NonNull String cameraId, @NonNull PreviewConfig config, @NonNull Size resolution) {
        this.updateSessionConfig(this.createPipeline(cameraId, config, resolution).build());
    }

    public int getTargetRotation() {
        return ((PreviewConfig)this.getUseCaseConfig()).getTargetRotation();
    }

    @NonNull
    public String toString() {
        return "Preview:" + this.getName();
    }

    @Override
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected UseCaseConfig.Builder<?, ?, ?> getDefaultBuilder(@Nullable CameraInfo cameraInfo) {
        PreviewConfig defaults = CameraX.getDefaultUseCaseConfig(PreviewConfig.class, cameraInfo);
        if (defaults != null) {
            return Builder.fromConfig(defaults);
        }
        return null;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected UseCaseConfig<?> applyDefaults(@NonNull UseCaseConfig<?> userConfig, @Nullable UseCaseConfig.Builder<?, ?, ?> defaultConfigBuilder) {
        PreviewConfig previewConfig = (PreviewConfig)super.applyDefaults(userConfig, defaultConfigBuilder);
        CameraInternal boundCamera = this.getBoundCamera();
        if (boundCamera != null && CameraX.getSurfaceManager().requiresCorrectedAspectRatio(boundCamera.getCameraInfoInternal().getCameraId())) {
            PreviewConfig imageConfig = previewConfig;
            Rational resultRatio = CameraX.getSurfaceManager().getCorrectedAspectRatio(boundCamera.getCameraInfoInternal().getCameraId(), imageConfig.getTargetRotation(0));
            if (resultRatio != null) {
                Builder configBuilder = Builder.fromConfig(previewConfig);
                configBuilder.setTargetAspectRatioCustom(resultRatio);
                previewConfig = configBuilder.getUseCaseConfig();
            }
        }
        return previewConfig;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void clear() {
        this.notifyInactive();
        if (this.mSessionDeferrableSurface != null) {
            this.mSessionDeferrableSurface.close();
            this.mSessionDeferrableSurface.getTerminationFuture().addListener(() -> {
                if (this.mProcessingPreviewThread != null) {
                    this.mProcessingPreviewThread.quitSafely();
                    this.mProcessingPreviewThread = null;
                }
            }, CameraXExecutors.directExecutor());
        }
        if (this.mSurfaceProviderCompleter != null) {
            this.mSurfaceProviderCompleter.setCancelled();
            this.mSurfaceProviderCompleter = null;
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onDestroy() {
        this.mSurfaceProvider = null;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected Size onSuggestedResolutionUpdated(@NonNull Size suggestedResolution) {
        this.mLatestResolution = suggestedResolution;
        this.updateConfigAndOutput(this.getBoundCameraId(), (PreviewConfig)this.getUseCaseConfig(), this.mLatestResolution);
        return this.mLatestResolution;
    }

    public static final class Builder
    implements UseCaseConfig.Builder<Preview, PreviewConfig, Builder>,
    ImageOutputConfig.Builder<Builder>,
    ThreadConfig.Builder<Builder> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(Preview.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setTargetClass((Class)Preview.class);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static Builder fromConfig(@NonNull PreviewConfig configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PreviewConfig getUseCaseConfig() {
            return new PreviewConfig(OptionsBundle.from(this.mMutableConfig));
        }

        @Override
        @NonNull
        public Preview build() {
            if (this.getMutableConfig().retrieveOption(PreviewConfig.OPTION_TARGET_ASPECT_RATIO, null) != null && this.getMutableConfig().retrieveOption(PreviewConfig.OPTION_TARGET_RESOLUTION, null) != null) {
                throw new IllegalArgumentException("Cannot use both setTargetResolution and setTargetAspectRatio on the same config.");
            }
            if (this.getMutableConfig().retrieveOption(PreviewConfig.OPTION_PREVIEW_CAPTURE_PROCESSOR, null) != null) {
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 35);
            } else {
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 34);
            }
            return new Preview(this.getUseCaseConfig());
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetClass(@NonNull Class<Preview> targetClass) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(PreviewConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_NAME, targetName);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setTargetAspectRatioCustom(@NonNull Rational aspectRatio) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_ASPECT_RATIO_CUSTOM, aspectRatio);
            this.getMutableConfig().removeOption(PreviewConfig.OPTION_TARGET_ASPECT_RATIO);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetAspectRatio(int aspectRatio) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_ASPECT_RATIO, aspectRatio);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_ROTATION, rotation);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, resolution);
            if (resolution != null) {
                this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_ASPECT_RATIO_CUSTOM, new Rational(resolution.getWidth(), resolution.getHeight()));
            }
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_DEFAULT_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_MAX_RESOLUTION, resolution);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setBackgroundExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_BACKGROUND_EXECUTOR, executor);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_DEFAULT_SESSION_CONFIG, sessionConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_DEFAULT_CAPTURE_CONFIG, captureConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_SESSION_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_CAPTURE_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, priority);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCameraSelector(@NonNull CameraSelector cameraSelector) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAMERA_SELECTOR, cameraSelector);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setUseCaseEventCallback(@NonNull UseCase.EventCallback useCaseEventCallback) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_USE_CASE_EVENT_CALLBACK, useCaseEventCallback);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setImageInfoProcessor(@NonNull ImageInfoProcessor processor) {
            this.getMutableConfig().insertOption(PreviewConfig.IMAGE_INFO_PROCESSOR, processor);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureProcessor(@NonNull CaptureProcessor captureProcessor) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_PREVIEW_CAPTURE_PROCESSOR, captureProcessor);
            return this;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<PreviewConfig> {
        private static final Size DEFAULT_MAX_RESOLUTION = CameraX.getSurfaceManager().getPreviewSize();
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 2;
        private static final PreviewConfig DEFAULT_CONFIG;

        @Override
        @NonNull
        public PreviewConfig getConfig(@Nullable CameraInfo cameraInfo) {
            return DEFAULT_CONFIG;
        }

        static {
            Builder builder = new Builder().setMaxResolution(DEFAULT_MAX_RESOLUTION).setSurfaceOccupancyPriority(2);
            DEFAULT_CONFIG = builder.getUseCaseConfig();
        }
    }

    public static interface SurfaceProvider {
        public void onSurfaceRequested(@NonNull SurfaceRequest var1);
    }
}

